/* Copyright (C) 2002, 2003, 2004, 2005, 2006 Jan Wedekind.
   This file is part of the recipe database application AnyMeal.

   AnyMeal is free software; you can redistribute it and/or modify it under
   the terms of the GNU GENERAL PUBLIC LICENSE as published by the Free
   Software Foundation; either version 2 of the License, or (at your option)
   any later version.

   AnyMeal is distributed in the hope that it will be useful, but WITHOUT ANY
   WARRANTY; without even the implied warranty of MERCHANTIBILITY or FITNESS
   FOR A PARTICULAR PURPOSE. See the GNU General Public License for more
   details.

   You should have received a copy of the GNU General Public License along
   with AnyMeal; if not, contact one of the authors of this software. */
#ifndef __MYSQLDATABASE_HPP
#define __MYSQLDATABASE_HPP

#include "include.hpp"
#include <mysql/mysql.h>
#include "database.hpp"
#include "mysqlServer.hpp"

/** @addtogroup mysqlCpp
    @{ */
/** Connection to MySQL database.
    @date Sun Mar 06 2005
    @author Jan Wedekind (wedesoft@users.sourceforge.net) */
class MySQLDatabase: public Database
{
public:
  /** Constructor connecting to a MySQL server over the network.
      Connect to a MySQL-server on the network.
      @param _server Server-object.
      @param _databaseName Name of MySQL-database. */
  MySQLDatabase( MySQLServerPtr _server,
                 const std::string &_databaseName ) throw (Error);
  /// Destructor.
  virtual ~MySQLDatabase(void);
  ///
  virtual StatementPtr execQuery( const std::string &query ) throw (Error);
  ///
  const std::string &getDatabaseName(void) const { return databaseName; }
  ///
  MYSQL *getConnection(void) { return &connection; }
protected:
  ///
  MYSQL connection;
  ///
  std::string databaseName;
};

/// Smart-Pointer referencing a MySQL-database.
typedef boost::shared_ptr< MySQLDatabase > MySQLDatabasePtr;

///@}

#endif
