// ========================================================================
// copyright (C) 1999-2003 by Tobias Erbsland <te@profzone.ch>
// ------------------------------------------------------------------------
// This program is free software; you can redistribute it and/or modify it
// under the terms of the GNU General Public License as published by the
// Free Software Foundation; either version 2 of the License, or (at your
// option) any later version.
// ========================================================================

#include "analyseplugin.h"
#include "filter.h"

analysePlugin::analysePlugin() :
		strPrefix( "analyse" ),
		strName( "Analyse Plugin" ),
		strVersion( "V0.1" ),
		strAuthor( "Tobias Erbsland <te@profzone.ch>" ),
		strHelp( "For execution of any analysis." )
{
	addParam( "all", "Enable all analysis.", "This is a flag.", FLAG, "0" );
}

analysePlugin::~analysePlugin()
{
}

void analysePlugin::beforeParam( void )
{
	std::list< Analyse * >::iterator i;
	for ( i = maps.a->begin(); i != maps.a->end(); i++ )
	{
		addParam( ( *i )->Prefix(), "Enable this analyse.", "This is a flag.", FLAG, "0" );
	}
}

analysePlugin::ps_e analysePlugin::analyse( void )
{
	std::list< Analyse * >::iterator i;
	for( i = maps.a->begin(); i != maps.a->end(); i++ )
	{
		// is flag for this analyse set, or the "all" flag?
		if( getFlagParam( ( *i ) ->Prefix() ) || getFlagParam( "all" ) )
		{
			execPlugin( &Plugin::beforeAnalyse, PA_BEFORE_ANALYSE, "before analyse", &( **i ) );
			( *i )->run( Filter::unityMap() );
			( *i )->print();
			execPlugin( &Plugin::afterAnalyse, PA_AFTER_ANALYSE, "after analyse", &( **i ) );
		}
	};
	return PS_CONTINUE;
};

bool analysePlugin::execPlugin( ps_e ( Plugin::*fp ) ( Analyse * ), pa_e pa,
									const std::string &name, Analyse * ap )
{
	std::list<Plugin *>::iterator i;
	ps_e status;

	for( i = maps.p->begin(); i != maps.p->end(); i++ )
	{
		if( (*i)->pa() & pa )
		{
			status = ( (*i)->*fp )( ap ); // WARNING! leave this untouched until you understand it.

			if( status == PS_STOP )
			{
				std::cerr << "Plugin " << (*i)->Prefix() << " status stop on " << name << "." << std::endl;
				return false;
			};
			if( ( status == Plugin::PS_ENABLE || status == Plugin::PS_DISABLE ) )  // hack!
			{
				std::cerr << "Plugin " << (*i)->Prefix() << " status enable|disable [wrong!] on " << name << "." << std::endl;
				std::cerr << " Allowed status returncodes on " << name << " are only stop and continue." << std::endl;
				return false;
			};
		}
	}
	return true;
}
