# H.6 Why did the Russian Revolution fail?

The greatest myth of Marxism must surely be the idea that the Russian
Revolution failed solely due to the impact of objective factors. While the
date Leninists consider the revolution to have become beyond reform varies
(over time it has moved backwards towards 1917 as the authoritarianism under
Lenin and Trotsky has become better known), the actual reasons are common. For
Leninists, the failure of the revolution was the product of such things as
civil war, foreign intervention, economic collapse and the isolation and
backwardness of Russia and **not** Bolshevik ideology. Bolshevik
authoritarianism, then, was forced upon the party by difficult objective
circumstances. It follows that there are no fundamental problems with Leninism
and so it is a case of simply applying it again, hopefully in more fortuitous
circumstances.

Anarchists are not impressed by this argument and we will show why by refuting
common Leninist explanations for the failure of the revolution. For
anarchists, Bolshevik ideology played its part, creating social structures (a
new state and centralised economic organisations) which not only disempowered
the masses but also made the objective circumstances being faced much worse.
Moreover, we argue, vanguardism could not help turn the rebels of 1917 into
the ruling elite of 1918. We explore these arguments and the evidence for them
in this section.

For those who argue that the civil war provoked Bolshevik policies, the
awkward fact is that many of the features of war communism, such as the
imposition of one-man management and centralised state control of the economy,
were already apparent before war communism. As one historian argues, _"[f]rom
the first days of Bolshevik power there was only a weak correlation between
the extent of 'peace' and the mildness or severity of Bolshevik rule, between
the intensity of the war and the intensity of proto-war communist measures . .
. Considered in ideological terms there was little to distinguish the
'breathing space' (April-May 1918) from the war communism that followed."_
Unsurprisingly, then, _"the breathing space of the first months of 1920 after
the victories over Kolchak and Denikin . . . saw their intensification and the
militarisation of labour"_ and, in fact, _"no serious attempt was made to
review the aptness of war communist policies."_ Ideology _"constantly impinged
on the choices made at various points of the civil war . . . Bolshevik
authoritarianism cannot be ascribed simply to the Tsarist legacy or to adverse
circumstances."_ [Richard Sakwa, **Soviet Communists in Power**, p. 24, p. 27
and p. 30] The inherent tendencies of Bolshevism were revealed by the civil
war, a war which only accelerated the development of what was implicit (and,
often, not so implicit) in Bolshevik ideology and its vision of socialism, the
state and the role of the party.

Thus _"the effective conclusion of the Civil War at the beginning of 1920 was
followed by a more determined and comprehensive attempt to apply these so-
called War Communism policies rather than their relaxation"_ and so the
_"apogee of the War Communism economy occurred after the Civil War was
effectively over."_ With the fighting over Lenin _"forcefully raised the
introduction of one-man management . . . Often commissars fresh from the Red
Army were drafted into management positions in the factories."_ By the autumn
of 1920, one-man management was in 82% of surveyed workplaces. This
_"intensification of War Communism labour policies would not have been a
significant development if they had continued to be applied in the same
haphazard manner as in 1919, but in early 1920 the Communist Party leadership
was no longer distracted by the Civil War from concentrating its thoughts and
efforts on the formulation and implementation of its labour policies."_ While
the _" experience of the Civil War was one factor predisposing communists
towards applying military methods"_ to the economy in early 1920,
_"ideological considerations were also important."_ [Jonathan Aves, **Workers
Against Lenin**, p. 2, p. 17, p. 15, p. 30, p. 17 and p. 11]

So it seems incredulous for Leninist John Rees to assert, for example, that
_"[w]ith the civil war came the need for stricter labour discipline and for .
. . 'one man management'. Both these processes developed lock step with the
war."_ [_"In Defence of October,"_ pp. 3-82, **International Socialism**, no.
52, p. 43] As we discuss in the [next section](secH6.html#sech61), Lenin was
advocating both of these **before** the outbreak of civil war in May 1918
**and** after it was effectively over. Indeed he explicitly, both before and
after the civil war, stressed that these policies were being implemented
because the lack of fighting meant that the Bolsheviks could turn their full
attention to building socialism. How these facts can be reconciled with claims
of policies being in _"lock step"_ with the civil war is hard to fathom.

Part of the problem is the rampant confusion within Leninist circles as to
when the practices condemned as Stalinism actually started. For example, Chris
Harman (of the UK's SWP) in his summary of the rise Stalinism asserted that
after _"Lenin's illness and subsequent death"_ the _"principles of October
were abandoned one by one."_ Yet the practice of, and ideological commitment
to, party dictatorship, one-man management in industry, banning opposition
groups/parties (as well as factions within the Communist Party), censorship,
state repression of strikes and protests, piece-work, Taylorism, the end of
independent trade unions and a host of other crimes against socialism were all
implemented under Lenin and normal practice at the time of his death. In other
words, the _"principles of October"_ were abandoned under, and by, Lenin.
Which, incidentally, explains why, Trotsky _"continued to his death to harbour
the illusion that somehow, despite the lack of workers' democracy, Russia was
a 'workers' state.'"_ [**Bureaucracy and Revolution in Eastern Europe**, p. 14
and p. 20] Simply put, there had been no workers' democracy when Trotsky held
state power and he considered that regime a _"workers' state"_. The question
arises why Harman thinks Lenin's Russia was some kind of "workers' state" if
workers' democracy is the criteria by which such things are to be judged.

From this it follows that, unlike Leninists, anarchists do not judge a regime
by who happens to be in office. A capitalist state does not become less
capitalist just because a social democrat happens to be prime minister or
president. Similarly, a regime does not become state capitalist just because
Stalin is in power rather than Lenin. While the Marxist analysis concentrates
on the transfer of state power from one regime to another, the anarchist one
focuses on the transfer of power from the state and bosses to working class
people. What makes a regime socialist is the social relationships it has, not
the personal opinions of those in power. Thus if the social relationships
under Lenin are similar to those under Stalin, then the nature of the regime
is similar. That Stalin's regime was far more brutal, oppressive and
exploitative than Lenin's does not change the underlying nature of the regime.
As such, Chomsky is right to point to _"the techniques of use of terminology
to delude"_ with respect to the Bolshevik revolution. Under Lenin and Trotsky,
_"a popular revolution was taken over by a managerial elite who immediately
dismantled all the socialist institutions."_ They used state power to _"create
a properly managed society, run by smart intellectuals, where everybody does
his job and does what he's told . . . That's Leninism. That's **the exact
opposite of socialism**. If socialism means anything, it means workers'
control of production and then on from there. That's the first thing they
destroyed. So why do we call it socialism?"_ [**Language and Politics**, p.
537]

To refute in advance one obvious objection to our argument, the anarchist
criticism of the Bolsheviks is **not** based on the utopian notion that they
did not create a fully functioning (libertarian) communist society. As we
discussed [section H.2.5](secH2.html#sech25), anarchists have never thought a
revolution would immediately produce such an outcome. As Emma Goldman argued,
she had not come to Russia _"expecting to find Anarchism realised"_ nor did
she _"expect Anarchism to follow in the immediate footsteps of centuries of
despotism and submission."_ Rather, she _"hope[d] to find in Russia at least
the beginnings of the social changes for which the Revolution had been
fought"_ and that _"the Russian workers and peasants as a whole had derived
essential social betterment as a result of the Bolshevik regime."_ Both hopes
were dashed. [**My Disillusionment in Russia**, p. xlvii] Equally, anarchists
were, and are, well aware of the problems facing the revolution, the impact of
the civil war and economic blockade. Indeed, both Goldman and Berkman used
these (as Leninists still do) to rationalise their support for the Bolsheviks,
in spite of their authoritarianism (for Berkman's account see **The Bolshevik
Myth** [pp. 328-31]). Their experiences in Russia, particularly after the end
of the civil war, opened their eyes to the impact of Bolshevik ideology on its
outcome.

Nor is it a case that anarchists have no solutions to the problems facing the
Russian Revolution. As well as the negative critique that statist structures
are unsuitable for creating socialism, particularly in the difficult economic
circumstances that affect every revolution, anarchists stressed that genuine
social construction had to be based on the people's own organisations and
self-activity. This was because, as Goldman concluded, the state is a _"menace
to the constructive development of the new social structure"_ and _"would
become a dead weight upon the growth of the new forms of life."_ Therefore,
she argued, the _"industrial power of the masses, expressed through their
libertarian associations - Anarchosyndicalism - is alone able to organise
successfully the economic life and carry on production"_ If the revolution had
been made a la Bakunin rather than a la Marx _"the result would have been
different and more satisfactory"_ as (echoing Kropotkin) Bolshevik methods
_"conclusively demonstrated how a revolution should **not** be made."_ [**Op.
Cit.**, pp. 253-4 and p. liv]

It should also be mentioned that the standard Leninist justification for party
dictatorship is that the opposition groups supported the counter-revolution or
took part in armed rebellions against "soviet power" (i.e., the Bolsheviks).
Rees, for example, asserts that some Mensheviks _"joined the Whites. The rest
alternated between accepting the legitimacy of the government and agitating
for its overthrow. The Bolsheviks treated them accordingly."_ [**Op. Cit.**,
p. 65] However, this is far from the truth. As one historian noted, while the
_"charge of violent opposition would be made again and again"_ by the
Bolsheviks, along with being _"active supporters of intervention and of
counter-revolution"_, in fact this _"charge was untrue in relation to the
Mensheviks, and the Communists, if they ever believed it, never succeeded in
establishing it."_ A few individuals did reject the Menshevik _"official
policy of confining opposition to strictly constitutional means"_ and they
were _"expelled from the party, for they had acted without its knowledge."_
[Leonard Schapiro, **The Origin of the Communist Autocracy**, p. 193]
Significantly, the Bolsheviks annulled their June 14th expulsion of the
Mensheviks from the soviets on the 30th of November of the same year, 1918.
[E. H. Carr, **The Bolshevik Revolution**, vol. 1, p. 180]

By _"agitating"_ for the _"overthrow"_ of the Bolshevik government, Rees is
referring to the Menshevik tactic of standing for election to soviets with the
aim of securing a majority and so forming a new government! Unsurprisingly,
the sole piece of evidence presented by Rees is a quote from historian E.H.
Carr: _"If it was true that the Bolshevik regime was not prepared after the
first few months to tolerate an organised opposition, it was equally true that
no opposition party was prepared to remain within legal limits. The premise of
dictatorship was common to both sides of the argument."_ [**Op. Cit.**, p.
190] Yet this _"judgment ignores"_ the Mensheviks whose policy of legal
opposition: _"The charge that the Mensheviks were not prepared to remain
within legal limits is part of the Bolsheviks’ case; it does not survive an
examination of the facts."_ [Schapiro, **Op. Cit.**, p. 355fn]

As regards the SRs, this issue is more complicated. The right-SRs welcomed and
utilised the rebellion of the Czech Legion in May 1918 to reconvene the
Constituent Assembly (within which they had an overwhelming majority and which
the Bolsheviks had dissolved). After the White General Kolchak overthrew this
government in November 1918 (and so turned the civil war into a Red against
White one), most right-SRs sided with the Bolsheviks and, in return, the
Bolsheviks restated them to the soviets in February 1919. [Carr, **Op. Cit.**,
p. 356 and p. 180] It must be stressed that, contra Carr, the SRs aimed for a
democratically elected government, not a dictatorship (and definitely not a
White one). With the Left-SRs, it was the Bolsheviks who denied them their
majority at the Fifth All-Congress of Soviets. Their rebellion was **not** an
attempted coup but rather an attempt to force the end of the Brest-Litovsk
treaty with the Germans by restarting the war (as Alexander Rabinowitch proves
beyond doubt in his **The Bolsheviks in Power**). It would be fair to say that
the anarchists, most SRs, the Left SRs and Mensheviks were not opposed to the
revolution, they were opposed to Bolshevik policy.

Ultimately, as Emma Goldman came to conclude, _"what [the Bolsheviks] called
'defence of the Revolution' was really only the defence of [their] party in
power."_ [**Op. Cit.**, p. 57]

At best it could be argued that the Bolsheviks had no alternative but to
impose their dictatorship, as the other socialist parties would have succumbed
to the Whites and so, eventually, a White dictatorship would have replaced the
Red one. This was why, for example, Victor Serge claimed he sided with the
Communists against the Kronstadt sailors even though the latter had right on
their side for _"the country was exhausted, and production practically at a
standstill; there was no reserves of any kind . . . The working-class
**elite** that had been moulded in the struggle against the old regime was
literally decimated. . . . If the Bolshevik dictatorship fell, it was only a
short step to chaos . . . and in the end, through the sheer force of events,
another dictatorship, this time anti-proletarian."_ [**Memoirs of a
Revolutionary**, pp. 128-9]

This, however, is shear elitism and utterly violates the notion that socialism
is the self-emancipation of the working class. Moreover, it places immense
faith on the goodwill of those in power - a utopian position. Equally, it
should not be forgotten that both the Reds and Whites were anti-working class.
At best it could be argued that the Red repression of working class protests
and strikes as well as opposition socialists would not have been as terrible
as that of the Whites, but that is hardly a good rationale for betraying the
principles of socialism. Yes, libertarians can agree with Serge that embracing
socialist principles may not work. Every revolution is a gamble and may fail.
As libertarian socialist Ante Ciliga correctly argued:

> _"Let us consider, finally, one last accusation which is commonly
circulated: that action such as that at Kronstadt could have **indirectly**
let loose the forces of the counter-revolution. It is **possible** indeed that
even by placing itself on a footing of workers' democracy the revolution might
have been overthrown; but what is **certain** is that it has perished, and
that it has perished on account of the policy of its leaders. The repression
of Kronstadt, the suppression of the democracy of workers and soviets by the
Russian Communist party, the elimination of the proletariat from the
management of industry, and the introduction of the NEP, already signified the
death of the Revolution."_ [_"The Kronstadt Revolt"_, pp. 330-7, **The
Raven**, no, 8, p. 333 p. 335]

So it should be stressed that no anarchist would argue that if an anarchist
path had been followed then success would have automatically followed. It is
possible that the revolution would have failed but one thing is sure: by
following the Bolshevik path it **did** fail. While the Bolsheviks may have
remained in power at the end of the civil war, the regime was a party
dictatorship presiding over a state capitalist economy. In such circumstances,
there could no further development towards socialism and, unsurprisingly,
there was none. Ultimately, as the rise of Stalin showed, the notion that
socialism could be constructed without basic working class freedom and self-
government was a baseless illusion.

As we will show, the notion that objective circumstances (civil war, economic
collapse, and so on) cannot fully explain the failure of the Russian
Revolution. This becomes clear once the awkward fact that Bolshevik
authoritarianism and state capitalist policies started before the outbreak of
civil war is recognised (see [section H.6.1](secH6.html#sech61)); that their
ideology inspired and shaped the policies they implemented and these policies
themselves made the objective circumstances worse (see [section
H.6.2](secH6.html#sech62)); and that the Bolsheviks had to repress working
class protest and strikes against them throughout the civil war, so suggesting
a social base existed for a genuinely socialist approach (see [section
H.6.3](secH6.html#sech63)).

Finally, there is a counter-example which, anarchists argue, shows the impact
of Bolshevik ideology on the fate of the revolution. This is the anarchist
influenced Makhnovist movement (see Peter Arshinov's **The History of the
Makhnovist Movement** or Alexandre Skirda's **Nestor Makhno Anarchy's
Cossack** for more details). Defending the revolution in the Ukraine against
all groups aiming to impose their will on the masses, the Makhnovists were
operating in the same objective conditions facing the Bolsheviks - civil war,
economic disruption, isolation and so forth. However, the policies the
Makhnovists implemented were radically different than those of the Bolsheviks.
While the Makhnovists called soviet congresses, the Bolsheviks disbanded them.
The former encouraged free speech and organisation, the latter crushed both.
While the Bolsheviks raised party dictatorship and one-man management to
ideological truisms, the Makhnovists stood for and implemented workplace,
army, village and soviet self-management. As one historian suggests, far from
being necessary or even functional, Bolshevik policies _"might even have made
the war more difficult and more costly. If the counter-example of Makhno is
anything to go by then [they] certainly did."_ [Christopher Read, **From Tsar
to Soviets**, p. 265] Anarchists argue that it shows the failure of Bolshevism
cannot be put down to purely objective factors like the civil war: the
politics of Leninism played their part.

Needless to say, this section can only be a summary of the arguments and
evidence. It does not pretend to be a comprehensive account of the revolution
or civil war. It concentrates on the key rationales by modern day Leninists to
justify Bolshevik actions and policies. We do so simply because it would be
impossible to cover every aspect of the revolution and because these
rationales are one of the main reasons why Leninist ideology has not been
placed in the dustbin of history where it belongs. For further discussion, see
Voline's **The Unknown Revolution**, Alexander Berkman's **The Russian
Tragedy** and **The Bolshevik Myth**, Emma Goldman's **My Disillusionment in
Russia** or Maurice Brinton's essential **The Bolsheviks and Workers'
Control**.

## H.6.1 Can objective factors explain the failure of the Russian Revolution?

Leninist John Rees recounts the standard argument, namely that the objective
conditions in Russia meant that the _"subjective factor"_ of Bolshevik
ideology _"was reduced to a choice between capitulation to the Whites or
defending the revolution with whatever means were at hands. Within these
limits Bolshevik policy was decisive. But it could not wish away the limits
and start with a clean sheet."_ From this perspective, the key factor was the
_"vice-like pressure of the civil war"_ which _"transformed the state"_ as
well as the _"Bolshevik Party itself."_ Industry was _"reduced . . . to
rubble"_ and the _"bureaucracy of the workers' state was left suspended in
mid-air, its class based eroded and demoralised."_ [_"In Defence of October,"_
pp. 3-82, **International Socialism**, no. 52, p. 30, p. 70, p. 66 and p. 65]

Due to these factors, argue Leninists, the Bolsheviks became dictators
**over** the working class and **not** due to their political ideas.
Anarchists are not convinced by this analysis, arguing that is factually and
logically flawed.

The first problem is factual. Bolshevik authoritarianism started **before**
the start of the civil war and major economic collapse. Whether it is soviet
democracy, workers' economic self-management, democracy in the armed forces or
working class power and freedom generally, the fact is the Bolsheviks had
systematically attacked and undermined it from the start. They also, as we
indicate in [section H.6.3](secH6.html'sech63) repressed working class
protests and strikes along with opposition groups and parties. As such, it is
difficult to blame something which had not started yet for causing Bolshevik
policies.

Although the Bolsheviks had seized power under the slogan _"All Power to the
Soviets,"_ as we noted in [section H.3.11](secH3.html#sech311) the facts are
the Bolsheviks aimed for party power and only supported soviets as long as
they controlled them. To maintain party power, they had to undermine the
soviets and they did. This onslaught on the soviets started quickly, in fact
overnight when the first act of the Bolsheviks was to create an executive
body, the Council of People's Commissars (or Sovnarkon), over and above the
soviets. This was in direct contradiction to Lenin's **The State and
Revolution**, where he had used the example of the Paris Commune to argue for
the merging of executive and legislative powers. Then, a mere four days after
this seizure of power by the Bolsheviks, the Sovnarkom unilaterally took for
itself legislative power simply by issuing a decree to this effect: _"This
was, effectively, a Bolshevik coup d’état that made clear the government's
(and party's) pre-eminence over the soviets and their executive organ.
Increasingly, the Bolsheviks relied upon the appointment from above of
commissars with plenipotentiary powers, and they split up and reconstituted
fractious Soviets and intimidated political opponents."_ [Neil Harding,
**Leninism**, p. 253]

The highest organ of soviet power, the Central Executive Committee (VTsIK) was
turned into little more than a rubber stamp, with its Bolshevik dominated
presidium using its power to control the body. Under the Bolsheviks, the
presidium was converted _"into the **de facto** centre of power within
VTsIK."_ It _"began to award representations to groups and factions which
supported the government. With the VTsIK becoming ever more unwieldy in size
by the day, the presidium began to expand its activities"_ and was used _"to
circumvent general meetings."_ Thus the Bolsheviks were able _"to increase the
power of the presidium, postpone regular sessions, and present VTsIK with
policies which had already been implemented by the Sovnarkon. Even in the
presidium itself very few people determined policy."_ [Charles Duval, _"Yakov
M. Sverdlov and the All-Russian Central Executive Committee of Soviets
(VTsIK)"_, pp. 3-22, **Soviet Studies**, vol. XXXI, no. 1, p.7, p. 8 and p.
18]

At the grassroots, a similar process was at work with oligarchic tendencies in
the soviets increasing post-October and _"[e]ffective power in the local
soviets relentlessly gravitated to the executive committees, and especially
their presidia. Plenary sessions became increasingly symbolic and
ineffectual."_ The party was _"successful in gaining control of soviet
executives in the cities and at **uezd** [district] and **guberniya**
[province] levels. These executive bodies were usually able to control soviet
congresses, though the party often disbanded congresses that opposed major
aspects of current policies."_ Local soviets _"had little input into the
formation of national policy"_ and _"[e]ven at higher levels, institutional
power shifted away from the soviets."_ [Carmen Sirianni, **Workers' Control
and Socialist Democracy**, p. 204 and p. 203] In Moscow, for example, power in
the soviet _"moved away from the plenum to ever smaller groups at the apex."_
The presidium, created in November 1917, _"rapidly accrued massive powers."_
[Richard Sakwa, **Soviet Communists in Power**, p. 166]

The Bolshevik dominated soviet executives used this power to maintain a
Bolshevik majority, by any means possible, in the face of popular
disillusionment with their regime. In Saratov, for example, _"as early as the
spring of 1918 . . . workers clashed with the soviet"_ while in the April
soviet elections, as elsewhere, the Bolsheviks' _"powerful majority in the
Soviet began to erode"_ as moderate socialists _"criticised the nondemocratic
turn Bolshevik power has taken and the soviet's loss of their independence."_
[Donald J. Raleigh, **Experiencing Russia's Civil War**, p. 366 and p. 368]
While the influence of the Mensheviks _"had sunk to insignificance by October
1917"_, the _"unpopularity of government policy"_ changed that and by the
_"middle of 1918 the Mensheviks could claim with some justification that large
numbers of the industrial working class were now behind them, and that but for
the systematic dispersal and packing of the soviets, and the mass arrests at
workers' meeting and congresses, their party could have one power by its
policy of constitutional opposition."_ The soviet elections in the spring of
1918 across Russia saw _"arrests, military dispersal, even shootings"_
whenever Mensheviks _"succeeded in winning majorities or a substantial
representation."_ [Leonard Schapiro, **The Origin of the Communist
Autocracy**, p. 191]

One such technique to maintain power was to postpone new soviet elections,
another was to gerrymander the soviets to ensure their majority. The
Bolsheviks in Petrograd, for example, faced _"demands from below for the
immediate re-election"_ of the Soviet. However, before the election, the
Bolshevik Soviet confirmed new regulations _"to help offset possible
weaknesses"_ in their _"electoral strength in factories."_ The _"most
significant change in the makeup of the new soviet was that numerically
decisive representation was given to agencies in which the Bolsheviks had
overwhelming strength, among them the Petrograd Trade Union Council,
individual trade unions, factory committees in closed enterprises, district
soviets, and district non-party workers' conferences."_ This ensured that
_"[o]nly 260 of roughly 700 deputies in the new soviet were to be elected in
factories, which guaranteed a large Bolshevik majority in advance"_ and so the
Bolsheviks _"contrived a majority"_ in the new Soviet long before gaining 127
of the 260 factory delegates. Then there is _"the nagging question of how many
Bolshevik deputies from factories were elected instead of the opposition
because of press restrictions, voter intimidation, vote fraud, or the short
duration of the campaign."_ The SR and Menshevik press, for example, were
reopened _"only a couple of days before the start of voting."_ Moreover,
_"Factory Committees from closed factories could and did elect soviet deputies
(the so-called dead souls), one deputy for each factory with more than one
thousand workers at the time of shutdown"_ while the electoral assemblies for
unemployed workers _"were organised through Bolshevik-dominated trade union
election commissions."_ Overall, then, the Bolshevik election victory _"was
highly suspect, even on the shop floor."_ [Alexander Rabinowitch, **The
Bolsheviks in Power**, pp. 248-9, p. 251 and p. 252] This meant that it was
_"possible for one worker to be represented in the soviet five times . . .
without voting once."_ Thus the soviet _"was no longer a popularly elected
assembly: it had been turned into an assembly of Bolshevik functionaries."_
[Vladimir N. Brovkin, **The Mensheviks After October**, p. 240]

When postponing and gerrymandering failed, the Bolsheviks turned to state
repression to remain in power. For all the provincial soviet elections in the
spring and summer of 1918 for which data is available, there was an
_"impressive success of the Menshevik-SR block"_ followed by _"the Bolshevik
practice of disbanding soviets that came under Menshevik-SR control."_ The
_"subsequent wave of anti-Bolshevik uprisings"_ were repressed by force.
[Brovkin, **Op. Cit.**, p. 159] Another historian also notes that by the
spring of 1918 _"Menshevik newspapers and activists in the trade unions, the
Soviets, and the factories had made a considerable impact on a working class
which was becoming increasingly disillusioned with the Bolshevik regime, so
much so that in many places the Bolsheviks felt constrained to dissolve
Soviets or prevent re-elections where Mensheviks and Socialist Revolutionaries
had gained majorities."_ [Israel Getzler, **Martov**, p. 179]

When the opposition parties raised such issues at the VTsIK, it had no impact.
In April 1918, one deputy _"protested that non-Bolshevik controlled soviets
were being dispersed by armed force, and wanted to discuss the issue."_ The
chairman _"refus[ed] to include it in the agenda because of lack of supporting
material"_ and requested such information be submitted to the presidium of the
soviet. The majority (i.e. the Bolsheviks) _"supported their chairman"_ and
the facts were _"submitted . . . to the presidium, where they apparently
remained."_ [Charles Duval, **Op. Cit.**, pp. 13-14] Given that the VTsIK was
meant to be the highest soviet body between congresses, this lack of concern
clearly shows the Bolshevik contempt for soviet democracy.

The Bolsheviks also organised rural poor committees, opposed to by all other
parties (particularly the Left-SRs). The Bolshevik leadership _"was well aware
that the **labouring peasantry**, largely represented in the countryside by
the Left Socialist-Revolutionary party, would be excluded from
participation."_ These committees were _"subordinated to central policy and
thus willing to implement a policy opposing the interests of the mass of the
peasants"_ and were also used for the _"disbandment of the peasants' soviets
in which Bolshevik representation was low or nil"_. It should be noted that
between March and August 1918 _"the Bolsheviks were losing power not only in
favour of the Left Socialist-Revolutionaries"_ but also _"in favour of non-
party people."_ [Silvana Malle, **The Economic Organisation of War Communism,
1918-1921**, pp. 366-7]

Unsurprisingly, the same contempt was expressed at the fifth All-Russian
Soviet Congress in July 1918 when the Bolsheviks gerrymandered it to maintain
their majority. They banned the Mensheviks in the context of political losses
**before** the Civil War, which gave the Bolsheviks an excuse and they _"drove
them underground, just on the eve of the elections to the Fifth Congress of
Soviets in which the Mensheviks were expected to make significant gains"_.
While the Bolsheviks _"offered some formidable fictions to justify the
expulsions"_ there was _"of course no substance in the charge that the
Mensheviks had been mixed in counter-revolutionary activities on the Don, in
the Urals, in Siberia, with the Czechoslovaks, or that they had joined the
worst Black Hundreds."_ [Getzler, **Op. Cit.**, p. 181]

With the Mensheviks and Right-SRs banned from the soviets, popular
disenchantment with Bolshevik rule was expressed by voting Left-SR. The
Bolsheviks ensured their majority in the congress and, therefore, a Bolshevik
government by gerrymandering it as they had the Petrograd soviet. Thus
_"electoral fraud gave the Bolsheviks a huge majority of congress delegates"_.
In reality, _"the number of legitimately elected Left SR delegates was roughly
equal to that of the Bolsheviks."_ The Left-SRs expected a majority but did
not include _"roughly 399 Bolsheviks delegates whose right to be seated was
challenged by the Left SR minority in the congress's credentials commission."_
Without these dubious delegates, the Left SRs and SR Maximalists would have
outnumbered the Bolsheviks by around 30 delegates. This ensured _"the
Bolshevik's successful fabrication of a large majority in the Fifth All-
Russian Congress of Soviets."_ [Rabinowitch, **Op. Cit.**, p. 396, p. 288, p.
442 and p. 308] Moreover, the Bolsheviks also _"allowed so-called committees
of poor peasants to be represented at the congress. . . This blatant
gerrymandering ensured a Bolshevik majority . . . Deprived of their democratic
majority the Left SRs resorted to terror and assassinated the German
ambassador Mirbach."_ [Geoffrey Swain, **The Origins of the Russian Civil
War**, p. 176] The Bolsheviks falsely labelled this an uprising against the
soviets and the Left-SRs joined the Mensheviks and Right-SRs in being made
illegal. It is hard not to agree with Rabinowitch when he comments that
_"however understandable framed against the fraudulent composition of the
Fifth All-Russian Congress of Soviets and the ominous developments at the
congresses's start"_ this act _"offered Lenin a better excuse than he could
possibly have hoped for to eliminate the Left SRs as a significant political
rival."_ [**Op. Cit.**, p. 308]

So before the start of the civil war all opposition groups, bar the Left-SRs,
had suffered some form of state repression by the hands of the Bolshevik
regime (the Bolsheviks had attacked the anarchist movement in April, 1918
[Paul Avrich, **The Russian Anarchists**, pp. 184-5]). Within six weeks of it
starting **every** opposition group had been excluded from the soviets.
Significantly, in spite of being, effectively, a one-party state Lenin later
proclaimed that soviet power _"is a million times more democratic than the
most democratic bourgeois republic"_ and pointed to the 6th Congress of
Soviets in November with its 97% of Bolsheviks! [**Collected Works**, vol. 28,
p. 248 and p. 303]

A similar authoritarian agenda was aimed at the armed forces and industry.
Trotsky simply abolished the soldier's committees and elected officers,
stating that _"the principle of election is politically purposeless and
technically inexpedient, and it has been, in practice, abolished by decree."_
[**How the Revolution Armed**, vol. 1, p. 47] The death penalty for
disobedience was restored, along with, more gradually, saluting, special forms
of address, separate living quarters and other privileges for officers.
Somewhat ironically, nearly 20 years later, Trotsky himself lamented how the
_"demobilisation of the Red Army of five million played no small role in the
formation of the bureaucracy. The victorious commanders assumed leading posts
in the local Soviets, in economy, in education, and they persistently
introduced everywhere that regime which had ensured success in the civil
war."_ For some reason he failed to mention who had introduced that very
regime, although he felt able to state, without shame, that the _"commanding
staff needs democratic control. The organisers of the Red Army were aware of
this from the beginning, and considered it necessary to prepare for such a
measure as the election of commanding staff."_ [**The Revolution Betrayed**,
p. 90 and p. 211] So it would be churlish to note that _"the root of the
problem lay in the very organisation of the army on traditional lines, for
which Trotsky himself had been responsible, and against which the Left
Communists in 1918 had warned."_ [Richard Sakwa, **Soviet Communists in
Power**, p. 231]

In industry, Lenin, as we discussed in [section H.3.14](secH3.html#sech314),
started to champion one-man management armed with _"dictatorial"_ powers in
April, 1918. Significantly, he argued that his new policies were **not**
driven by the civil war for _"[i]n the main . . . the task of suppressing the
resistance of the exploiters was fulfilled"_ (since _"(approximately) February
1918."_). The task _"now coming to the fore"_ was that of _"organising [the]
**administration** of Russia."_ It _"has become the main and central task"_
precisely **because** of _"the peace which has been achieved - despite its
extremely onerous character and extreme instability"_ and so _"the Russian
Soviet Republic has gained an opportunity to concentrate its efforts for a
while on the most important and most difficult aspect of the socialist
revolution, namely, the task of organisation."_ This would involve imposing
one-man management, that is _"individual executives"_ with _"dictatorial
powers (or 'unlimited' powers)"_ as there was _"absolutely **no**
contradiction in principle between Soviet (**that is**, socialist) democracy
and the exercise of dictatorial powers by individuals."_ [**Op. Cit.**, vol.
27, p. 242, p. 237, p. 267 and p. 268]

Trotsky concurred, arguing in the same speech which announced the destruction
of military democracy that workplace democracy _"is not the last word in the
economic constructive work of the proletariat"_. The _"next step must consist
in self-limitation of the collegiate principle"_ and its replacement by
_"[p]olitical collegiate control by the Soviets"_, i.e. the state control
Lenin had repeatedly advocated in 1917. However _"for executive functions we
must appoint technical specialists."_ He ironically called this the working
class _"throwing off the one-man management principles of its masters of
yesterday"_ and failed to recognise it was imposing the one-man management
principles of new masters. As with Lenin, the destruction of workers' power at
the point of production was of little concern for what mattered was that
_"with power in our hands, we, the representatives of the working class"_
would introduce socialism. [**How the Revolution Armed**, vol. 1, p. 37 and p.
38]

In reality, the Bolshevik vision of socialism simply replaced private
capitalism with state capitalism, taking control of the economy out of the
hands of the workers and placing it into the hands of the state bureaucracy.
As one historian correctly summarises the so-called workers' state _"oversaw
the reimposition of alienated labour and hierarchical social relations. It
carried out this function in the absence of a ruling class, and then played a
central role in ushering that class into existence - a class which
subsequently ruled not through its ownership of private property but through
its 'ownership' of the state. That state was antagonistic to the forces that
could have best resisted the retreat of the revolution, i.e. the working
class."_ [Simon Pirani, **The Russian Revolution in Retreat, 1920-24**, p.
240]

Whether it is in regards to soviet, workplace or army democracy or the rights
of the opposition to organise freely and gather support, the facts are the
Bolsheviks had systematically eliminated them **before** the start of the
civil war. So when Trotsky asserted that _"[i]n the beginning, the party had
wished and hoped to preserve freedom of political struggle within the
framework of the Soviets"_ but that it was civil war which _"introduced stern
amendments into this calculation,"_ he was rewriting history. Rather than
being _"regarded not as a principle, but as an episodic act of self-defence"_
the opposite is the case. As we note in [section H.3.8](secH3.html#sech38)
from roughly October 1918 onwards, the Bolsheviks **did** raise party
dictatorship to a _"principle"_ and did not care that this was _"obviously in
conflict with the spirit of Soviet democracy."_ Trotsky was right to state
that _"on all sides the masses were pushed away gradually from actual
participation in the leadership of the country."_ [**The Revolution
Betrayed**, p. 96 and p. 90] He was just utterly wrong to imply that this
process happened **after** the end of the civil war rather than before its
start and that the Bolsheviks did not play a key role in so doing. Thus, _"in
the soviets and in economic management the embryo of centralised and
bureaucratic state forms had already emerged by mid-1918."_ [Sakwa, **Op.
Cit.**, pp. 96-7]

It may be argued in objection to this analysis that the Bolsheviks faced
resistance from the start and, consequently, civil war existed from the moment
Lenin seized power and to focus attention on the events of late May 1918 gives
a misleading picture of the pressures they were facing. After all, the
Bolsheviks had the threat of German Imperialism and there were a few (small)
White Armies in existence as well as conspiracies to combat. However, this is
unconvincing as Lenin himself pointed to the ease of Bolshevik success post-
October. On March 14th, 1918, Lenin had proclaimed that _"the civil war was
one continuous triumph for Soviet power"_ and in June argued that _"the
Russian bourgeoisie was defeated in open conflict . . . in the period from
October 1917 to February and March 1918"_. [**Collected Works**, vol. 27, p.
174 and p. 428] It can be concluded that the period up until March 1918 was
not considered by the Bolsheviks themselves as being so bad as requiring the
adjustment of their politics. This explains why, as one historian notes, that
the _"revolt of the Czechoslovak Legion on 25 May 1918 is often considered to
be the beginning of full-scale military activity. There followed a succession
of campaigns."_ This is reflected in Bolshevik policy as well, with war
communism _"lasting from about mid-1918 to March 1921."_ [Sakwa, **Op. Cit.**,
p. 22 and p. 19]

Significantly, the introduction of one-man management was seen not as an
emergency measure forced upon the Bolsheviks by dire circumstances of civil
war but rather as a natural aspect of building socialism itself. In March,
1918, for example, Lenin argued that civil war _"became a fact"_ on October,
25, 1917 and _"[i]n this civil war . . . victory was achieved with . . .
extraordinary ease . . . The Russian revolution was a continuous triumphal
march in the first months."_ [**Op. Cit.**, pp. 88-9] Looking back at this
time from April 1920, Lenin reiterated his position (_"Dictatorial powers and
one-man management are not contradictory to socialist democracy."_) while also
stressing that this was not forced upon the Bolsheviks by civil war.
Discussing how, again, the civil war was ended and it was time to build
socialism he argued that the _"whole attention of the Communist Party and the
Soviet government is centred on peaceful economic development, on problems of
the dictatorship and of one-man management . . . When we tackled them for the
first time in 1918, there was no civil war and no experience to speak of."_ So
it was _"not only experience"_ of civil war, argued Lenin _"but something more
profound . . . that has induced us now, as it did two years ago, to
concentrate all our attention on labour discipline."_ [**Op. Cit.**, vol. 30,
p. 503 and p. 504] Trotsky also argued that Bolshevik policy was not
conditioned by the civil war (see [section H.3.14](secH3.html#sech314)).

As historian Jonathan Aves notes, _"the Communist Party took victory as a sign
of the correctness of its ideological approach and set about the task of
economic construction on the basis of an intensification of War Communism
policies."_ [**Workers Against Lenin**, p. 37] In addition, this perspective
flowed, as we argue in the [next section](secH6.html#sech62), from the
Bolshevik ideology, from its vision of socialism, rather than some alien
system imposed upon an otherwise healthy set of ideas.

Of course, this can be ignored in favour of the argument that party rule was
required for the revolution to succeed. That would be a defendable, if utterly
incorrect, position to take. It would, however, also necessitate ripping up
Lenin's **State and Revolution** as it is clearly not relevant to a socialist
revolution nor can it be considered as the definitive guide of what Leninism
really stands for, as Leninists like to portray it to this day. Given that
this is extremely unlikely to happen, it is fair to suggest that claims that
the Bolsheviks faced "civil war" from the start, so justifying their
authoritarianism, can be dismissed as particularly unconvincing special
pleading. Much the same can be said for the "objective conditions" produced by
the May 1918 to October 1920 civil war argument in general.

Then there is the logical problem. Leninists say that they are
revolutionaries. As we noted in [section H.2.1](secH2.html#sech21), they
inaccurately mock anarchists for not believing that a revolution needs to
defend itself. Yet, ironically, their whole defence of Bolshevism rests on the
_"exceptional circumstances"_ produced by the civil war they claim is
inevitable. If Leninism cannot handle the problems associated with actually
conducting a revolution then, surely, it should be avoided at all costs. This
is particularly the case as leading Bolsheviks all argued that the specific
problems their latter day followers blame for their authoritarianism were
natural results of any revolution and, consequently, unavoidable. Lenin, for
example, in 1917 mocked those who opposed revolution because _"the situation
is exceptionally complicated."_ He noted _"the development of the revolution
itself **always** creates an **exceptionally** complicated situation"_ and
that it was an _"incredibly complicated and painful process."_ In fact, it was
_"the most intense, furious, desperate class war and civil war. Not a single
great revolution in history has taken place without civil war. And only a 'man
in a muffler' can think that civil war is conceivable without an
'exceptionally complicated situation.'"_ _"If the situation were not
exceptionally complicated there would be no revolution."_ [**Op. Cit.**, vol.
26, pp. 118-9]

He reiterated this in 1918, arguing that _"every great revolution, and a
socialist revolution in particular, even if there is no external war, is
inconceivable without internal war, i.e., civil war, which is even more
devastating than external war, and involves thousands and millions of cases of
wavering and desertion from one side to another, implies a state of extreme
indefiniteness, lack of equilibrium and chaos."_ [**Op. Cit.**, vol. 27, p.
264] He even argued that revolution in an advanced capitalist nations would be
far more devastating and ruinous than in Russia. [**Op. Cit.**, vol. 28, p.
298]

Therefore, Lenin stressed, _"it will never be possible to build socialism at a
time when everything is running smoothly and tranquilly; it will never be
possible to realise socialism without the landowners and capitalists putting
up a furious resistance."_ Those _"who believe that socialism can be built at
a time of peace and tranquillity are profoundly mistaken: it will be
everywhere built at a time of disruption, at a time of famine. That is how it
must be."_ Moreover, _"not one of the great revolutions of history has taken
place"_ without civil war and _"without which not a single serious Marxist has
conceived the transition from capitalism to socialism."_ Obviously, _"there
can be no civil war - the inevitable condition and concomitant of socialist
revolution - without disruption."_ [**Op. Cit.**, vol. 27, p. 520, p. 517, p.
496 and p. 497]

Moreover, anarchists had long argued that a revolution would be associated
with economic disruption, isolation and civil war and, consequently, had
developed their ideas to take these into account. For example, Kropotkin was
_"certain that the coming Revolution . . . will burst upon us in the middle of
a great industrial crisis . . . There are millions of unemployed workers in
Europe at this moment. It will be worse when Revolution has burst upon us . .
. The number of the out-of-works will be doubled as soon as barricades are
erected in Europe and the United States . . . we know that in time of
Revolution exchange and industry suffer most from the general upheaval . . . A
Revolution in Europe means, then, the unavoidable stoppage of at least half
the factories and workshops."_ The _"smallest attack upon property will bring
in its train the complete disorganisation"_ of the capitalist economy. This
meant that society _"itself will be forced to take production in hand . . .
and to reorganise it to meet the needs of the whole people."_ [**The Conquest
of Bread**, pp. 69-70] This prediction was a common feature of Kropotkin's
politics (as can be seen from, say, his _"The First Work of the Revolution"_
[**Act for Yourselves**, pp. 56-60]).

Revolutionary anarchism, then, is based on a clear understanding of the nature
of a social revolution, the objective problems it will face and the need for
mass participation and free initiative to solve them. So it must, therefore,
be stressed that the very _"objective factors"_ supporters of Bolshevism use
to justify the actions of Lenin and Trotsky were predicted correctly by
anarchists decades beforehand and integrated into our politics. Moreover,
anarchists had developed their ideas on social revolution to make sure that
these inevitable disruptions would be minimised. By stressing the need for
self-management, mass participation, self-organisation and free federation,
anarchism showed how a free people could deal with the difficult problems they
would face (as we discuss in the [section H.6.2](secH6.html#sech62) there is
substantial evidence to show that Bolshevik ideology and practice made the
problems facing the Russian revolution much worse than they had to be).

It should also be noted that every revolution has confirmed the anarchist
analysis. For example, the German Revolution after 1918 faced an economic
collapse which was, relatively, just as bad as that facing Russia the year
before. The near revolution produced extensive political conflict, including
civil war, which was matched by economic turmoil. Taking 1928 as the base
year, the index of industrial production in Germany was slightly lower in
1913, namely 98 in 1913 to 100 in 1928. In 1917, the index was 63 and by 1918,
it was 61 (i.e. industrial production had dropped by nearly 40%). In 1919, it
fell again to 37, rising to 54 in 1920 and 65 in 1921. Thus, in 1919, the
_"industrial production reached an all-time low"_ and it _"took until the late
1920s for [food] production to recover its 1912 level."_ [V. R. Berghahn,
**Modern Germany**, p. 258, pp. 67-8 and p. 71] In Russia, the index for large
scale industry fell to 77 in 1917 from 100 in 1913, falling again to 35 in
1918, 26 in 1919 and 18 in 1920. [Tony Cliff, **Lenin**, vol. 3, p. 86]

Strangely, Leninists do not doubt that the spread of the Russian Revolution to
Germany would have allowed the Bolsheviks more leeway to avoid
authoritarianism and so save the Revolution. Yet this does not seem likely
given the state of the German economy. Comparing the two countries, there is a
similar picture of economic collapse. In the year the revolution started,
production had fallen by 23% in Russia (from 1913 to 1917) and by 43% in
Germany (from 1913 to 1918). Once revolution had effectively started,
production fell even more. In Russia, it fell to 65% of its pre-war level in
1918, in Germany it fell to 62% of its pre-war level in 1919. However, no
Leninist argues that the German Revolution was impossible or doomed to
failure. Similarly, no Leninist denies that a socialist revolution was
possible during the depths of the Great Depression of the 1930s or to post-
world war two Europe, marked as it was by economic collapse. This was the case
in 1917 as well, when economic crisis had been a fact of Russian life
throughout the year. This did not stop the Bolsheviks calling for revolution
and seizing power. Nor did this crisis stop the creation of democratic working
class organisations, such as soviets, trade unions and factory committees
being formed nor did it stop mass collective action. It appears, therefore,
that while the economic crisis of 1917 did not stop the development of
socialist tendencies to combat it, the seizure of power by a socialist party
did.

To conclude, it seems hypocritical in the extreme for Leninists to blame
difficult circumstances for the failure of the Russian Revolution. As Lenin
himself argued, the Bolsheviks _"never said that the transition from
capitalism to socialism would be easy. It will invoke a whole period of
violent civil war, it will involve painful measures."_ They knew _"that the
transition from capitalism to socialism is a struggle of an extremely
difficult kind"_ and so _"[i]f there ever existed a revolutionary who hoped
that we could pass to the socialist system without difficulties, such a
revolutionary, such a socialist, would not be worth a brass farthing."_ [**Op.
Cit.**, p. 431, p. 433 and pp. 432-3] He would have been surprised to discover
that many of his own followers would be _"such a socialist"_!

Consequently, it is not hard to conclude that for Leninists difficult
objective circumstances place socialism off the agenda only when they are
holding power. So even if we ignore the extensive evidence that Bolshevik
authoritarianism started before the civil war, the logic of the Leninist
argument is hardly convincing. Yet it does have advantages, for by focusing
attention on the civil war, Leninists also draw attention away from Bolshevik
ideology and tactics. As Peter Kropotkin recounted to Emma Goldman this simply
cannot be done:

> _"the Communists are a political party firmly adhering to the idea of a
centralised State, and that as such they were bound to misdirect the course of
the Revolution . . . [Their policies] have paralysed the energies of the
masses and have terrorised the people. Yet without the direct participation of
the masses in the reconstruction of the country, nothing essential could be
accomplished . . . They created a bureaucracy and officialdom . . . [which
were] parasites on the social body . . . It was not the fault of any
particular individual: rather it was the State they had created, which
discredits every revolutionary ideal, stifles all initiative, and sets a
premium on incompetence and waste . . . Intervention and blockade were
bleeding Russia to death, and were preventing the people from understanding
the real nature of the Bolshevik regime."_ [**My Disillusionment in Russia**,
p. 99]

Obviously, if the "objective" factors do not explain Bolshevik
authoritarianism and the failure of the revolution we are left with the
question of which aspects of Bolshevik ideology impacted negatively on the
revolution. As Kropotkin's comments indicate, anarchists have good reason to
argue that one of the greatest myths of state socialism is the idea that
Bolshevik ideology played no role in the fate of the Russian Revolution. We
turn to this in the [next section](secH6.html#sech62)

## H.6.2 Did Bolshevik ideology influence the outcome of the Russian
Revolution?

As we discussed in the [last section](secH6.html#sech61), anarchists reject
the Leninist argument that the failure of Bolshevism in the Russian Revolution
can be blamed purely on the difficult objective circumstances they faced. As
Noam Chomsky summarises:

> _"In the stages leading up to the Bolshevik coup in October 1917, there
**were** incipient socialist institutions developing in Russia - workers'
councils, collectives, things like that. And they survived to an extent once
the Bolsheviks took over - but not for very long; Lenin and Trotsky pretty
much eliminated them as they consolidated their power. I mean, you can argue
about the **justification** for eliminating them, but the fact is that the
socialist initiatives were pretty quickly eliminated. _

> _"Now, people who want to justify it say, 'The Bolsheviks had to do it' -
that's the standard justification: Lenin and Trotsky had to do it, because of
the contingencies of the civil war, for survival, there wouldn't have been
food otherwise, this and that. Well, obviously the question is, was that true.
To answer that, you've got to look at the historical facts: I don't think it
was true. In fact, I think the incipient socialist structures in Russia were
dismantled **before** the really dire conditions arose . . . But reading their
own writings, my feeling is that Lenin and Trotsky knew what they were doing,
it was conscious and understandable."_ [**Understanding Power**, p. 226]

Chomsky is right on both counts. The attack on the basic building blocks of
genuine socialism started before the civil war. Moreover, it did not happen by
accident. The attacks were rooted in the Bolshevik vision of socialism. As
Maurice Brinton concluded:

> _"there is a clear-cut and incontrovertible link between what happened under
Lenin and Trotsky and the later practices of Stalinism . . . The more one
unearths about this period the more difficult it becomes to define - or even
to see - the 'gulf' allegedly separating what happened in Lenin's time from
what happened later. Real knowledge of the facts also makes it impossible to
accept . . . that the whole course of events was 'historically inevitable' and
'objectively determined'. Bolshevik ideology and practice were themselves
important and sometimes decisive factors in the equation, at every critical
stage of this critical period."_ [**The Bolsheviks and Workers' Control**, p.
84]

This is not to suggest that the circumstances played no role in the
development of the revolution. It is simply to indicate that Bolshevik
ideology played its part as well by not only shaping the policies implemented
but also how the results of those policies themselves contributed to the
circumstances being faced. This is to be expected, given that the Bolsheviks
were the ruling party and, consequently, state power was utilised to implement
their policies, policies which, in turn, were influenced by their ideological
preferences and prejudices. Ultimately, to maintain (as Leninists do) that the
ideology of the ruling party played no (or, at best, a minor) part hardly
makes sense logically nor, equally importantly, can it be supported once even
a basic awareness of the development of the Russian Revolution is known.

A key issue is the Bolsheviks support for centralisation. Long before the
revolution, Lenin had argued that within the party it was a case of _"the
transformation of the power of ideas into the power of authority, the
subordination of lower Party bodies to higher ones."_ [**Collected Works**,
vol. 7, p. 367] Such visions of centralised organisation were the model for
the revolutionary state and, once in power, they did not disappoint. Thus,
_"for the leadership, the principle of maximum centralisation of authority
served more than expedience. It consistently resurfaced as the image of a
peacetime political system as well."_ [Thomas F. Remington, **Building
Socialism in Bolshevik Russia**, p. 91]

However, by its very nature centralism places power into a few hands and
effectively eliminates the popular participation required for any successful
revolution to develop. The power placed into the hands of the Bolshevik
government was automatically no longer in the hands of the working class. So
when Leninists argue that "objective" circumstances forced the Bolsheviks to
substitute their power for that of the masses, anarchists reply that this
substitution had occurred the moment the Bolsheviks centralised power and
placed it into their own hands. As a result, popular participation and
institutions began to wither and die. Moreover, once in power, the Bolsheviks
were shaped by their new position and the social relationships it created and,
consequently, implemented policies influenced and constrained by the
hierarchical and centralised structures they had created.

This was not the only negative impact of Bolshevik centralism. It also spawned
a bureaucracy. As we noted in [section H.1.7](secH1.html#sech17), the rise of
a state bureaucracy started immediately with the seizure of power. Thus _"red
tape and vast administrative offices typified Soviet reality"_ as the
Bolsheviks _"rapidly created their own [state] apparatus to wage the political
and economic offensive against the bourgeoisie and capitalism. As the
functions of the state expanded, so did the bureaucracy"_ and so _"following
the revolution the process of institutional proliferation reached
unprecedented heights . . . a mass of economic organisations [were] created or
expanded."_ [Richard Sakwa, **Soviet Communists in Power**, p. 190 and p. 191]
This was a striking confirmation of the anarchist analysis which argued that a
new bureaucratic class develops around any centralised body. This body would
soon become riddled with personal influences and favours, so ensuring that
members could be sheltered from popular control while, at the same time,
exploiting its power to feather their own nest. Over time, this permanent
collection of bodies would become the real power in the state, with the party
members nominally in charge really under the control of an unelected and
uncontrolled officialdom. This was recognised by Lenin in 1922:

> _"If we take Moscow with its 4,700 Communists in responsible positions, and
if we take that huge bureaucratic machine, that gigantic heap, we must ask:
who is directing whom? I doubt very much whether it can truthfully be said
that the Communists are directing that heap. To tell the truth, they are not
directing, they are being directed."_ [**The Lenin Anthology**, p. 527]

By the end of 1920, there were five times more state officials than industrial
workers (5,880,000 were members of the state bureaucracy). However, the
bureaucracy had existed since the start. In Moscow, in August 1918, state
officials represented 30 per cent of the workforce there and by 1920 the
general number of office workers _"still represented about a third of those
employed in the city"_ (200,000 in November, 1920, rising to 228,000 in July,
1921 and, by October 1922, to 243,000). [Sakwa, **Op. Cit.**, pp. 191-3] And
with bureaucracy came the abuse of it simply because it held **real** power:

> _"The prevalence of bureaucracy, of committees and commissions . . .
permitted, and indeed encouraged, endless permutations of corrupt practices.
These raged from the style of living of communist functionaries to bribe-
taking by officials. With the power of allocation of scare resources, such as
housing, there was an inordinate potential for corruption."_ [**Op. Cit.**, p.
193]

The growth in **power** of the bureaucracy should not, therefore, come as a
major surprise given that it had existed from the start in sizeable numbers.
Yet, for the Bolsheviks _"the development of a bureaucracy"_ was a puzzle,
_"whose emergence and properties mystified them."_ It should be noted that,
_"[f]or the Bolsheviks, bureaucratism signified the escape of this bureaucracy
from the will of the party as it took on a life of its own."_ [**Op. Cit.**,
p. 182 and p. 190] This was the key. They did not object to the usurpation of
power by the party (indeed they placed party dictatorship at the core of their
politics and universalised it to a general principle for **all** "socialist"
revolutions). Nor did they object to the centralisation of power and activity
(and so the bureaucratisation of life). As such, the Bolsheviks failed to
understand how their own politics helped the rise of this new ruling class.
They failed to understand the links between centralism and bureaucracy.
Bolshevik nationalisation and centralism (as well as being extremely
inefficient) also ensured that the control of society, economic activity and
its product would be in the hands of the state and, so, class society would
continue. Unsurprisingly, complaints by working class people about the
privileges enjoyed by Communist Party and state officials were widespread.

Another problem was the Bolshevik vision of (centralised) democracy. Trotsky
is typical. In April 1918 he argued that once elected the government was to be
given total power to make decisions and appoint people as required as it is
_"better able to judge in the matter than"_ the masses. The sovereign people
were expected to simply obey their public servants until such time as they
_"dismiss that government and appoint another."_ Trotsky raised the question
of whether it was possible for the government to act _"against the interests
of the labouring and peasant masses?"_ And answered no! Yet it is obvious that
Trotsky's claim that _"there can be no antagonism between the government and
the mass of the workers, just as there is no antagonism between the
administration of the union and the general assembly of its members"_ is just
nonsense. [**Leon Trotsky Speaks**, p. 113] The history of trade unionism is
full of examples of committees betraying their membership. Needless to say,
the subsequent history of Lenin's government shows that there can be
_"antagonism"_ between rulers and ruled and that appointments are always a key
way to further elite interests.

This vision of top-down "democracy" can, of course, be traced back to Marx and
Lenin (see sections [H.3.2](secH3.html#sech32) and
[H.3.3](secH3.html#sech33)). By equating centralised, top-down decision making
by an elected government with "democracy," the Bolsheviks had the ideological
justification to eliminate the functional democracy associated with the
soviets, factory committees and soldiers committees. The Bolshevik vision of
democracy became the means by which real democracy was eliminated in area
after area of Russian working class life. Needless to say, a state which
eliminates functional democracy in the grassroots will not stay democratic in
any meaningful sense for long.

Nor does it come as too great a surprise to discover that a government which
considers itself as _"better able to judge"_ things than the people finally
decides to annul any election results it dislikes. As we discussed in [section
H.5](secH5.html), this perspective is at the heart of vanguardism, for in
Bolshevik ideology the party, not the class, is in the final analysis the
repository of class consciousness. This means that once in power it has a
built-in tendency to override the decisions of the masses it claimed to
represent and justify this in terms of the advanced position of the party (as
historian Richard Sakwa notes a _"lack of identification with the Bolshevik
party was treated as the absence of political consciousness altogether"_
[**Op. Cit.**, p. 94]). Combine this with a vision of "democracy" which is
highly centralised and which undermines local participation then we have the
necessary foundations for the turning of party power into party dictatorship.

Which brings us to the next issue, namely the Bolshevik idea that the party
should seize power, not the working class as a whole, equating party power
with popular power. The question instantly arises of what happens if the
masses turn against the party? The gerrymandering, disbanding and
marginalisation of the soviets in the spring and summer of 1918 answers that
question (see [last section](secH6.html#sech61)). It is not a great step to
party dictatorship **over** the proletariat from the premises of Bolshevism.
In a clash between soviet democracy and party power, the Bolsheviks
consistently favoured the latter - as would be expected given their ideology.

This can be seen from the Bolsheviks' negative response to the soviets of
1905. At one stage the Bolsheviks demanded the St. Petersburg soviet accept
the Bolshevik political programme and then disband. The rationale for these
attacks is significant. The St. Petersburg Bolsheviks were convinced that
_"only a strong party along class lines can guide the proletarian political
movement and preserve the integrity of its program, rather than a political
mixture of this kind, an indeterminate and vacillating political organisation
such as the workers council represents and cannot help but represent."_
[quoted by Anweiler, **The Soviets**, p. 77] In other words, the soviets could
not reflect workers' interests because they were elected by the workers! The
implications of this perspective became clear in 1918, as are its obvious
roots in Lenin's arguments in **What is to be Done?**. As one historian
argues, the 1905 position on the soviets _"is of particular significance in
understanding the Bolshevik's mentality, political ambitions and **modus
operandi.**"_ The Bolshevik campaign _"was repeated in a number of provincial
soviets"_ and _"reveals that from the outset the Bolsheviks were distrustful
of, if not hostile towards the Soviets, to which they had at best an
instrumental and always party-minded attitude."_ The Bolsheviks actions showed
an _"ultimate aim of controlling [the soviets] and turning them into one-party
organisations, or, failing that, of destroying them."_ [Israel Getzler, _"The
Bolshevik Onslaught on the Non-Party 'Political Profile' of the Petersburg
Soviet of Workers' Deputies October-November 1905"_, **Revolutionary
History**, pp. 123-146, vol. 5, no. 2, pp. 124-5]

That the mainstream of Bolshevism expressed this perspective once in power
goes without saying, but even dissident Communists expressed identical views.
Left-Communist V. Sorin argued in 1918 that the _"party is in every case and
everywhere superior to the soviets . . . The soviets represent labouring
democracy in general; and its interest, and in particular the interests of the
petty bourgeois peasantry, do not always coincide with the interests of the
proletariat."_ [quoted by Sakwa, **Op. Cit.**, p. 182] As one historian notes,
_"[a]ccording to the Left Communists . . . the party was the custodian of an
interest higher than that of the soviets."_ Unsurprisingly, in the party there
was _"a general consensus over the principles of party dictatorship for the
greater part of the [civil] war. But the way in which these principles were
applied roused increasing opposition."_ [Sakwa, **Op. Cit.**, p. 182 and p.
30] This consensus existed in all the so-called opposition (including the
**Workers' Opposition** and Trotsky's **Left Opposition** in the 1920s). The
ease with which the Bolsheviks embraced party dictatorship is suggestive of a
fundamental flaw in their political perspective which the problems of the
revolution, combined with loss of popular support, simply exposed.

Then there is the Bolshevik vision of socialism. As we discussed in [section
H.3.12](secH3.html#sech312), the Bolsheviks, like other Marxists at the time,
saw the socialist economy as being built upon the centralised organisations
created by capitalism. They confused state capitalism with socialism. The
former, Lenin wrote in May 1917, _"is a complete **material** preparation for
socialism, the threshold of socialism"_ and so socialism _"is nothing but the
next step forward from state capitalist monopoly."_ It is _"merely state-
capitalist monopoly **which is made to serve the interests of the whole
people** and has to that extent **ceased** to be capitalist monopoly."_
[**Collected Works**, vol. 25, p. 359 and p. 358] A few months later, he was
talking about how the institutions of state capitalism could be taken over and
used to create socialism. Unsurprisingly, when defending the need for state
capitalism in the spring of 1918 against the "Left Communists," Lenin stressed
that he gave his _"'high' appreciation of state capitalism . . . **before**
the Bolsheviks seized power."_ And, as Lenin noted, his praise for state
capitalism can be found in his **State and Revolution** and so it was
_"significant that [his opponents] did **not** emphasise **this**"_ aspect of
his 1917 ideas. [**Op. Cit.**, vol. 27, p. 341 and p. 354] Unsurprisingly,
modern-day Leninists do not emphasise that element of Lenin's ideas either.

Given this perspective, it is unsurprising that workers' control was not given
a high priority once the Bolsheviks seized power. While in order to gain
support the Bolsheviks **had** paid lip-service to the idea of workers'
control, as we noted in [section H.3.14](secH3.html#sech314) the party had
always given that slogan a radically different interpretation than the factory
committees had. While the factory committees had seen workers' control as
being exercised directly by the workers and their class organisations, the
Bolshevik leadership saw it in terms of state control in which the factory
committees would play, at best, a minor role. Given who held actual power in
the new regime, it is unsurprising to discover which vision was actually
introduced:

> _"On three occasions in the first months of Soviet power, the [factory]
committee leaders sought to bring their model into being. At each point the
party leadership overruled them. The result was to vest both managerial
**and** control powers in organs of the state which were subordinate to the
central authorities, and formed by them."_ [Thomas F. Remington, **Building
Socialism in Bolshevik Russia**, p. 38]

Given his vision of socialism, Lenin's rejection of the factory committee's
model comes as no surprise. As Lenin put it in 1920, the _"domination of the
proletariat consists in the fact that the landowners and capitalists have been
deprived of their property . . . The victorious proletariat has abolished
property . . . and therein lies its domination as a class. The prime thing is
the question of property."_ [**Op. Cit.**, vol. 30, p. 456] As we proved in
[section H.3.13](secH3.html#sech313), the Bolsheviks had no notion that
socialism required workers' self-management of production and, unsurprisingly,
they, as Lenin had promised, built from the top-down their system of unified
administration based on the Tsarist system of central bodies which governed
and regulated certain industries during the war. The **Supreme Economic
Council** (Vesenka) was set up in December of 1917, and _"was widely
acknowledged by the Bolsheviks as a move towards 'statisation'
(ogosudarstvleniye) of economic authority."_ During the early months of 1918,
the Bolsheviks began implementing their vision of "socialism" and the Vesenka
began _"to build, from the top, its 'unified administration' of particular
industries. The pattern is informative"_ as it _"gradually took over"_ the
Tsarist state agencies such as the **Glakvi** (as Lenin had promised) _"and
converted them . . . into administrative organs subject to [its] direction and
control."_ The Bolsheviks _"clearly opted"_ for the taking over of _"the
institutions of bourgeois economic power and use[d] them to their own ends."_
This system _"necessarily implies the perpetuation of hierarchical relations
within production itself, and therefore the perpetuation of class society."_
[Brinton, **Op. Cit.**, p. 22, p. 36 and p. 22] Thus the Supreme Council of
the National Economy _"was an expression of the principle of centralisation
and control from above which was peculiar to the Marxist ideology."_ In fact,
it is _"likely that the arguments for centralisation in economic policy, which
were prevalent among Marxists, determined the short life of the All-Russian
Council of Workers' Control."_ [Silvana Malle, **The Economic Organisation of
War Communism, 1918-1921**, p. 95 and p. 94]

Moreover, the Bolsheviks had systematically stopped the factory committees
organising together, using their controlled unions to come _"out firmly
against the attempt of the Factory Committees to form a national
organisation."_ The unions _"prevented the convocation of a planned All-
Russian Congress of Factory Committees._ [I. Deutscher, quoted by Brinton,
**Op. Cit.**, p. 19] Given that one of the key criticisms of the factory
committees by leading Bolsheviks was their "localism", this blocking of co-
ordination is doubly damning.

At this time Lenin _"envisaged a period during which, in a workers' state, the
bourgeoisie would still retain the formal ownership and effective management
of most of the productive apparatus"_ and workers' control _"was seen as the
instrument"_ by which the _"capitalists would be coerced into co-operation."_
[Brinton, **Op. Cit.**, p. 13] The Bolsheviks turned to one-management in
April, 1918 (it was applied first on the railway workers). As the capitalists
refused to co-operate, with many closing down their workplaces, the Bolsheviks
were forced to nationalise industry and place it fully under state control in
late June 1918. This saw state-appointed "dictatorial" managers replacing the
remaining capitalists (when it was not simply a case of the old boss being
turned into a state manager). The Bolshevik vision of socialism as
nationalised property replacing capitalist property was at the root of the
creation of state capitalism within Russia. This was very centralised and very
inefficient:

> _"it seems apparent that many workers themselves . . . had now come to
believe . . . that confusion and anarchy [sic!] **at the top** were the major
causes of their difficulties, and with some justification. The fact was that
Bolshevik administration was chaotic . . . Scores of competitive and
conflicting Bolshevik and Soviet authorities issued contradictory orders,
often brought to factories by armed Chekists. The Supreme Economic Council. .
. issu[ed] dozens of orders and pass[ed] countless directives with virtually
no real knowledge of affairs."_ [William G. Rosenberg, **Russian Labour and
Bolshevik Power**, p. 116]

Faced with the chaos that their own politics, in part, had created, like all
bosses, the Bolsheviks blamed the workers. Yet abolishing the workers'
committees resulted in _"a terrifying proliferation of competitive and
contradictory Bolshevik authorities, each with a claim of life or death
importance . . . Railroad journals argued plaintively about the correlation
between failing labour productivity and the proliferation of competing
Bolshevik authorities."_ Rather than improving things, Lenin's one-man
management did the opposite, _"leading in many places . . . to a greater
degree of confusion and indecision"_ and _"this problem of contradictory
authorities clearly intensified, rather than lessened."_ Indeed, the _"result
of replacing workers' committees with one man rule . . . on the railways . . .
was not directiveness, but distance, and increasing inability to make
decisions appropriate to local conditions. Despite coercion, orders on the
railroads were often ignored as unworkable."_ It got so bad that _"a number of
local Bolshevik officials . . . began in the fall of 1918 to call for the
restoration of workers' control, not for ideological reasons, but because
workers themselves knew best how to run the line efficiently, and might obey
their own central committee's directives if they were not being constantly
countermanded."_ [William G. Rosenberg, **Workers' Control on the Railroads**,
p. D1208, p. D1207, p. D1213 and pp. D1208-9]

That it was Bolshevik policies and not workers' control which was to blame for
the state of the economy can be seen from what happened **after** Lenin's one-
man management was imposed. The centralised Bolshevik economic system quickly
demonstrated how to **really** mismanage an economy. The Bolshevik onslaught
against workers' control in favour of a centralised, top-down economic regime
ensured that the economy was handicapped by an unresponsive system which
wasted the local knowledge in the grassroots in favour of orders from above
which were issued in ignorance of local conditions. Thus the **glavki** _"did
not know the true number of enterprises in their branch"_ of industry. To
ensure centralism, customers had to go via a central orders committee, which
would then past the details to the appropriate **glavki** and, unsurprisingly,
it was _"unable to cope with these enormous tasks"_. As a result, workplaces
often _"endeavoured to find less bureaucratic channels"_ to get resources and,
in fact, the _"comparative efficiency of factories remaining outside the
**glavki** sphere increased."_ In summary, the _"shortcomings of the central
administrations and **glavki** increased together with the number of
enterprises under their control"_. [Malle, **Op. Cit.**, p. 232, p. 233 and p.
250] In summary:

> _"The most evident shortcoming . . . was that it did not ensure central
allocation of resources and central distribution of output, in accordance with
any priority ranking . . . materials were provided to factories in arbitrary
proportions: in some places they accumulated, whereas in others there was a
shortage. Moreover, the length of the procedure needed to release the products
increased scarcity at given moments, since products remained stored until the
centre issued a purchase order on behalf of a centrally defined customer.
Unused stock coexisted with acute scarcity. The centre was unable to determine
the correct proportions among necessary materials and eventually to enforce
implementation of the orders for their total quantity. The gap between theory
and practice was significant."_ [**Op. Cit.**, p. 233]

Thus there was a clear _"gulf between the abstraction of the principles on
centralisation and its reality."_ This was recognised at the time and,
unsuccessfully, challenged. Provincial delegates argued that _"[w]aste of time
was . . . the effect of strict compliance of vertical administration . . .
semi-finished products [were] transferred to other provinces for further
processing, while local factories operating in the field were shut down"_ (and
given the state of the transport network, this was a doubly inefficient). The
local bodies, knowing the grassroots situation, _"had proved to be more far-
sighted than the centre."_ For example, flax had been substituted for cotton
long before the centre had issued instructions for this. Arguments reversing
the logic of centralisation were raised: _"there was a lot of talk about
scarcity of raw materials, while small factories and mills were stuffed with
them in some provinces: what's better, to let work go on, or to make plans?"_
These _"expressed feelings . . . about the inefficiency of the **glavk**
system and the waste which was visible locally."_ Indeed, _"the inefficiency
of central financing seriously jeopardised local activity."_ While _"the
centre had displayed a great deal of conservatism and routine thinking,"_ the
localities _"had already found ways of rationing raw materials, a measure
which had not yet been decided upon at the centre."_ [**Op. Cit.**, p.269, p.
270 and pp. 272-3]

This did not result in changes as such demands _"challenged . . . the central
directives of the party"_ which _"approved the principles on which the
**glavk** system was based"_ and _"the maximum centralisation of production."_
Even the _"admission that some of the largest works had been closed down,
owning to the scarcity of raw materials and fuel, did not induce the
economists of the party to question the validity of concentration, although in
Russia at the time impediments due to lack of transport jeopardised the whole
idea of convergence of all productive activity in a few centres."_ The party
leadership _"decided to concentrate the tasks of economic reconstruction in
the hands of the higher organs of the state."_ Sadly, _"the **glavk** system
in Russia did not work . . . Confronted with production problems, the central
managers needed the collaboration of local organs, which they could not obtain
both because of reciprocal suspicion and because of a lack of an efficient
system of information, communications and transport. But the failure of
**glavkism** did not bring about a reconsideration of the problems of economic
organisation . . . On the contrary, the ideology of centralisation was
reinforced."_ [**Op. Cit.**, p. 271 and p. 275]

The failings of centralisation can be seen from the fact that in September
1918, the Supreme Economic Council (SEC) chairman reported that
_"approximately eight hundred enterprises were known to have been nationalised
and another two hundred or so were presumed to be nationalised but were not
registered as such. In fact, well over two thousand enterprises had been taken
over by this time."_ The _"centre's information was sketchy at best"_ and
_"efforts by the centre to exert its power more effectively would provoke
resistance from local authorities."_ [Thomas F. Remington, **Op. Cit.**, pp.
58-9] This kind of clashing could not help but occur when the centre had no
real knowledge nor understanding of local conditions:

> _"Organisations with independent claims to power frequently ignored it. It
was deluged with work of an ad hoc character . . . Demands for fuel and
supplies piled up. Factories demanded instructions on demobilisation and
conversion. Its presidium . . . scarcely knew what its tasks were, other than
to direct the nationalisation of industry. Control over nationalisation was
hard to obtain, however. Although the SEC intended to plan branch-wide
nationalisations, it was overwhelmed with requests to order the
nationalisation of individual enterprises. Generally it resorted to the
method, for want of a better one, of appointing a commissar to carry out each
act of nationalisation. These commissars, who worked closely with the Cheka,
had almost unlimited powers over both workers and owners, and acted largely on
their own discretion."_ [**Op. Cit.**, p. 61-2]

Unsurprisingly, _"[r]esentment of the **glavki** was strongest where local
authorities had attained a high level of competence in co-ordinating local
production. They were understandably distressed when orders from central
organs disrupted local production plans."_ Particularly given that the centre
_"drew up plans for developing or reorganising the economy of a region, either
in ignorance, or against the will, of the local authorities."_
_"Hypercentralisation"_, ironically, _"multiplied the lines of command and
accountability, which ultimately reduced central control."_ For example, one
small condensed milk plan, employing fewer than 15 workers, _"became the
object of a months-long competition among six organisations."_ Moreover, the
**glavki** _"were filled with former owners."_ Yet _"throughout 1919, as the
economic crisis grew worse and the war emergency sharper the leadership
strengthened the powers of the **glavki** in the interests of
centralisation."_ [**Op. Cit.**, p. 68, p. 69, p. 70 and p. 69]

A clearer example of the impact of Bolshevik ideology on the fate of the
revolution would be hard to find. While the situation was pretty chaotic in
early 1918, this does not prove that the factory committees' socialism was not
the most efficient way of running things under the (difficult) circumstances.
Unless of course, like the Bolsheviks, you have a dogmatic belief that
centralisation is always more efficient. That favouring the factory
committees, as anarchists stressed then and now, could have been a possible
solution to the economic problems being faced is not utopian. After all rates
of _"output and productivity began to climb steadily after"_ January 1918 and
_"[i]n some factories, production doubled or tripled in the early months of
1918 . . . Many of the reports explicitly credited the factory committees for
these increases."_ [Carmen Sirianni, **Workers' Control and Socialist
Democracy**, p. 109] Another expert notes that there is _"evidence that until
late 1919, some factory committees performed managerial tasks successfully. In
some regions factories were still active thanks to their workers' initiatives
in securing raw materials."_ [Malle, **Op. Cit.**, p. 101]

Moreover, given how inefficient the Bolshevik system was, it was only the
autonomous self-activity at the base which keep it going. Thus the
Commissariat of Finance was _"not only bureaucratically cumbersome, but [it]
involved mountainous accounting problems"_ and _"with the various offices of
the Sovnarkhoz and commissariat structure literally swamped with 'urgent'
delegations and submerged in paperwork, even the most committed supporters of
the revolution - perhaps one should say **especially** the most committed -
felt impelled to act independently to get what workers and factories needed,
even if this circumvented party directives."_ [William G. Rosenberg, _"The
Social Background to Tsektran,"_ pp. 349-373, **Party, State, and Society in
the Russian Civil War**, Diane P. Koenker, William G. Rosenberg and Ronald
Grigor Suny (eds.), p. 357] _"Requisition and confiscation of resources,"_ as
Malle notes, _"largely undertaken by the **glavki**, worked against any
possible territorial network of complementary industries which might have been
more efficient in reducing delays resulting from central financing, central
ordering, central supply and delivery."_ By integrating the factory committees
into a centralised state structure, this kind of activity became harder to do
and, moreover, came up against official resistance and opposition.
Significantly, due to _"the run-down of large-scale industry and the
bureaucratic methods applied to production orders"_ the Red Army turned to
small-scale workplaces to supply personal equipment. These workplaces
_"largely escaped the **glavk** administration"_ and _"allowed the Bolsheviks
to support a well equipped army amidst general distress and disorganisation."_
[**Op. Cit.**, p. 251, p. 477 and p. 502]

Needless to say, Lenin never wavered in his support for one-man management nor
in his belief in the efficiency of centralism to solve all problems,
particularly the problems it itself created in abundance. Nor did his explicit
call to reproduce capitalist social relations in production cause him any
concern for, if the primary issue were property and not who **manages** the
means of production, then factory committees are irrelevant in determining the
socialist nature of the economy. Equally, if (as with Engels) all forms of
organisation are inherently authoritarian then it does not fundamentally
matter whether that authority is exercised by an elected factory committee or
an appointed dictatorial manager (see [section H.4](secH4.html)). And it must
be noted that the politics of the leading members of the factory committee
movement also played its part. While the committees expressed a spontaneous
anarchism, almost instinctively moving towards libertarian ideas, the actual
influence of conscious anarchists was limited. Most of the leaders of the
movement were, or became, Bolsheviks and, as such, shared many of the statist
and centralistic assumptions of the party leadership as well as accepting
party discipline. As such, they did not have the theoretical accruement to
resist their leadership's assault on the factory committees and, as a result,
did integrate them into the trade unions when demanded.

As well as advocating one-man management, Lenin's proposals also struck at the
heart of workers' power in other ways. For example, he argued that _"we must
raise the question of piece-work and apply it and test in practice; we must
raise the question of applying much of what is scientific and progressive in
the Taylor system"_. [**Op. Cit.**, vol. 27, p. 258] As Leninist Tony Cliff
noted, _"the employers have at their disposal a number of effective methods of
disrupting th[e] unity [of workers as a class]. One of the most important of
these is the fostering of competition between workers by means of piece-work
systems."_ He added that these were used by the Nazis and the Stalinists _"for
the same purpose."_ [**State Capitalism in Russia**, pp. 18-9] Obviously
piece-work is different when Lenin introduces it!

Other policies undermined working class collectivity. Banning trade helped
undermine a collective response to the problems of exchange between city and
country. For example, a delegation of workers from the Main Workshops of the
Nikolaev Railroad to Moscow reported to a well-attended meeting that _"the
government had rejected their request [to obtain permission to buy food
collectively] arguing that to permit the free purchase of food would destroy
its efforts to come to grips with hunger by establishing a 'food
dictatorship.'"_ [David Mandel, **The Petrograd Workers and the Soviet Seizure
of Power**, p. 392] Bolshevik ideology replaced collective working class
action with an abstract "collective" response via the state, which turned the
workers into isolated and atomised individuals. As such, the Bolsheviks
provided a good example to support Malatesta's argument that _"if . . . one
means government action when one talks of social action, then this is still
the resultant of individual forces, but only of those individuals who form the
government . . . it follows. . . that far from resulting in an increase in the
productive, organising and protective forces in society, it would greatly
reduce them, limiting initiative to a few, and giving them the right to do
everything without, of course, being able to provide them with the gift of
being all-knowing."_ [**Anarchy**, pp. 38-9] Can it be surprising, then, that
Bolshevik policies aided the atomisation of the working class by replacing
collective organisation and action by state bureaucracy?

The negative impact of Bolshevik ideology showed up in other areas of the
economy as well. For example, the Leninist fetish that bigger was better
resulted in the _"waste of scare resources"_ as the _"general shortage of fuel
and materials in the city took its greatest toll on the largest enterprises,
whose overhead expenditures for heating the plant and firing the furnaces were
proportionately greater than those for smaller enterprises. This point . . .
was recognised later. Not until 1919 were the regime's leaders prepared to
acknowledge that small enterprises, under the conditions of the time, might be
more efficient in using resources; and not until 1921 did a few Bolsheviks
theorists grasp the economic reasons for this apparent violation of their
standing assumption that larger units were inherently more productive."_
[Remington, **Op. Cit.**, p. 106] Given how disrupted transport was and how
scare supplies were, this kind of ideologically generated mistake could not
fail to have substantial impact.

Post-October Bolshevik policy is a striking confirmation of the anarchist
argument that a centralised structure would stifle the initiative of the
masses and their own organs of self-management. Not only was it disastrous
from a revolutionary perspective, it was hopelessly inefficient. The
constructive self-activity of the people was replaced by the bureaucratic
machinery of the state. The Bolshevik onslaught on workers' control, like
their attacks on soviet democracy and workers' protest, undoubtedly engendered
apathy and cynicism in the workforce, alienating even more the positive
participation required for building socialism which the Bolshevik mania for
centralisation had already marginalised. The negative results of Bolshevik
economic policy confirmed Kropotkin's prediction that a revolution which
_"establish[ed] a strongly centralised Government"_, leaving it to _"draw up a
statement of all the produce"_ in a country and _"then **command** that a
prescribed quantity"_ of some good _"be sent to such a place on such a day"_
and _"stored in particular warehouses"_ would _"not merely"_ be _"undesirable,
but it never could by any possibility be put into practice."_ _"In any case,"_
Kropotkin stressed, _"a system which springs up spontaneously, under stress of
immediate need, will be infinitely preferable to anything invented between
four-walls by hide-bound theorists sitting on any number of committees."_
[**The Conquest of Bread**, pp. 82-3 and p. 75]

Some Bolsheviks were aware of the problems. One left-wing Communist, Osinskii,
concluded that _"his six weeks in the provinces had taught him that the centre
must rely on strong regional and provincial councils, since they were more
capable than was the centre of managing the nationalised sector."_ [Remington,
**Op. Cit.**, p. 71] However, Marxist ideology seemed to preclude even finding
the words to describe a possible solution to the problems faced by the regime:
_"I stand not for a local point of view and not for bureaucratic centralism,
but for organised centralism, - I cannot seem to find the actual word just
now, - a more balanced centralism."_ [Osinskii, quoted by Remington, **Op.
Cit.**, p. 71] Any anarchist would know that the word he was struggling to
find was federalism! Little wonder Goldman concluded that anarcho-syndicalism,
not nationalisation, could solve the problems facing Russia:

> _"Only free initiative and popular participation in the affairs of the
revolution can prevent the terrible blunders committed in Russia. For
instance, with fuel only a hundred versts [about sixty-six miles] from
Petrograd there would have been no necessity for that city to suffer from cold
had the workers' economic organisations of Petrograd been free to exercise
their initiative for the common good. The peasants of the Ukraina would not
have been hampered in the cultivation of their land had they had access to the
farm implements stacked up in the warehouses of Kharkov and other industrial
centres awaiting orders from Moscow for their distribution. These are
characteristic examples of Bolshevik governmentalism and centralisation, which
should serve as a warning to the workers of Europe and America of the
destructive effects of Statism."_ [**My Disillusionment in Russia**, p. 253]

If Bolshevik industrial policy reflected a basic ignorance of local conditions
and the nature of industry, their agricultural policies were even worse. Part
of the problem was that the Bolsheviks were simply ignorant of peasant life
(as one historian put it, _"the deeply held views of the party on class
struggle had overcome the need for evidence."_ [Christopher Read, **From Tsar
to Soviets**, p. 225]). Lenin, for example, thought that inequality in the
villages was much, much higher than it actually was, a mistaken assumption
which drove the unpopular and counter-productive "Committees of Poor Peasants"
(kombedy) policy of 1918. Rather than a countryside dominated by a few rich
kulaks (peasants who employed wage labour), Russian villages were
predominantly pre-capitalist and based on actual peasant farming (i.e., people
who worked their land themselves). While the Bolsheviks attacked kulaks, they,
at best, numbered only 5 to 7 per cent of the peasantry and even this is high
as only 1 per cent of the total of peasant households employed more than one
labourer. The revolution itself had an equalising effect on peasant life, and
during 1917 _"average size of landholding fell, the extremes of riches and
poverty diminished."_ [Alec Nove, **An economic history of the USSR:
1917-1991**, p. 103 and p. 102]

By 1919, even Lenin had to admit that the policies pursued in 1918, against
the advice and protest of the Left-SRs, were failures and had alienated the
peasantry. While admitting to errors, it remains the case that it was Lenin
himself, more than anyone, who was responsible for them. Still, there was no
fundamental change in policy for another two years. Defenders of the
Bolsheviks argue that they had no alternative but to use violence to seize
food from the peasants to feed the starving cities. However, this fails to
acknowledge two key facts. Firstly, Bolshevik industrial policy made the
collapse of industry worse and so the lack of goods to trade for grain was, in
part, a result of the government. It is likely that if the factory committees
had been fully supported then the lack of goods to trade may have been
reduced. Secondly, it cannot be said that the peasants did not wish to trade
with the cities. They were willing, but at a fair price as can be seen from
the fact that throughout Russia peasants with bags of grains on their backs
went to the city to exchange them for goods. In fact, in the Volga region
official state sources indicate _"that grain-hoarding and the black market did
not become a major problem until the beginning of 1919, and that during the
autumn the peasants, in general, were 'wildly enthusiastic to sell as much
grain as possible' to the government."_ This changed when the state reduced
its fixed prices by 25% and _"it became apparent that the new government would
be unable to pay for grain procurements in industrial goods."_ [Orlando Figes,
**Peasant Russia, Civil War**, p. 253 and p. 254] Thus, in that region at
least, it was **after** the introduction of central state food requisition in
January 1919 that peasants started to hoard food. Thus Bolshevik policy made
the situation worse. And as Alec Nove noted _"at certain moments even the
government itself was compelled to 'legalise' illegal trade. For example, in
September 1918 the wicked speculators and meshochniki [bag-men] were
authorised to take sacks weighing up to 1.5 poods (54 lbs.) to Petrograd and
Moscow, and in this month . . . they supplied four times more than did the
official supply organisation."_ [**Op. Cit.**, p. 55]

Yet rather than encourage this kind of self-activity, the Bolsheviks denounced
it as speculation and did all in their power to suppress it (this included
armed pickets around the towns and cities). This, of course, drove the prices
on the black market higher due to the risk of arrest and imprisonment this
entailed and so the regime made the situation worse: _"it was in fact quite
impossible to live on the official rations, and the majority of the supplies
even of bread come through the black market. The government was never able to
prevent this market from functioning, but did sufficiently disrupt it to make
food shortages worse."_ By January 1919, only 19% of all food came through
official channels and rose to around 30% subsequently. Official sources,
however, announced an increase in grain, with total procurements amounting to
30 million poods in the agricultural year 1917-18 to 110 million poods in
1918-19. [Nove, **Op. Cit.**, p. 55 and p. 54] Needless to say, the average
worker in the towns saw nothing of this improvement in official statistics
(and this in spite of dropping urban populations!).

In the face of repression (up to and including torture and the destruction of
whole villages), the peasantry responded by both cutting back on the amount of
grain planted (something compounded by the state often taking peasant reserves
for next season) and rising in insurrection. Unsurprisingly, opposition groups
called for free trade in an attempt to both feed the cities and stop the
alienation of the peasantry from the revolution. The Bolsheviks denounced the
call, before being forced to accept it in 1921 due to mass pressure from
below. Three years of bad policies had made a bad situation worse. Moreover,
if the Bolsheviks had not ignored and alienated the Left-SRs, gerrymandered
the Fifth All-Russian Congress of Soviets and pushed them into revolt then
their links with the countryside would not have been so weak and sensible
policies which reflected the reality of village life may have been
implemented.

Nor did it help that the Bolsheviks undermined Russia's extensive network of
consumer co-operatives because they were associated with the moderate
socialists. It should also be noted that the peasants (or "kulaks") were
blamed for food shortages when problems on the transport network or general
bureaucratic mismanagement was the real reason. That there is _"is little
evidence to support the Leninist view"_ that kulaks were behind the peasant
resistance and revolts resulting from the Bolshevik food requisition policies
should go without saying. [Figes, **Op. Cit.**, p. 155]

Given all this, it is not hard to conclude that alternatives existed to
Bolshevik policies - particularly as even the Bolsheviks had to admit in 1919
their decisions of the previous year were wrong! The New Economic Policy (NEP)
was introduced in 1921 (under immense popular pressure) in conditions even
worse than those in 1918, for example. Since NEP allowed wage labour, it was a
step backwards from the ideas of the peasantry itself, peasant based parties
like the SRs and Left-SRs as well as such rebels as the Kronstadt sailors. A
more socialistic policy, recognising that peasants exchanging the product of
their labour was **not** capitalism, could have been implemented much earlier
but Bolshevik ignorance and disdain for the peasantry combined with a false
belief that centralised state control was more efficient and more socialist
ensured that this option was unlikely to be pursued, particularly given the
collapse of industrial production Bolshevik state capitalist policies helped
deepen.

The pre-revolution Bolshevik vision of a socialist system was fundamentally
centralised and, consequently, top-down. This was what was implemented post-
October, with disastrous results. At each turning point, the Bolsheviks tended
to implement policies which reflected their prejudices in favour of
centralism, nationalisation and party power. Unsurprisingly, this also
undermined the genuine socialist tendencies which existed at the time and so
the Bolshevik vision of socialism and democracy played a key role in the
failure of the revolution. Therefore, the Leninist idea that politics of the
Bolsheviks had no influence on the outcome of the revolution, that their
policies during the revolution were a product purely of objective forces, is
unconvincing. This is enforced by the awkward fact that the Bolshevik leaders
_"justified what they were doing in theoretical terms, e.g. in whole books by
Bukharin and Trotsky."_ [Pirani, **The Russian Revolution in Retreat,
1920-24**, p. 9]

Remember, we are talking about the ideology of a ruling party and so it is
more than just ideas for after the seizure of power, they became a part of the
real social situation within Russia. Individually, party members assumed
leadership posts in all spheres of social life and started to make decisions
influenced by that ideology and its prejudices in favour of centralisation,
the privileged role of the party, the top-down nature of decision making, the
notion that socialism built upon state capitalism, amongst others. Then there
is the hierarchical position which the party leaders found themselves. _"If it
is true that people's real social existence determines their consciousness,"_
argued Cornelius Castoriadis, _"it is from that moment illusory to expect the
Bolshevik party to act in any other fashion than according to its real social
position. The real social situation of the Party is that of a directorial
organ, and its point of view toward this society henceforth is not necessarily
the same as the one this society has toward itself."_ [**Political and Social
Writings**, vol. 3, p. 97]

Ultimately, the Bolshevik's acted as if they were trying to prove Bakunin's
critique of Marxism was right (see [section H.1.1](secH1.html#sech11)).
Implementing a dictatorship of the proletariat in a country where the majority
were not proletarians failed while, for the proletariat, it quickly became a
dictatorship **over** the proletariat by the party (and in practice, a few
party leaders and justified by the privileged access they had to socialist
ideology). Moreover, centralisation proved to be as disempowering and
inefficient as Bakunin argued.

Sadly, far too many Marxists seem keen on repeating rather than learning from
history while, at the same time, ignoring the awkward fact that anarchism's
predictions were confirmed by the Bolshevik experience. It is not hard to
conclude that another form of socialism was essential for the Russian
revolution to have any chance of success. A decentralised socialism based on
workers running their workplaces and the peasants controlling the land was not
only possible but was being implemented by the people themselves. For the
Bolsheviks, only a centralised planned economy was true socialism and, as a
result, fought this alternative socialism and replaced it with a system
reflecting that perspective. Yet socialism needs the mass participation of all
in order to be created. Centralisation, by its very nature, limits that
participation (which is precisely **why** ruling classes have always
centralised power into states). As Russian Anarchist Voline argued, state
power _"seeks more or less to take in its hands the reins of social life. It
**predisposes the masses to passivity**, and all spirit of initiative is
stifled by the very existence of power"_ and so under state socialism the
_"tremendous new creative forces which are latent in the masses thus remain
unused."_ [**The Unknown Revolution**, p. 250] This cannot help have a
negative impact on the development of the revolution and, as anarchists had
long feared and predicted, it did.

## H.6.3 Were the Russian workers "declassed" and "atomised"?

A standard Leninist explanation for the dictatorship of the Bolshevik party
(and subsequent rise of Stalinism) is based on the _"atomisation"_ or
_"declassing"_ of the proletariat. Leninist John Rees summarised this
argument:

> _"The civil war had reduced industry to rubble. The working class base of
the workers' state, mobilised time and again to defeat the Whites, the rock on
which Bolshevik power stood, had disintegrated. The Bolsheviks survived three
years of civil war and wars in intervention, but only at the cost of reducing
the working class to an atomised, individualised mass, a fraction of its
former size, and no longer able to exercise the collective power that it had
done in 1917 . . . The bureaucracy of the workers' state was left suspended in
mid-air, its class base eroded and demoralised. Such conditions could not help
but have an effect on the machinery of the state and organisation of the
Bolshevik Party."_ [_"In Defence of October,"_ pp. 3-82, **International
Socialism**, no. 52, p. 65]

It should be noted that this perspective originated in Lenin's arguments that
the Russian proletariat had become "declassed." In 1921 it was the case that
the proletariat, _"owning to the war and to the desperate poverty and ruin,
has become declassed, i.e. dislodged from its class groove, and had ceased to
exist as proletariat . . . the proletariat has disappeared."_ [**Collected
Works**, vol. 33, p. 66] However, unlike his later-day followers, Lenin was
sure that while it _"would be absurd and ridiculous to deny that the fact that
the proletariat is declassed is a handicap"_ it could still _"fulfil its task
of winning and holding state power."_ [**Op. Cit.**, vol. 32, p. 412] Since
Lenin, this argument has been utilised repeatedly by Leninists to justify his
regime as well as explaining both its authoritarianism and the rise of
Stalinism.

It does, of course, contain an element of truth. The numbers of industrial
workers **did** decrease dramatically between 1918 and 1921, particularly in
Petrograd and Moscow (although the drop in both cities was exceptional, with
most towns seeing much smaller reductions). As one historian summarises, the
_"social turmoil at this time undeniably reduced the size of Russia's working
class . . . . Yet a substantial core of urban workers remained in the
factories, and their attitudes towards the Bolsheviks were indeed
transformed."_ [Donald J. Raleigh, **Experiencing Russia's Civil War**, p.
348] This core was those with the least ties with the countryside - the
genuine industrial worker.

Nor can it be maintained that the Russian working class was incapable of
collective action during the civil war. Throughout that period, as well as
before and after, the Russian workers proved themselves quite capable of
taking collective action - against the Bolshevik state. Simply put, an
_"atomised, individualised mass"_ does not need extensive state repression to
control it. So while the working class **was** _"a fraction of its former
size"_ it **was** able _"to exercise the collective power it had done in
1917."_ Significantly, rather than decrease over the civil war period, the
mass protests **grew** in militancy. By 1921 these protests and strikes were
threatening the very existence of the Bolshevik dictatorship, forcing it to
abandon key aspects of its economic policies.

Which shows a key flaw in the standard Leninist account - the Russian working
class, while undoubtedly reduced in size and subject to extreme economic
problems, was still able to organise, strike and protest. This awkward fact
has been systematically downplayed, when not ignored, in Leninist accounts of
this period. As in any class society, the history of the oppressed is ignored
in favour of the resolutions and decisions of the enlightened few at the top
of the social pyramid. Given the relative lack of awareness of working class
protest against the Bolsheviks, it will be necessary to present substantial
evidence of it.

This process of collective action by workers and Bolshevik repression started
before the Civil War began, continued throughout and after it. For example,
_"[t]hroughout the civil war there was an undercurrent of labour militancy in
Moscow . . . both the introduction and the phasing out of war communism were
marked by particularly active periods of labour unrest."_ In the Moscow area,
while it is _"impossible to say what proportion of workers were involved in
the various disturbances,"_ following the lull after the defeat of the protest
movement in mid-1918 _"each wave of unrest was more powerful than the last,
culminating in the mass movement from late 1920."_ [Richard Sakwa, **Soviet
Communists in Power**, p. 94 and p. 93] This was the case across Russia, with
_"periodic swings in the workers' political temper. When Soviet rule stood in
peril . . . [this] spared the regime the defection of its proletarian base.
During lulls in the fighting, strikes and demonstrations broke out."_ [Thomas
F. Remington, **Building Socialism in Bolshevik Russia**, p. 101] Workers'
resistance and protests against the Bolsheviks shows that not only that a
"workers' state" is a contradiction in terms but also that there was a social
base for possible alternatives to Leninism.

The early months of Bolshevik rule were marked by _"worker protests, which
then precipitated violent repressions against hostile workers. Such treatment
further intensified the disenchantment of significant segments of Petrograd
labour with Bolshevik-dominated Soviet rule."_ [Alexander Rabinowitch, **Early
Disenchantment with Bolshevik Rule**, p. 37] The first major act of state
repression was an attack on a march in Petrograd in support of the Constituent
Assembly when it opened in January 1918. Early May saw _"the shooting of
protesting housewives and workers in the suburb of Kolpino"_, the _"arbitrary
arrest and abuse of workers"_ in Sestroretsk, the _"closure of newspapers and
arrests of individuals who protested the Kolpino and Sestroretsk events"_ and
_"the resumption of labour unrest and conflict with authorities in other
Petrograd factories."_ This was no isolated event, as _"violent incidents
against hungry workers and their family demanding bread occurred with
increasing regularity."_ [Alexander Rabinowitch, **The Bolsheviks in Power**,
pp. 229-30] The shooting at Kolpino _"triggered a massive wave of indignation
. . . Work temporarily stopped at a number of plants."_ In Moscow, Tula,
Kolomna, Nizhnii-Novoprod, Rybinsk, Orel, Tver' and elsewhere _"workers
gathered to issue new protests."_ In Petrograd, _"textile workers went on
strike for increased food rations and a wave of demonstrations spread in
response to still more Bolshevik arrests."_ This movement was the _"first
major wave of labour protest"_ against the regime, with _"protests against
some form of Bolshevik repression"_ being common. [William Rosenberg,
**Russian Labor and Bolshevik Power**, pp. 123-4]

This general workers' opposition generated the Menshevik inspired, but
independent, Extraordinary Assembly of Delegates (EAD). _"The emergence of the
EAD"_, Rabinowitch notes, _"was also stimulated by the widespread view that
trade unions, factory committees, and soviets . . . were no longer
representative, democratically run working-class institutions; instead they
had been transformed into arbitrary, bureaucratic government agencies. There
was ample reason for this concern."_ To counter the EAD, the Bolsheviks
organised non-party conferences which, in itself, shows that the soviets had
become as distant from the masses as the opposition argued. District soviets
_"were deeply concerned about their increasing isolation . . . At the end of
March . . . they resolved to convene successive nonparty workers' conferences
. . . in part to undercut the EAD by strengthening ties between district
soviets and workers."_ This was done amidst _"unmistakable signs of the
widening rift between Bolshevik-dominated political institutions and ordinary
factory workers."_ The EAD, argues Rabinowitch, was an expression of the
_"growing disenchantment of Petrograd workers with economic conditions and the
evolving structure and operation of Soviet political institutions"_. [**Op.
Cit.**, p. 224, p. 232 and p. 231]

Anarchists should be not too surprised that the turning of popular
organisations into parts of a state soon resulted in their growing isolation
from the masses. The state, with its centralised structures, is simply not
designed for mass participation - and this does doubly for the highly
centralised Leninist state.

These protests and repression continued after the start of the civil war. _"At
the end of May and beginning of June, a wave of strikes to protest the lack of
bread swept Nivskii district factories"_ and _"strikes followed by bloody
clashes between workers and Soviet authorities had erupted in scattered parts
of central Russia."_ On June 21, a general meeting of Obukhov workers _"seized
control of the plant"_ and the next day the assembled workers _"resolved to
demand that the EAD should declare political strikes . . . to protest the
political repression of workers."_ Orders were issued by the authorities _"to
shut down Obukhov plant"_ and _"the neighbourhood surrounding the plant was
placed under martial law."_ [Rabinowitch, **Op. Cit.**, p. 231 and pp. 246-7]
However _"workers were not so readily pacified. In scores of additional
factories and shops protests mounted and rapidly spread along the railways."_
[Rosenberg, **Op. Cit.**, pp. 126-7]

Faced with this mounting pressure of spontaneous strikes, the EAD declared a
general strike for the 2nd of July. The Bolshevik authorities acted quickly:
_"Any sign of sympathy for the strike was declared a criminal act. More
arrests were made. In Moscow, Bolsheviks raided the Aleksandrovsk railroad
shops, not without bloodshed. Dissidence spread."_ On July 1st, _"machine guns
were set up at main points throughout the Petrograd and Moscow railroad
junctions, and elsewhere in both cities as well. Controls were tightened in
factories. Meetings were forcefully dispersed."_ [Rosenberg, **Op. Cit.**, p.
127] Factories were warned _"that if they participated in the general strike
they would face immediate shutdown, and individual strikes were threatened
with fines or loss of work. Agitators and members of strike committees were
subject to immediate arrest."_ Opposition printing presses _"were sealed, the
offices of hostile trade unions were raided, martial law on lines in the
Petrograd rail hub was declared, and armed patrols with authority to prevent
work stoppages were formed and put on twenty-four hour duty at key points
around the city."_ Perhaps unsurprisingly, given _"the brutal suppression of
the EAD's general strike"_, it was not successful. [Rabinowitch, **Op. Cit.**,
p. 254 and p. 259]

Thus _"[b]y the early summer of 1918"_ there were _"widespread anti-Bolshevik
protests. Armed clashes occurred in the factory districts of Petrograd and
other industrial centres."_ [William Rosenberg, **Op. Cit.**, p. 107] It
should also be noted that at the end of September of that year, there was a
revolt by Baltic Fleet sailors demanding (as they did again in 1921) a
_"return to government by liberated, democratic soviets - that is, 1917-type
soviets."_ As after the more famous 1921 revolt, the Left-SR controlled
Kronstadt soviet had been disbanded and replaced by a Bolshevik revolutionary
committee in July 1918, during the repression after the Left-SR assassination
of the German ambassador. [Rabinowitch, **Op. Cit.**, p. 352 and p. 302]

As well as state repression, the politics of the opposition played a role in
its defeat. Before October 1918, both the Mensheviks and SRs were in favour of
the Constituent Assembly and Dumas as the main organs of power, with the
soviets playing a minor role. This allowed the Bolsheviks to portray
themselves as defenders of "soviet power" (a position which still held popular
support). Understandably, many workers were unhappy to support an opposition
which aimed to replace the soviets with typically bourgeois institutions. Many
also considered the Bolshevik government as a "soviet power" and so, to some
degree, their own regime. With the civil war starting, many working class
people would also have been uneasy in protesting against a regime which
proclaimed its soviet and socialist credentials. After October 1918, the
Mensheviks supported the idea of (a democratically elected) soviet power,
joining the Left-SRs (who were now effectively illegal after their revolt of
July - see [section H.6.1](secH6.html#sech61)). However, by then it was far
too late as Bolshevik ideology had adjusted to Bolshevik practice and the
party was now advocating party dictatorship. Thus, we find Victor Serge in the
1930s noting that _"the degeneration of Bolshevism"_ was apparent by that
time, _"since at the start of 1919 I was horrified to read an article by
Zinoviev . . . on the monopoly of the party in power."_ [**The Serge-Trotsky
Papers**, p. 188] It should be noted, though, that Serge kept his horror well
hidden throughout this period - and well into the 1930s (see [section
H.1.2](secH1.html#sech12) for his public support for this monopoly).

As noted above, this cycle of resistance and repression was not limited to
Petrograd. In July 1918, a leading Bolshevik insisted _"that severe measures
were needed to deal with strikes"_ in Petrograd while in other cities
_"harsher forms of repression"_ were used. For example, in Tula, in June 1918,
the regime declared _"martial law and arrested the protestors. Strikes
followed and were suppressed by violence"_. In Sormovo, 5,000 workers went on
strike after a Menshevik-SR paper was closed. Violence was _"used to break the
strike."_ [Remington, **Op. Cit.**, p. 105]

Similar waves of protests and strikes as those in 1918 took place the
following year with 1919 seeing a _"new outbreak of strikes in March"_, with
the _"pattern of repression . . . repeated."_ One strike saw _"closing of the
factory, the firing of a number of workers, and the supervised re-election of
its factory committee."_ In Astrakhan, a mass meeting of 10,000 workers was
fired on by Red Army troops, killing 2,000 (another 2,000 were taken prisoner
and subsequently executed). [Remington, **Op. Cit.**, p. 109] Moscow, at the
end of June, saw a _"committee of defence (KOM) [being] formed to deal with
the rising tide of disturbances."_ The KOM _"concentrated emergency power in
its hands, overriding the Moscow Soviet, and demanding obedience from the
population. The disturbances died down under the pressure of repression."_
[Sakwa, **Op. Cit.**, pp. 94-5] In the Volga region, delegates to a conference
of railroad workers _"protested the Cheka's arrest of union members, which the
delegates insisted further disrupted transport. It certainly curbed the number
of strikes."_ [Raleigh, **Op. Cit.**, p. 371] In Tula _"after strikes in the
spring of 1919"_ local Menshevik party activists had been arrested while
Petrograd saw _"violent strikes"_ at around the same time. [Jonathan Aves,
**Workers Against Lenin**, p. 19 and p. 23] As Vladimir Brovkin argues in his
account of the strikes and protests of 1919:

> _"Data on one strike in one city may be dismissed as incidental. When,
however, evidence is available from various sources on simultaneous
independent strikes in different cities an overall picture begins to emerge.
All strikes developed along a similar timetable: February, brewing discontent;
March and April, peak of strikes: May, slackening in strikes; and June and
July, a new wave of strikes . . . _

> _"Workers' unrest took place in Russia's biggest and most important
industrial centres . . . Strikes affected the largest industries, primarily
those involving metal: metallurgical, locomotive, and armaments plants . . .
In some cities . . . textile and other workers were active protesters as well.
In at least five cities . . . the protests resembled general strikes."_
[_"Workers' Unrest and the Bolsheviks' Response in 1919"_, pp. 350-373,
**Slavic Review**, Vol. 49, No. 3, p. 370]

These strikes raised both economic and political demands, such as _"free and
fair elections to the soviets."_ Unsurprisingly, in all known cases the
Bolsheviks' _"initial response to strikes was to ban public meetings and
rallies"_ as well as _"occup[ying] the striking plant and dismiss[ing] the
strikers en masse."_ They also _"arrested strikers"_ and executed some. [**Op.
Cit.**, p. 371 and p. 372]

1920 saw similar waves of strikes and protests. In fact, strike action
_"remained endemic in the first nine months of 1920."_ Soviet figures report a
total of 146 strikes, involving 135,442 workers for the 26 provinces covered.
In Petrograd province, there were 73 strikes with 85,642 participants. _"This
is a high figure indeed, since at this time . . . there were 109,100 workers"_
in the province. Overall, _"the geographical extent of the February-March
strike wave is impressive"_ and the _"harsh discipline that went with labour
militarisation led to an increase in industrial unrest in 1920."_ [Aves, **Op.
Cit.**, p. 69, p. 70 and p. 80]

Saratov, for example, saw a wave of factory occupations break out in June and
mill workers went out in July while in August, strikes and walkouts occurred
in its mills and other factories and these _"prompted a spate of arrests and
repression."_ In September railroad workers went out on strike, with arrests
making _"the situation worse, forcing the administration to accept the
workers' demands."_ [Raleigh, **Op. Cit.**, p. 375] In January 1920, a strike
followed a mass meeting at a railway repair shop in Moscow. Attempts to spread
were foiled by arrests. The workshop was closed, depriving workers of their
rations and 103 workers of the 1,600 employed were imprisoned. _"In late March
1920 there were strikes in some factories"_ in Moscow and _"[a]t the height of
the Polish war the protests and strikes, usually provoked by economic issues
but not restricted to them, became particularly frequent . . . The assault on
non-Bolshevik trade unionism launched at this time was probably associated
with the wave of unrest since there was a clear danger that they would provide
a focus for opposition."_ [Sakwa, **Op. Cit.**, p. 95] The _"largest strike in
Moscow in the summer of 1920"_ was by tram workers over the equalisation of
rations. It began on August 12th, when one tram depot went on strike, quickly
followed by others while workers _"in other industries joined in to."_ The
tram workers _"stayed out a further two days before being driven back by
arrests and threats of mass sackings."_ In the textile manufacturing towns
around Moscow _"there were large-scale strikes"_ in November 1920, with 1000
workers striking for four days in one district and a strike of 500 mill
workers saw 3,000 workers from another mill joining in. [Simon Pirani, **The
Russian Revolution in Retreat, 1920-24**, p. 32 and p. 43]

In Petrograd the Aleksandrovskii locomotive building works _"had seen strikes
in 1918 and 1919"_ and in August 1920 it again stopped work. The Bolsheviks
locked the workers out and placed guards outside it. The Cheka then arrested
the SRs elected to the soviet from that workplace as well as about 30 workers.
After the arrests, the workers refused to co-operate with elections for new
soviet delegates. The _"opportunity was taken to carry out a general round-up,
and arrests were made"_ at three other works. The enormous Briansk works
_"experienced two major strikes in 1920"_, and second one saw the introduction
of martial law on both the works and the settlement it was situated in. A
strike in Tula saw the Bolsheviks declare a _"state of siege"_, although the
repression _"did not prevent further unrest and the workers put forward new
demands"_ while, in Moscow, a strike in May by printers resulted in their
works _"closed and the strikers sent to concentration camps."_ [Aves, **Op.
Cit.**, p. 41, p. 45, p. 47, pp. 48-9, pp. 53-4 and p. 59]

These expressions of mass protest and collective action continued in 1921,
unsurprisingly as the civil war was effectively over in the previous autumn.
Even John Rees had to acknowledge the general strike in Russia at the time,
stating that the Kronstadt revolt was _"preceded by a wave of serious but
quickly resolved strikes."_ [**Op. Cit.**, p. 61] Significantly, he failed to
note that the Kronstadt sailors rebelled in solidarity with those strikes and
how it was state repression which _"resolved"_ the strikes. Moreover, he
seriously downplays the scale and importance of these strikes, perhaps
unsurprisingly as _"[b]y the beginning of 1921 a revolutionary situation with
workers in the vanguard had emerged in Soviet Russia"_ with _"the simultaneous
outbreak of strikes in Petrograd and Moscow and in other industrial regions."_
In February and March 1921, _"industrial unrest broke out in a nation-wide
wave of discontent or **volynka**. General strikes, or very widespread
unrest"_ hit all but one of the country's major industrial regions and
_"workers protest consisted not just of strikes but also of factory
occupations, 'Italian strikes', demonstrations, mass meetings, the beating up
of communists and so on."_ Faced with this massive strike wave, the Bolsheviks
did what many ruling elites do: they called it something else. Rather than
admit it was a strike, they _"usually employed the word **volynka**, which
means only a 'go-slow'"_. [Aves, **Op. Cit.**, p. 3, p. 109, p. 112, pp.
111-2]

Mid-February 1921 saw workers in Moscow striking and _"massive city-wide
protest spread through Petrograd . . . Strikes and demonstrations spread. The
regime responded as it had done in the past, with lock-outs, mass arrests,
heavy show of force - and concessions."_ [Remington, **Op. Cit.**, p. 111] As
Paul Avrich recounts, in Petrograd these _"street demonstrations were heralded
by a rash of protest meetings"_ in workplaces. On the 24th of February, the
day after a workplace meeting, the Trubochny factory workforce downed tools
and walked out the factory. Additional workers from nearby factories joined
in. The crowd of 2,000 was dispersed by armed military cadets. The next day,
the Trubochny workers again took to the streets and visited other workplaces,
bringing them out on strike too. In the face of a near general strike, a
three-man Defence Committee was formed. Zinoviev _"proclaimed martial law"_
and _"[o]vernight Petrograd became an armed camp."_ Strikers were locked out
and the _"application of military force and the widespread arrests, not to
speak of the tireless propaganda waged by the authorities"_ was
_"indispensable in restoring order"_ (as were economic concessions).
[**Kronstadt 1921**, pp. 37-8, p. 39, pp. 46-7 and p. 50]

In Moscow, _"industrial unrest . . . turned into open confrontation and
protest spilled on to the streets"_, starting with a _"wave of strikes that
had its centre in the heart of industrial Moscow."_ Strikes were _"also
spreading outside Moscow city itself into the surrounding provinces"_ and so
_"Moscow and Moscow province were put under martial law"._ [Aves, **Op.
Cit.**, p. 130, p. 138, p. 143 and p. 144] This strike wave started when
_"[m]eetings in factories and plants gathered and criticised government
policies, beginning with supply and developing into general political
criticism."_ As was typical, the _"first response of the civil authorities to
the disturbances was increased repression"_ although as _"the number of
striking factories increased some concessions were introduced."_ Military
units called in against striking workers _"refused to open fire, and they were
replaced by the armed communist detachments"_ which did. _"That evening mass
protest meetings were held . . . The following day several factories went on
strike"_ and troops were _"disarmed and locked in as a precaution"_ by the
government against possible fraternising. February 23rd saw a 10,000 strong
street demonstration and _"Moscow was placed under martial law with a 24-hour
watch on factories by the communist detachments and trustworthy army units."_
The disturbances were accompanied by factory occupations and on the 1st of
March the soviet called on workers _"not to go on strike."_ However, _"wide-
scale arrests deprived the movement of its leadership."_ March 5th saw
disturbances at the Bromlei works, _"resulting in the now customary arrest of
workers. A general meeting at the plant on 25 March called for new elections
to the Moscow Soviet. The management dispersed the meeting but the workers
called on other plants to support the calls for new elections. As usual, the
ringleaders were arrested."_ [Sakwa, **Op. Cit.**, pp. 242-3, p. 245 and p.
246]

The events at the Bromlei works were significant in that the March 25th mass
meeting passed an anarchist and Left-SR initiated resolution supporting the
Kronstadt rebels. The party _"responded by having them sacked en masse"_. The
workers _"demonstrated through"_ their district _"and inspired some brief
solidarity strikes."_ Over 3000 workers joined the strikes and about 1000 of
these joined the flying picket (managers at one print shop locked their
workers in to stop them joining the protest). While the party was willing to
negotiate economic issues, _"it had no wish to discuss politics with workers"_
and so arrested those who initiated the resolution, sacked the rest of the
workforce and selectively re-employed them. Two more strikes were conducted
_"to defend the political activists in their midst"_ and two mass meetings
demanded the release of arrested ones. Workers also struck on supply issues in
May, July and August. [Pirani, **Op. Cit.**, pp. 83-4]

While the Kronstadt revolt took place too late to help the Petrograd strikes,
it did inspire a strike wave in Ekaterinoslavl (in the Ukraine) in May, 1921.
It started in the railway workshops and became _"quickly politicised,"_ with
the strike committee raising a _"series of political ultimatums that were very
similar in content to the demands of the Kronstadt rebels"_ (many of the
resolutions put to the meeting almost completely coincided with them). The
strike _"spread to the other workshops"_ and on June 1st the main large
Ekaterinoslavl factories joined the strike. The strike was spread via the use
of trains and telegraph and soon an area up to fifty miles around the town was
affected. The strike was finally ended by the use of the Cheka, using mass
arrests and shootings. Unsurprisingly, the local communists called the revolt
a _"little Kronstadt."_ [Aves, **Op. Cit.**, pp. 171-3]

Saratov also saw a mass revolt in March 1921, when a strike by railroad
workers over a reduction in food rations spread to the metallurgical plants
and other large factories _"as workers and non-workers sent representatives to
the railroad shops."_ They forced the Communists to allow the setting up of a
commission to re-examine the activities of all economic organs and the Cheka.
During the next two days, _"the assemblies held at factories to elect
delegates to the commission bitterly denounced the Communists."_ The _"unrest
spilled over into Pokrovsk."_ The commission of 270 had less than ten
Communists and _"demanded the freeing of political prisoners, new elections to
the soviets and to all labour organisations, independent unions, and freedom
of speech, the press, and assembly."_ The Communists _"resolved to shut down
the commission before it could issue a public statement"_ and set up a
Provincial Revolutionary Committee which _"introduced martial law both in the
city and the garrison"_ as well as arresting _"the ringleaders of the workers'
movement."_ The near general strike was broken by a _"wave of repression"_ but
_"railroad workers and dockworkers and some printers refused to resume work."_
[Raleigh, **Op. Cit.**, pp. 388-9]

Post-**volynka**, workplaces _"that had been prominent in unrest were
particularly hit by . . . purges . . . The effect on the willingness of
workers to support opposition parties was predictable."_ However, _"the
ability to organise strikes did not disappear"_ and they continued to take
place throughout 1921. The spring of 1922 saw _"a new strike wave."_ [Aves,
**Op. Cit.**, p. 182 and p. 183] For example, in early March, _"long strikes"_
hit the textile towns around Moscow. At the Glukhovskaia mills 5000 workers
struck for 5 days, 1000 at a nearby factory for 2 days and 4000 at the
Voskresenskaia mills for 6 days. In May, 1921, workers in the city of Moscow
reacted to supply problems _"with a wave of strikes. Party officials reckoned
that in a 24-day period in May there were stoppages at 66 large enterprises."_
These included a sit-down strike at one of Moscow's largest plants, while
_"workers at engineering factories in Krasnopresnia followed suit, and Cheka
agents reported 'dissent, culminating in strikes and occupation' in Bauman."_
August 1922 saw 19,000 workers strike in textile mills in Moscow region for
several days. Tram workers also struck that year, while teachers _"organised
strikes and mass meetings"_. Workers usually elected delegates to negotiate
with their trade unions as well as their bosses as both were Communist Party
members. Strike organisers, needless to say, were sacked. [Pirani, **Op.
Cit.**, p. 82, pp. 111-2 and p. 157]

While the strike wave of early 1921 is the most famous, due to the Kronstadt
sailors rebelling in solidarity with it, the fact is that this was just one of
many strike waves during the 1918 and 1921 period. In response to protests,
_"the government had combined concessions with severe repression to restore
order"_ as well as _"commonly resort[ing] to the lock out as a means of
punishing and purging the work force."_ Yet, _"as the strike waves show, the
regime's sanctions were not sufficient to prevent all anti-Bolshevik political
action."_ [Remington, **Op. Cit.**, p. 111, p. 107, and p. 109] In fact,
repression _"did not prevent strikes and other forms of protest by workers
becoming endemic in 1919 and 1920"_ while in early 1921 the Communist Party
_"faced what amounted to a revolutionary situation. Industrial unrest was only
one aspect of a more general crisis that encompassed the Kronstadt revolt and
the peasant rising in Tambov and Western Siberia."_ This _"industrial unrest
represented a serious political threat to the Soviet regime . . . From
Ekaterinburg to Moscow, from Petrograd to Ekaterinoslavl, workers took to the
streets, often in support of political slogans that called for the end of
Communist Party rule . . . soldiers in many of the strike areas showed
themselves to be unreliable [but] the regime was able to muster enough forces
to master the situation. Soldiers could be replaced by Chekists, officer
cadets and other special units where Party members predominated."_ [Aves,
**Op. Cit.**, p. 187, p. 155 and p. 186]

Yet, an _"atomised"_ and powerless working class does not need martial law,
lockouts, mass arrests and the purging of the workforce to control it. As
Russian anarchist Ida Mett succinctly put it: _"And if the proletariat was
that exhausted how come it was still capable of waging virtually total general
strikes in the largest and most heavily industrialised cities?"_ [**The
Kronstadt Rebellion**, p. 81] The end of the civil war also saw the Bolsheviks
finally destroy what was left of non-Bolshevik trade unionism. In Moscow, this
took place against fierce resistance of the union members. As one historian
concludes:

> _"Reflecting on the determined struggle mounted by printers, bakers and
chemical workers in Moscow during 1920-1, in spite of appalling economic
conditions, being represented by organisations weakened by constant repression
. . . to retain their independent labour organisations it is difficult not to
feel that the social basis for a political alternative existed."_ [Jonathan
Aves, _"The Demise of Non-Bolshevik Trade Unionism in Moscow: 1920-21"_, pp.
101- 33, **Revolutionary Russia**, vol. 2, no. 1, p. 130]

Elsewhere, Aves argues that an _"examination of industrial unrest after the
Bolshevik seizure of power . . . shows that the Revolution had brought to the
surface resilient traditions of organisation in society and had released
tremendous forces in favour of greater popular participation . . . The
survival of the popular movement through the political repression and economic
devastation of the Civil War testifies to its strength."_ [**Workers Against
Lenin**, p. 186] The idea that the Russian working class was incapable of
collective struggle is hard to defend given this series of struggles (and
state repression). The class struggle in Bolshevik Russia did not stop, it
continued except the ruling class had changed. All the popular energy and
organisation this expressed, which could have been used to combat the problems
facing the revolution and create the foundations of a genuine socialist
society, were wasted in fighting the Bolshevik regime. Ultimately, the
_"sustained, though ultimately futile, attempts to revive an autonomous
workers' movement, especially in mid-1918 and from late 1920, failed owing to
repression."_ [Sakwa, **Op. Cit.**, p. 269] Another historian notes that
_"immediately after the civil war"_ there was _"a revival of working class
collective action that culminated in February-March 1921 in a widespread
strike movement and the revolt at the Kronstadt naval base."_ As such, the
position expounded by Rees and other Leninists _"is so one-sided as to be
misleading."_ [Pirani, **Op. Cit.**, p. 7 and p. 23]

Nor is this commonplace Leninist rationale for Bolshevik rule particularly
original, as it dates back to Lenin and was first formulated _"to justify a
political clamp-down."_ Indeed, this argument was developed in response to
rising working class protest rather than its lack: _"As discontent amongst
workers became more and more difficult to ignore, Lenin . . . began to argue
that the consciousness of the working class had deteriorated . . . workers had
become 'declassed.'"_ However, there _"is little evidence to suggest that the
demands that workers made at the end of 1920 . . . represented a fundamental
change in aspirations since 1917."_ [Aves, **Op. Cit.**, p. 18, p. 90 and p.
91] So while the _"working class had decreased in size and changed in
composition,. . . the protest movement from late 1920 made clear that it was
not a negligible force and that in an inchoate way it retained a vision of
socialism which was not identified entirely with Bolshevik power . . . Lenin's
arguments on the declassing of the proletariat was more a way of avoiding this
unpleasant truth than a real reflection of what remained, in Moscow at least,
a substantial physical and ideological force."_ [Sakwa, **Op. Cit.**, p. 261]

Nor can it be suggested, as the Bolsheviks did at the time, that these strikes
were conducted by newly arrived workers, semi-peasants without an awareness of
proletarian socialism or traditions. Links between the events in 1917 and
those during the civil war are clear. Jonathan Aves writes that there were
_"distinct elements of continuity between the industrial unrest in 1920 and
1917 . . . As might be anticipated, the leaders of unrest were often to be
found amongst the skilled male workers who enjoyed positions of authority in
the informal shop-floor hierarchies."_ Looking at the strike wave of early
1921 in Petrograd, the _"strongest reason for accepting the idea that it was
established workers who were behind the **volynka** is the form and course of
protest. Traditions of protest reaching back through the spring of 1918 to
1917 and beyond were an important factor in the organisation of the
**volynka**"._ In fact, _"an analysis of the industrial unrest of early 1921
shows that long-standing workers were prominent in protest."_ [Aves, **Op.
Cit.**, p. 39, p. 126 and p. 91] As another example, _"although the ferment
touched all strata of Saratov workers, it must be emphasised that the skilled
metalworkers, railroad workers, and printers - the most 'conscious' workers -
demonstrated the most determined resistance."_ They _"contested repression and
the Communists' violation of fair play and workplace democracy."_ [Raleigh,
**Op. Cit.**, p. 376] As Ida Mett argued in relation to the strikes in early
1921:

> _"The population was drifting away from the capital. All who had relatives
in the country had rejoined them. The authentic proletariat remained till the
end, having the most slender connections with the countryside. _

> _"This fact must be emphasised, in order to nail the official lies seeking
to attribute the Petrograd strikes . . . to peasant elements, 'insufficiently
steeled in proletarian ideas.' The real situation was the very opposite . . .
There was certainly no exodus of peasants into the starving towns! . . . It
was the famous Petrograd proletariat, the proletariat which had played such a
leading role in both previous revolutions, that was finally to resort to the
classical weapon of the class struggle: the strike."_ [**The Kronstadt
Uprising**, p. 36]

As one expert on this issue argues, while the number of workers did drop _"a
sizeable core of veteran urban proletarians remained in the city; they did not
all disappear."_ In fact, _"it was the loss of young activists rather than of
all skilled and class-conscious urban workers that caused the level of
Bolshevik support to decline during the Civil War. Older workers had tended to
support the Menshevik Party in 1917"_. Given this, _"it appears that the
Bolshevik Party made deurbanisation and declassing the scapegoats for its
political difficulties when the party's own policies and its unwillingness to
accept changing proletarian attitudes were also to blame."_ It should also be
noted that the notion of declassing to rationalise the party's misfortunes was
used long before the civil war: _"This was the same argument used to explain
the Bolsheviks' lack of success among workers in the early months of 1917 -
that the cadres of conscious proletarians were diluted by nonproletarian
elements."_ [Diane P. Koenker, _"Urbanisation and Deurbanisation in the
Russian Revolution and Civil War"_, pp. 81-104, **Party, State, and Society in
the Russian Civil War**, Diane P. Koenker, William G. Rosenberg and Ronald
Grigor Suny (eds.), p. 96, p. 95, p. 100 and p. 84]

While there is still much research required, what facts that are available
suggest that throughout the time of Lenin's regime the Russian workers took
collective action in defence of their interests. This is not to say that
workers did not also respond to the problems they faced in an individualistic
manner, often they did. However, such responses were, in part (as we noted in
the [last section](secH6.html#sech62)), because Bolshevik policy **itself**
gave them little choice as it limited their ability to respond collectively.
Yet in the face of difficult economic circumstances, workers turned to mass
meetings and strikes. In response, the Bolsheviks used state repression to
break resistance and protest against their regime. In such circumstances it is
easy to see how the Bolshevik party became isolated from the masses they
claimed to be leading but were, in fact, ruling. This transformation of rebels
into a ruling elite comes as no great surprise given that Bolsheviks aimed to
seize power themselves in a centralised and hierarchical institution, a state,
which has always been the method by which ruling classes secured their
position (as we argued in [section H.3.7](secH3.html#sech37), this perspective
flowed from the flawed Marxist theory of the state). Just as they had to,
first, gerrymander and disband soviets to regime in power in the spring and
summer of 1918, so the Bolsheviks had to clamp down on any form of collective
action by the masses. As such, it is incredulous that latter day Leninists
justify Bolshevik authoritarianism on a lack of collective action by workers
when that authoritarianism was often driven precisely to break it!

So the claim by John Rees that the _"dialectical relationship between the
Bolsheviks and the working class was broken, shattered because the working
class itself was broke-backed after the civil war"_ leaves a lot to be
desired. [**Op. Cit.**, p. 22] The Bolsheviks did more than their fair share
of breaking the back of the working class. This is unsurprising for a
government which grants to the working class the greatest freedom undermines
its own power by so doing. Even a limited relaxation of its authority will
allow people to organise themselves, listen to alternative points of view and
to act on them. That could not but undermine the rule of the party and so
could not be supported - nor was it.

For example, in his 1920 diatribe against Left-wing Communism, Lenin pointed
to _"non-Party workers' and peasants' conferences"_ and Soviet Congresses as
means by which the party secured its rule. Yet, **if** the congresses of
soviets were _"**democratic** institutions, the like of which even the best
democratic republics of the bourgeois have never known"_, the Bolsheviks would
have no need to _"support, develop and extend"_ non-Party conferences _"to be
able to observe the temper of the masses, come closer to them, meet their
requirements, promote the best among them to state posts"._ [**The Lenin
Anthology**, p. 573] How the Bolsheviks met _"their requirements"_ is
extremely significant - they disbanded them, just as they had with soviets
with non-Bolshevik majorities in 1918. This was because _"[d]uring the
disturbances"_ of late 1920, _"they provided an effective platform for
criticism of Bolshevik policies."_ Their frequency was decreased and they
_"were discontinued soon afterward."_ [Sakwa, **Op. Cit.**, p. 203]

In the soviets themselves, workers turned to non-partyism, with non-party
groups winning majorities in soviet delegates from industrial workers'
constituencies in many places. This was the case in Moscow, where Bolshevik
support among _"industrial workers collapsed"_ in favour of non-party people.
Due to support among the state bureaucracy and the usual packing of the soviet
with representatives from Bolshevik controlled organisations, the party had,
in spite of this, a massive majority. Thus the Moscow soviet elections of
April-May 1921 _"provided an opportunity to revive working-class
participation. The Bolsheviks turned it down."_ [Pirani, **Op. Cit.**, pp.
97-100 and p. 23] Indeed, one Moscow Communist leader stated that these soviet
elections had seen _"a high level of activity by the masses and a striving to
be in power themselves."_ [quoted by Pirani, **Op. Cit.**, p. 101]

1921 also saw the Bolsheviks disperse provincial trade unions conferences in
Vologda and Vitebsk _"because they had anti-communist majorities."_ [Aves,
**Op. Cit.**, p. 176] At the All-Russian Congress of Metalworkers' Union in
May, the delegates voted down the party-list of recommended candidates for
union leadership. The Central Committee of the Party _"disregarded every one
of the votes and appointed a Metalworkers' Committee of its own. So much for
'elected and revocable delegates'. Elected by the union rank and file and
revocable by the Party leadership!"_ [Brinton, **Op. Cit.**, p. 83]

Another telling example is provided in August 1920 by Moscow's striking tram
workers who, in addition to economic demands, called for a general meeting of
all depots. As one historian notes, this was _"significant: here the workers'
movement was trying to get on the first rung of the ladder of organisation,
and being knocked off by the Bolsheviks."_ The party _"responded to the strike
in such a way as to undermine workers' organisation and consciousness"_ and
_"throttl[ed] independent action"_ by _"repression of the strike by means
reminiscent of tsarism."_ The Bolshevik's _"dismissive rejection"_ of the
demand for a city-wide meeting _"spoke volumes about their hostility to the
development of the workers' movement, and landed a blow at the type of
collective democracy that might have better able to confront supply
problems."_ This, along with the other strikes that took place, showed that
_"the workers' movement in Moscow was, despite its numerical weakness and the
burdens of civil war, engaged with political as well as industrial issues . .
. the working class was far from non-existent, and when, in 1921, it began to
resuscitate soviet democracy, the party's decision to make the Moscow soviet
its 'creature' was not effect but cause."_ [Pirani, **Op. Cit.**, p. 32, p.
33, p. 37 and p. 8]

When such things happen, we can conclude that Bolshevik desire to remain in
power had a significant impact on whether workers were able to exercise
collective power or not. As Pirani concludes:

> _"one of the most important choices the Bolsheviks made . . . was to turn
their backs on forms of collective, participatory democracy that workers
briefly attempted to revive [post civil war]. [Available evidence] challenges
the notion . . . that political power was forced on the Bolsheviks because the
working class was so weakened by the civil war that it was incapable of
wielding it. In reality, non-party workers were willing and able to
participate in political processes, but in the Moscow soviet and elsewhere,
were pushed out of them by the Bolsheviks. The party's vanguardism, i.e. its
conviction that it had the right, and the duty, to make political decisions on
the workers' behalf, was now reinforced by its control of the state apparatus.
The working class was politically expropriated: power was progressively
concentrated in the party, specifically in the party elite."_ [**Op. Cit.**,
p. 4]

It should also be stressed that fear of arrest limited participation. A sadly
typical example of this occurred in April 1920, which saw the first conference
of railway workers on the Perm-Ekaterinburg line. The meeting of 160 delegates
elected a non-Party chairman who _"demanded that delegates be guaranteed
freedom of debate and immunity from arrest."_ [Aves, **Op. Cit.**, p. 44] A
Moscow Metalworkers' Union conference in early February 1921 saw the first
speakers calling _"for the personal safety of the delegates to be guaranteed"_
before criticisms would be aired. [Sakwa, **Op. Cit.**, p. 244] Later that
year dissidents in the Moscow soviet demanded _"that delegates be given
immunity from arrest unless sanctioned by plenary session of the soviet."_
Immediately afterwards two of them, including an anarcho-syndicalist, were
detained. It was also proposed that delegates' freedom of speech _"included
immunity from administrative or judicial punishment"_ along with the right of
any number of delegates _"to meet and discuss their work as they chose."_
[Pirani, **Op. Cit.** p. 104] Worse, _"[b]y the end of 1920 workers not only
had to deal with the imposition of harsh forms of labour discipline, they also
had to face the Cheka in their workplace."_ This could not help hinder working
class collective action, as did the use of the Cheka and other troops to
repress strikes. While it is impossible to accurately measure how many workers
were shot by the Cheka for participation in labour protest, looking at
individual cases _"suggests that shootings were employed to inspire terror and
were not simply used in the occasional extreme case."_ [Aves, **Op. Cit.**, p.
35] Which means, ironically, those who had seized power in 1917 in the name of
the politically conscious proletariat were in fact ensuring their silence by
fear of the Cheka or weeding them out, by means of workplace purges and
shooting.

Perhaps unsurprisingly, but definitely significantly, of the 17,000 camp
detainees on whom statistical information was available on 1 November 1920,
peasants and workers constituted the largest groups, at 39% and 34%
respectively. Similarly, of the 40,913 prisoners held in December 1921 (of
whom 44% had been committed by the Cheka) nearly 84% were illiterate or
minimally educated, clearly, therefore, either peasants or workers. [George
Leggett, **The Cheka: Lenin's Political Police**, p. 178] Needless to say,
Lenin failed to mention this aspect of his system in **The State and
Revolution** (a failure shared by later Leninists). Ultimately, the
contradictions between Bolshevik rhetoric and the realities of working class
life under their rule was closed by coercion.

Such forms of repression could not help ensure both economic chaos and push
the revolution away from socialism. As such, it is hard to think of a more
incorrect assertion than Lenin's 1921 one that _"[i]ndustry is indispensable,
democracy is not. Industrial democracy breeds some utterly false ideas."_
[**Collected Works**, vol. 32, p. 27] Yet without industrial democracy, any
development towards socialism is aborted and the problems of a revolution
cannot be solved in the interests of the working masses.

This account of workers' protest being crushed by the so-called workers' state
raises an important theoretical question. Following Marx and Engels, Lenin
asserted that the _"state is nothing but a machine for the suppression of one
class by another"_ [**Collected Works**, vol. 28, p. 259] Yet here is the
working class being suppressed by "its" state. If the state is breaking
strikes, including general strikes, by what stretch of the imagination can it
be considered a "workers' state"? Particularly as the workers, like the
Kronstadt sailors, demanded free soviet elections, **not**, as the Leninists
then and now claim, "soviets without Communists" (although one soviet
historian noted with regards the 1921 revolt that _"taking account of the mood
of the workers, the demand for free elections to the soviets meant the
implementation in practice of the infamous slogan of soviets without
communists."_ [quoted by Aves, **Op. Cit.**, p. 123]). If the workers are
being repressed and denied any real say in the state, how can they be
considered the ruling class? And what class is doing the _"suppression"_? As
we discussed in [section H.3.8](secH3.html#sech38), Bolshevik ideology
adjusted to this reality by integrating the need for party dictatorship to
combat the "wavering" within the working class into its theory of the state.
Yet it is the party (i.e., the state) which determines what is and is not
wavering. This suggests that the state apparatus has to be separate from the
working class in order to repress it (as always, in its own interests).

So anarchists argue that the actual experience of the Bolshevik state shows
that the state is no mere _"machine"_ of class rule but has interests of its
own. Which confirms the anarchist theory of the state rather than the Marxist
(see [section H.3.7](secH3.html#sech37)). It should be stressed that it was
**after** the regular breaking of working class protest and strikes that the
notion of the dictatorship of the party became Bolshevik orthodoxy. This makes
sense, as protests and strikes express "wavering" within the working class
which needs to be solved by state repression. This, however, necessitates a
normal state power, one which is isolated from the working class and which, in
order to enforce its will, **must** (like any state) atomise the working class
people and render them unable, or unwilling, to take collective action in
defence of their interests. For the defenders of Bolshevism to turn round and
blame Bolshevik authoritarianism on the atomisation required for the party to
remain in power and enforce its will is staggering.

Finally, it should be noted that Zinoviev, a leading Bolshevik, tried to
justify the hierarchical position of the Bolshevik party arguing that _"[i]n
time of strike every worker knows that there must be a Strike Committee - a
centralised organ to conduct the strike, whose orders must be obeyed -
although this Committee is elected and controlled by the rank and file.
**Soviet Russia is on strike against the whole capitalist world. The social
Revolution is a general strike against the whole capitalist system. The
dictatorship of the proletariat is the strike committee of the social
Revolution.**"_ [**Proceedings and Documents of the Second Congress 1920**,
vol. 2, p. 929]

In strikes, however, the decisions which are to be obeyed are those of the
strikers. They should make the decisions and the strike committees should
carry them out. The actual decisions of the Strike Committee should be
accountable to the assembled strikers who have the real power (and so power is
**decentralised** in the hands of the strikers and not in the hands of the
committee). A far better analogy for what happened in Russia was provided by
Emma Goldman:

> _"There is another objection to my criticism on the part of the Communists.
Russia is on strike, they say, and it is unethical for a revolutionist to side
against the workers when they are striking against their masters. That is pure
demagoguery practised by the Bolsheviki to silence criticism. _

> _"It is not true that the Russian people are on strike. On the contrary, the
truth of the matter is that the Russian people have been **locked out** and
that the Bolshevik State - even as the bourgeois industrial master - uses the
sword and the gun to keep the people out. In the case of the Bolsheviki this
tyranny is masked by a world-stirring slogan: thus they have succeeded in
blinding the masses. Just because I am a revolutionist I refuse to side with
the master class, which in Russia is called the Communist Party."_ [**My
Disillusionment in Russia**, p. xlix]

The isolation of the Bolsheviks from the working class was, in large part,
required to ensure their power and, moreover, a natural result of utilising
state structures. _"The struggle against oppression - political, economic, and
social, against the exploitation of man by man"_ argued Alexander Berkman,
_"is always simultaneously a struggle against government as such. The
political State, whatever its form, and constructive revolutionary effort are
irreconcilable. They are mutually exclusive."_ Every revolution _"faces this
alternative: to build freely, independently and despite of the government, or
to choose government with all the limitation and stagnation it involves . . .
Not by the order of some central authority, but organically from life itself,
must grow up the closely knit federation of the industrial, agrarian, and
other associations; by the workers themselves must they be organised and
managed."_ The _"very essence and nature"_ of the socialist state _"excludes
such an evolution. Its economic and political centralisation, its
governmentalism and bureaucratisation of every sphere of activity and effort,
its inevitable militarisation and degradation of the human spirit mechanically
destroy every germ of new life and extinguish the stimuli of creative,
constructive work."_ [**The Bolshevik Myth**, pp. 340-1] By creating a new
state, the Bolsheviks ensured that the mass participation required to create a
genuine socialist society could not be expressed and, moreover, came into
conflict with the Bolshevik authorities and their attempts to impose their
(essentially state capitalist) vision of "socialism".

It need not have been that way. As can be seen from our discussion of labour
protest under the Bolsheviks, even in extremely hard circumstances the Russian
people were able to organise themselves to conduct protest meetings,
demonstrations and strikes. The social base for an alternative to Bolshevik
power and policies existed. Sadly Bolshevik politics, policies and the
repression they required ensured that it could not be used constructively
during the revolution to create a genuine socialist revolution.

[‹ H.5 What is vanguardism and why do anarchists reject it?](/afaq/secH5.html
"Go to previous page" ) [up](/afaq/secHcon.html "Go to parent page" ) [Section
I - What would an anarchist society look like? ›](/afaq/secIcon.html "Go to
next page" )

