# C.8 Is state control of money the cause of the business cycle?

As explained in the [last section](secC7.html), capitalism will suffer from a
boom-and-bust cycle due to objective pressures on profit production even if we
ignore the subjective revolt against authority by working class people. It is
this two-way pressure on profit rates, the subjective and objective, which
causes the business cycle and such economic problems as _"stagflation."_
However, for supporters of the free market, this conclusion is unacceptable
and so they usually try to explain the business cycle in terms of **external**
influences rather than those generated by the way capitalism works. Most
pro-"free market" capitalists blame government intervention in the market,
particularly state control over money, as the source of the business cycle.
This analysis is defective, as will be shown below.

First it should be noted that many supporters of capitalism ignore the
"subjective" pressures on capitalism that we discussed in [section
C.7.1](secC7.html#secc71). In addition, the problems associated with rising
capital investment (as highlighted in [section C.7.3](secC7.html#secc73)) are
also usually ignored, because they usually consider capital to be "productive"
and so cannot see how its use could result in crises. This leaves them with
the problems associated with the price mechanism, as discussed in [section
C.7.2](secC7.html#secc72). It is here, in the market for credit and money,
that the role of the state comes into play, distorting the natural workings of
the market and causing the ups and downs of business.

In pre-Keynesian bourgeois economics, the reason why Say's Law is applicable
in a money economy is the interest rate. As we discussed in [section
C.2.6](secC2.html#secc26), this is claimed to reflect the _"time preference"_
of individuals. While it is possible for sales not to be turned into purchases
in the market, the money involved is not withdrawn from the economy. Rather,
it is saved and made available to investors. The interest rate is the means by
which savings and investment come into line. This means that Say's Law is
maintained as savings are used to purchase capital goods and so demand and
supply match. As long as interest rates are working as they should, the
possibility of a general crisis is impossible. The problem is that the credit
system does not work exactly as it claimed and this lies with the banks who
introduce fractional reserve banking. This allows them to loan out more money
than they have in savings in order to increase their profits. This lowers the
rate of interest below its _"natural"_ (or equilibrium) rate and thus firms
get price signals which do not reflect the wishes of consumers for future
goods rather than current ones. This causes over-investment and, ultimately, a
crisis. This is because, eventually, interest rates must rise and projects
which were profitable at the lower rate of interest will no longer be so. The
moral of the theory is that if the actual rate of interest equalled the
_"natural"_ rate then a situation of _"neutral"_ money would be achieved and
so misdirections of production would be avoided, so ending the business cycle.

As far as capitalist economics had a theory of the business cycle, this was it
and it was the dominant ideological position within the profession until
publication of Keynes' **The General Theory of Employment, Interest and
Money** in 1936. Politically, it was very useful as it recommended that the
state should do nothing during the crisis and this was the preferred position
of right-wing governments in America and Britain. It was forcefully argued by
"Austrian" economist Frederick von Hayek during the early 1930s, who was
repeating the earlier arguments of his mentor Ludwig von Mises and has been
repeated by their followers ever since. Yet, for some strange reason, they
almost always fail to mention that Hayek was roundly defeated in the
theoretical battles of the time by Keynesians. In fact, his former students
(including John Hicks and Nicholas Kaldor) showed how Hayek's theory was
flawed and he gave up business cycle research in the early 1940s for other
work. Kaldor's first critique (_"Capital Intensity and the Trade Cycle"_), for
example, resulted in Hayek completed rewriting his theory while Kaldor's
second article (_"Professor Hayek and the Concertina-effect"_) showed that
Hayek's Ricardo Effect was only possible under some very special circumstances
and so highly unlikely. [Kaldor, **Essays on Economic Stability and Growth**,
pp. 120-147 and pp. 148-176]

Kaldor's critique was combined with an earlier critique by Piero Sraffa who
noted that Hayek's desire for _"neutral"_ money was simply impossible in any
real capitalist economy for _"a state of things in which money is 'neutral' is
identical with a state in which there is no money at all."_ Hayek _"completely
ignored"_ the fact that _"money is not only the medium of exchange, but also a
store of value"_ which _"amounts to assuming away the very object of the
inquiry."_ Sraffa also noted that the starting point of Hayek's theory was
flawed: _"An essential confusion . . . is the belief that the divergence of
rates is a characteristic of a money economy . . . If money did not exist, and
loans were made in terms of all sorts of commodities, there would be a single
rate which satisfies the conditions of equilibrium, but there might be at any
moment as many 'natural' rates of interest as there are commodities, though
they would not be 'equilibrium' rates. The 'arbitrary' action of the banks is
by no means a necessary condition for the divergence; if loans were made in
wheat and farmers (or for that matter the weather) 'arbitrarily changed' the
quantity of wheat produced, the actual rate of interes on loans in terms of
wheat would diverge from the rate on other commodities and there would be no
single equilibrium rate."_ [_"Dr. Hayek on Money and Capital,"_ pp. 42-53,
**The Economic Journal**, vol. 42, no. 165, p. 42, pp. 43-4 and p. 49] Hayek
admitted that this was a possibility, to which Sraffa replied:

> _"only under conditions of equilibrium would there be a single rate, and
that when saving was in progress there would be at any one moment be many
'natural' rates, possibly as many as there are commodities; so that it would
be not merely difficult in practice, but altogether inconceivable, that the
money rate would be equal to 'the' natural rate . . . Dr. Hayek now
acknowledges the multiplicity of the 'natural' rates, but he has nothing more
to say on this specific point than that they 'all would be equilibrium rates.'
The only meaning (if it be a meaning) I can attach to this is that his maxim
of policy now requires that the money rate should be equal to all these
divergent natural rates."_ [_"A Rejoinder,"_ pp. 249-251, **Op. Cit.** Vol.
42, No. 166, p. 251]

Then there was the practical suggestions that flowed from the analysis, namely
do nothing. It also implied that the best thing to do in a recession or
depression is not to spend, but rather to save as this will bring the savings
and loans back into the equilibrium position. Economist R. F. Kahn recounted
when Hayek presented his theory at a seminar in Cambridge University. His
presentation was followed by silence. Then Kahn asked the obvious question:
_"Is it your view that if I went out tomorrow and bought a new overcoat, that
would increase unemployment?"_ All that Hayek could offer in reply was the
unconvincing claim that to show why would require a complicated mathematical
argument. The notion that reducing consumption in a depression was the best
thing to do convinced few people and the impact of such saving should be
obvious, namely a collapse in demand for goods and services. Any savings
would, in the circumstances of a recession, be unlikely to be used for
investing. After all, which company would start increasing its capital stock
facing a fall in demand and which capitalist would venture to create a new
company during a depression? Unsurprisingly, few economists thought that
advocating a deflationary policy in the midst of the most severe economic
crisis in history made much sense. It may have been economic orthodoxy but
making the depression worse in order to make things better would have ensured
either the victory of fascism or some-sort of socialist revolution.

Given these practical considerations and the devastating critiques inflicted
upon it, Keynesian theory became the dominant theme in economics (particularly
once it had been lobotomised of any ideas which threatened neo-classical
supremacy -- see [section C.8.1](secC8.html#secc81)). This has not, as noted,
stopped Hayek's followers repeating his theory to this day (nor has its roots
in equilibrium theory bothered them -- see [section
C.1.6](secC1.html#secc16)). Bearing this in mind, it is useful to discuss this
theory because it reflects the pre-Keynesian orthodoxy although we must stress
that our discussion of "Austrian" economics here should not be taken as
suggesting that they are a significant school of thought or that their
influence is large. Far from it -- they still remain on the sidelines of
economics where they were pushed after von Hayek's defeat in the 1930s. We use
them simply because they are the only school of thought which still subscribes
fully to the pre-Keynesian position. Most modern neo-classical economists pay
at least lip-service to Keynes.

Take, for example, "Austrian" economist W. Duncan Reekie's argument that the
business cycle _"is generated by monetary expansion and contraction . . . When
new money is printed it appears as if the supply of savings has increased.
Interest rates fall and businessmen are misled into borrowing additional funds
to finance extra investment activity."_ This would be of _"no consequence"_ if
it had been the outcome of genuine saving _"but the change was government
induced . . . Capital goods industries will find their expansion has been in
error and malinvestments have been incurred"_ and so there has been _"wasteful
mis-investment due to government interference with the market."_ [**Markets,
Entrepreneurs and Liberty**, pp. 68-9]

Yet the government does **not** force banks to make excessive loans and this
is the first, and most obvious, fallacy of argument. After all, what Reekie is
actually complaining about when he argues that _"state action"_ creates the
business cycle by creating excess money is that the state **allows** bankers
to meet the demand for credit by creating it. This makes sense, for how could
the state force bankers to expand credit by loaning more money than they have
savings? This is implicitly admitted when Reekie argues that _"[o]nce
fractional reserve banking is introduced, however, the supply of money
substitutes will include fiduciary media. The ingenuity of bankers, other
financial intermediaries and the endorsement and **guaranteeing of their
activities by governments and central banks** has ensured that the quantity of
fiat money is immense."_ [**Op. Cit.**, p. 73] As we will discuss in detail
below what is termed _"credit money"_ (created by banks) is an essential part
of capitalism and would exist without a system of central banks. This is
because money is created from within the system, in response to the needs of
capitalists. In a word, the money supply is endogenous.

The second fallacy of this theory of the business cycle lies with the
assumption that the information provided by the interest rate itself is
sufficient in itself to ensure rational investment decisions, it that provides
companies and individuals with accurate information about how price changes
will affect future trends in production. Specifically, the claim is that
changes in interest rates (i.e. changes in the demand and supply of credit)
indirectly inform companies of the responses of their competitors. As John
O'Neill argues, the argument assumes _"that information about the panned
responses of producers in competition is indirectly distributed by changes in
interest rates: the planned increase in production by separate producers is
reflected in an increased demand for credit, and hence a rise in interest
rates."_ [**The Market**, p. 135]

For example, if the price of tin rises, this will lead to an expansion in
investment in the tin industry to reap the higher profits this implies. This
would lead to a rise in interest rates as more credit is demanded. This rise
in interest rates lowers anticipated profits and dampens the expansion. The
expansion of credit stops this process by distorting the interest rate and so
stops it performing its economic function. This results in overproduction as
interest rates do not reflect **real** savings and so capitalists over-invest
in new capital, capital which appears profitable only because the interest
rate is artificially low. When the rate inevitably adjusts upwards towards its
"natural" value, the invested capital becomes unprofitable and so over-
investment appears. Hence, according to the argument, by eliminating state
control of money these negative effects of capitalism would disappear as the
credit system, if working correctly, will communicate all the relevant
information required by capitalists.

_"However,"_ argues O'Neil, _"this argument is flawed. It is not clear that
the relevant information is communicated by changes in interest rates."_ This
is because interest rates reflect the general aggregate demand for credit in
an economy. However, the information which a **specific** company requires
_"if the over-expansion in the production of some good is to be avoided is not
the general level of demand for credit, but the level of demand amongst
competitors."_ It does not provide the relative demands in different
industries (the parallels with Sraffa's critique should be obvious). _"An
increase in the planned production of some good by a group of competitors will
be reflected in a proportional change in interest rates only if it is assumed
that the change in demand for credit by that group is identical with that
found in the economy as a whole, i.e. if rates of change in the demand for
credit are even throughout an economy. However, there is no reason to suppose
such an assumption is true, given the different production cycles of different
industries."_ This will produce differing needs for credit (in both terms of
amount and of intensity). _"Assuming uneven changes in the demand for credit"_
between industries reflecting uneven changes in their requirements it is quite
possible for over-investment (and so over-production) to occur _"even if the
credit system is working 'satisfactorily'"_ (i.e., as it should in theory. The
credit system, therefore, _"does not communicate the relevant information"_
and for this reason _"it is not the case that we must look to a departure from
an ideal credit system to explain the business cycle."_ [**Op. Cit.**, pp.
135-6]

Another underlying assumption in this argument is that the economy is close to
equilibrium (a concept which "Austrian" economists claim to reject). After
all, rising interest rates will cause debt-servicing to become harder even if
it reflects the _"natural"_ rate. Equally, it also suggests that both banks
and firms are capable of seeing into the future. For even **if** the credit
market is working as postulated in the theory it does not mean that firms and
banks do not make mistakes nor experience unexpected market situations. In
such circumstances, firms may find it impossible to repay loans, credit chains
may start to break as more and more firms find themselves in economic
difficulties. Just because actual interest rates somehow equal the natural
rate does not make the future any more certain nor does it ensure that credit
is invested wisely. Crucially, it does not ensure that credit is not used to
inflate a bubble or add to over-investment in a specific sector of the
economy. To assume otherwise suggests the firms and banks rarely make mistakes
and that the accumulative impact of all decisions move an economy always
towards, and never away from, equilibrium. As Post-Keynesian Paul Davidson
dryly noted, _"Austrian subjectivists cannot have it both ways -- they cannot
argue for the importance of time, uncertainty, and money, and simultaneously
presume that plan or pattern co-ordination must exist and is waiting to be
discovered."_ [_"The economics of ignorance or the ignorance of economics?"_,
pp. 467-87, **Critical Review**, vol. 3, no. 3-4, p. 468]

In other words, the notion that if the actual interest rate somehow equalled
the _"natural"_ one is not only rooted in equilibrium but also the neo-
classical notion of perfect knowledge of current and future events -- all of
which "Austrian" economists are meant to reject. This can be seen when Murray
Rothbard states that entrepreneurs _"are trained to forecast the market
correctly; they only make mass errors when governmental or bank intervention
distorts the 'signals' of the market."_ He even attacks Joseph Schumpeter's
crisis theory because, in effect, Schumpeter does not show how entrepreneurs
cannot predict the future (_"There is no explanation offered on the lack of
accurate forecasting . . . why were not the difficulties expected and
discounted?"_). [**America's Great Depression**, p. 48 and p. 70] Rothbard
does not ponder why bankers, who are surely entrepreneurs as well, make
**their** errors nor why the foresight of business people in an uncertain and
complex economy seems to fail them in the face of repeated actions of banks
(which they could, surely, have _"expected and discounted"_). This means that
the argument concerning distortions of the interest rate does not, as such,
explain the occurrence of over-investment (and so the business cycle).
Therefore, it cannot be claimed that removing state interference in the market
for money will also remove the business-cycle.

However, these arguments do have an element of truth in them. Expansion of
credit above the _"natural"_ level which equates it with savings can and does
allow capital to expand further than it otherwise would and so **encourages**
over-investment (i.e. it builds upon trends already present rather than
**creating** them). While we have ignored the role of credit expansion in our
comments above to stress that credit is not fundamental to the business cycle,
it is useful to discuss this as it is an essential factor in real capitalist
economies. Indeed, without it capitalist economies would not have grown as
fast as they have. Credit is fundamental to capitalism and this is the last
fallacy in the pre-Keynesian argument. In a real economy, it is the most
important. Even assuming that the actual rate of interest **could** always
equal the equilibrium rate and that it reflected the natural rate of all
commodities and all industries, it would not matter as banks would always seek
to make profits by extending credit and so artificially lower the actual
interest rate during booms. To understand why, we need to explain the flaws in
the main laissez-faire approaches to money.

There are three main approaches to the question of eliminating state control
of money in "free market" capitalist economics -- Monetarism, the 100% gold
reserve limit for banks and what is often called "free banking." All three are
associated with the right and all three are wrong. The first two are easy to
dismiss. Monetarism has been tried and has failed spectacularly in the early
1980s. As it was a key aspect of the neo-liberal war on working class people
at this time we will discuss its limitations as part of our account of this
period in [section C.8.3](secC8.html#secc83).

The second option, namely imposing a 100% gold reserve limit for banks is
highly interventionist and so not remotely laissez-faire (why should the
banking industry be subject to state regulation unlike the rest?). Its logic
is simple, namely to ensure that banks do not make loans unless they have
sufficient savings to cover them all. In other words, it seeks to abolish the
credit cycle by abolishing credit by making banks keep 100% gold reserves
against notes. This, in effect, abolishes banking as an industry. Simply put
(and it seems strange to have to point this out to supporters of capitalism)
banks seek to make a profit and do so by providing credit. This means that any
capitalist system will be, fundamentally, one with credit money as banks will
always seek to make a profit on the spread between loan and deposit rates. It
is a necessity for the banking system and so non-fractional banking is simply
not possible. The requirement that banks have enough cash on hand to meet all
depositors demand amounts to the assertion that banks do not lend any money. A
100% reserve system is not a reformed or true banking system. It is the
abolition of the banking system. Without fractional reserves, banks cannot
make any loans of any kind as they would not be in a position to give their
clients their savings if they have made loans. Only someone completely
ignorant of a real capitalist economy could make such a suggestion and,
unsurprisingly, this position is held by members of the "Austrian" school
(particularly its minimum state wing).

This leaves "free banking." This school of thought is, again, associated with
the "Austrian" school of economics and right-wing "libertarians" in general.
It is advocated by those who seek to eliminate fractional reserve banking but
balk by the regulations required by a 100% gold standard (Rothbard gets round
this by arguing this standard _"would be part and parcel of the general
libertarian legal prohibition against fraud."_ [**Op. Cit.**, p. 32]). It is
based on totally privatising the banking system and creating a system in which
banks and other private companies compete on the market to get their coins and
notes accepted by the general population. This position, it must be stressed,
is not the same as anarchist mutual banking as it is seen not as a way of
reducing usury to zero but rather as a means of ensuring that interest rates
work as they are claimed to do in capitalist theory.

The "free banking" school argues that under competitive pressures, banks would
maintain a 100% ratio between the credit they provide and the money they issue
with the reserves they actually have. They argue that under the present
system, banks can create more credit than they have funds/reserves available
as the state exists as lender of last resort and so banks will count on it to
bail them out in bad times. Market forces would ensure the end of fractional
reserve banking and stop them pushing the rate of interest below its "natural
rate." So if banks were subject to market forces, it is argued, then they
would not generate credit money, interest rates would reflect the real rate
and so over-investment, and so crisis, would be a thing of the past. Knowing
that the state would not step in to save them will also force banks to be
prudent in their activities.

This analysis, however, is flawed. We have noted one flaw above, namely the
problem that interest rates do not provide sufficient or correct information
for investment decisions. Thus relative over-investment could still occur.
Another problem is the endogenous nature of money and credit and the pressures
this puts on banks. As Steve Keen notes, Austrian economists think that _"the
current system of State money means that the money supply is entirely
exogenous and under the control of the State authorities. They then attribute
much of the cyclical behaviour of the economy to government meddling with the
money supply and the rate of interest."_ In contrast, Post-Keynesian
economists argue that _"though it may appear that the State controls the money
supply, the complex chain of causation in the finance sector actually works
backwards"_ with _"private banks and other credit-generating institutions
largely forc[ing] the State's hand. Thus the money supply is largely
endogenously determined by the market economy, rather than imposed upon it
exogenously by the State."_ He notes that the _"empirical record certainly
supports Post-Keynesians rather than Austrians on this point. Statistical
evidence about the leads and lags between the State-determined component of
money supply and broad credit show that the latter 'leads' the former."_
[**Debunking Economics**, p. 303] Moreover, as our discussion of the failure
of Monetarism will show, central banks could **not** control the money supply
when they tried.

To understand why, we need to turn to the ideas of the noted Post-Keynesian
economist Hyman Minsky. He created an analysis of the finance and credit
markets which gives an insight into why it is doubtful that even a "free
banking" system would resist the temptation to create credit money (i.e.
loaning more money than available savings). This model is usually called _"The
Financial Instability Hypothesis."_

Let us assume that the economy is going into the recovery period after a
crash. Initially firms would be conservative in their investment while banks
would lend within their savings limit and to low-risk investments. In this way
the banks do ensure that the interest rate reflects the "natural" rate.
However, this combination of a growing economy and conservatively financed
investment means that most projects succeed and this gradually becomes clear
to managers/capitalists and bankers. As a result, both managers and bankers
come to regard the present risk premium as excessive. New investment projects
are evaluated using less conservative estimates of future cash flows. This is
the foundation of the new boom and its eventual bust. In Minsky's words,
_"stability is destabilising."_

As the economy starts to grow, companies increasingly turn to external finance
and these funds are forthcoming because the banking sector shares the
increased optimism of investors. Let us not forget that banks are private
companies too and so seek profits as well. As Minsky argues, _"bankers live in
the same expectational climate as businessmen"_ and so _"profit-seeking
bankers will find ways of accommodating their customers . . . Banks and
bankers are not passive managers of money to lend or to invest; they are in
business to maximise profits."_ [quoted by L. Randall Wray, **Money and Credit
in Capitalist Economies**, p. 85] Providing credit is the key way of doing
this and so credit expansion occurs. If they did not, the boom would soon turn
into slump as investors would have no funds available for them and interest
rates would increase, thus forcing firms to pay more in debt repayment, an
increase which many firms may not be able to do or find difficult. This in
turn would suppress investment and so production, generating unemployment (as
companies cannot "fire" investments as easily as they can fire workers), so
reducing consumption demand along with investment demand, so deepening the
slump.

To avoid this and to take advantage of the rising economy, bankers accommodate
their customers and generate credit rather than rise interest rates. In this
way they accept liability structures both for themselves and for their
customers _"that, in a more sober expectational climate, they would have
rejected."_ [Minsky, **Inflation, Recession and Economic Policy**, p. 123] The
banks innovate their financial products, in other words, in line with demand.
Firms increase their indebtedness and banks are more than willing to allow
this due to the few signs of financial strain in the economy. The individual
firms and banks increase their financial liability, and so the whole economy
moves up the liability structure. Like other businesses, banks operate in an
uncertain environment and have no way of knowing whether their actions will
increase the fragility within the economy or push it into crisis.

The central banks, meanwhile, accommodate the banks activity. They do not and
cannot force them to create credit. Alan Holmes, a senior vice president at
the New York Federal Reserve, put the process this way:

> _"In the real world, banks extend credit, creating deposits in the process,
and look for the reserves later. The question then becomes one of whether and
how the Federal Reserve will accommodate the demand for reserves. In the very
short run, the Federal Reserve has little or no choice about accommodating
that demand, over time, its influence can obviously be felt."_ [quoted by Doug
Henwood, **Wall Street**, p. 220]

As long as profits exceed debt servicing requirements, the system will
continue to work. Eventually, though, interest rates rise as the existing
extension of credit appears too high to the banks or the central bank. This
affects all firms, from the most conservatively financed to the most
speculative, and "pushes" them up even higher up the liability structure.
Refinancing existing debts is made at the higher rate of interest, increasing
cash outflows and reducing demand for investment as the debt burden increases.
Conservatively financed firms can no longer can repay their debts easily, less
conservative ones fail to pay them and so on. The margin of error narrows and
firms and banks become more vulnerable to unexpected developments, such a new
competitors, strikes, investments which do not generate the expected rate of
return, credit becoming hard to get, interest rates increase and so on. In the
end, the boom turns to slump and firms and banks fail. The state then
intervenes to try and stop the slump getting worse (with varying degrees of
success and failure).

Thus the generation of credit is a spontaneous process rooted in the nature of
capitalism and is fundamentally endogenous in nature. This means that the
business cycle is an inherent part of capitalism even if we assume that it is
caused purely by disequilibrium in the credit market. In other words, it is
more than likely that the credit market will be in disequilibrium like every
other market in any real capitalist economy -- and for the same reasons. As
such, the natural rate of interest relies on concepts of equilibrium that are
not only inconsistent with reality but also with the broader principles of
"Austrian" economic ideology.

The "free banking" school reject this claim and argue that private banks in
competition would **not** do this as this would make them appear less
competitive on the market and so customers would frequent other banks (this is
the same process by which inflation would be solved). However, it is
**because** the banks are competing that they innovate -- if they do not,
another bank or company would in order to get more profits. Keynesian
economist Charles P. Kindleburger comments:

> _"As a historical generalisation, it can be said that every time the
authorities stabilise or control some quantity of money. . . in moments of
euphoria more will be produced. Or if the definition of money is fixed in
terms of particular assets, and the euphoria happens to 'monetise' credit in
new ways that are excluded from the definition, the amount of money defined in
the old way will not grow, but its velocity will increase . . . fix any
[definition of money] and the market will create new forms of money in periods
of boom to get round the limit."_ [**Manias, Panics and Crashes**, p. 48]

This can be seen from the fact that _"[b]ank notes . . . and bills of exchange
. . . were initially developed because of an inelastic supply of coin."_ Thus
monetary expansion _"is systematic and endogenous rather than random and
exogenous."_ [Kindleburger, **Op. Cit.**, p. 51 and p. 150] This means that
_"any shortage of commonly-used types [of money] is bound to lead to the
emergence of new types; indeed, this is how, historically, first bank notes
and the chequing account emerged."_ If the state tries to regulate one form of
money, _"lending and borrowing is diverted to other sources."_ [Nicholas
Kaldor, _"The New Monetarism"_, **The Essential Kaldor**, p. 481 and p. 482]
This means that the notion that abolishing central banking will result in the
use of gold and 100% reverses and so eliminate the business cycle is
misplaced:

> _"This view overlooks the fact that the **emergence** of money-substitutes
-- whether in the form of bank notes, bank accounts, or credit cards -- was a
spontaneous process, not planned or regulated 'from above' by some central
authority, and for that reason alone it is impossible to treat some arbitrary
definition of money (which included specific forms of such money-substitutes
in the definition of money) as an exogenous variable. The emergence of
surrogate money was a spontaneous process resulting from the development of
the banking system; this development brought a steady increase in the ratio of
money substitutes of 'real' money."_ [Nicholas Kaldor, **The Scourge of
Monetarism**, p. 44f]

This process can be seen at work in Adam Smith's time. Then Scotland was based
on a competitive banking system in which baking firms issued their own money
and maintained their own reverse of gold. Yet, as Smith notes, they issued
more money than was available in the banks coffers:

> _"Though some of those notes [the banks issued] are continually coming back
for payment, part of them continue to circulate for months and years together.
Though he [the banker] has generally in circulation, therefore, notes to the
extent of a hundred thousand pounds, twenty thousand pounds in gold and silver
may frequently be a sufficient provision for answering occasional demands."_
[**The Wealth of Nations**, pp. 257-8]

In other words, the competitive banking system did not, in fact, eliminate
fractional reserve banking. Ironically enough, Smith noted that _"the Bank of
England paid very dearly, not only for its own imprudence, but for the much
greater imprudence of almost all of the Scotch [sic!] banks."_ Thus the
central bank was more conservative in its money and credit generation than the
banks under competitive pressures! Indeed, Smith argues that the banking
companies did not, in fact, act in line with their interests as assumed by the
"free banking" school for _"had every particular banking company always
understood and attended to its own particular interest, the circulation never
could have been overstocked with paper money. But every particular baking
company has not always understood and attended to its own particular interest,
and the circulation has frequently been overstocked with paper money."_ Thus
we have reserve banking plus bankers acting in ways opposed to their
_"particular interest"_ (i.e. what economists consider to be their actual
self-interest rather than what the bankers actually thought was their self-
interest!) in a system of competitive banking. Why could this be the case?
Smith mentions, in passing, a possible reason. He notes that _"the high
profits of trade afforded a great temptation to over-trading"_ and that while
a _"multiplication of banking companies . . . increases the security of the
public"_ by forcing them _"to be more circumspect in their conduct"_ it also
_"obliges all bankers to be more liberal in their dealings with their
customers, lest their rivals should carry them away."_ [**Op. Cit.**, p. 269,
p. 267, p. 274 and p. 294]

Thus the banks were pulled in two directions at once, to accommodate their
loan customers and make more profits while being circumspect in their
activities to maintain sufficient reserves for the demands of their savers.
Which factor prevails would depend on the state of the economy, with up-swings
provoking liberal lending (as described by Minsky). Moreover, given that
credit generation is meant to produce the business cycle, it is clear from the
case of Scotland that competitive banking would not, in fact, stop either.
This also was the case with 19th century America, which did not have a central
bank for most of that period and that _"left the volatile US financial system
without any kind of lender of last resort, but in booms all kinds of funny
money passed."_ This lead to _"thousands of decentralised banks . . . hoarding
reserves"_ and so _"starving the system of liquidity precisely at the moment
it was most badly needed"_ while _"the up cycles were also extraordinary,
powered by loose credit and kinky currencies (like privately issued
banknotes)."_ [Doug Henwood, **Op. Cit.**, p. 93 and p. 94]

As Nicholas Kaldor argued, _"the essential function of banks in the creation
of 'finance' (or credit) was well understood by Adam Smith, who . . . regarded
branch-banking as a most important invention for the enrichment of society. He
described how, as a result of the finance banks were able to place at the
disposal of producers, the real income of Scotland doubled or trebled in a
remarkably short time. Expressed in Keynesian terms, the 'finance' provided by
banks made it possible to increase investments ahead of income or savings, and
to provide the savings counterpart of the investment out of the additional
income generated through a multiplier process by the additional spending."_
This process, however, was unstable which naturally lead to the rise of
central banks. _"Since the notes issued by some banks were found more
acceptable than those of others, giving rise to periodic payments crises and
uncertainty, it was sooner or later everywhere found necessary to concentrate
the right of issuing bank notes in the hands of a single institution."_ [_"How
Monetarism Failed,"_ **Further Essays on Economic Theory and Policy**, p. 181]
In addition, from an anarchist perspective, no ruling class wants economic
instability to undermine its wealth and income generating ability (Doug
Henwood provides a useful summary of this process, and the arguments used to
justify it within the American ruling class, for the creation of the US
Federal Reserve at the start of the 20th century. [**Wall Street**, pp.
92-5]). Nor would any ruling class want too easy credit undermining its power
over the working class by holding down unemployment too long (or allowing
working class people to create their own financial institutions).

Thus the over supply of credit, rather than being the **cause** of the crisis
is actually a symptom. Competitive investment drives the business cycle
expansion, which is allowed and encouraged by the competition among banks in
supplying credit. Such expansion complements -- and thus amplifies -- other
objective tendencies towards crisis, such as over-investment and
disportionalities. In other words, a pure "free market" capitalism would still
have a business cycle as this cycle is caused by the nature of capitalism, not
by state intervention. In reality (i.e. in "actually existing" capitalism),
state manipulation of money (via interest rates) is essential for the
capitalist class as it allows indirect profit-generating activity, such as
ensuring a "natural" level of unemployment to keep profits up, an acceptable
level of inflation to ensure increased profits, and so forth, as well as
providing a means of tempering the business cycle, organising bailouts and
injecting money into the economy during panics. Ultimately, if state
manipulation of money caused the problems of capitalism, we would not have
seen the economic successes of the post-war Keynesian experiment or the
business cycle in pre-Keynesian days and in countries which had a more free
banking system (for example, nearly half of the late 19th century in the US
was spent in periods of recession and depression, compared to a fifth since
the end of World War II).

It is true that all crises have been preceded by a speculatively-enhanced
expansion of production and credit. This does not mean, however, that crisis
**results** from speculation and the expansion of credit. The connection is
not causal in free market capitalism. The expansion and contraction of credit
is a mere symptom of the periodic changes in the business cycle, as the
decline of profitability contracts credit just as an increase enlarges it. So
while there are some similarities in the pre-Keynesian/"Austrian" theory and
the radical one outlined here, the key differences are two-fold. Firstly, the
pro-capitalist theory argues that it is possible for capitalist banks **not**
to act, well, like capitalists if subject to competition (or regulated
enough). This seems highly unlikely and fits as badly into their general
theories as the notion that disequilibrium in the credit market is the root of
the business cycle. Secondly, the radical position stresses that the role of
credit reflect deeper causes. Paul Mattick gives the correct analysis:

> _"[M]oney and credit policies can themselves change nothing with regard to
profitability or insufficient profits. Profits come only from production, from
the surplus value produced by workers . . . The expansion of credit has always
been taken as a sign of a coming crisis, in the sense that it reflected the
attempt of individual capital entities to expand despite sharpening
competition, and hence survive the crisis. . . Although the expansion of
credit has staved off crisis for a short time, it has never prevented it,
since ultimately it is the real relationship between total profits and the
needs of social capital to expand in value which is the decisive factor, and
that cannot be altered by credit."_ [**Economics, Politics and the Age of
Inflation**, pp. 17-18]

In short, the apologists of capitalism confuse the symptoms for the disease.

The cyclical movements on the real side of the economy will be enhanced (both
upwards and downwards) by events in its financial side and this may result in
greater amplitudes in the cycle but the latter does not create the former.
Where there _"is no profit to be had, credit will not be sought."_ While
extension of the credit system _"can be a factor deferring crisis, the actual
outbreak of crisis makes it into an aggravating factor because of the larger
amount of capital that must be devalued."_ [Paul Mattick, **Economic Crisis
and Crisis Theory**, p. 138] But this is also a problem facing competing
private companies using the gold standard. The money supply reflects the
economic activity within a country and if that supply cannot adjust, interest
rates rise and provoke a crisis. Thus the need for a flexible money supply (as
desired, for example, by Mutualists and the US Individualist Anarchists).

It must always be remembered that a loan is not like other commodities. Its
exchange value is set by its use value. As its use value lies in investing and
so generating a stream of income, the market rate of interest is governed by
the average expectations of profits for the capitalist class. Thus credit is
driven by its **perceived** use-value rather than its cost of production or
the amount of money a bank has. Its possible use value reflects the
prospective exchange-values (prices and profits) it can help produce. This
means that uncertainty and expectations play a key role in the credit and
financial markets and these impact on the real economy. This means that money
can **never** be neutral and so capitalism will be subject to the business
cycle and so unemployment will remain a constant threat over the heads of
working class people. In such circumstances, the notion that capitalism
results in a level playing field for classes is simply not possible and so,
except in boom times, working class will be at a disadvantage on the labour
market.

To sum up, _"[i]t is not credit but only the increase in production made
possible by it that increases surplus value. It is then the rate of
exploitation which determines credit expansion."_ [Paul Mattick, **Economics,
Politics and the Age of Inflation**, p. 18] Hence credit money would increase
and decrease in line with capitalist profitability, as predicted in capitalist
economic theory. But this could not affect the business cycle, which has its
roots in production for capital (i.e. profit) and capitalist authority
relations, to which the credit supply would obviously reflect, and not vice
versa.

## C.8.1 Does this mean that Keynesianism works?

If state interference in credit generation does not cause the business cycle,
does that mean Keynesianism capitalism can work? Keynesian economics, as
opposed to free market capitalism, maintains that the state can and should
intervene in the economy in order to stop economic crises from occurring. Can
it work? To begin to answer that question, we must first quickly define what
is meant by Keynesianism as there are different kinds of Keynesianist policies
and economics.

As far as economics goes, Keynes' co-worker Joan Robinson coined the phrase
_"Bastard Keynesianism"_ to describe the vulgarisation of his economics and
its stripping of all aspects which were incompatible with the assumptions of
neo-classical economics. Thus the key notion of uncertainty was eliminated and
his analysis of the labour market reduced to the position he explicitly
rejected, namely that unemployment was caused by price rigidities. This
process was aided by the fact that Keynes retained significant parts of the
neo-classical position in his analysis and argued that the role of the state
was limited to creating the overall conditions necessary to allow the neo-
classical system to come _"into its own again"_ and allow capitalism _"to
realise the full potentialities of production."_ [**The General Theory**, pp.
378-9] Unlike many of his more radical followers, Keynes was blind to real
nature of capitalism as a class based system and so failed to understand the
functional role that unemployment plays within it (see [section
C.1.5](secC5.html#secc15)).

However, the context in which Keynes worked explains much. Faced with the dire
situation capitalism faced during the 1930s, he presented a new theoretical
analysis of capitalism that both explained the crisis and suggested policies
that would, without interfering with its general principles, end it. Keynes'
work was aided both by the practical failure of traditional solutions and
growing fear of revolution and so even the most died-in-the-wool neo-classical
economists could not keep his theory from being tried. When it appeared to
work that, on one level, ended the argument. However, at a deeper level, at
the level of theory, the struggle was just beginning. As the neo-classical
(and Austrian) tradition is axiom-led rather than empirically-led (otherwise
their axioms would have been abandoned long ago), the mere fact that
capitalism was in crisis and that Keynes had presented a theory more in line
with the reality was not enough to change mainstream economics. From the
start, neo-classical economists began their counter-attack. Led by Paul
Samuelson in the US and John Hicks in the UK, they set about making Keynes'
theories safe for neo-classical economics. They did this by using mathematics
on a part of his theory, leaving out all those bits that were inconsistent
with neo-classical axioms. This bowdlerised version of Keynes soon became the
standard in undergraduate courses.

The fate of Keynes reinforces the comment of French revolutionary Louis de
Saint-Just that _"those who make revolution half way only dig their own
graves."_ Keynes ideas were only a partial break with the neo-classical
orthodoxy and, as such, allowed the basis for the neo-classical-Keynesian
synthesis which dominated post-war economics until the mid-1970s as well as
giving the Monetarist counter-revolution space to grow. Perhaps this partial
break is understandable, given the dominance of neo-classical ideas in the
economics profession it may have been too much to expect them to renounce all
their dogmas yet it ensured that any developments towards an economics based
on science rather than ideology would be resigned to the sidelines.

It is important to stress that Keynes was, first and foremost, a supporter of
capitalism. He aimed to save it, not to end it. As he put it the _"**class
war** will find me on the side of the educated bourgeoisie."_ [quoted by
Henwood, **Wall Street**, p. 212] That he presented a more accurate picture of
capitalism and exposed some of the contradictions within neo-classical
economics is part of the reason he was and is so hated by many on the right,
although his argument that the state should limit some of the power of
individual firms and capitalists and redistribute some income and wealth was a
far more important source of that hatred. That he helped save capitalism from
itself (and secure their fortunes) did not seem to concern his wealthy
detractors. They failed to understand Keynes often sounded more radical than
he actually was. Doug Henwood gives a good overview of Keynes' ideas (and
limitations) in chapter 5 of his book **Wall Street**.

What of Keynesian policies? The _"Bastard Keynesianism"_ of the post-war
period (for all its limitations) did seem to have some impact on capitalism.
This can be seen from comparing Keynesianism with what came before. The more
laissez-faire period was nowhere near as stable as modern day supporters of
free(r) market capitalists like to suggest. There were continual economic
booms and slumps. The last third of the 19th century (often considered as the
heyday of private enterprise) was a period of profound instability and anxiety
as it _"was characterised by violent booms and busts, in nearly equal measure,
since almost half the period was one of panic and depression."_ American spent
nearly half of the late 19th century in periods of recession and depression.
By way of comparison, since the end of world war II, only about a fifth of the
time has been. [Doug Henwood, **Wall Street**, p. 94 and p. 54] Between 1867
and 1900 there were 8 complete business cycles. Over these 396 months, the
economy expanded during 199 months and contracted during 197. Hardly a sign of
great stability. Overall, the economy went into a slump, panic or crisis in
1807, 1817, 1828, 1834, 1837, 1854, 1857, 1873, 1882, and 1893 (in addition,
1903 and 1907 were also crisis years).

Then there is what is often called the _"Golden Age of Capitalism,"_ the boom
years of (approximately) 1945 to 1975. This post-war boom presents compelling
evidence that Keynesianism can effect the business cycle for the better by
reducing its tendency to develop into a full depression. By intervening in the
economy, the state would reduce uncertainty for capitalists by maintaining
overall demand which will, in turn, ensure conditions where they will invest
their money rather than holding onto it (what Keynes termed _"liquidity-
preference"_). In other words, to create conditions where capitalists will
desire to invest and ensure the willingness on the part of capitalists to act
as capitalists.

This period of social Keynesianism after the war was marked by reduced
inequality, increased rights for working class people, less unemployment, a
welfare state you could actually use and so on. Compared to present-day
capitalism, it had much going for it. However, Keynesian capitalism is still
capitalism and so is still based upon oppression and exploitation. It was, in
fact, a more refined form of capitalism, within which the state intervention
was used to protect capitalism from itself while trying to ensure that working
class struggle against it was directed, via productivity deals, into keeping
the system going. For the population at large, the general idea was that the
welfare state (especially in Europe) was a way for society to get a grip on
capitalism by putting some humanity into it. In a confused way, the welfare
state was promoted as an attempt to create a society in which the economy
existed for people, not people for the economy.

While the state has always had a share in the total surplus value produced by
the working class, only under Keynesianism is this share increased and used
actively to manage the economy. Traditionally, placing checks on state
appropriation of surplus value had been one of the aims of classical
capitalist thought (simply put, cheap government means more surplus value
available for capitalists to compete for). But as capital has accumulated, so
has the state increased and its share in social surplus (for control over the
domestic enemy has to be expanded and society protected from the destruction
caused by free market capitalism). It must be stressed that state intervention
was not **totally** new for _"[f]rom its origins, the United States had relied
heavily on state intervention and protection for the development of industry
and agriculture, from the textile industry in the early nineteenth century,
through the steel industry at the end of the century, to computers,
electronics, and biotechnology today. Furthermore, the same has been true of
every other successful industrial society."_ [Noam Chomsky, **World Orders,
Old and New**, p. 101] The difference was that such state action was directed
to social goals as well as bolstering capitalist profits (much to the hatred
of the right).

The roots of the new policy of higher levels and different forms of state
intervention lie in two related factors. The Great Depression of the 1930s had
lead to the realisation that attempts to enforce widespread reductions in
money wages and costs (the traditional means to overcome depression) simply
did not work. As Keynes stressed, cutting wages reduced prices and so left
real wages unaffected. Worse, it reduced aggregate demand and lead to a
deepening of the slump (see [section C.9.1](secC9.html#secc91) for details).
This meant that leaving the market to solve its own problems would make things
a lot worse before they became better. Such a policy would, moreover, be
impossible because the social and economic costs would have been too
expensive. Working class people simply would not tolerate more austerity
imposed on them and increasingly took direct action to solve their problems.
For example, America saw a militant strike wave involving a half million
workers in 1934, with factory occupations and other forms of militant direct
action commonplace. It was only a matter of time before capitalism was either
ended by revolution or saved by fascism, with neither prospect appealing to
large sections of the ruling class.

So instead of attempting the usual class war (which may have had revolutionary
results), sections of the capitalist class thought a new approach was
required. This involved using the state to manipulate demand in order to
increase the funds available for capital. By means of demand bolstered by
state borrowing and investment, aggregate demand could be increased and the
slump ended. In effect, the state acts to encourage capitalists to act like
capitalists by creating an environment when they think it is wise to invest
again. As Paul Mattick points out, the _"additional production made possible
by deficit financing does appear as additional demand, but as demand
unaccompanied by a corresponding increase in total profits. . . [this]
functions immediately as an increase in demand that stimulates the economy as
a whole and can become the point for a new prosperity"_ if objective
conditions allow it. [**Economic Crisis and Crisis Theory**, p. 143]

State intervention can, in the short term, postpone crises by stimulating
production. This can be seen from the in 1930s New Deal period under Roosevelt
when the economy grew five years out of seven compared to it shrinking every
year under the pro-laissez-faire Republican President Herbert Hoover (under
Hoover, the GNP shrank an average of -8.4 percent a year, under Roosevelt it
grew by 6.4 percent). The 1938 slump after 3 years of growth under Roosevelt
was due to a decrease in state intervention:

> _"The forces of recovery operating within the depression, as well as the
decrease in unemployment via public expenditures, increased production up to
the output level of 1929. This was sufficient for the Roosevelt administration
to drastically reduce public works . . . in a new effort to balance the budget
in response to the demands of the business world. . . The recovery proved to
be short-lived. At the end of 1937 the Business Index fell from 110 to 85,
bringing the economy back to the state in which it had found itself in 1935 .
. . Millions of workers lost their jobs once again."_ [Paul Mattick,
**Economics, Politics and the Age of Inflation**, p. 138]

The rush to war made Keynesian policies permanent. With the success of state
intervention during the second world war, Keynesianism was seen as a way of
ensuring capitalist survival. The resulting boom is well known, with state
intervention being seen as the way of ensuring prosperity for all sections of
society. It had not fully recovered from the Great Depression and the boom
economy during the war had obviously contrasted deeply with the stagnation of
the 1930s. Plus, of course, a militant working class, which had put up with
years of denial in the struggle against fascist-capitalism would not have
taken lightly to a return to mass unemployment and poverty. Capitalism had to
turn to continued state intervention as it is not a viable system. So,
politically and economically a change was required. This change was provided
by the ideas of Keynes, a change which occurred under working class pressure
but in the interests of the ruling class.

So there is no denying that for a considerable time, capitalism has been able
to prevent the rise of depressions which so plagued the pre-war world and that
this was accomplished by government interventions. This is because
Keynesianism can serve to initiate a new prosperity and postpone crisis by
state intervention to bolster demand and encourage profit investment. This can
mitigate the conditions of crisis, since one of its short-term effects is that
it offers private capital a wider range of action and an improved basis for
its own efforts to escape the shortage of profits for accumulation. In
addition, Keynesianism can fund Research and Development in new technologies
and working methods (such as automation) which can increase profits, guarantee
markets for goods as well as transferring wealth from the working class to
capital via indirect taxation and inflation. In the long run, however,
Keynesian _"management of the economy by means of monetary and credit policies
and by means of state-induced production must eventually find its end in the
contradictions of the accumulation process."_ [Paul Mattick, **Op. Cit.**, p.
18] This is because it cannot stop the tendency to (relative) over-investment,
disproportionalities and profits squeeze we outlined in [section
C.7](secC7.html). In fact, due to its maintenance of full employment it
increases the possibility of a crisis arising due to increased workers' power
at the point of production.

So, these interventions did not actually set aside the underlying causes of
economic and social crisis. The modifications of the capitalist system could
not totally countermand the subjective and objective limitations of a system
based upon wage slavery and social hierarchy. This can be seen when the rosy
picture of post-war prosperity changed drastically in the 1970s when economic
crisis returned with a vengeance, with high unemployment occurring along with
high inflation. This soon lead to a return to a more "free market" capitalism
with, in Chomsky's words, _"state protection and public subsidy for the rich,
market discipline for the poor."_ This process and its aftermath are discussed
in the [next section](secC8.html#secc82).

## C.8.2 What happened to Keynesianism in the 1970s?

Basically, the subjective and objective limitations to Keynesianism we
highlighted in the [last section](secC8.html#secc81) were finally reached in
the early 1970s. It, in effect, came into conflict with the reality of
capitalism as a class and hierarchical system. It faced either revolution to
increase popular participation in social, political and economic life (and so
eliminate capitalist power), an increase in social democratic tendencies (and
so become some kind of democratic state capitalist regime) or a return to
free(r) market capitalist principles by increasing unemployment and so placing
a rebellious people in its place. Under the name of fighting inflation, the
ruling class unsurprisingly picked the latter option.

The 1970s are a key time in modern capitalism. In comparison to the two
previous decades, it suffered from high unemployment and high inflation rates
(the term stagflation is usually used to describe this). This crisis was
reflected in mass strikes and protests across the world. Economic crisis
returned, with the state interventions that for so long kept capitalism
healthy either being ineffective or making the crisis worse. In other words, a
combination of social struggle and a lack of surplus value available to
capital resulted in the breakdown of the successful post-war consensus. Both
subjected the _"Bastard Keynesianism"_ of the post-war period to serious
political and ideological challenges. This lead to a rise in neo-classical
economic ideology and the advocating of free(r) market capitalism as the
solution to capitalism's problems. This challenge took, in the main, the form
of Milton Friedman's Monetarism.

The roots and legacy of this breakdown in Keynesianism are informative and
worth analysing. The post-war period marked a distinct change for capitalism,
with new, higher levels of state intervention. The mix of intervention
obviously differed from country to country, based upon the needs and
ideologies of the ruling parties and social elites as well as the impact of
social movements and protests. In Europe, nationalisation was widespread as
inefficient capital was taken over by the state and reinvigorated by state
funding while social spending was more important as Social Democratic parties
attempted to introduce reforms. Chomsky describes the process in the USA:

> _"Business leaders recognised that social spending could stimulate the
economy, but much preferred the military Keynesian alternative -- for reasons
having to do with privilege and power, not 'economic rationality.' This
approach was adopted at once, the Cold War serving as the justification. . . .
The Pentagon system was considered ideal for these purposes. It extends well
beyond the military establishment, incorporating also the Department of
Energy. . . and the space agency NASA, converted by the Kennedy administration
to a significant component of the state-directed public subsidy to advanced
industry. These arrangements impose on the public a large burden of the costs
of industry (research and development, R&amp;D) and provide a guaranteed
market for excess production, a useful cushion for management decisions.
Furthermore, this form of industrial policy does not have the undesirable
side-effects of social spending directed to human needs. Apart from unwelcome
redistributive effects, the latter policies tend to interfere with managerial
prerogatives; useful production may undercut private gain, while state-
subsidised waste production. . . is a gift to the owner and manager, to whom
any marketable spin-offs will be promptly delivered. Social spending may also
arouse public interest and participation, thus enhancing the threat of
democracy. . . The defects of social spending do not taint the military
Keynesian alternative. For such reasons, **Business Week** explained, 'there's
a tremendous social and economic difference between welfare pump-priming and
military pump-priming,' the latter being far preferable."_ [**World Orders,
Old and New**, pp. 100-1]

Over time, social Keynesianism took increasing hold even in the USA, partly in
response to working class struggle, partly due to the need for popular support
at elections and partly due to _"[p]opular opposition to the Vietnam war
[which] prevented Washington from carrying out a national mobilisation . . .
which might have made it possible to complete the conquest without harm to the
domestic economy. Washington was forced to fight a 'guns-and-butter' war to
placate the population, at considerable economic cost."_ [Chomsky, **Op.
Cit.**, pp. 157-8]

Social Keynesianism directs part of the total surplus value to workers and
unemployed while military Keynesianism transfers surplus value from the
general population to capital and from capital to capital. This allows R&amp;D
and capital to be publicly subsidised, as well as essential but unprofitable
capital to survive. As long as real wages did not exceed a rise in
productivity, Keynesianism would continue. However, both functions have
objective limits as the transfer of profits from successful capital to
essential, but less successful, or long term investment can cause a crisis is
there is not enough profit available to the system as a whole. The surplus
value producing capital, in this case, would be handicapped due to the
transfers and cannot respond to economic problems as freely as before. This
was compounded by the world becoming economically "tripolar," with a
revitalised Europe and a Japan-based Asian region emerging as major economic
forces. This placed the USA under increased pressure, as did the Vietnam War.
Increased international competition meant the firms were limited in how they
could adjust to the increased pressures they faced in the class struggle.

This factor, class struggle, cannot be underestimated. In fact, the main
reason for the 1970s breakdown was social struggle by working people. The only
limit to the rate of growth required by Keynesianism to function is the degree
to which final output consists of consumption goods for the presently employed
population instead of investment. As long as wages rise in line with
productivity, capitalism does well and firms invest (indeed, investment is the
most basic means by which work, i.e. capitalist domination, is imposed).
However, faced with a workforce which is able to increase its wages and resist
the introduction of new technologies then capitalism will face a crisis. The
net effect of full employment was the increased rebellious of the working
class (both inside and outside the workplace). This struggle was directed
against hierarchy in general, with workers, students, women, ethnic groups,
anti-war protesters and the unemployed all organising successful struggles
against authority. This struggle attacked the hierarchical core of capitalism
as well as increasing the amount of income going to labour, resulting in a
profit squeeze (see [section C.7](secC7.html)). By the 1970s, capitalism and
the state could no longer ensure that working class struggles could be
contained within the system.

This profits squeeze reflected the rise in inflation. While it has become
commonplace to argue that Keynesianism did not predict the possibility of
exploding inflation, this is not entirely true. While Keynes and the
mainstream Keynesians failed to take into account the impact of full
employment on class relations and power, his left-wing followers did not.
Influenced by Michal Kalecki, the argued that full employment would impact on
power at the point of production and, consequently, prices. To quote Joan
Robinson from 1943:

> _"The first function of unemployment (which has always existed in open or
disguised forms) is that it maintains the authority of master over man. The
master has normally been in a position to say: 'If you don't want the job,
there are plenty of others who do.' When the man can say: 'If you don't want
to employ me, there are plenty of others who will', the situation is radically
altered. One effect of such a change might be to remove a number of abuses to
which the workers have been compelled to submit in the past . . . [Another is
that] the absence of fear of unemployment might go further and have a
disruptive effect upon factory discipline . . . [He may] us[e] his newly-found
freedom from fear to snatch every advantage that he can . . .  
>  _

>

> _"The change in the workers' bargaining position which would follow from the
abolition of unemployment would show itself in another and more subtle way.
Unemployment . . . has not only the function of preserving discipline in
industry, but also indirectly the function of preserving the value of money .
. . there would be a constant upward pressure upon money wage-rates . . . the
vicious spiral of wages and prices might become chronic . . . if it moved too
fast, it might precipitate a violent inflation."_ [**Collected Economic
Papers**, vol. 1, pp. 84-5]

Thus left-wing Keynesians (who later founded the Post-Keynesian school of
economics) recognised that capitalists _"could recoup themselves for rising
costs by raising prices."_ [**Op. Cit.**, p. 85] This perspective was
reflected in a watered-down fashion in mainstream economics by means of the
Philips Curve. When first suggested in the 1958, this was taken to indicate a
stable relationship between unemployment and inflation. As unemployment fell,
inflation rose. This relationship fell apart in the 1970s, as inflation rose
as unemployment rose.

Neo-classical (and other pro-"free market" capitalist) economics usually
argues that inflation is purely a monetary phenomenon, the result of there
being more money in circulation than is needed for the sale of the various
commodities on the market. This was the position of Milton Friedman and his
Monetarist school during the 1960s and 1970s. However, this is not true. In
general, there is no relationship between the money supply and inflation. The
amount of money can increase while the rate of inflation falls, for example
(as we will discuss in the [next section](secC8.html#secc83), Monetarism
itself ironically proved there is no relationship). Inflation has other roots,
namely it is _"an expression of inadequate profits that must be offset by
price and money policies . . . Under any circumstances, inflation spells the
need for higher profits."_ [Paul Mattick, **Economics, Politics and the Age of
Inflation**, p. 19] Inflation leads to higher profits by making labour
cheaper. That is, it reduces _"the real wages of workers. . . [which] directly
benefits employers. . . [as] prices rise faster than wages, income that would
have gone to workers goes to business instead."_ [J. Brecher and T. Costello,
**Common Sense for Hard Times**, p. 120]

Inflation, in other words, is a symptom of an on-going struggle over income
distribution between classes. It is caused when capitalist profit margins are
reduced (for whatever reason, subjective or objective) and the bosses try to
maintain them by increasing prices, i.e. by passing costs onto consumers. This
means that it would be wrong to conclude that wage increases "cause" inflation
as such. To do so ignores the fact that workers do not set prices, capitalists
do. Any increase in costs could, after all, be absorbed by lowering profits.
Instead working class people get denounced for being "greedy" and are
subjected to calls for "restraint" -- in order for their bosses to make
sufficient profits! As Joan Robinson put it, while capitalist economies denies
it (unlike, significantly, Adam Smith) there is an _"inflationary pressure
that arises from an increase in the share of gross profits in gross income.
How are workers to be asked to accept 'wage restraint' unless there is a
restraint on profits? . . . unemployment is the problem. If it could be
relived by tax cuts, generating purchasing power, would not a general cut in
profit margins be still more effective? These are the questions that all the
rigmarole about marginal productivity is designed to prevent us from
discussing."_ [**Collected Economic Papers**, vol. 4, p. 134]

Inflation and the response by the capitalist class to it, in their own ways,
shows the hypocrisy of capitalism. After all, wages are increasing due to
"natural" market forces of supply and demand. It is the **capitalists** who
are trying to buck the market by refusing to accept lower profits caused by
conditions on it. Obviously, to use Benjamin Tucker's expression, under
capitalism market forces are good for the goose (labour) but bad for the
gander (capital). The so-called "wages explosion" of the late 1960s was a
symptom of this shift in class power away from capital and to labour which
full employment had created. The growing expectations and aspirations of
working class people led them not only to demand more of the goods they
produced, it had start many questioning why social hierarchies were needed in
the first place. Rather than accept this as a natural outcome of the eternal
laws of supply and demand, the boss class used the state to create a more
favourable labour market environment (as, it should be stressed, it has always
done).

This does not mean that inflation suits all capitalists equally (nor,
obviously, does it suit those social layers who live on fixed incomes and who
thus suffer when prices increase but such people are irrelevant in the eyes of
capital). Far from it -- during periods of inflation, lenders tend to lose and
borrowers tend to gain. The opposition to high levels of inflation by many
supporters of capitalism is based upon this fact and the division within the
capitalist class it indicates. There are two main groups of capitalists,
finance capitalists and industrial capitalists. The latter can and do benefit
from inflation (as indicated above) but the former sees high inflation as a
threat. When inflation is accelerating it can push the real interest rate into
negative territory and this is a horrifying prospect to those for whom
interest income is fundamental (i.e. finance capital). In addition, high
levels of inflation can also fuel social struggle, as workers and other
sections of society try to keep their income at a steady level. As social
struggle has a politicising effect on those involved, a condition of high
inflation could have serious impacts on the political stability of capitalism
and so cause problems for the ruling class.

How inflation is viewed in the media and by governments is an expression of
the relative strengths of the two sections of the capitalist class and of the
level of class struggle within society. For example, in the 1970s, with the
increased international mobility of capital, the balance of power came to rest
with finance capital and inflation became the source of all evil. This shift
of influence to finance capital can be seen from the rise of rentier income.
The distribution of US manufacturing profits indicate this process --
comparing the periods 1965-73 to 1990-96, we find that interest payments rose
from 11% to 24%, dividend payments rose from 26% to 36% while retained
earnings fell from 65% to 40%. Given that retained earnings are the most
important source of investment funds, the rise of finance capital helps
explain why, in contradiction to the claims of the right-wing, economic growth
has become steadily worse as markets have been liberalised -- funds that could
have been resulted in real investment have ended up in the finance machine. In
addition, the waves of strikes and protests that inflation produced had
worrying implications for the ruling class as they showed a working class able
and willing to contest their power and, perhaps, start questioning **why**
economic and social decisions were being made by a few rather than by those
affected by them. However, as the underlying reasons for inflation remained
(namely to increase profits) inflation itself was only reduced to acceptable
levels, levels that ensured a positive real interest rate and acceptable
profits.

Thus, Keynesianism sowed the seeds of its own destruction. Full employment had
altered the balance of power in the workplace and economy from capital to
labour. The prediction of socialist economist Michal Kalecki that full
employment would erode social discipline had become true (see [section
B.4.4](secB4.html#secb44)). Faced with rising direct and indirect costs due to
this, firms passed them on to consumers. Yet consumers are also, usually,
working class and this provoked more direct action to increase real wages in
the face of inflation. Within the capitalist class, finance capital was
increasing in strength at the expense of industrial capital. Facing the
erosion of their loan income, states were subject to economic pressures to
place fighting inflation above maintaining full employment. While Keynes had
hoped that _"the rentier aspect of capitalism [was] a transitional phase"_ and
his ideas would lead to _"the euthanasia of the rentier,"_ finance capital was
not so willing to see this happen. [**The General Theory**, p. 376] The 1970s
saw the influence of an increasingly assertive finance capital rise at a time
when significant numbers within ranks of industrial capitalists were sick of
full employment and wanted compliant workers again. The resulting recessions
may have harmed individual capitalists (particularly smaller ones) but the
capitalist class as a whole did very well of them (and, as we noted in
[section B.2](secB2.html), one of the roles of the state is to manage the
system in the interests of the capitalist class **as a whole** and this can
lead it into conflict with **some** members of that class). Thus the
maintenance of sufficiently high unemployment under the mantra of fighting
inflation as the de facto state policy from the 1980s onwards (see [section
C.9](secC9.html)). While industrial capital might want a slightly stronger
economy and a slightly lower rate of unemployment than finance capital, the
differences are not significant enough to inspire major conflict. After all,
bosses in any industry _"like slack in the labour market"_ as it _"makes for a
pliant workforce"_ and, of course, _"many non-financial corporations have
heavy financial interests."_ [Doug Henwood, **Wall Street**, pp. 123-4 and p.
135]

It was these processes and pressures which came to a head in the 1970s. In
other words, post-war Keynesianism failed simply because it could not, in the
long term, stop the subjective and objective pressures which capitalism always
faces. In the 1970s, it was the subjective pressure which played the key role,
namely social struggle was the fundamental factor in economic developments.
The system could not handle the struggle of human beings against the
oppression, exploitation, hierarchy and alienation they are subject to under
capitalism.

## C.8.3 How did capitalism adjust to the crisis in Keynesianism?

Basically by using, and then managing, the 1970s crisis to discipline the
working class in order to reap increased profits and secure and extend the
ruling classes' power. It did this using a combination of crisis, free(r)
markets and adjusted Keynesianism as part of a ruling elite lead class war
against labour.

In the face of crisis in the 1970s, Keynesianist redirection of profits
between capitals and classes had become a burden to capital as a whole and had
increased the expectations and militancy of working people to dangerous
levels. The crisis of the 1970s and early 1980s helped control working class
power and unemployment was utilised as a means of saving capitalism and
imposing the costs of free(r) markets onto society as whole. The policies
implemented were ostensibly to combat high inflation. However, as left-wing
economist Nicholas Kaldor summarised, inflation may have dropped but this lay
_"in their success in transforming the labour market from a twentieth-century
sellers' market to a nineteenth-century buyers' market, with wholesome effects
on factory discipline, wage claims, and proneness to strike."_ [**The Scourge
of Monetarism**, p. xxiii] Another British economist described this policy
memorably as _"deliberately setting out to base the viability of the
capitalist system on the maintenance of a large 'industrial reserve army' [of
the unemployed] . . . [it is] the incomes policy of Karl Marx."_ [Thomas
Balogh, **The Irrelevance of Conventional Economics**, pp. 177-8] The aim, in
summary, was to swing the balance of social, economic and political power back
to capital and ensure the road to (private) serfdom was followed. The
rationale was fighting inflation.

Initially the crisis was used to justify attacks on working class people in
the name of the free market. And, indeed, capitalism was made more market
based, although with a "safety net" and "welfare state" for the wealthy. We
have seen a partial return to _"what economists have called freedom of
industry and commerce, but which really meant the relieving of industry from
the harassing and repressive supervision of the State, and the giving to it
full liberty to exploit the worker, whom was still to be deprived of his
freedom."_ The _"crisis of democracy"_ which so haunted the ruling class in
the 1960s and 1970s was overcome and replaced with, to use Kropotkin's words,
the _"liberty to exploit human labour without any safeguard for the victims of
such exploitation and the political power organised as to assure freedom of
exploitation to the middle-class."_ [Kropotkin, **The Great French
Revolution**, vol.1, p. 28 and p. 30]

Fighting inflation, in other words, was simply code used by the ruling class
for fighting the class war and putting the working class back in its place in
the social hierarchy. _"Behind the economic concept of inflation was a fear
among elites that they were losing control"_ as the _"sting of unemployment
was lessened and workers became progressively less docile."_ [Doug Henwood,
**After the New Economy**, p. 204] Milton Friedman's Monetarism was the means
by which this was achieved. While (deservedly) mostly forgotten now,
Monetarism was very popular in the 1970s and was the economic ideology of
choice of both Reagan and Thatcher. This was the economic justification for
the restructuring of capitalism and the end of social Keynesianism. Its legacy
remains to some degree in the overriding concern over inflation which haunts
the world's central banks and other financial institutions, but its specific
policy recommendations have been dropped in practice after failing
spectacularly when applied (a fact which, strangely, was not mentioned in the
eulogies from the right that marked Friedman's death).

According to Monetarism, the problem with capitalism was money related, namely
that the state and its central bank printed too much money and, therefore, its
issue should be controlled. Friedman stressed, like most capitalist
economists, that monetary factors are **the** most important feature in
explaining such problems of capitalism as the business cycle, inflation and so
on. This is unsurprising, as it has the useful ideological effect of
acquitting the inner-workings of capitalism of any involvement in such
developments. Slumps, for example, may occur, but they are the fault of the
state interfering in the economy. Inflation was a purely monetary phenomenon
caused by the state printing more money than required by the growth of
economic activity (for example, if the economy grew by 2% but the money supply
increased by 5%, inflation would rise by 3%). This analysis of inflation is
deeply flawed, as we will see. This was how Friedman explained the Great
Depression of the 1930s in the USA, for example (see, for example, his _"The
Role of Monetary Policy"_ [**American Economic Review**, Vol. 68, No. 1, pp.
1-17]).

Thus Monetarists argued for controlling the money supply, of placing the state
under a _"monetary constitution"_ which ensured that the central banks be
required by law to increase the quantity of money at a constant rate of 3-5% a
year. This would ensure that inflation would be banished, the economy would
adjust to its natural equilibrium, the business cycle would become mild (if
not disappear) and capitalism would finally work as predicted in the economics
textbooks. With the _"monetary constitution"_ money would become
_"depoliticised"_ and state influence and control over money would be
eliminated. Money would go back to being what it is in neo-classical theory,
essentially neutral, a link between production and consumption and capable of
no mischief on its own. Hence the need for a _"legislated rule"_ which would
control _"the behaviour of the stock of money"_ by _"instructing the monetary
authority to achieve a specified rate of growth in the stock of money."_
[**Capitalism and Freedom**, p. 54]

Unfortunately for Monetarism, its analysis was simply wrong. It cannot be
stressed enough how deeply flawed and ideological Friedman's arguments were.
As one critique noted, his assumptions have _"been shown to be fallacious and
the empirical evidence questionable if not totally misinterpreted."_ Moreover,
_"none of the assumptions which Friedman made to reach his extraordinary
conclusions bears any relation to reality. They were chosen precisely because
they led to the desired conclusion, that inflation is a purely monetary
phenomenon, originating solely in excess monetary demand."_ [Thomas Balogh,
**Op. Cit.**, p. 165 and p. 167] For Kaldor, Friedman's claims that empirical
evidence supported his ideology were false. _"Friedman's assertions lack[ed]
any factual foundation whatsoever."_ He stressed, _"They ha[d] no basis in
fact, and he seems to me have invented them on the spur of the moment."_
[**Op. Cit.**, p. 26] There was no relationship between the money supply and
inflation.

Even more unfortunately for both the theory and (far more importantly) vast
numbers of working class people, it was proven wrong not only theoretically
but also empirically. Monetarism was imposed on both the USA and the UK in the
early 1980s, with disastrous results. As the Thatcher government in 1979
applied Monetarist dogma the most whole-heartedly we will concentrate on that
regime (the same basic things occurred under Reagan as well but he embraced
military Keynesianism sooner and so mitigated its worse effects. [Michael
Stewart, **Keynes and After**, p. 181] This did not stop the right proclaiming
the Reagan boom as validation of "free market" economics!).

Firstly, the attempt to control the money supply failed, as predicted by
Nicholas Kaldor (see his 1970 essay _"The New Monetarism"_). This is because
the money supply, rather than being set by the central bank or the state (as
Friedman claimed), is a function of the demand for credit, which is itself a
function of economic activity. To use economic terminology, Friedman had
assumed that the money supply was "exogenous" and so determined outside the
economy by the state when, in fact, it is "endogenous" in nature (i.e. comes
from **within** the economy). [**The Essential Kaldor**, p. 483] This means
that any attempt by the central bank to control the money supply, as desired
by Friedman, will fail.

The experience of the Thatcher and Reagan regimes indicates this well. The
Thatcher government could not meet the money controls it set. It took until
1986 before the Tory government stopped announcing monetary targets, persuaded
no doubt by the embarrassment caused by its inability to hit them. In
addition, the variations in the money supply showed that Friedman's argument
on what caused inflation was also wrong. According to his theory, inflation
was caused by the money supply increasing faster than the economy, yet
inflation **fell** as the money supply increased. Between 1979 and 1981-2, its
growth rose and was still higher in 1982-3 than it had been in 1978-9 yet
inflation was down to 4.6% in 1983. As the moderate conservative MP Ian
Gilmore pointed out, _"[h]ad Friedmanite monetarism. . . been right, inflation
would have been about 16 per cent in 1982-3, 11 per cent in 1983-4, and 8 per
cent in 1984-5. In fact . . . in the relevant years it never approached the
levels infallibly predicted by monetarist doctrine."_ [Ian Gilmore, **Dancing
With Dogma**, p. 57 and pp. 62-3] So, as Henwood summarises, _"even the
periods of recession and recovery disprove monetarist dogma."_ [**Wall
Street**, p. 202]

However, the failed attempt to control the money supply had other, more
important effects, namely exploding interest and unemployment rates. Being
unable to control the supply of money, the government did the next best thing:
it tried to control the demand for money by rising interest rates.
Unfortunately for the Tories their preferred measure for the money supply
included interest-bearing bank deposits. This meant, as the government raised
interest rates in its attempts to control the money supply, it was profitable
for people to put more money on deposit. Thus the rise in interest rates
promoted people to put money in the bank, so increasing the particular measure
of the money supply the government sought to control which, in turn, lead them
to increase interest rates. [Michael Stewart, **Keynes in the 1990s**, p. 50]

The exploding interest rates used in a vain attempt to control the money
supply was the last thing Britain needed in the early 1980s. The economy was
already sliding into recession and government attempts to control the money
supply deepened it. While Milton Friedman predicted _"only a modest reduction
in output and employment"_ as a _"side effect of reducing inflation to single
figures by 1982,"_ in fact Britain experienced its deepest recession since the
1930s. [quoted by Michael Stewart, **Keynes and After**, p. 179] As Michael
Stewart dryly notes, it _"would be difficult to find an economic prediction
that that proved more comprehensively inaccurate."_ Unemployment rose from
around 5% in 1979 to 13% in the middle of 1985 (and would have been even
higher but for a change in the method used for measuring it, a change
implemented to knock numbers off of this disgraceful figure). In 1984
manufacturing output was still 10% lower than it had been in 1979. [**Op.
Cit.**, p. 180] Little wonder Kaldor stated that Monetarism was _"a terrible
curse, a visitation of evil spirits, with particularly unfortunate, one could
almost say devastating, effects on"_ Britain. [_"The Origins of the New
Monetarism,"_ pp. 160-177, **Further Essays on Economic Theory and Policy**,
p. 160]

Eventually, inflation did fall. From an anarchist perspective, however, this
fall in inflation was the result of the high unemployment of this period as it
weakened labour, so allowing profits to be made in production rather than in
circulation (see [last section](secC8.html#secc82) for this aspect of
inflation). With no need for capitalists to maintain their profits via price
increases, inflation would naturally decrease as labour's bargaining position
was weakened by the fear mass unemployment produced in the workforce. Rather
than being a purely monetary phenomena as Friedman claimed, inflation was a
product of the profit needs of capital and the state of the class struggle.
The net effect of the deep recession of the early 1980s and mass unemployment
during the 1980s (and 1990s) was to control working class people by putting
the fear of being fired back. The money supply had nothing to do with it and
attempts to control it would, of necessity, fail and the only tool available
to governments would be raising interest rates. This would reduce inflation
only by depressing investment, generating unemployment, and so (eventually)
slowing the growth in wages as workers bear the brunt of the recessions by
lowering their real income (i.e., paying higher prices on the same wages).
Which is what happened in the 1980s.

It is also of interest to note that even in Friedman's own test case of his
basic contention, the Great Depression of 1929-33, he got it wrong. For
Friedman, the _"fact is that the Great Depression, like most other periods of
severe unemployment, was produced by government mismanagement rather than by
any inherent instability of the private economy."_ [**Op. Cit.**, p. 54]
Kaldor pointed out that _"[a]ccording to Friedman's own figures, the amount of
'high-powered money'. . . in the US increased, not decreased, throughout the
Great Contraction: in July 1932, it was more than 10 per cent higher than in
July, 1929 . . . The Great Contraction of the money supply . . . occurred
**despite** this increase in the monetary base."_ [_"The New Monetarism"_,
**The Essential Kaldor**, pp. 487-8] Other economists also investigated
Friedman's claims, with similar result. Peter Temin, for example, critiqued
them from a Keynesian point of view, asking whether the decline in spending
resulted from a decline in the money supply or the other way round. He noted
that while the Monetarist _"narrative is long and complex"_ it _"offers far
less support for [its] assertions than appears at first. In fact, it assumes
the conclusion and describes the Depression in terms of it; it does not test
or prove it at all."_ He examined the changes in the real money balances and
found that they increased between 1929 and 1931 from between 1 and 18%
(depending on choice of money aggregate used and how it was deflated).
Overall, the money supply not only did not decline but actually increased 5%
between August 1929 and August 1931. Temin concluded that there is no evidence
that money caused the depression after the stock market crash. [**Did Monetary
Forces Cause the Great Depression?**, pp. 15-6 and p. 141]

There is, of course, a slight irony about Friedman's account of the Great
Depression. Friedman suggested that the Federal Reserve actually caused the
Great Depression, that it was in some sense a demonstration of the evils of
government intervention. In his view, the US monetary authorities followed
highly deflationary policies and so the money supply fell because they forced
or permitted a sharp reduction in the monetary base. In other words, because
they failed to exercise the responsibilities assigned to them. This is the
core of his argument. Yet it is important to stress that by this he did not,
in fact, mean that it happened because the government had intervened in the
market. Ironically, Friedman argued it happened because the government did
**not** intervene fast or far enough thus making a bad situation much worse.
In other words, it was not interventionist enough!

This self-contradictory argument arises because Friedman was an ideologue for
capitalism and so sought to show that it was a stable system, to exempt
capitalism from any systemic responsibility for recessions. That he ended up
arguing that the state caused the Great Depression by doing nothing (which,
ironically, was what Friedman usually argued it should do) just shows the
power of ideology over logic or facts. Its fleeting popularity was due to its
utility in the class war for the ruling class at that time. Given the absolute
failure of Monetarism, in both theory and practice, it is little talked about
now. That in the 1970s it was the leading economic dogma of the right explains
why this is the case. Given that the right usually likes to portray itself as
being strong on the economy it is useful to indicate that this is **not** the
case -- unless you think causing the deepest recessions since the 1930s in
order to create conditions where working class people are put in their place
so the rich get richer is your definition of sound economic policy. As Doug
Henwood summarises, there _"can be no doubt that monetarism . . . throughout
the world from the Chilean coup onward, has been an important part of a
conscious policy to crush labour and redistribute income and power toward
capital."_ [**Wall Street**, pp. 201-2]

For more on Monetarism, the work of its greatest critic, Nicholas Kaldor, is
essential reading (see for example, _"Origins of the new Monetarism"_ and
_"How Monetarism Failed"_ in **Further Essays on Economic Theory and Policy**,
_"The New Monetarism"_ in **The Essential Kaldor** and **The Scourge of
Monetarism**).

So under the rhetoric of "free market" capitalism, Keynesianism was used to
manage the crisis as it had previously managed the prosperity. "Supply Side"
economics (combined with neo-classical dogma) was used to undercut working
class power and consumption and so allow capital to reap more profits off
working class people by a combination of reduced regulation for the capitalist
class and state intervention to control the working class. Unemployment was
used to discipline a militant workforce and as a means of getting workers to
struggle **for** work instead of **against** wage labour. With the fear of job
loss hanging over their heads, workers put up with speedups, longer hours,
worse conditions and lower wages and this increased the profits that could be
extracted directly from workers as well as reducing business costs by allowing
employers to reduce on-job safety and protection and so on. The labour
"market" was fragmented to a large degree into powerless, atomised units with
unions fighting a losing battle in the face of a recession made much worse by
government policy (and justified by economic ideology). In this way capitalism
could successfully change the composition of demand from the working class to
capital.

Needless to say, we still living under the legacy of this process. As we
indicated in [section C.3](secC3.html), there has been a significant shift in
income from labour to capital in the USA. The same holds true in the UK, as
does rising inequality and higher rates of poverty. While the economy is doing
well for the few, the many are finding it harder to make ends meet and, as a
result, are working harder for longer and getting into debt to maintain their
income levels (in a sense, it could be argued that aggregate demand management
has been partially privatised as so many working class people are in debt).
Unsurprisingly 70% of the recent gain in per capita income in the Reagan-Bush
years went to the top 1% of income earners (while the bottom lost absolutely).
Income inequality increased, with the income of the bottom fifth of the US
population falling by 18% while that of the richest fifth rose by 8%. [Noam
Chomsky, **World Orders, Old and New**, p. 141] Combined with bubbles in
stocks and housing, the illusion of a good economy is maintained while only
those at the top are doing well (see [section B.7](secB7.html) on rising
inequality). This disciplining of the working class has been successful,
resulting in the benefits of rising productivity and growth going to the
elite. Unemployment and underemployment are still widespread, with most newly
created jobs being part-time and insecure.

Indirect means of increasing capital's share in the social income were also
used, such as reducing environment regulations, so externalising pollution
costs onto current and future generations. In Britain, state owned monopolies
were privatised at knock-down prices allowing private capital to increase its
resources at a fraction of the real cost. Indeed, some nationalised industries
were privatised **as monopolies** for a period allowing monopoly profits to be
extracted from consumers before the state allowed competition in those
markets. Indirect taxation also increased, reducing working class consumption
by getting us to foot the bill for capitalist restructuring as well as
military-style Keynesianism. Internationally, the exploitation of under-
developed nations increased with $418 billion being transferred to the
developed world between 1982 and 1990 [Chomsky, **Op. Cit.**, p. 130] Capital
also became increasingly international in scope, as it used advances in
technology to move capital to third world countries where state repression
ensured a less militant working class. This transfer had the advantage of
increasing unemployment in the developed world, so placing more pressures upon
working class resistance.

This policy of capital-led class war, a response to the successful working
class struggles of the 1960s and 1970s, obviously reaped the benefits it was
intended to for capital. Income going to capital has increased and that going
to labour has declined and the "labour market" has been disciplined to a large
degree (but not totally we must add). Working people have been turned, to a
large degree, from participants into spectators, as required for any
hierarchical system. The human impact of these policies cannot be calculated.
Little wonder, then, the utility of neo-classical dogma to the elite -- it
could be used by rich, powerful people to justify the fact that they are
pursuing social policies that create poverty and force children to die. As
Chomsky argues, _"one aspect of the internationalisation of the economy is the
extension of the two-tiered Third World mode to the core countries. Market
doctrine thus becomes an essential ideological weapon at home as well, its
highly selective application safely obscured by the doctrinal system. Wealth
and power are increasingly concentrated. Service for the general public -
education, health, transportation, libraries, etc. -- become as superfluous as
those they serve, and can therefore be limited or dispensed with entirely."_
[**Year 501**, p. 109]

The state managed recession has had its successes. Company profits are up as
the _"competitive cost"_ of workers is reduced due to fear of job losses. The
Wall Street Journal's review of economic performance for the last quarter of
1995 is headlined _"Companies' Profits Surged 61% on Higher Prices, Cost
Cuts."_ After-tax profits rose 62% from 1993, up from 34% for the third
quarter. While working America faces stagnant wages, Corporate America posted
record profits in 1994. **Business Week** estimated 1994 profits to be up _"an
enormous 41% over [1993],"_ despite a bare 9% increase in sales, a _"colossal
success,"_ resulting in large part from a _"sharp"_ drop in the _"share going
to labour,"_ though _"economists say labour will benefit -- eventually."_
[quoted by Noam Chomsky, _"Rollback III"_, **Z Magazine**, April 1995] Labour
was still waiting over a decade later.

Moreover, for capital, Keynesianism is still goes on as before, combined (as
usual) with praises to market miracles. For example, Michael Borrus, co-
director of the Berkeley Roundtable on the International Economy (a corporate-
funded trade and technology research institute), cites a 1988 Department of
Commerce study that states that _"five of the top six fastest growing U.S.
industries from 1972 to 1988 were sponsored or sustained, directly or
indirectly, by federal investment."_ He goes on to state that the _"winners
[in earlier years were] computers, biotechnology, jet engines, and airframes"_
all _"the by-product of public spending."_ [quoted by Chomsky, **World Orders,
Old and New**, p. 109] As James Midgley points out, _"the aggregate size of
the public sector did not decrease during the 1980s and instead, budgetary
policy resulted in a significant shift in existing allocations from social to
military and law enforcement."_ [_"The radical right, politics and society"_,
**The Radical Right and the Welfare State**, Howard Glennerster and James
Midgley (eds.), p. 11] Indeed, the US state funds one third of all civil
R&amp;D projects, and the UK state provides a similar subsidy. [Chomsky, **Op.
Cit.**, p. 107] And, of course, the state remains waiting to save the elite
from their own market follies (for example, after the widespread collapse of
Savings and Loans Associations in deregulated corruption and speculation, the
1980s pro-"free market" Republican administration happily bailed them out,
showing that market forces were only for one class).

The corporate owned media attacks social Keynesianism, while remaining silent
or justifying pro-business state intervention. Combined with extensive
corporate funding of right-wing "think-tanks" which explain why (the wrong
sort of) social programmes are counter-productive, the corporate state system
tries to fool the population into thinking that there is no alternative to the
rule by the market while the elite enrich themselves at the public's expense.
This means that state intervention has not ended as such. We are still in the
age of Keynes, but social Keynesianism has been replaced by military
Keynesianism cloaked beneath the rhetoric of "free market" dogma. This is a
mix of free(r) markets (for the many) and varying degrees of state
intervention (for the select few), while the state has become stronger and
more centralised (_"prisons also offer a Keynesian stimulus to the economy,
both to the construction business and white collar employment; the fastest
growing profession is reported to be security personnel."_ [Chomsky, **Year
501**, p. 110]). In other words, pretty much the same situation that has
existed since the dawn of capitalism (see [section D.1](secD1.html)) --
free(r) markets supported by ready use of state power as and when required.

The continued role of the state means that it is unlikely that a repeat of the
Great Depression is possible. The large size of state consumption means that
it stabilises aggregate demand to a degree unknown in 1929 or in the 19th
century period of free(r) market capitalism. This is **not** to suggest that
deep recessions will not happen (they have and will). It is simply to suggest
that they will **not** turn into a deep depression. Unless, of course,
ideologues who believe the "just-so" stories of economic textbooks and the
gurus of capitalism gain political office and start to dismantle too much of
the modern state. As Thatcher showed in 1979, it is possible to deepen
recessions considerably if you subscribe to flawed economic theory (ideology
would be a better word) and do not care about the impact it is having on the
general public -- and, more importantly, if the general public cannot stop
you).

However, as we discuss in [section C.10](secC10.html) the net effect of this
one-sided class war has not been as good as has been suggested by the
ideologues of capitalism and the media. Faced with the re-imposition of
hierarchy, the quality of life for the majority has fallen (consumption, i.e.
the quantity of life, may not but that is due to a combination of debt,
increased hours at work and more family members taking jobs to make ends
meet). This, in turn, has lead to a fetish over economic growth. As Joan
Robinson put it in the 1970s when this process started the _"economists have
relapsed into the slogans of laisser faire -- what is profitable promotes
growth; what is most profitable is best. But people have began to notice that
the growth of statistical GNP is not the same thing as an increase in
welfare."_ [**Collected Economic Papers**, vol. 4, p. 128] Yet even here, the
post-1970s experience is not great. A quarter century of top heavy growth in
which the vast majority of economic gains have gone to the richest 10% of the
population has not produced the rate of GDP growth promised for it. In fact,
the key stimulus for growth in the 1990s and 2000s was bubbles, first in the
stock market and then in the housing market. Moreover, rising personal debt
has bolstered the economy in a manner which are as unsustainable as the stock
and housing bubbles which, in part, supported it. How long the system will
stagger on depends, ultimately, on how long working class people will put up
with it and having to pay the costs inflicted onto society and the environment
in the pursuit of increasing the wealth of the few.

While working class resistance continues, it is largely defensive, but, as in
the past, this can and will change. Even the darkest night ends with the dawn
and the lights of working class resistance can be seen across the globe. For
example, the anti-Poll Tax struggle in Britain against the Thatcher Government
was successful as have been many anti-cuts struggles across the USA and
Western Europe, the Zapatista uprising in Mexico was inspiring as was the
Argentine revolt against neo-liberalism and its wave of popular assemblies and
occupied workplaces. In France, the anti-CPE protests showed a new generation
of working class people know not only how to protest but also nonsense when
they hear it. In general, there has been continual strikes and protests across
the world. Even in the face of state repression and managed economic
recession, working class people are still fighting back. The job for
anarchists to is encourage these sparks of liberty and help them win.

[‹ C.7 What causes the capitalist business cycle?](/afaq/secC7.html "Go to
previous page" ) [up](/afaq/secCcon.html "Go to parent page" ) [C.9 Would
laissez-faire capitalism reduce unemployment? ›](/afaq/secC9.html "Go to next
page" )

