/* this file is a part of Ami software, (C) Hwang chi-deok 1999 */

#include "config.h"
#include "edit.h"
#include "ic.h"
#include "ami.h"
#include "dw.h"
#include "cb.h"
#include "util.h"
#include "hinput.h"
#include <gdk/gdkkeysyms.h>

char *
editing_mbstocts(char *s)
{
    XTextProperty tp;

    XmbTextListToTextProperty(gdk_display, &s, 1,
			      XCompoundTextStyle, &tp);
    return tp.value;
}

int
editing_commit(IC *ic, char *buf)
{
    char *cts;
    IMCommitStruct cs;

    g_return_val_if_fail (ic != NULL, FALSE);
    g_return_val_if_fail (buf != NULL, FALSE);

    cts = editing_mbstocts(buf);
    cs.connect_id = ic->connect_id;
    cs.icid = ic->id;
    cs.flag = XimLookupChars;
    cs.commit_string = cts;
    IMCommitString(xims, (gpointer)&cs);
    XFree(cts);
    if (debug) g_print("ic=%d: commit string=%s\n", ic->id,buf);
    return 1;
}

int
editing_commit_both(IC *ic, KeySym keysym, char *buf)
{
    char *cts;
    IMCommitStruct cs;

    g_return_val_if_fail (ic != NULL, FALSE);
    g_return_val_if_fail (buf != NULL, FALSE);

    cs.connect_id = ic->connect_id;
    cs.icid = ic->id;
    if (*buf) {
	cs.flag = XimLookupBoth;
	cts = editing_mbstocts(buf);
    } else {
	cs.flag = XimLookupKeySym;
	cts = "";
    }
    cs.commit_string = cts;
    IMCommitString(xims, (gpointer)&cs);
    if (*cts) XFree(cts);
    if (debug) g_print("ic=%d: commit-both string=%s\n", ic->id,buf);
    return 1;
}

void
editing_toggle(IC *ic)
{
    g_return_if_fail (ic != NULL);
    g_return_if_fail (ic->han != NULL);

    ic->han->composing_hangul = !ic->han->composing_hangul;
    ic->composing_hangul = ic->han->composing_hangul;

    editing_flush(ic);
    ami_hangul_input_clear();
    if (ic->edit_win) {
	if (ic->han->composing_hangul) {
	    dw_show(ic->edit_win);
	} else {
	    dw_hide(ic->edit_win);
	}
    }
    if (ic->input_style & XIMPreeditCallbacks) {
	cb_edit_toggle(ic);
    }
    editing_status_win_update(ic);
}


/* FIXME */
/* make more sane function name */
int
editing_flush(IC *ic)
{
    char *s;
    g_return_val_if_fail (ic != NULL, 0);
    g_return_val_if_fail (ic->han != NULL, 0);
    s = g_strdup(ic->han->buf);
    if (ic->han->len <= 0) return 0;
    editing_commit(ic, ic->han->buf);
    editing_send_caret_position(ic);
    editing_reset(ic);
    //editing_commit(ic, s);
    g_free(s);
    return 1;
}

int
editing_flush_without_reset(IC *ic)
{
    g_return_val_if_fail (ic != NULL, 0);
    g_return_val_if_fail (ic->han != NULL, 0);
    if (ic->han->len <= 0) return 0;
    editing_commit(ic, ic->han->buf);
    editing_send_caret_position(ic);

    if (ic->input_style & XIMPreeditCallbacks) {
	cb_edit_reset(ic);
    }
    ic->han->buf[0] = '\0';
    ic->han->pos = ic->han->len = 0;
    ic->han->has_temp_hangul = 0;
    if (ic->edit_win) {
	dw_set_text(ic->edit_win, "", 0, 0);
    }
    return 1;
}

int
editing_flush_with_c(IC *ic, char c)
{
    g_return_val_if_fail (ic != NULL, 0);
    g_return_val_if_fail (ic->han != NULL, 0);
    if (ic->han->len == 0) {
	char buf[2]; 
	buf[0] = c; buf[1] = 0;
	editing_commit(ic, buf);
	return 1;
    }
    memmove(ic->han->buf + ic->han->pos + 1, ic->han->buf + ic->han->pos, ic->han->len - ic->han->pos + 1);
    ic->han->buf[ic->han->pos] = c; 
    editing_commit(ic, ic->han->buf);
    ic->han->pos++;
    editing_send_caret_position(ic);
    ic->han->pos--;
    editing_reset(ic);
    return 1;
}

int
editing_reset(IC *ic)
{
    g_return_val_if_fail (ic != NULL, 0);
    g_return_val_if_fail (ic->han != NULL, 0);
    if (ic->han->len <= 0) return 0;
    if (ic->input_style & XIMPreeditCallbacks) {
	cb_edit_reset(ic);
    }
    ami_hangul_input_clear();
    ic->han->buf[0] = '\0';
    ic->han->pos = ic->han->len = 0;
    ic->han->has_temp_hangul = 0;
    if (ic->edit_win) {
	dw_set_text(ic->edit_win, "", 0, 0);
    }
    return 1;
}

void
editing_correct_insert(IC *ic, guchar *buf)
{

    int pos;
    guchar *hbuf;
    g_return_if_fail (ic != NULL);
    g_return_if_fail (ic->han != NULL);

    pos = ic->han->pos;

    buf[4] = '\0';

    if (ic->input_style & XIMPreeditCallbacks) {
	cb_edit_correct_insert(ic, buf);
    }

    ami_hangul_check_bufsize(ic->han, 2);

    hbuf = ic->han->buf;
    if (ic->han->len > pos)
        memmove(hbuf + pos + 2, hbuf + pos, ic->han->len - pos);
    memcpy(hbuf + pos - 2, buf, 4);
    ic->han->pos += 2;
    ic->han->len += 2;
    hbuf[ic->han->len] = '\0';
    if (ic->edit_win) {
	editing_edit_win_update(ic);
    } 
}

int
editing_forward_delete(IC *ic)
{
    int pos;
    guchar *hbuf;
    int howmuch;
    g_return_val_if_fail (ic != NULL, 0);
    g_return_val_if_fail (ic->han != NULL, 0);

    pos = ic->han->pos;
    hbuf = ic->han->buf;
    howmuch = hbuf[pos] & 0x80 ? 2:1;

    if (pos + howmuch > ic->han->len) howmuch = ic->han->len - pos;
    if (howmuch <= 0) return FALSE;
    memmove (hbuf + pos, hbuf + pos + howmuch, ic->han->len - pos - howmuch);
    ic->han->len -= howmuch;
    hbuf[ic->han->len] = '\0';
    if (ic->edit_win) {
	editing_edit_win_update(ic);
    } else if (ic->input_style & XIMPreeditCallbacks) {
    }
    return TRUE;
}

int
editing_backward_delete(IC *ic)
{
    int pos;
    guchar *hbuf;
    int howmuch;

    g_return_val_if_fail (ic != NULL, 0);
    g_return_val_if_fail (ic->han != NULL, 0);

    pos = ic->han->pos;
    hbuf = ic->han->buf;

    if (pos <= 0) return FALSE;
    if (ic->input_style & XIMPreeditCallbacks) {
	cb_edit_backward_delete(ic);
    }


    howmuch = hbuf[pos - 1] & 0x80 ? 2:1;
    if (pos - howmuch < 0) howmuch = pos;
    memmove(hbuf + pos - howmuch, hbuf + pos, ic->han->len - pos);
    ic->han->len -= howmuch;
    ic->han->pos -= howmuch;
    hbuf[ic->han->len] = '\0';
    if (ic->edit_win) {
	editing_edit_win_update(ic);
    } 
    return TRUE;
}

void
editing_insert(IC *ic, guchar *buf, int size)
{
    int pos;
    guchar *hbuf;
    g_return_if_fail (ic != NULL);
    g_return_if_fail (ic->han != NULL);

    pos = ic->han->pos;

    buf[size] = '\0';
    if (ic->input_style & XIMPreeditCallbacks) {
	/*
	Is this necessary really?
	char buf1[3];
	buf1[0] = buf[0]; buf1[1] = buf[1]; buf1[2] = '\0';
	cb_edit_correct(ic, buf1);
	*/
	cb_edit_insert(ic, buf);
    }

    ami_hangul_check_bufsize(ic->han, size);
    hbuf = ic->han->buf;
    if (ic->han->len > pos)
    	memmove(hbuf + pos + size, hbuf + pos, ic->han->len - pos);
    ic->han->len += size;
    hbuf[ic->han->len] = '\0';
    memcpy(hbuf + pos, buf, size);
    ic->han->pos = pos + size;
    if (ic->edit_win) {
	editing_edit_win_update(ic);
    } 
}

void
editing_correct(IC *ic, guchar *buf)
{
    int pos;
    g_return_if_fail (ic != NULL);
    g_return_if_fail (ic->han != NULL);
    pos = ic->han->pos;
    buf[2] = '\0';
    if (ic->input_style & XIMPreeditCallbacks) {
    	cb_edit_correct(ic, buf);
    }
    ic->han->buf[pos - 2] = buf[0];
    ic->han->buf[pos - 1] = buf[1];
    if (ic->edit_win) {
	editing_edit_win_update(ic);
    } 
}

void
editing_hanja_replace(IC *ic, guchar *hanja)
{
    int len = strlen(hanja);
    char *buf = ic->han->buf + ic->han->pos - len;
    char *hangul = g_strndup(buf, len);
    char **hanja_formats = g_strsplit(ami_hanja_subst_format, ":", -1);
    GString *str = g_string_new(NULL);
    char *s = hanja_formats[ami_hanja_subst_mode-1];
    while (*s) {
	if (strncmp(s, "", 4) == 0) {
	    s += 4;
	    g_string_append(str, hangul);
	} else if (strncmp(s, "", 4) == 0) {
	    s += 4;
	    g_string_append(str, hanja);
	} else {
	    g_string_append_c(str, *s++);
	}
    }
    g_strfreev(hanja_formats);
    if (ic->input_style & XIMPreeditCallbacks) {
	cb_edit_hanja_replace(ic, hangul, str->str);
    }
    ami_hangul_check_bufsize(ic->han, str->len - len);
    buf = ic->han->buf + ic->han->pos - len;
    memmove(buf + str->len, buf + len, strlen(buf + len)+1);
    memmove(buf, str->str, str->len);
    ic->han->len += str->len - len;
    ic->han->pos += str->len - len;
    if (ic->edit_win) {
	editing_edit_win_update(ic);
    } 
    g_free(hangul);
    g_string_free(str, TRUE);
    if (debug) g_print("%s\n", buf);
}

/* ̵ ϸ TRUE, ϸ FALSE */ 
int
editing_move(IC *ic, int howmuch)
{
    int pos;
    char *buf;
    int len;
    g_return_val_if_fail (ic != NULL, 0);
    g_return_val_if_fail (ic->han != NULL, 0);
    buf = ic->han->buf;
    len = ic->han->len;
    pos = ic->han->pos;
    if (howmuch > 0) {
	while (howmuch--) {
	    if (buf[pos] & 0x80) pos++;
	    if (++pos >= len) {
		pos = len;
		break;
	    }
	}
    } else {
	while(howmuch++) {
	    if (--pos <= 0) {
		pos = 0;
		break;
	    }
	    if (buf[pos] & 0x80) pos--;
	}
    }
    if (ic->han->pos == pos) return FALSE;
    ic->han->pos = pos;
    if (ic->edit_win) {
	editing_edit_win_update(ic);
    } else if (ic->input_style & XIMPreeditCallbacks) {
	cb_edit_move(ic);
    }
    return TRUE;
}

void
editing_edit_win_update(IC *ic)
{
    g_return_if_fail (ic != NULL);
    g_return_if_fail (ic->han != NULL);
    if (!ic->edit_win) return;
    dw_set_text(ic->edit_win, ic->han->buf, ic->han->pos, ic->han->has_temp_hangul);
}

void
editing_status_win_update(IC *ic)
{
    g_return_if_fail (ic != NULL);
    g_return_if_fail (ic->han != NULL);
    if (!ic->status_win) return;
    g_return_if_fail (ic->han != NULL);
    if (ic->han->composing_hangul) {
	dw_set_text(ic->status_win, hangul_mode_label, -1, 0);
    } else {
	dw_set_text(ic->status_win, english_mode_label, -1, 0);
    }
}

void
editing_clear_temp(IC *ic)
{
    g_return_if_fail (ic != NULL);
    g_return_if_fail (ic->han != NULL);
    if (!ic->han->has_temp_hangul) return;
    if (ic->input_style & XIMPreeditCallbacks) cb_edit_clear_temp(ic);
    ic->han->has_temp_hangul = 0;
    ami_hangul_input_clear();
}

void
editing_send_caret_position(IC *ic)
{
#if 1
    IMCommitStruct cs;
    int howmuch;
    g_return_if_fail (ic != NULL);
    g_return_if_fail (ic->han != NULL);
    if (ic->han->len == ic->han->pos) return;
    howmuch = util_get_mb_strlen(ic->han->buf + ic->han->pos, -1);
    if (debug) g_print("%s: %d\n",__FUNCTION__, howmuch);

    cs.connect_id = ic->connect_id;
    cs.icid = ic->id;
    cs.flag = XimLookupKeySym;
    cs.commit_string = "";
    cs.keysym = GDK_Left;
    while (howmuch-- > 0) {
	IMCommitString(xims, (gpointer)&cs);
    }
#else
    IMForwardEventStruct cs;
    int howmuch;
    XKeyEvent *ev;
    g_return_if_fail (ic != NULL);
    g_return_if_fail (ic->han != NULL);
    if (ic->han->len == ic->han->pos) return;
    howmuch = count_char_num(ic->han->buf + ic->han->pos);
    cs.connect_id = ic->connect_id;
    cs.icid = ic->id;
    cs.event.xany.serial = 0;
    ev = (XKeyEvent *)&cs.event;
    ev->type = KeyPress;
    ev->state = 0;
    ev->time = 0;
    ev->keycode = XKeysymToKeycode(gdk_display, GDK_Left);
    while (howmuch-- > 0) {
	IMForwardEvent(xims, (gpointer)&cs);
    }
#endif
}
