#ifndef __EMU8000_LOCAL_H
#define __EMU8000_LOCAL_H
/*
 *  Local defininitons for the emu8000 (AWE32/64)
 *
 *  Copyright (C) 1999 Steve Ratcliffe
 *  Copyright (C) 1999-2000 Takashi Iwai <tiwai@suse.de>
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include "../../include/emu8000.h"
#include "../../include/emu8000_reg.h"

#define NELEM(arr) (sizeof(arr)/sizeof((arr)[0]))

/* emu8000_reg.c */
void snd_emu8000_poke(emu8000_t *emu, unsigned int port, unsigned int reg,
		      unsigned int val);
unsigned short snd_emu8000_peek(emu8000_t *emu, unsigned int port,
				unsigned int reg);
void snd_emu8000_poke_dw(emu8000_t *emu, unsigned int port, unsigned int reg,
			 unsigned int val);
unsigned int snd_emu8000_peek_dw(emu8000_t *emu, unsigned int port,
				 unsigned int reg);

int snd_emu8000_detect(emu8000_t *emu);
void snd_emu8000_dma_chan(emu8000_t *emu, int ch, int mode);
int snd_emu8000_open_dma(emu8000_t *emu, int mode);
void snd_emu8000_close_dma(emu8000_t *emu);
void snd_emu8000_wait_dma(emu8000_t *emu);
void snd_emu8000_read_wait(emu8000_t *emu);
void snd_emu8000_write_wait(emu8000_t *emu);
void snd_emu8000_wait(emu8000_t *emu, unsigned short delay);

/* emu8000_init.c */
void snd_emu8000_init_hw(emu8000_t *emu);
void snd_emu8000_start(emu8000_t *emu);
void snd_emu8000_init(emu8000_t *emu);
void snd_emu8000_init_fm(emu8000_t *emu);

/* emu8000_patch.c */
int snd_emu8000_sample_new(void *private_data, snd_sf_sample_t *sp, snd_emux_memhdr_t *hdr, const void *data, long count);
int snd_emu8000_sample_free(void *private_data, snd_sf_sample_t *sp, snd_emux_memhdr_t *hdr);
void snd_emu8000_sample_reset(void *private_data);

/* Prototypes for emu8000_proc.c */
void snd_emu8000_proc_init(emu8000_t *emu);
void snd_emu8000_proc_free(snd_info_entry_t *ip);

/* emu8000_synth.c */
void snd_emu8000_ops_setup(emu8000_t *emu);
void snd_emu8000_tweak_voice(emu8000_t *emu, int ch);

/* emu8000_equalizer.c */
void snd_emu8000_update_chorus_mode(emu8000_t *emu);
void snd_emu8000_update_reverb_mode(emu8000_t *emu);
void snd_emu8000_update_equalizer(emu8000_t *emu);
int snd_emu8000_load_fx(void *private, int type, int mode, const void *buf, long len);
void snd_emu8000_set_chorus_mode(emu8000_t *emu, int mode);
void snd_emu8000_set_reverb_mode(emu8000_t *emu, int mode);

int snd_emu8000_create_mixer(emu8000_t *emu, snd_kmixer_t *mixer, snd_kmixer_element_t *me_dest, int index);
void snd_emu8000_free_mixer(emu8000_t *emu);


#endif	/* __EMU8000_LOCAL_H */
