#  Alicq ICQ client: encoding module
#  Copyright (C) Ihar Viarheichyk 2001

#  This module is a part of Alicq ICQ client.

proc GetEncoding {} {
	# Default value is system encoding
	set encoding [encoding system]
	# Use encodings beginnig with CP on the wire
	if {[string match cp* $encoding]} {return $encoding}
	# Trying find wire encoding by the list
	foreach {local wire} {{koi8-r koi8-u iso8859-5} cp1251} {
		if {[lsearch -exact $local $encoding]!=-1} {
			return $wire 
		}
	}
	# If previuos attempts failed, analyse LANG variable
	# (usefull for UTF-8 encoding
	if {[info exists ::env(LANG)]} {
		switch -regex $::env(LANG) {
			"^(be|ru|uk)_" 	{set encoding "cp1251" }
		}
	}
	return $encoding
}
set var [pref "icq encoding"]
if {[info exists $var]} { set $var [GetEncoding] }

