// ---------------------------------------------------------------------------
// - Serial.hpp                                                              -
// - standard object library - serializable object abstract class definition -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2003 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  ALEPH_SERIAL_HPP
#define  ALEPH_SERIAL_HPP

#ifndef  ALEPH_OBJECT_HPP
#include "Object.hpp"
#endif

namespace aleph {

  /// The Serial class is an abstract class that defines the object 
  /// interface for serialization. An object serialization is performed 
  /// with the "wrstream" virtual method. The deserialization is performed
  /// with the "rdstream" virtual method. The class also defines the 
  /// standard object serialization identifier. All codes between 0x00
  /// and 0x7F are reserved. The rest is available for user custom class.
  /// @author amaury darsch

  class Serial : public virtual Object {
  public:
    /// the reserved serial ids
    static const t_byte SERIAL_NILP_ID = 0x00;
    static const t_byte SERIAL_BOOL_ID = 0x01;
    static const t_byte SERIAL_INTG_ID = 0x02;
    static const t_byte SERIAL_REAL_ID = 0x03;
    static const t_byte SERIAL_STRG_ID = 0x04;
    static const t_byte SERIAL_CHAR_ID = 0x05;
    static const t_byte SERIAL_RELT_ID = 0x06;
    static const t_byte SERIAL_REGX_ID = 0x07;
    static const t_byte SERIAL_CONS_ID = 0x08;
    static const t_byte SERIAL_VECT_ID = 0x09;

    /// the default serial constructor prototype
    typedef Serial* (*t_genser) (void);

  public:
    /// @return the object serial code
    virtual t_byte serialid (void) const;

    /// serialize an object to an output stream
    /// @param os the output stream to write
    virtual void wrstream (class Output& os) const;

    /// deserialize an object from an input stream
    /// @param is the input steam to read in
    virtual void rdstream (class Input& is);

    /// serialize an object with its serial id
    /// @param os the output stream to write
    virtual void serialize (class Output& os) const;

    // register a deserialize callback
    static t_byte setsid (const t_byte sid, t_genser cbk);

    /// @return a serial object by serial id
    static Serial* getserial (const t_byte sid);

    /// @return an object by deserialization
    static Object* deserialize (Input& is);
  };
}

#endif
