// ---------------------------------------------------------------------------
// - Address.hpp                                                             -
// - aleph:net library - address class definition                            -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2003 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  ALEPH_ADDRESS_HPP
#define  ALEPH_ADDRESS_HPP

#ifndef  ALEPH_STRING_HPP
#include "String.hpp"
#endif

namespace aleph {

  /// The Address class is the base class of the aleph networking environment
  /// which manipulates internet (ip) addresses. The address can be either
  /// a qualified name, or a family address. Currently the ip version 4 and 6
  /// are valid addresses.
  /// @author amaury darsch

  class Address : public Object {
  private:
    /// the original name
    String  d_name;
    /// the address bytes
    t_byte* p_addr;

  public:
    /// create a local address
    Address (void);

    /// create an address by name
    /// @param name the host name to use
    Address (const String& name);

    /// create an address by bytes
    /// @param addr the address bytes to use
    Address (const t_byte* addr);

    /// copy construct an address
    /// @param that the address to copy
    Address (const Address& that);

    /// destroy this address class
    ~Address (void);

    /// @return the class name
    String repr (void) const;

    /// assign an address to this one
    /// @param that the address to assign
    Address& operator = (const Address& that);

    /// @return the address canonical name
    String getcanon (void) const;

    /// @return the address representation
    String getaddr (void) const;

    /// generate a new address class
    /// @param argv the argument vector
    static Object* mknew (Vector* argv);

    /// apply this address with a set of arguments and a quark
    /// @param robj  the current runnable
    /// @param nset  the current nameset    
    /// @param quark the quark to apply these arguments
    /// @param argv  the arguments to apply
    Object* apply (Runnable* robj, Nameset* nset, const long quark,
		   Vector* argv);
    
  private:
    // make some friends
    friend class Socket;
    friend class UdpSocket;
  };
}

#endif
