// ---------------------------------------------------------------------------
// - t_integer.cpp                                                           -
// - standard object library - integer class tester module                   -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2001 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "Integer.hpp"
#include "Exception.hpp"

int main (int, char**) {
  using namespace aleph;

  // create a default null integer
  Integer i1;

  // check for initialized value at 0
  if ((i1 == 0) == false) return 1;

  // check for conversion
  Integer* p = new Integer (1);
  if (p->tostring() != "1") return 1;
  delete p;

  // create another integer and compare
  Integer i2 = 1;
  if (i1 == i2) return 1;
  if (i2 <  i1) return 1;
  if (i2 <= i1) return 1;
  if (i1 >  i2) return 1;
  if (i1 >= i2) return 1;

  // check for assign
  i1 = i2;
  if (i1 != i2) return 1;

  // check for add
  if ((i1 + i2) != 2) return 1;
  if ((i1 + 2)  != 3) return 1;

  // we are done
  return 0;
}
