// ---------------------------------------------------------------------------
// - t_cclk.cpp                                                              -
// - standard platform library - time function tester                        -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2001 amaury darsch                                   -
// ---------------------------------------------------------------------------

#include "cclk.hpp"

int main (int, char**) {
  using namespace aleph;

  // get the utc time since the epoch
  long tclk = c_time ();
  if (tclk <= 0) return -1;

  // test the local time - we need to be in year 2000
  s_tinfo* linfo = c_getlocal (tclk);
  if (linfo == 0) return -1;
  if (linfo->d_year < 2000) return -1;
  delete linfo;

  // test the utc time - we need to be in year 2000
  s_tinfo* uinfo = c_getutc (tclk);
  if (uinfo == 0) return -1;
  if (uinfo->d_year < 2000) return -1;
  delete uinfo;

  // sleep for one second
  c_sleep (1000);

  // everything is fine
  return 0;
}
