// ---------------------------------------------------------------------------
// - cnet.hxx                                                                -
// - standard system library - c network function platform definitions       -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2001 amaury darsch                                   -
// ---------------------------------------------------------------------------

// check for unknown platform
#if (ALEPH_PLATFORM_PLATID == ALEPH_PLATFORM_UNKNOWN)
#error "unknown platform type"
#endif

// check for unknown processor
#if (ALEPH_PLATFORM_PROCID == ALEPH_PROCTYPE_UNKNOWN)
#error "unknown processor type"
#endif

// linux platform
#if (ALEPH_PLATFORM_PLATID == ALEPH_PLATFORM_LINUX)
#define  ALEPH_HAVE_IPV6
#define  ALEPH_HAVE_IPV6_MCAST
#define  ALEPH_LOOPBACK_NAME "localhost"
#include <sys/socket.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <netdb.h>
#include <stdio.h>
#include <errno.h>
#endif

// solaris platform
#if (ALEPH_PLATFORM_PLATID == ALEPH_PLATFORM_SOLARIS)
#define  ALEPH_LOOPBACK_NAME "localhost"
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <stdio.h>
#include <errno.h>
// solaris 2.5.1 uses old setsockopt and does not define socklen_t
#if (ALEPH_PLATFORM_MAJOR == 5) && (ALEPH_PLATFORM_MINOR < 7)
typedef int socklen_t;
#define ALEPH_HAVE_CHAROPT
#endif
// ipv6 is only on solaris 8
#if (ALEPH_PLATFORM_MAJOR == 5) && (ALEPH_PLATFORM_MINOR >= 8)
#define  ALEPH_HAVE_IPV6
#define  ALEPH_HAVE_IPV6_MCAST
#include <netinet/ip6.h>
#endif
#endif

// freebsd platform
#if (ALEPH_PLATFORM_PLATID == ALEPH_PLATFORM_FREEBSD)
#define  ALEPH_LOOPBACK_NAME "localhost"
#define  ALEPH_HAVE_IPV6
#define  ALEPH_HAVE_IPV6_MCAST
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netinet/ip6.h>
#include <netinet/tcp.h>
#include <netdb.h>
#include <stdio.h>
#include <errno.h>
// define ipv6 multicast socket option
#ifndef IPV6_ADD_MEMBERSHIP
#define IPV6_ADD_MEMBERSHIP  IPV6_JOIN_GROUP
#endif
#ifndef IPV6_DROP_MEMBERSHIP
#define IPV6_DROP_MEMBERSHIP IPV6_LEAVE_GROUP
#endif
#endif

// the global socket address space is defined depending on ipv6 or not.
// some implementations are sensitive to the address length
#ifdef  ALEPH_HAVE_IPV6
// the socket option level
#ifndef SOL_IPV6
#define SOL_IPV6 IPPROTO_IPV6
#endif
// the address length
const socklen_t IP_ADDRLEN_6 = sizeof (struct sockaddr_in6);
const socklen_t IP_ADDRLEN_4 = sizeof (struct sockaddr_in);
// the global address space
typedef union {
  struct sockaddr_in  addr4;
  struct sockaddr_in6 addr6;
} t_sockaddr;
#else
const socklen_t IP_ADDRLEN_4 = sizeof (struct sockaddr_in);
typedef union {
  struct sockaddr_in addr4;
} t_sockaddr;
#endif

// adjust socket options constant
#ifndef SOL_TCP
#define SOL_TCP  IPPROTO_TCP
#endif

#ifndef SOL_IP
#define SOL_IP   IPPROTO_IP
#endif
