// ---------------------------------------------------------------------------
// - cclk.hpp                                                                -
// - standard system library - c time native function definition             -
// ---------------------------------------------------------------------------
// - This program is free software;  you can redistribute it  and/or  modify -
// - it provided that this copyright notice is kept intact.                  -
// -                                                                         -
// - This program  is  distributed in  the hope  that it will be useful, but -
// - without  any  warranty;  without  even   the   implied    warranty   of -
// - merchantability or fitness for a particular purpose.  In no event shall -
// - the copyright holder be liable for any  direct, indirect, incidental or -
// - special damages arising in any way out of the use of this software.     -
// ---------------------------------------------------------------------------
// - copyright (c) 1999-2001 amaury darsch                                   -
// ---------------------------------------------------------------------------

#ifndef  ALEPH_CCLK_HPP
#define  ALEPH_CCLK_HPP

#ifndef  ALEPH_CCNF_HPP
#include "ccnf.hpp"
#endif

namespace aleph {

  /// structure used for time description
  struct s_tinfo {
    int  d_secs; // seconds after the minute
    int  d_mins; // minutes after the hour
    int  d_hour; // hour in the day
    int  d_mday; // day on the month
    int  d_ymon; // month in the year
    int  d_year; // year since 1900
    int  d_wday; // day of the week
    int  d_yday; // day of the year
  };

  /// pause for a certain time
  /// @param time the time to pause in milliseonds
  void c_sleep (const long time);

  /// @return a machine time stamp
  t_octa c_stamp (void);

  /// @return the current utc since the epoch in second
  long c_time (void);

  /// @return the local time info structure
  s_tinfo* c_getlocal (const long tclk);

  /// @return the utc time info structure
  s_tinfo* c_getutc (const long tclk);

  /// @return a time value from a time structure
  long c_mktime (s_tinfo* tinfo);
}

#endif
