//==============================================
//  copyright            : (C) 2003-2005 by Will Stokes
//==============================================
//  This program is free software; you can redistribute it
//  and/or modify it under the terms of the GNU General
//  Public License as published by the Free Software
//  Foundation; either version 2 of the License, or
//  (at your option) any later version.
//==============================================

#ifndef GUI_HELP_HELPWINDOW_H
#define GUI_HELP_HELPWINDOW_H

#include <qdialog.h>
#include "contents.h"

class ALabel;
class QTextBrowser;

//=====================================
/*! \brief Help window widget
 */
//=====================================

//======================
class HelpWindow : public QDialog
{
Q_OBJECT
//----------------------
public:
  HelpWindow( QWidget *parent=0, const char* name=0);
  ~HelpWindow();
//----------------------
signals:
  void closed();
//----------------------
private slots:
  void setPage(HELP_PAGE page);
  void showFirstSelection();
  void showCurrentPage();
  void reject();
//----------------------
private:
  void closeEvent( QCloseEvent* e);

  ALabel* billboard;
  QTextBrowser* content;
  
  HELP_PAGE currentPage;  
  
  QMimeSourceFactory* loadingMimeSource;
//----------------------
};
//======================

#endif //GUI_HELP_HELPWINDOW_H
