/**********************************************************************
 * ip_address.h                                              March 2001
 * Horms                                             horms@vergenet.net
 *
 * aggregate
 * CIDR network aggregation and filtering
 * Copyright (C) 2001  Horms
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
 * 02111-1307  USA
 *
 **********************************************************************/


#ifndef IP_FRUB
#define IP_FRUB

#include "int.h"

#define IP_STRING_LENGTH 16
#define IP_BITS 32

typedef uint32 ip_address_t;
typedef uint8  octet_t;

#define IP_MIN (ip_address_t) 0
#define IP_MAX (ip_address_t) 4294967295

#define OCTET_MIN (octet_t) 0
#define OCTET_MAX (octet_t) 255


/**********************************************************************
 * ip_address_dotted_quad_to_decimal
 * Convert an IP address given as a string into decimal
 * pre: alleged_ip: string representing ip address
 * post: 0 on success, result contains value
 *       -1 on error
 **********************************************************************/

int ip_address_dotted_quad_to_decimal(
  char *alleged_ip, 
  ip_address_t *decimal_ip
);


/**********************************************************************
 * ip_address_decimal_to_dotted_quad
 * Turn an IP given as a decimal to a dotted quad
 * pre: ip_address: string representing IP address
 * post: NULL if an error occurs
 *       dotted quad representation of IP address otherwise
 * Note: result is rendered into a static buffer
 **********************************************************************/

char *ip_address_decimal_to_dotted_quad(ip_address_t ip_address);

#endif
