/****************** Start of $RCSfile: sysutils.h,v $  ****************
*
* $Source: /home/alb/afbackup/afbackup-3.3.6/RCS/sysutils.h,v $
* $Id: sysutils.h,v 1.2 2002/02/27 10:17:11 alb Exp alb $
* $Date: 2002/02/27 10:17:11 $
* $Author: alb $
*
*
******* description ***********************************************
*
*
*
*******************************************************************/

#ifndef __SYSUTILS_H
#define	__SYSUTILS_H	__SYSUTILS_H

#include <signal.h>
#include <sys/types.h>
#include <stdarg.h>
#include <syslog.h>

#include <genutils.h>

#ifdef	__FreeBSD__
# define O_SYNC O_FSYNC
#endif

#ifndef	MAXHOSTNAMELEN
#define	MAXHOSTNAMELEN	200	/* should be almost sufficient */
#endif


typedef	struct	__mnt_ent_ {
  dev_t		dev;
  UChar		*dir;
  UChar		*typestr;
  UChar		*devstr;
} MntEnt;

#ifdef __QNX__

#define	ITIMER_REAL		0		/* Real time */
#define	ITIMER_VIRTUAL		1		/* Per-process time */
#define	ITIMER_PROF		2		/* Per-process user time */

#if 0
/* seems to exist already */
struct timeval {
        int		tv_sec;			/* seconds */
        int		tv_usec;		/* microseconds */
};

struct	itimerval {
	struct		timeval it_interval;	/* timer interval */
	struct		timeval it_value;	/* current value */
};
#endif	/* 0 */

#ifdef	__cplusplus
extern	"C"	{
#endif

extern	int	setitimer(int, struct itimerval *, struct itimerval *);
extern	int	getitimer(int, struct itimerval *);

#ifdef	__cplusplus
}
#endif

#endif	/* defined(__QNX__) */

#ifdef	__cplusplus
extern	"C"	{
#endif

extern	Int32	get_fs_space(UChar *, Real64 *);
extern	Int32	get_fs_status(UChar *, Int32 *, Real64 *, Real64 *, Real64 *);
extern	MntEnt	*get_all_mounts(Int32 *);
extern	MntEnt	*find_mnt_by_devno(MntEnt *, Int32, dev_t);
extern	UChar	*get_fstype_by_devno(dev_t);
extern	void	free_mounts(MntEnt *);
extern	Int32	free_fds();
extern	Flag	is_a_tty(int);
extern	void	gvsyslog(UChar *, int, int, int, UChar *, va_list);
extern	int	fd_system_fork(char *, int *);
extern	int	fp_system_fork(char *, FILE **);
extern	int	fdpopen(char *, int, int *);
extern	Int32	bytes_free_real_mem_pag(Int32, Int32);
extern	int	open_to_pipe(UChar *, UChar *, UChar, int *, int);
extern	int	open_from_pipe(UChar *, UChar *, UChar, int *);
extern	Int32	open_from_to_pipe(UChar *, int *, UChar, int *);
extern	int	open_to_pipe_sigblk(UChar *, UChar *, UChar,
					int *, int, sigset_t *);
extern	int	open_from_pipe_sigblk(UChar *, UChar *, UChar,
					int *, sigset_t *);
extern	Int32	open_from_to_pipe_sigblk(UChar *, int *, UChar,
					int *, sigset_t *);
extern	int	detach_from_tty();
extern	void	ms_sleep(Int32);
extern	int	set_eff_ugids(uid_t, gid_t, int, gid_t *);
extern	int	get_groups(int *, gid_t **);



#ifdef	__cplusplus
}
#endif


#endif	/* ! defined(__SYSUTILS_H) */

/************ end of $RCSfile: sysutils.h,v $ ******************/

