/*
 * This file is part of ACGVision, SaaS system-monitoring software
 * Copyright (C) 2009 ACGCenter
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package com.acgvision.agent.run;

import com.acgvision.core.ws.Job;
import java.util.Date;
import org.apache.log4j.Logger;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import static org.junit.Assert.*;

/**
 *
 * @author Rémi Debay <remi.debay@acgcenter.com>
 */
public class UniqueListTest {
    private static final Logger logger = Logger.getLogger(Task.class);
    public UniqueListTest() {
    }

    @BeforeClass
    public static void setUpClass() throws Exception {
    }

    @AfterClass
    public static void tearDownClass() throws Exception {
    }

    /**
     * Test of addUnique method, of class UniqueList.
     */
    @Test
    public void testAddUnique() {
        System.out.println("addUnique");
        Task t1 = new Task();
        Task t2 = new Task();
        Task t3 = new Task();
        Task t4 = new Task();
        Job j1 = new Job();
        j1.setId(1L);
        Job j2 = new Job();
        j2.setId(2L);
        Job j3 = new Job();
        j3.setId(3L);
        Job j4 = new Job();
        j4.setId(4L);
        t1.setJob(j1);
        t2.setJob(j2);
        t3.setJob(j3);
        t4.setJob(j4);



        @SuppressWarnings("deprecation")
        Date d1 =new Date("01/01/2009");
        @SuppressWarnings("deprecation")
        Date d2 = new Date("01/01/2020");//d1<d2
        @SuppressWarnings("deprecation")
        Date d3 = new Date("01/01/2012");//d1<d3<d2
        @SuppressWarnings("deprecation")
        Date d4 = new Date("01/01/2007");//d1<d3<d2

        t1.setNextTime(d1);
        t2.setNextTime(d2);
        t3.setNextTime(d3);
        t4.setNextTime(d4);

        UniqueList instance = new UniqueList();

        instance.addUnique(t1);
        assertTrue(instance!=null);
        assertTrue(instance.getFirst()!=null);
        assertTrue(instance.getFirst().equals(t1));

        instance.addUnique(t2);
        assertTrue(instance.getFirst().equals(t1));
        assertTrue(instance.get(1).equals(t2));

        instance.addUnique(t3);
        assertTrue(instance.getFirst().equals(t1));
        assertTrue(instance.get(1).equals(t3));
        assertTrue(instance.get(2).equals(t2));

        instance.addUnique(t4);
        assertTrue(instance.getFirst().equals(t4));
        assertTrue(instance.get(1).equals(t1));
        assertTrue(instance.get(2).equals(t3));
        assertTrue(instance.get(3).equals(t2));

        instance.remove(t1);
        assertTrue(instance.getFirst().equals(t4));
        assertTrue(instance.get(1).equals(t3));
        assertTrue(instance.get(2).equals(t2));
    }

}