/*
 * This file is part of ACGVision, SaaS system-monitoring software
 * Copyright (C) 2009 ACGCenter
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package com.acgvision.agent.run;

import com.acgvision.core.ws.Average;
import com.acgvision.core.ws.Job;
import com.acgvision.core.ws.Control;
import com.acgvision.core.ws.Jobs;
import com.acgvision.core.ws.LimitValue;
import com.acgvision.core.ws.Monitor;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;

/**
 * Uses a linked List and generates it has an ordered list of unique elements.
 * First task in this list is nearest in future.
 * @param <Object>
 * @author Rémi Debay <remi.debay@acgcenter.com>
 */
public class UniqueList<Object> extends LinkedList implements Serializable {

    private static final Logger logger = Logger.getLogger(UniqueList.class);

    public boolean contains(Job j) {
        Iterator<Task> it = this.iterator();
       // while(Task t : (List<Task>)this)
        while (it.hasNext()) {
            Task t = it.next();
            if (t.getJob() != null) {
                if (t.getJob().getId() == j.getId()) {
                    return true;
                }
            }
        }
        return false;
    }

    /**
     * Adds a unique value and orders the list
     * @param newTask
     */
    public void addUnique(Task newTask) {
        if (newTask != null && newTask.getJob()!=null) {
            if (!this.contains(newTask) && !this.contains(newTask.getJob())) {

                Iterator<Task> it = this.iterator();
                boolean findwhen = false;
                while (it.hasNext() && !findwhen) {
                    Task o = it.next();
                    //si la tache courante est moins proche que la tache à ajouter
                    //on ajoute
                    if (o.getNextTime().getTime()>newTask.getNextTime().getTime()) {//if positive means t > o
                        if (logger.isInfoEnabled()){
                            logger.debug("Ajout de la tâche "+newTask.getJob().getName() +" à la date " + newTask.getNextTime().toString() +" \n" +
                                    "Devant la tâche  "+o.getJob().getName() +" à la date " + o.getNextTime().toString()  );
   
                            logger.info(newTask);
                        }
                        this.add(this.indexOf(o), newTask);
                        findwhen = true;
                    }
                }
                if (!findwhen) {
                    if (logger.isInfoEnabled()){
                       logger.info("Ajout de la tâche "+newTask.getJob().getName() +" à la date " + newTask.getNextTime().toString() +" en queue.\n" );
                    }
                    this.addLast(newTask);
                }
            }else{
                if (logger.isInfoEnabled()){
                       logger.info("Tâche "+newTask.getJob().getName() +" à la date " + newTask.getNextTime().toString() +" existe déjà dans la liste.\n" );
                    }
            }
        }else{
            logger.error("Trying to insert null task");
        }
    }

    /**
     * adds a list and orders it.
     * @param jobs list to add.
     */
    public void addUnique(List<? extends Job> jobs) {
        if (jobs != null) {
            if (!jobs.isEmpty()) {
                Iterator<? extends Job> i = jobs.iterator();
                while (i.hasNext()) {
                    Task t = new Task();
                    t.setJob(i.next());
                    if (t.getJob() instanceof Monitor) {
                        ((Monitor) t.getJob()).getMeasures().clear();
                        if (logger.isDebugEnabled() && t.getJob() instanceof Monitor && ((Monitor) t.getJob()).getLimitValues() != null && ((Monitor) t.getJob()).getAverages() != null) {
                            //On affiche si des actions automatiques
                            for (Average avg : ((Monitor) t.getJob()).getAverages()) {
                                if (avg.getAutomaticAction() != null) {
                                    logger.debug("Contient l'action automatique : " + avg.getAutomaticAction().getName());
                                }
                            }
                            for (LimitValue lv : ((Monitor) t.getJob()).getLimitValues()) {
                                if (lv.getAutomaticAction() != null) {
                                    logger.debug("Contient l'action automatique : " + lv.getAutomaticAction().getName());
                                }
                            }
                        }
                    }
                    if (t.getJob() instanceof Control) {
                        ((Control) t.getJob()).getIncidents().clear();
                    }
                    logger.debug("Adding job :" + t.getJob().getName());

                    t.generateWhen();
                    this.addUnique(t);
                }
            } else {
                logger.debug("no jobs to add.");
            }
        }
    }

    /**
     * adds jobs and orders it.
     * @param jobs to add.
     */
    public void addUnique(Jobs jobs) {
        if (jobs != null) {
            addUnique(jobs.getAlives());
            //addUnique(jobs.getAverages());
            addUnique(jobs.getCpus());
            addUnique(jobs.getDeployements());
            addUnique(jobs.getFileSystems());
            //addUnique(jobs.getLimitValues());
            addUnique(jobs.getLogFiles());
            addUnique(jobs.getMemories());
            addUnique(jobs.getProcesses());
            addUnique(jobs.getScripts());
            addUnique(jobs.getUpdates());
        }
    }
}
