// $Id: client.cpp 85150 2009-04-23 07:20:57Z johnnyw $

#include "Client_Task.h"
#include "ace/Get_Opt.h"

ACE_RCSID(Client_Leaks, client, "$Id: client.cpp 85150 2009-04-23 07:20:57Z johnnyw $")

const ACE_TCHAR *ior = ACE_TEXT ("file://test.ior");
int iterations = 100;
int threads = 12;

int
parse_args (int argc, ACE_TCHAR *argv[])
{
  ACE_Get_Opt get_opts (argc, argv, ACE_TEXT("k:i:n:"));
  int c;

  while ((c = get_opts ()) != -1)
    switch (c)
      {
      case 'k':
        ior = get_opts.opt_arg ();
        break;

      case 'i':
        iterations = ACE_OS::atoi (get_opts.opt_arg ());
        break;

      case 'n':
        threads = ACE_OS::atoi (get_opts.opt_arg ());
        break;

      case '?':
      default:
        ACE_ERROR_RETURN ((LM_ERROR,
                           "usage:  %s "
                           "-k <ior> "
                           "-i <iterations> "
                           "-i <threads> "
                           "\n",
                           argv [0]),
                          -1);
      }
  // Indicates sucessful parsing of the command line
  return 0;
}

int
ACE_TMAIN (int argc, ACE_TCHAR *argv[])
{
  try
    {
      CORBA::ORB_var orb =
        CORBA::ORB_init (argc, argv);

      if (parse_args (argc, argv) != 0)
        return 1;

      CORBA::Object_var tmp =
        orb->string_to_object (ior);

      Test::Process_Factory_var process_factory =
        Test::Process_Factory::_narrow(tmp.in ());

      if (CORBA::is_nil (process_factory.in ()))
        {
          ACE_ERROR_RETURN ((LM_DEBUG,
                             "Nil process reference <%s>\n",
                             ior),
                            1);
        }

      Client_Task client_task (process_factory.in (),
                               iterations);

      if (client_task.activate (THR_NEW_LWP | THR_JOINABLE,
                                threads, 1) == -1)
        {
          ACE_ERROR ((LM_ERROR, "Error activating client task\n"));
        }
      ACE_Thread_Manager::instance ()->wait ();

      process_factory->shutdown ();

      orb->destroy ();

      // Only pass the test if 90% of the calls worked
      if (client_task.successful_calls () < 0.9 * iterations * threads)
        {
          ACE_ERROR ((LM_ERROR,
                      "ERROR: no calls were successful\n"));
        }
    }
  catch (const CORBA::Exception& ex)
    {
      ex._tao_print_exception ("Exception caught:");
      return 1;
    }

  return 0;
}
