// client.cpp,v 1.1 2004/10/07 16:40:08 elliott_c Exp

#include "testC.h"
#include "ace/Get_Opt.h"

ACE_RCSID(StringArray, client, "client.cpp,v 1.1 2004/10/07 16:40:08 elliott_c Exp")

const char *ior = "file://server.ior";

int
parse_args (int argc, char *argv[])
{
  ACE_Get_Opt get_opts (argc, argv, "k:");
  int c;

  while ((c = get_opts ()) != -1)
    switch (c)
      {
      case 'k':
        ior = get_opts.opt_arg ();
        break;

      case '?':
      default:
        ACE_ERROR_RETURN ((LM_ERROR,
                           "usage:  %s "
                           "-k <ior> "
                           "\n",
                           argv [0]),
                          -1);
      }
  // Indicates sucessful parsing of the command line
  return 0;
}

int
main (int argc, char *argv[])
{
  ACE_TRY_NEW_ENV
    {
      CORBA::ORB_var orb =
        CORBA::ORB_init (argc, argv, "" ACE_ENV_ARG_PARAMETER);
      ACE_TRY_CHECK;

      if (parse_args (argc, argv) != 0)
        return 1;

      CORBA::Object_var tmp =
        orb->string_to_object(ior ACE_ENV_ARG_PARAMETER);
      ACE_TRY_CHECK;

      SimpleStrings_var server =
        SimpleStrings::_narrow(tmp.in () ACE_ENV_ARG_PARAMETER);
      ACE_TRY_CHECK;

      if (CORBA::is_nil (server.in ()))
        {
          ACE_ERROR_RETURN ((LM_DEBUG,
                             "Nil SimpleStrings reference <%s>\n",
                             ior),
                            1);
        }

      ArrayOfString_var the_strings;
      server->get_strings (the_strings.out () ACE_ENV_ARG_PARAMETER);
      ACE_TRY_CHECK;

      for(size_t i = 0; i < 15; i++)
        {
          ACE_DEBUG ((LM_DEBUG, "%s\n", the_strings[i].in ()));
        }

      orb->destroy (ACE_ENV_SINGLE_ARG_PARAMETER);
      ACE_TRY_CHECK;
    }
  ACE_CATCHANY
    {
      ACE_PRINT_EXCEPTION (ACE_ANY_EXCEPTION,
                           "Exception caught:");
      return 1;
    }
  ACE_ENDTRY;

  return 0;
}
