// RecursDef_i.cpp,v 1.3 2005/01/31 03:58:38 ossama Exp

#include "RecursDef_i.h"


ACE_RCSID (IFRService,
           RecursDef_i,
           "RecursDef_i.cpp,v 1.1 2004/10/18 09:00:00 SMA Exp")


//-----------------------------------------------------------------------------
// Class TAO_RecursiveDef_OuterScopes is a support class for StructDef_i.h and
// UnionDef_i.h files. It creates a stack of outer structure definitions, used
// by TAO_StructDef_i::type_i(), and TAO_UnionDef_i::type_i() during nested
// structure processing.
//-----------------------------------------------------------------------------

TAO_RecursiveDef_OuterScopes::TAO_RecursiveDef_OuterScopes( const ACE_TString &id )
  : id_( id ), pNextOuterID_( pIDsSeenAlready )
{
  pIDsSeenAlready= this; // "Push" this scope
}

TAO_RecursiveDef_OuterScopes::~TAO_RecursiveDef_OuterScopes()
{
  pIDsSeenAlready= pNextOuterID_; // "Pop" this scope
}

bool TAO_RecursiveDef_OuterScopes::SeenBefore( const ACE_TString &id )
{
  for ( const TAO_RecursiveDef_OuterScopes *pOuterScope= pIDsSeenAlready;
        pOuterScope;
        pOuterScope= pOuterScope->pNextOuterID_ )
  {
    if (pOuterScope->id_ == id)
      return true;
  }

  return false;
}

const TAO_RecursiveDef_OuterScopes
  *TAO_RecursiveDef_OuterScopes::pIDsSeenAlready= 0;
