/* -*- C++ -*- */
// Logging_Test_i.h,v 1.7 2004/08/27 07:03:14 jtc Exp

// ============================================================================
//
// = LIBRARY
//    TAO/orbsvcs/tests/Logger
//
// = FILENAME
//    client_i.h
//
// = DESCRIPTION
//    This class implements a simple logger CORBA client for the Logger
//    example using stubs generated by the TAO ORB IDL compiler
//
// = AUTHORS
//      Sergio Flores-Gaitan <sergio@cs.wustl.edu>
//      Matt Braun <mjb2@cec.wustl.edu>
//
// ============================================================================

#ifndef _LOG_CLIENT_H
#define _LOG_CLIENT_H

#include "ace/Get_Opt.h"

#if !defined (ACE_LACKS_PRAGMA_ONCE)
# pragma once
#endif /* ACE_LACKS_PRAGMA_ONCE */

#include "orbsvcs/CosNamingC.h"
#include "LoggerC.h"
#include "orbsvcs/Naming/Naming_Client.h"

class Logger_Client
{
  // = TITLE
  //    Defines a class that encapsulates behaviour of the Logger
  //    client example.  Provides a better understanding of the logic
  //    in an object oriented way.
  //
  // = DESCRIPTION
  //    This class declares an interface to run the example client for
  //    Logger CORBA server.  All the complexity for initializing the
  //    server is hidden in the class.  Just the <run> interface is
  //    needed.
public:
  // = Initialization and termination methods.

  Logger_Client (void);
  // Constructor.

  ~Logger_Client (void);
  // Destructor.

  int init (int argc, char **argv);
  // Initialize the client communication endpoint with server.

  int run (void);
  // Execute client example code.

private:
  int parse_args (void);
  // Parses the arguments passed on the command line.

  void init_record (Logger::Log_Record &newrec,
                    Logger::Log_Priority lp,
                    const char *msg);
  // Prepares the <Log_Record> for logging.

  int init_naming_service (ACE_ENV_SINGLE_ARG_DECL);
  // Initialises the name server and resolves the logger_factory

  int init_loggers (ACE_ENV_SINGLE_ARG_DECL);
  // Instantiates the 2 logger member variables

  void show_record (Logger::Log_Record &newrec);
  // Shows contents of the record (for debugging purposes).

  CORBA::ORB_var orb_;
  // Keep a pointer to the ORB for easy access

  TAO_Naming_Client my_name_client_;
  // An instance of the name client used for resolving the factory
  // objects.

  int argc_;
  // # of arguments on the command line.

  char **argv_;
  // arguments from command line.

  Logger_Factory_var factory_;
  // A pointer to the Logger_Factory; used in init_loggers

  Logger_var logger_1_;
  // Logger obj ref.

  Logger_var logger_2_;
  // Logger obj ref.
};

#endif /* _LOG_CLIENT_H */
