
/* 
	--- ACA example ---
	
	Show:
		- Widget definition: 	(buttons)
		- Dialogs using		(SelectFile, FileViewer, YesNo)
		- Refresh buffer using.
 */

#include <aca/aca.h>
#include <aca/aca_widget.h>
#include <aca/aca_dlg.h>

#include "examples_colors.h"

   int main() 
   {
      Wbutton	me_button[] = {
      { "[ |S|elect ]", 0 },
      { "[ |V|iew ]",   0 }
      };
      Widget	w[] = {
      { TRUE, 10,10,0,5, button_fn, (void *) &me_button[0],  Wf_DEFAULT, NULL },
      { TRUE, 12,10,0,5, button_fn, (void *) &me_button[1],  Wf_DEFAULT, NULL },
      { TRUE, 14,10,0,9, button_fn, (void *) &def_button[_BUTT_QUIT], Wf_DEFAULT, ACA_TD },
      W_NULL
      };
      SessW	s;
      char	dirname[BUFSIZ], *file = chN;
      static chtype	**scr_buff = (chtype **) NULL;

      setlocale(LC_MESSAGES, "");
   
      init_aca();
      examples_colors(); 
      init_keys((aca_INI *) NULL);
      aca_c(WHITE_BLUE);
      clean_box(0, LINES, 0, COLS);
      center_addnstr(5, COLS/2, "ACA SelectFile & FileViewer example\n{ QUIT: press button quit or key F10 }", 40);		
   
      init_sessw(&s, 0, FALSE, w, NULL, Sf_HAVENT_BGR);
   
      scr_buff = init_refresh_buffer();
      strcpy(dirname, "/");
   
      W_redraw_session(&s);
      do {
         if (run_act_widget(&s) & Wr_BUTTON_PRESS) {
            fill_refresh_buffer(scr_buff);
            if (s.actual == 0) 
               file = Dlg_SelectFile(dirname,	" Select file example ", chN);
            else if (s.actual == 1) 
               Dlg_FileViewer(file, " View file example ", chN, COLS-8);
            else {		
               if (Dlg_YesNo(" Example quit ", "Do you really want to quit ACA example ?", 50))
                  exit(RE_OK);					
            }
            print_refresh_buffer(scr_buff);			
         }
         W_key_to_widgets(&s);		
         W_default_go(&s);
         aca_c(WHITE_RED);
         clean_hline(16, 20, 50);		
         mvprintw(16, 10, " Your file: '%s' ", file);		
      } while((s.key = get_k()) != KEY_F(10));  
   
      exit(RE_OK);							
   }