
/* 
	--- ACA example ---
	
	Show:
		ACA Dialogs
 */

#include <aca/aca.h>
#include <aca/aca_widget.h>
#include <aca/aca_dlg.h>

#include <stdlib.h>

#include "examples_colors.h"
   
   void spec_resize(void *data)
   {
   	W_redraw_session((SessW *) data);
   }

   void bgr_examp(SessW *s)
   {
      clean_box(0, 0, LINES, COLS, WHITE_BLUE); 
      center_addnstr(2, COLS/2, "ACA dlg example\n{ QUIT: press button quit or key F10 }", 40);		
      mvaddstr(LINES-1, COLS-17,"(C) Zakkr - 1999");
   }

   int main() {
      char	dirbuff[BUFSIZ], selfile[BUFSIZ];
      Wbutton b[] = {
      	{ "[ |Y|esNo       ]", 0,0 },
	{ "[ |S|elect File ]", 0,0 },
      	{ "[ |V|iev File   ]", 0,0 },
      	{ "[ |W|arning     ]", 0,0 },
      	{ "[ |E|rror       ]", 0,0 },
      	{ "[ |L|ear keys   ]", 0,0 }
      };
      Widget	w[] = {
      	{ TRUE, 7, 9,0,0, button_fn, (void *) &b[0], Wf_DEFAULT, NULL },
      	{ TRUE, 9, 9,0,0, button_fn, (void *) &b[1], Wf_DEFAULT, NULL },
      	{ TRUE, 11,9,0,0, button_fn, (void *) &b[2], Wf_DEFAULT, NULL },
      	{ TRUE, 13,9,0,0, button_fn, (void *) &b[3], Wf_DEFAULT, NULL },
      	{ TRUE, 15,9,0,0, button_fn, (void *) &b[4], Wf_DEFAULT, NULL },
      	{ TRUE, 17,9,0,0, button_fn, (void *) &b[5], Wf_DEFAULT, NULL },
      	{ TRUE, 21,9,0,0, button_fn, (void *) &def_button[_BUTT_QUIT], Wf_DEFAULT, ACA_TD },			
      	W_NULL
      };
      SessW	s;
      
      /* INI */
      INI_Section	ini_sec[] = {
		TERMINAM_KEYS_SECTION,
		{ chN, FALSE, NULL }
      };
      aca_INI	INI = { "ini_test.ini", ini_sec };	

      setlocale(LC_MESSAGES, "");

      init_aca(TRUE);
      init_keys_ini(&ini_sec[0]);
      INI_load(&INI);
      init_keys(&INI);
      aca.extra_resize		= TRUE;
      aca.extra_resize_call_fn 	= spec_resize;
      aca.extra_resize_data	= (void *) &s;
      
      examples_colors(); 
      init_sessw(&s, 0, FALSE, w, bgr_examp, 0);
   
      strcpy(dirbuff, getenv("HOME"));
   
      W_redraw_session(&s);
      do {
         if (s.key == K_SCREEN_RESIZED) continue;
         if (run_act_widget(&s) & Wr_BUTTON_PRESS) {
            switch(s.actual) {
            case 0:
            	Dlg_YesNo(" ACA ", "Do you want sex  ?", 2*COLS/3);
            	break;
            case 1:
            	Dlg_SelectFile(dirbuff, " Select file ", chN, selfile);
            	break;
            case 2:
            	Dlg_FileViewer(selfile, " FileViewer ", "description text", COLS-6);
            	break;
            case 3:
            	Warning("This is WARNING text.");
            	break;
            case 4:
            	Error("This is ERROR text.");
            	break;
            case 5:
                Dlg_LearnKey (&INI);
                break; 		
            case 6:
            	/* write to ini file */
      		INI_save(&INI);
            	exit(RE_OK);							
            }
            W_redraw_session(&s); 
         }
         W_key_to_widgets(&s);		
         W_default_go(&s);
      } while((s.key = get_k()) != KEY_F(10));  
   
      /* write to ini file */
      INI_save(&INI);
              
      exit(RE_OK);							
   }