!!****h* BigDFT/lazy_24
!! NAME
!!   lazy_24
!!
!! FUNCTION
!!   Filters for interpolating scaling functions (order 30)
!!
!! SOURCE
!!
integer, parameter :: m=26
real(dp), dimension(-m:m) :: ch = (/ &
     0._dp, 0._dp, 0._dp, &
     -2.00495833269087598e-8_dp,0._dp,5.0505855142546352e-7_dp,0._dp,&
     -6.14044870417274069e-6_dp,0._dp,0.0000480399810385279125_dp,0._dp,&
     -0.000272226559218324837_dp,0._dp,0.00119360875964957813_dp,0._dp,&
     -0.00423188560239395883_dp,0._dp,0.0125613112325027032_dp,0._dp,&
     -0.032300514597864094_dp,0._dp,0.0753678673950162192_dp,0._dp,&
     -0.175858357255037845_dp,0._dp,0.623497812086043268_dp,1._dp,0.623497812086043268_dp,&
     0._dp,-0.175858357255037845_dp,0._dp,0.0753678673950162192_dp,0._dp,&
     -0.032300514597864094_dp,0._dp,0.0125613112325027032_dp,0._dp,&
     -0.00423188560239395883_dp,0._dp,0.00119360875964957813_dp,0._dp,&
     -0.000272226559218324837_dp,0._dp,0.0000480399810385279125_dp,0._dp,&
     -6.14044870417274069e-6_dp,0._dp,5.0505855142546352e-7_dp,0._dp,&
     -2.00495833269087598e-8_dp,&
     0._dp, 0._dp, 0._dp   /)
real(dp), dimension(-m:m) ::  cg,cht,cgt

!******** coefficients for wavelet transform *********************
do i=-m,m
   cht(i)=0._dp
   cg(i)=0._dp
   cgt(i)=0._dp
enddo

! the normalization is chosen such that a constant function remains the same constant 
! on each level of the transform

cht( 0)=1._dp

! g coefficients from h coefficients
do i=-m,m-1
   cg(i+1)=cht(-i)*(-1)**(i+1)
   cgt(i+1)=ch(-i)*(-1)**(i+1)
enddo
!!***

