# $Id: graphs.tcl,v 1.11 1998/10/18 20:26:15 cthulhu Exp $


proc createGraph {} {
    source "[xxl_library]/globalvars.tcl"

    if {$currentRange == ""} {
	HelpMessage "Can't create graph with only one cell selected!" 1 1
    } elseif {[lindex $currentRange 1]==[lindex $currentRange 3]} {
	HelpMessage "Graph creation needs more than one Y dimension" 1 1
    } else {
	
	foreach f {bar explodepie histogram line pie scatter stackedBar}  {
	    source "[xxl_home]/graphics/$f.tcl"  
	}
	
	toplevel .creategraph
	frame .creategraph.topf
	frame .creategraph.botf
	frame .creategraph.topf.lf
	frame .creategraph.topf.lf.f1 -relief ridge -borderw 2
	frame .creategraph.topf.lf.f2 -relief ridge -borderw 2
	frame .creategraph.topf.lf.f3 
	frame .creategraph.topf.lf.f4 
	frame .creategraph.topf.lf.f5 -relief ridge -borderw 2
	frame .creategraph.topf.rf  -relief ridge -borderw 2
	frame .creategraph.topf.rf.f1
	frame .creategraph.topf.rf.f2
	frame .creategraph.topf.rf.f3
	frame .creategraph.topf.rf.f4
	frame .creategraph.topf.rf.f5 
	frame .creategraph.topf.rf.f6 
	
	radiobutton .creategraph.topf.lf.f1.b1 -text "Pie" \
            -variable graphType -value 1
	radiobutton .creategraph.topf.lf.f1.b2 -text "Exploded Pie" \
            -variable graphType -value 2
	radiobutton .creategraph.topf.lf.f1.b3 -text "Line" \
            -variable graphType -value 3
	radiobutton .creategraph.topf.lf.f1.b4 -text "Bar" \
            -variable graphType -value 4
	radiobutton .creategraph.topf.lf.f1.b5 -text "Stacked Bar" \
            -variable graphType -value 5 
	radiobutton .creategraph.topf.lf.f1.b6 -text "XY" \
            -variable graphType -value 6 
	.creategraph.topf.lf.f1.b1 select
	
	pack .creategraph.topf.lf.f1.b1 .creategraph.topf.lf.f1.b2 \
	    .creategraph.topf.lf.f1.b3 .creategraph.topf.lf.f1.b4 \
	    .creategraph.topf.lf.f1.b5 .creategraph.topf.lf.f1.b6 \
	    -anchor w
	
	label .creategraph.topf.lf.f2.range -text "Graph range" 
	entry .creategraph.topf.lf.f2.entry -textvariable currentRangeName
	pack .creategraph.topf.lf.f2.range \
	    .creategraph.topf.lf.f2.entry -side left
	
	pack .creategraph.topf.lf.f1 .creategraph.topf.lf.f2 \
	    .creategraph.topf.rf.f3 .creategraph.topf.rf.f4 \
	    .creategraph.topf.rf.f5 .creategraph.topf.rf.f6 -fill both \
	    -expand yes
	pack .creategraph.topf.lf -side left -fill both \
	    -expand yes
	
	radiobutton .creategraph.topf.rf.f3.coords -text "At cell  " \
	    -variable graphPosition -value 1
	entry .creategraph.topf.rf.f3.entry -textvariable activeCellName
	radiobutton .creategraph.topf.rf.f4.new -text "New canvas" \
	    -variable graphPosition -value 2
	set graphPosition 2            
	
	pack .creategraph.topf.rf.f3.coords .creategraph.topf.rf.f3.entry \
	    -side left
	pack .creategraph.topf.rf.f4.new -anchor w
	
	entry .creategraph.topf.rf.f5.height -textvariable graphHeight
	label .creategraph.topf.rf.f5.ht -text "Graph height"
	entry .creategraph.topf.rf.f6.width -textvariable graphWidth
	label .creategraph.topf.rf.f6.wt -text "Graph width"
	
	pack .creategraph.topf.rf.f5.ht \
	    .creategraph.topf.rf.f5.height -side left
	pack .creategraph.topf.rf.f6.wt .creategraph.topf.rf.f6.width \
	    -side left
	
	button .creategraph.botf.ok -text Ok \
	    -command {destroy .creategraph ; \
			  HelpMessage "Press and hold right mouse button to define graph area" ; \
			  bind .$activeSheet.fr.midrow.canvas <Enter> \
			  { stateMachine %W focus ; \
				set helpMessage $canvasHelpMessage } ; \
			  bind .$activeSheet.fr.midrow.canvas <Leave> \
			  { set canvasHelpMessage $helpMessage } ; \
			  set canvasHelpMessage $helpMessage ; \
			  doCreateGraph }
	button .creategraph.botf.abort -text Abort \
	    -command {destroy .creategraph}
	pack .creategraph.botf.abort .creategraph.botf.ok \
	    -fill x -expand yes -side bottom 
	pack .creategraph.topf .creategraph.botf -fill both -expand yes
	grab .creategraph
    }
}

proc doCreateGraph {} {
    source "[xxl_library]/globalvars.tcl"
    
    getGraphCoordinates
    
    set graphCol [CellCol $activeSheet $graphX]
    set graphRow [CellRow $activeSheet $graphY]
    
    #guarda o valor do grafico na origem
    
    set graphX [expr $graphX-[ColOrigin $activeSheet $graphCol]]
    set graphY [expr $graphY-[RowOrigin $activeSheet $graphRow]]
    
    set graphRange $currentRange

    set graphRange [validSelection $graphRange]
    
    if { ([lindex $graphRange 2]!=-1)&&([lindex $graphRange 3]!=-1)} {
	if {[lindex $graphRange 1]==[lindex $graphRange 3]} {
	    HelpMessage \
		"Graph not drawn: creation needs more than one Y dimension" 1
	} else {
	    set cnt [SetGraphParams $activeSheet $graphType \
			 [lindex $graphRange 0] [lindex $graphRange 1] \
			 [lindex $graphRange 2] [lindex $graphRange 3] \
			 $graphWidth $graphHeight $graphX $graphY \
			 $graphCol $graphRow]
	    doDrawGraph $activeSheet $cnt
	    HelpMessage "Use menu option Graphics/Pick Graph to delete or edit graphics" -1 1 
	}
    } else {
	HelpMessage "Graph not drawn: creation needs data in the cells" 1
    }
    bind .$activeSheet.fr.midrow.canvas <Enter> { stateMachine %W focus }
    bind .$activeSheet.fr.midrow.canvas <Leave> {}


}

proc doDeleteGraph {cnt} {
    source "[xxl_library]/globalvars.tcl"

    set c [canvasFromSheet $activeSheet]
    
    $c delete graph_$cnt
    DeleteGraph $activeSheet $cnt    
}

proc doRedrawGraph {cnt} {
    source "[xxl_library]/globalvars.tcl"

    doDrawGraph $activeSheet $cnt
}

proc getGraphCoordinates {} {
    source "[xxl_library]/globalvars.tcl"
    
    
    set c [canvasFromSheet $activeSheet]


    set antesb1m [bind $c <B1-Motion>]
    set antesb1r [bind $c <ButtonRelease-1>]
    set antesb1  [bind $c <Button-1>]
    
    bind $c <B1-Motion> {}
    bind $c <ButtonRelease-1> {}
    bind $c <Button-1> {}

    $c config -cursor ul_angle
    
    bind $c <3> {
        %W config -cursor lr_angle
        set graphX [%W canvasx %x]
        set graphY  [%W canvasy %y]
    }
    bind $c <B3-Motion> {
        set x [%W canvasx %x]
        set y [%W canvasy %y]
	if {$x < $graphX && $y < $graphY} {%W config -cursor ul_angle} else {
	    if {$x < $graphX} {%W config -cursor ll_angle} else {
		if {$y < $graphY} {%W config -cursor ur_angle} else { 
		    %W config -cursor lr_angle }
	    } 
	} 
        catch {%W delete graphrect}
        %W create rect $graphX $graphY $x $y X 0 0 0 0 -tag graphrect
    }
    bind $c <B3-ButtonRelease> {
	
	if {$y < $graphY} {
	    set temp $y;
	    set y $graphY;
	    set graphY $temp
	}
	if {$x < $graphX} {
	    set temp $x;
	    set x $graphX;
	    set graphX $temp}
	
        set graphHeight [expr abs([expr $y-$graphY])]
        set graphWidth [expr abs([expr $x-$graphX])]
        %W config -cursor diamond_cross
        %W delete graphrect
    }
    
    tkwait variable graphHeight
    bind $c <3> {}
    bind $c <B3-Motion> {}
    bind $c <B3-ButtonRelease> {}

    bind $c <B1-Motion> $antesb1m 
    bind $c <ButtonRelease-1> $antesb1r
    bind $c <Button-1> $antesb1

    .$activeSheet.fr.menubar.menu.graphs.menu entryconfigure "Pick Graph" -state normal


}

proc doDrawGraph {sheet cnt} {
    
    source "[xxl_library]/globalvars.tcl"
    
    foreach f [glob [xxl_home]/graphics/*.tcl] {
	source "$f";  
    }
    
    set s [GetGraphParams $activeSheet $cnt]

    set graphType [lindex $s 0]
    set graphRange "[lindex $s 1] [lindex $s 2] [lindex $s 3] [lindex $s 4]"
    set graphWidth [lindex $s 5]
    set graphHeight [lindex $s 6]
    set graphX [lindex $s 7]
    set graphY [lindex $s 8]
    set graphCol [lindex $s 9]
    set graphRow [lindex $s 10]
    
    set graphRange [validSelection $graphRange]
    
    if { ([lindex $graphRange 2]!=-1)&&([lindex $graphRange 3]!=-1)} {
	if {[lindex $graphRange 1]==[lindex $graphRange 3]} {
	    HelpMessage "Graph not drawn: creation needs more than one Y dimension" 1
	} else {
	    switch $graphType {
		1 {createPieGraph $cnt}
		2 {createExplodedPieGraph $cnt}
		3 {createLineGraph $cnt}
		4 {createBarGraph $cnt}
		5 {createStackedbarGraph $cnt}
		6 {createScatterGraph $cnt}
	    }
	}
    } else {
	HelpMessage "Graph not drawn creation needs data in the cells" 1
    }
}

proc graphData {sheet cnt col row {number 0}} {
    global graphRange

    if {$number==0} {    
	set r [CellValue $sheet [expr [lindex $graphRange 0]+$col] \
		   [expr [lindex $graphRange 1]+$row]]
    } else {
	set r [CellGetNumber $sheet [expr [lindex $graphRange 0]+$col] \
		   [expr [lindex $graphRange 1]+$row]]
    }

    return $r
}

proc drawLine {canvas color x1 y1 x2 y2 gcnt} {
    global graphX graphY graphCol graphRow 
    global graphHeight graphWidth yScale xScale graphMargin
    
    $canvas create line \
	[expr $graphX+5*$graphMargin+$x1*$xScale] \
	[expr $graphY+$graphHeight-5*$graphMargin-$y1*$yScale] \
            [expr $graphX+5*$graphMargin+$x2*$xScale] \
	[expr $graphY+$graphHeight-5*$graphMargin-$y2*$yScale] \
	X \
	$graphCol $graphRow $graphCol $graphRow -fill $color \
	-tag graph_$gcnt
}

proc drawRectangle {canvas color x1 y1 x2 y2 gcnt {factor 1}} {
    global graphX graphY graphCol graphRow 
    global graphHeight graphWidth yScale xScale graphMargin
    
    $canvas create rect \
	[expr $graphX+5*$graphMargin+$x1*$xScale] \
	[expr $graphY+$graphHeight-$factor*$graphMargin-$y1*$yScale] \
	[expr $graphX+5*$graphMargin+$x2*$xScale] \
	[expr $graphY+$graphHeight-$factor*$graphMargin-$y2*$yScale] \
	X \
	$graphCol $graphRow $graphCol $graphRow -fill $color \
	-tag graph_$gcnt
}

set barColors(0) "blue"
set barColors(1) "green"
set barColors(2) "red"
set barColors(3) "yellow"
set barColors(4) "brown"
set barColors(5) "darkgreen"
set barColors(6) "gray40"
set barColors(7) "tomato"
set barColors(8) "blue3"

proc colorIndex {i} {
    global barColors
    return $barColors([expr $i % 9])
}

#
# Funcao auxiliar para eliminar colunas e linhas vazias inuteis da seleccao
#

proc validSelection { rg } {
    source "[xxl_library]/globalvars.tcl"

    if {[GetMaxColUsed $activeSheet] < [lindex $rg 2]} { 
	set minX [expr [GetMaxColUsed $activeSheet] +1] 
    } else {set minX [expr [lindex $rg 2]+1] }
    set maxX -1
    if {[GetMaxRowUsed $activeSheet] < [lindex $rg 3] } {
	set minY [expr [GetMaxRowUsed $activeSheet] +1 ]
    } else {set minY [expr [lindex $rg 3]+1]} 
    set maxY -1 
 
    if {[GetMinColUsed $activeSheet] > [lindex $rg 0]} { 
	set X [GetMinColUsed $activeSheet] 
    } else {set X [lindex $rg 0]}
    if {[GetMinRowUsed $activeSheet] > [lindex $rg 1] } {
	set Y [GetMinRowUsed $activeSheet]
    } else {set Y [lindex $rg 1]} 
    
    for { set i $Y } \
	{ $i <= [expr ([GetMaxRowUsed $activeSheet]<[lindex $rg 3]) ? \
		     [GetMaxRowUsed $activeSheet] : \
		     [lindex $rg 3]] } \
	{ set i [expr $i +1] } {
	for { set j $X } \
	    { $j <= [expr ([GetMaxColUsed $activeSheet]<[lindex $rg 2]) ? \
			 [GetMaxColUsed $activeSheet] : \
			 [lindex $rg 2]] } \
	    { set j [expr $j +1] } {
	    if { [CellGetNumber $activeSheet $j $i]!="" } {
		if { $minX > $j } {set minX $j}
		if { $maxX < $j } {set maxX $j}
		if { $minY > $i } {set minY $i}
		if { $maxY < $i } {set maxY $i}
	    }
	}
    }

    set rg [list [expr ($minX ==[lindex $rg 0])? $minX:[expr $minX-1]] \
		$minY $maxX $maxY]

    return $rg
}

proc InsideArea {posx posy x1 y1 x2 y2} {

    if {($posx<=$x2)&&($posx>=$x1)&&($posy<=$y2)&&($posy>=$y1)} {
	return 1
    }
    return 0
}

proc controlSquares {c x1 y1 x2 y2} {

    $c create rect [expr $x1] [expr $y1] [expr $x1+10] [expr $y1+10]\
	X 0 0 0 0 -fill red -tag graphrect 

    $c create rect [expr $x2-10] [expr $y2-10] [expr $x2] [expr $y2]\
	X 0 0 0 0 -fill red -tag graphrect 
}

proc identifySquare {posx posy x1 y1 x2 y2} {

    if {($posy <= [expr $y1 + 10]) && ($posy >= $y1)} {
	if { ($posx <= [expr $x1 +10])&&($posx >= $x1) } {return 1} 
	return 0
    }
 
    if {($posy <= $y2 )&&($posy >= [expr $y2 - 10])} {
	if { ($posx <= $x2 ) && ($posx >= [expr $x2 - 10]) } {return 2}
	return 0
    }
    return 0
}




#
# Apagar graficos
#

proc delGraph {} {
    source "[xxl_library]/globalvars.tcl"
    set c [canvasFromSheet $activeSheet]

    global graphstate

    if { $graphSelected != -1 } {
	$c delete graph_$graphSelected
	DeleteGraph $activeSheet $graphSelected undosave
	set graphSelected -1
	set graphstate 0
    }
    .$activeSheet.fr.menubar.menu.graphs.menu entryconfigure New -state normal
    .$activeSheet.fr.menubar.menu.graphs.menu entryconfigure "Pick Graph" -state normal
}
    

#
# Seleccionar,Mover,Redimensionar graficos
#

proc getGraph {} {

    source "[xxl_library]/globalvars.tcl"

    set graphSelected -1
    set c [canvasFromSheet $activeSheet]

    global graphstate
    set graphstate 1

    global moving
    set moving 0

    $c config -cursor hand1


    .$activeSheet.fr.menubar.menu.graphs.menu entryconfigure "Pick Graph" -state disabled
    .$activeSheet.fr.menubar.menu.graphs.menu entryconfigure New -state disabled

    set antesb1m [bind $c <B1-Motion>]
    set antesb1r [bind $c <ButtonRelease-1>]
    set antesb1  [bind $c <Button-1>]
    
    set beforeX 0
    set beforeY 0
    set deslx 0
    set desly 0

    bind $c <B1-Motion> {}
    bind $c <ButtonRelease-1> {}
    bind $c <Button-1> {}


    bind $c <1> {
	set posX [%W canvasx %x]
        set posY [%W canvasy %y]

	if {$graphSelected!=-1} {
	    %W delete graphrect
	}
	
	###	percorrer lista de graficos e identifica-los
	
	set graphSelected [FindGraph $activeSheet $posX $posY]
	
	if {$graphSelected!=-1} {
	    .$activeSheet.fr.menubar.menu.graphs.menu entryconfigure Delete -state normal

	    set s [GetGraphParams $activeSheet $graphSelected]
	    
	    set graphWidth [lindex $s 5]
	    set graphHeight [lindex $s 6]
	    set graphX [lindex $s 7]
	    set graphY [lindex $s 8]
	    set graphCol [lindex $s 9]
	    set graphRow [lindex $s 10]


	    doRedrawGraph $graphSelected
	    
	    ###     se estiver escolhido um desenha borda vermelha em volta
	    
	    %W create rect $graphX $graphY \
		[expr $graphX+$graphWidth] [expr $graphY+$graphHeight] X \
		$graphCol $graphRow $graphCol $graphRow -outline red -tag graphrect
	    
	    controlSquares %W  [expr [ColOrigin $activeSheet $graphCol]+$graphX] \
		[expr [RowOrigin $activeSheet $graphRow]+$graphY] \
		[expr [ColOrigin $activeSheet $graphCol]+$graphX+$graphWidth] \
		[expr [RowOrigin $activeSheet $graphRow]+$graphY+$graphHeight]

	    set deslx $posX
	    set desly $posY

	} 

	if {$graphSelected > -1} {
	    set s [GetGraphParams $activeSheet $graphSelected]
	    
	    set graphWidth [lindex $s 5]
	    set graphHeight [lindex $s 6]
	    set graphX [lindex $s 7]
	    set graphY [lindex $s 8]
	    set graphCol [lindex $s 9]
	    set graphRow [lindex $s 10]
	    
	    set moving [identifySquare $posX $posY \
			    [expr [ColOrigin $activeSheet $graphCol]+$graphX] \
			    [expr [RowOrigin $activeSheet $graphRow]+$graphY] \
			    [expr [ColOrigin $activeSheet $graphCol]+$graphX+$graphWidth] \
			    [expr [RowOrigin $activeSheet $graphRow]+$graphY+$graphHeight]]
	    if {$moving >0} {
		
		set moving [expr $moving+1]
		%W delete graph_$graphSelected
		
	    } elseif { [InsideArea $posX $posY \
			    [expr [ColOrigin $activeSheet $graphCol]+$graphX] \
			    [expr [RowOrigin $activeSheet $graphRow]+$graphY] \
			    [expr [ColOrigin $activeSheet $graphCol]+$graphX+$graphWidth] \
			    [expr [RowOrigin $activeSheet $graphRow]+$graphY+$graphHeight]] } {
		
		set moving 1
		set beforeX $posX
		set beforeY $posY
		set deslx $posX
		set desly $posY
		
	    } else { set moving 0}
	    
	} else {
	    
	    .$activeSheet.fr.menubar.menu.graphs.menu entryconfigure Delete -state disabled
	    .$activeSheet.fr.menubar.menu.graphs.menu entryconfigure New -state normal
	    .$activeSheet.fr.menubar.menu.graphs.menu entryconfigure "Pick Graph" -state normal
	    set graphstate 0
	} 
	
    }
    
    bind $c <B1-Motion> {
	global moving
	if {$graphSelected!=-1} {
	    set s [GetGraphParams $activeSheet $graphSelected]
	    
	    set graphWidth [lindex $s 5]
	    set graphHeight [lindex $s 6]
	    set graphX [lindex $s 7]
	    set graphY [lindex $s 8]
	    set graphCol [lindex $s 9]
	    set graphRow [lindex $s 10]
	     
	    if { $moving == 1 } { #caso seja mover figura
		set moving 1
		
		%W config -cursor hand1
		
		set posX [%W canvasx %x]
		set posY [%W canvasy %y]
		
		%W move graphrect [expr $posX-$deslx] [expr $posY-$desly]
		%W move graph_$graphSelected [expr $posX-$deslx] [expr $posY-$desly]
		
		set deslx $posX
		set desly $posY
		
	    } elseif { $moving == 2 } { #caso seja mover ponto de controlo esquerdo
		
		if { ([expr [ColOrigin $activeSheet $graphCol] \
			   +$graphX+$graphWidth-[%W canvasx %x]]>=50)} {
		    set posX [%W canvasx %x]
		}
		if { ([expr [RowOrigin $activeSheet $graphRow] \
			   +$graphY+$graphHeight-[%W canvasy %y]]>=50)} {
		    set posY [%W canvasy %y]
		}	
		
		%W delete graphrect
		
		%W create rect $posX $posY \
		    [expr $graphWidth+$graphX+[ColOrigin $activeSheet $graphCol]] \
		    [expr $graphHeight+$graphY+[RowOrigin $activeSheet $graphRow]] \
		    X 0 0 0 0 -fill white -outline red -tag graphrect 
	    } elseif { $moving == 3 } { #caso seja mover ponto de controlo direito
		
		if { ([expr [%W canvasx %x]-[ColOrigin $activeSheet $graphCol]-$graphX]>=50)} {
		    set posX [%W canvasx %x]
		}
		if {([expr [%W canvasy %y]-[RowOrigin $activeSheet $graphRow]-$graphY]>=50) } {
		    set posY [%W canvasy %y]
		}	
		%W delete graphrect
		
		%W create rect $graphX $graphY $posX $posY \
		    X $graphCol $graphRow 0 0  -fill white -outline red -tag graphrect 
	    }
	}
    }
    

    bind $c <ButtonRelease-1> {
	global moving
	if { $moving > 0 } {
	    
	    set s [GetGraphParams $activeSheet $graphSelected]
	    
	    set graphWidth [lindex $s 5]
	    set graphHeight [lindex $s 6]
	    set graphX [lindex $s 7]
	    set graphY [lindex $s 8]
	    set graphCol [lindex $s 9]
	    set graphRow [lindex $s 10]
	    
	    if { $moving == 1 } {
		set moving 0
		
		set dx [expr [%W canvasx %x]-$beforeX]
		set dy [expr [%W canvasy %y]-$beforeY]
		
		set x [expr [ColOrigin $activeSheet $graphCol]+$graphX+$dx]
		set y [expr [RowOrigin $activeSheet $graphRow]+$graphY+$dy]
		
		set s [lreplace $s 7 10 \
			   [expr $x-[ColOrigin $activeSheet [CellCol $activeSheet $x]]] \
			   [expr $y-[RowOrigin $activeSheet [CellRow $activeSheet $y]]] \
			   [CellCol $activeSheet $x] \
			   [CellRow $activeSheet $y]]
		
		ChangeGraphParams $activeSheet $graphSelected \
		    [lindex $s 5] [lindex $s 6] [lindex $s 7] \
		    [lindex $s 8] [lindex $s 9] [lindex $s 10]
		
	    } elseif { $moving == 2 } {
		set moving 0
		
		set tmpCol [CellCol $activeSheet $posX]
		set tmpRow [CellRow $activeSheet $posY]
		set tmpX   [expr $posX-[ColOrigin $activeSheet [CellCol $activeSheet $posX]]]
		set tmpY   [expr $posY-[RowOrigin $activeSheet [CellRow $activeSheet $posY]]]
		set tmpWidth [expr abs([expr $posX-[expr [ColOrigin $activeSheet $graphCol] \
							+$graphX+$graphWidth]])]
		set tmpHeight [expr abs([expr $posY-[expr [RowOrigin $activeSheet $graphRow] \
							 +$graphY+$graphHeight]])] 
		
		ChangeGraphParams $activeSheet $graphSelected \
		    $tmpWidth $tmpHeight $tmpX $tmpY $tmpCol $tmpRow 
		
		doDrawGraph $activeSheet $graphSelected
		
	    } elseif { $moving == 3 } {
		set moving 0
		
		set tmpWidth [expr abs([expr $posX-[expr [ColOrigin $activeSheet $graphCol]+ \
							$graphX]])]
		set tmpHeight [expr abs([expr $posY-[expr [RowOrigin $activeSheet $graphRow]+ \
							 $graphY]])] 
		
		ChangeGraphParams $activeSheet $graphSelected \
		    $tmpWidth $tmpHeight $graphX $graphY $graphCol $graphRow 
		
		doDrawGraph $activeSheet $graphSelected
		
	    }

	    set s [GetGraphParams $activeSheet $graphSelected]
	    
	    set graphWidth [lindex $s 5]
	    set graphHeight [lindex $s 6]
	    set graphX [lindex $s 7]
	    set graphY [lindex $s 8]
	    set graphCol [lindex $s 9]
	    set graphRow [lindex $s 10]
	    
	    %W create rect $graphX $graphY \
		[expr $graphX+$graphWidth] [expr $graphY+$graphHeight] X \
		$graphCol $graphRow $graphCol $graphRow -outline red -tag graphrect
	    
	    controlSquares %W  [expr [ColOrigin $activeSheet $graphCol]+$graphX] \
		[expr [RowOrigin $activeSheet $graphRow]+$graphY] \
		[expr [ColOrigin $activeSheet $graphCol]+$graphX+$graphWidth] \
		[expr [RowOrigin $activeSheet $graphRow]+$graphY+$graphHeight]
	}

    }

    bind $c <3> { set graphstate 0}
    
    HelpMessage "Use the left mouse button to select a Graphic,Move and Resize" -1 1 

    tkwait variable graphstate
    
    bind $c <1> {}
    bind $c <B1-Motion> $antesb1m 
    bind $c <ButtonRelease-1> $antesb1r
    bind $c <Button-1> $antesb1
    
    $c delete graphrect

    $c config -cursor diamond_cross
    .$activeSheet.fr.menubar.menu.graphs.menu entryconfigure New -state normal
    .$activeSheet.fr.menubar.menu.graphs.menu entryconfigure "Pick Graph" -state normal
    .$activeSheet.fr.menubar.menu.graphs.menu entryconfigure Delete -state disabled
    
}

# $Log: graphs.tcl,v $
# Revision 1.11  1998/10/18 20:26:15  cthulhu
# Instead of glob'ing whole graphs directory for graph scripts, loading is
# now done using a list.
#
# Revision 1.10  1998/10/01 20:57:25  cthulhu
# validSelection proc optimized - scans cells up until GetMaxColUsed or
# 	GetMaxRow used only instead of user selection that - if using
# 	col or row selects - could include entire sheet.
#
# Revision 1.9  1998/09/30 21:07:18  cthulhu
# Added some user help messages.
# Some code optimizations were performed.
#
# Revision 1.8  1998/09/30 00:38:56  cthulhu
# Switched name from Edit to Pick Graph to make edition more intuitive.
#
# Revision 1.7  1998/09/04 02:33:42  cthulhu
# Graph window now does a .grab so user is not allowed to do other stuff in the
# 	middle of graph creation
#
# Revision 1.6  1998/08/24 21:49:55  cthulhu
# Changed canvas bindings so that graph help message is remembered until user
# finished drawing up graph.
#
# Revision 1.5  1998/08/24 18:34:16  cthulhu
# Errors are reported using HelpMessage instead of warnUser
#
# Revision 1.4  1998/08/22 22:08:47  cthulhu
# Warnings are displayed using HelpMessage instead of WarnUser
#
# Revision 1.3  1998/08/06 21:08:32  aml
# Released alpha version of Abacus.
#
# Revision 1.2  1997/03/27 10:00:35  aml
# Started implementing graphs.
# Fixed bug in tkCanvasPs.c
# Created bindings for composite characters in Portuguese.
#
# Revision 1.1  1997/02/10  17:34:37  aml
# Initial revision
#
