/* ------------------------------------------------------------------------
 * $Id: ControllerImpl.cc,v 1.2 2001/08/22 12:23:20 elm Exp $
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2001-08-21 by Niklas Elmqvist.
 *
 * Copyright (c) 2001 Niklas Elmqvist <elm@3dwm.org>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

// -- 3Dwm Includes
#include "Nobel/Renderer.hh"
#include "Nobel/Transform.hh"
#include "Nobel/Volume.hh"
#include "Celsius/Mutex.hh"
#include "Celsius/Guard.hh"
#include "Polhem/ControllerImpl.hh"

using namespace Nobel;

// -- Code Segment

ControllerImpl::ControllerImpl()
{
    // empty
}

ControllerImpl::~ControllerImpl()
{
    // empty
}

void ControllerImpl::render(Renderer_ptr r)
{
    // empty
}

void ControllerImpl::pick(Nobel::Picker_ptr p)
{
    // empty
}

void ControllerImpl::traverse(Nobel::Visitor_ptr v)
{
    Guard<Mutex> guard(_mutex);
    
    // Delegate to child (if there is one)
    if (!CORBA::is_nil(_body))
	v->traverse(_body, _body->transformation());
}

Transform_ptr ControllerImpl::transformation()
{
    Guard<Mutex> guard(_mutex);
    
    // Delegate to child (if there is one)
    if (!CORBA::is_nil(_body))
	return _body->transformation();
    else
	return Nobel::Transform::_nil();
}

Volume_ptr ControllerImpl::getBoundingVolume()
{
    Guard<Mutex> guard(_mutex);
    
    // Delegate to child (if there is one)
    if (!CORBA::is_nil(_body))
	return _body->getBoundingVolume();
    else
	return Nobel::Volume::_nil();
}

void ControllerImpl::setBody(Node_ptr b)
{
    Guard<Mutex> guard(_mutex);

    // First, remove ourselves as a listener from the current body node
    if (!CORBA::is_nil(_body))
	_body->removeListener(_this());
    
    // Update reference and start listening to the new node
    _body = Nobel::Node::_duplicate(b);
    if (!CORBA::is_nil(_body))
	_body->addListener(_this());
}

Node_ptr ControllerImpl::getBody()
{
    Guard<Mutex> guard(_mutex);
    return Nobel::Node::_duplicate(_body);
}

/*
void ControllerImpl::receive(const Nobel::Event& e)
{
    // Try to handle the event internally
    if (handleNodeEvents(e) == false) {

	// Can't handle it, propagate the event upwards
	emit(e);
    }
}
*/

bool ControllerImpl::handleNodeEvents(const Nobel::Event &e)
{
    // If we return false, that means we can't handle the event. This
    // will propagate all events to our parents.
    return false;
}
