/* ------------------------------------------------------------------------
 * $Id: AppearanceImpl.hh,v 1.12 2001/08/28 13:18:50 elm Exp $
 *
 * This file is part of 3Dwm: The Three-Dimensional User Environment.
 *
 * 3Dwm: The Three-Dimensional User Environment:
 *	<http://www.3dwm.org>
 *
 * Chalmers Medialab
 * 	<http://www.medialab.chalmers.se>
 * 
 * ------------------------------------------------------------------------
 * File created 2000-08-07 by Niklas Elmqvist.
 *
 * Copyright (c) 2000, 2001 Niklas Elmqvist <elm@3dwm.org>.
 * Copyright (c) 2000 Steve Houston <shouston@programmer.net>.
 * ------------------------------------------------------------------------
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 * ------------------------------------------------------------------------
 */

#ifndef _AppearanceImpl_hh_
#define _AppearanceImpl_hh_

// -- 3Dwm Includes
#include "Nobel/CORBA.hh"
#include "Nobel/Appearance.hh"

// -- Forward Declarations
class Mutex;

// -- Class Declarations

/**
 * C++ implementation of the appearance interface.
 **/
class AppearanceImpl : public virtual POA_Nobel::Appearance,
		       public virtual PortableServer::RefCountServantBase {
public:
    
    /**
     * Constructor.
     **/
    AppearanceImpl(); 
        
    /**
     * Destructor.
     **/
    ~AppearanceImpl();
    
    // IDL functions
    virtual Nobel::Appearance::ShadingAttributes shading();
    virtual void shading(Nobel::Appearance::ShadingAttributes);
    virtual CORBA::Boolean lighting();
    virtual void lighting(CORBA::Boolean);
    virtual Nobel::MaterialAttributes material();
    virtual void material(const Nobel::MaterialAttributes&);
    virtual void setTexture(Nobel::Texture_ptr tex);
    virtual Nobel::Texture_ptr getTexture();
    virtual void apply(Nobel::Renderer_ptr r);
private:
    bool _use_lighting;
    Nobel::Appearance::ShadingAttributes _shading;
    Nobel::MaterialAttributes _material;
    Nobel::Texture_var _tex;
    Mutex _mutex;
}; 

#endif /* AppearanceImpl.hh */
