/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs.optional.ejb;

import java.io.File;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Java;
import org.apache.tools.ant.types.Path;

public class WLRun
extends Task {
    private static final String defaultPolicyFile = "weblogic.policy";
    private Path classpath;
    private Path weblogicClasspath;
    private String weblogicMainClass = "weblogic.Server";
    private String additionalArgs = "";
    private String securityPolicy;
    private File weblogicSystemHome;
    private String weblogicSystemName = "myserver";
    private String weblogicPropertiesFile = "weblogic.properties";
    private String additionalJvmArgs = "";

    public void execute() throws BuildException {
        if (this.weblogicSystemHome == null) {
            throw new BuildException("weblogic home must be set");
        }
        if (!this.weblogicSystemHome.isDirectory()) {
            throw new BuildException("weblogic home directory " + this.weblogicSystemHome.getPath() + " is not valid");
        }
        File propertiesFile = new File(this.weblogicSystemHome, this.weblogicPropertiesFile);
        if (!propertiesFile.exists()) {
            throw new BuildException("Properties file " + this.weblogicPropertiesFile + " not found in weblogic home " + this.weblogicSystemHome);
        }
        File securityPolicyFile = null;
        securityPolicyFile = this.securityPolicy == null ? new File(this.weblogicSystemHome, defaultPolicyFile) : new File(this.weblogicSystemHome, this.securityPolicy);
        if (!securityPolicyFile.exists()) {
            throw new BuildException("Security policy " + securityPolicyFile + " was not found.");
        }
        Java weblogicServer = (Java)this.project.createTask("java");
        weblogicServer.setTaskName(this.getTaskName());
        weblogicServer.setFork(true);
        weblogicServer.setClassname(this.weblogicMainClass);
        String jvmArgs = "";
        if (this.weblogicClasspath != null) {
            jvmArgs = String.valueOf(jvmArgs) + " -Dweblogic.class.path=" + this.weblogicClasspath;
        }
        jvmArgs = String.valueOf(jvmArgs) + " -Djava.security.manager -Djava.security.policy==" + securityPolicyFile;
        jvmArgs = String.valueOf(jvmArgs) + " -Dweblogic.system.home=" + this.weblogicSystemHome;
        jvmArgs = String.valueOf(jvmArgs) + " -Dweblogic.system.name=" + this.weblogicSystemName;
        jvmArgs = String.valueOf(jvmArgs) + " -Dweblogic.system.propertiesFile=" + this.weblogicPropertiesFile;
        jvmArgs = String.valueOf(jvmArgs) + " " + this.additionalJvmArgs;
        weblogicServer.createJvmarg().setLine(jvmArgs);
        weblogicServer.createArg().setLine(this.additionalArgs);
        weblogicServer.setClasspath(this.classpath);
        if (weblogicServer.executeJava() != 0) {
            throw new BuildException("Execution of weblogic server failed");
        }
    }

    public void setArgs(String args) {
        this.additionalArgs = args;
    }

    public void setClasspath(Path classpath) {
        this.classpath = classpath;
    }

    public void setHome(String weblogicHome) {
        this.weblogicSystemHome = new File(weblogicHome);
    }

    public void setJvmargs(String args) {
        this.additionalJvmArgs = args;
    }

    public void setName(String serverName) {
        this.weblogicSystemName = serverName;
    }

    public void setPolicy(String securityPolicy) {
        this.securityPolicy = securityPolicy;
    }

    public void setProperties(String propertiesFilename) {
        this.weblogicPropertiesFile = propertiesFilename;
    }

    public void setWeblogicMainClass(String c) {
        this.weblogicMainClass = c;
    }

    public void setWlclasspath(Path weblogicClasspath) {
        this.weblogicClasspath = weblogicClasspath;
    }
}

