-- `Topal': GPG/Pine integration
--
-- Copyright (C) 2001,2  Phillip J. Brooke
--
--     This program is free software; you can redistribute it and/or modify
--     it under the terms of the GNU General Public License as published by
--     the Free Software Foundation; either version 2 of the License, or
--     (at your option) any later version.
--
--     This program is distributed in the hope that it will be useful,
--     but WITHOUT ANY WARRANTY; without even the implied warranty of
--     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
--     GNU General Public License for more details.
--
--     You should have received a copy of the GNU General Public License
--     along with this program; if not, write to the Free Software
--     Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

with Globals; use Globals;

generic
   type Index is (<>);
package Char_Menus is

   Arrays_Not_Matched : exception;

   type MA is array (Index range <>) of UBS;

   -- Give a Menu_Array where each item contains the valid characters for
   -- that option.  The appropriate number will be returned.  Char_Words
   -- gives the word to display when that character is accepted.
   generic
      Accept_Chars   : MA;
      Char_Words     : MA;
      Default_Prompt : String := "";
   function Menu (Prompt : in String := Default_Prompt) return Index;

end Char_Menus;



