/*
 * ====================================================================
 *
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 1999 The Apache Software Foundation.  All rights 
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution, if
 *    any, must include the following acknowlegement:  
 *       "This product includes software developed by the 
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowlegement may appear in the software itself,
 *    if and wherever such third-party acknowlegements normally appear.
 *
 * 4. The names "The Jakarta Project", "Tomcat", and "Apache Software
 *    Foundation" must not be used to endorse or promote products derived
 *    from this software without prior written permission. For written 
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache"
 *    nor may "Apache" appear in their names without prior written
 *    permission of the Apache Group.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * [Additional notices, if required by prior licensing conditions]
 *
 */ 
package org.apache.tomcat.util.threads;

import org.apache.tomcat.util.*;

/**
 * The reaper is a background thread with which ticks every minute
 * and calls registered objects to allow reaping of old session
 * data.
 * 
 * @author James Duncan Davidson [duncan@eng.sun.com]
 * @author Costin Manolache
 */
public class Reaper extends Thread {

    public Reaper() {
	this.setDaemon(true);
	this.setName("TomcatReaper");
    }

    public Reaper(String name) {
	this.setDaemon(true);
	this.setName(name);
    }

    private long interval = 1000 * 60; //ms
    
    // XXX TODO Allow per/callback interval, find next, etc
    // Right now the "interval" is used for all callbacks
    // and it represent a sleep between runs.
    
    ThreadPoolRunnable cbacks[]=new ThreadPoolRunnable[30]; // XXX max
    Object tdata[][]=new Object[30][]; // XXX max
    int count=0;

    /** Adding and removing callbacks is synchronized
     */
    Object lock=new Object();
    static boolean running=true;

    public void setDefaultInterval( long t ) {
	interval=t;
    }
    
    public int addCallback( ThreadPoolRunnable c, int interval ) {
	synchronized( lock ) {
	    cbacks[count]=c;
	    count++;
	    return count-1;
	}
    }

    public void removeCallback( int idx ) {
	synchronized( lock ) {
	    count--;
	    cbacks[idx]=cbacks[count];
	    cbacks[count]=null;
	}
    }

    public void startReaper() {
	running=true;
	this.start();
    }

    public synchronized void stopReaper() {
	running=false;
	System.out.println("Stop reaper ");
	this.interrupt(); // notify() doesn't stop sleep
    }
    
    public void run() {
	while (running) {
	    if( !running) break;
	    try {
		this.sleep(interval);
	    } catch (InterruptedException ie) {
		// sometimes will happen
	    }

	    if( !running) break;
	    for( int i=0; i< count; i++ ) {
		ThreadPoolRunnable callB=cbacks[i];
		// it may be null if a callback is removed.
		//  I think the code is correct
		if( callB!= null ) {
		    callB.runIt( tdata[i] );
		}
		if( !running) break;
	    }
	}
    }
}
