#include <stdio.h>
#include <math.h>
#include <stdlib.h>
#include "../src/object.h"

#define PI 3.14159265358979

int main()
{
	FILE *in, *out;
	char line[1000];
	int n, magi, i;
	char psrname[11];
	double x, y, z;
	struct object obj;
	float lb;

        double ra, dec;

	in=fopen("../raw/ascat1.dat", "r");
	if(in == 0)
	{	
		printf("can't open ascat1.dat\n");
		return -1;
	}
	out=fopen("psr_catalog.cat", "w");
	for(n=0;;)
	{
		fgets(line, 999, in);
		if(feof(in)) break;
		if(line[0] <= ' ') continue;

		for(i = 0; i < 10; i++) psrname[i] = line[i];
		psrname[10] = 0;

		line[52] = 0;
		ra = -atof(line+37);
		fgets(line, 999, in);
		line[32] = 0;	
		dec = atof(line+17);

		x = cos(ra)*cos(dec);
		y = sin(ra)*cos(dec);
		z = sin(dec);

		magi = 0;

		obj.x = (long)(x*(double)(1<<30));
                obj.y = (long)(y*(double)(1<<30));
                obj.z = (long)(z*(double)(1<<30));
		obj.type=229;
                obj.icon = 0;
		obj.mag = 0;
		if(ra == 0.0 && dec == 0.0) obj.mask = 0x8F;
                else obj.mask = 0x0F;

		fwrite(&obj, 1, sizeof(obj), out);
		n++;
		fgets(line, 999, in);
		fgets(line, 999, in);
		fgets(line, 999, in);
		fgets(line, 999, in);
		fgets(line, 999, in);
		line[24] = 0;
		lb = atof(line+18);
		printf("%s %f\n", psrname, lb);
	}

	fclose(in);

	fclose(out);
	printf("%d pulsars loaded\n", n);

	return 0;
}
