#include "fft.h"
#include <math.h>

/************* BIT Reversion ***************/

unsigned reversi(unsigned d)
{
	int i,j;
	j=0;
	for (i=0;i<NBITS;i++){
		j<<=1;
		if (d&1) j|=1;
		d>>=1;
	}
	return j;
}

/********* fft **********/

void fft(complex *a)
{
	unsigned int i,l,m,n,lim1,lim2,lim3,rate;
	double cstep,sstep,a1,a2,b1,b2,c1,c2,cs,si,cs1,si1;
	complex auxi;
	const double cose[]={
		-1,
		6.12303e-17,
		0.707107,
		0.92388,
		0.980785,
		0.995185,
		0.998795,
		0.999699,
		0.999925,
		0.999981
	};
	const double sen[]={
		1.22461e-16,
		1,
		0.707107,
		0.382683,
		0.19509,
		0.0980171,
		0.0490677,
		0.0245412,
		0.0122715,
		0.00613588
	};

	/*=========== bit reversed swap ===========*/

	for (i=0;i<NSAMPLES;i++){
		l=reversi(i);
		if (l>i) {
			auxi=a[i];
			a[i]=a[l];
			a[l]=auxi;
		}
	}


	/*=========== decimation in time ===========*/

	for (i=0;i<NBITS;i++){
		lim1=1<<i;
		lim2=1<<(NBITS-i-1);
		cs=1.0;
		si=0.0;
		cstep=cose[i];
		sstep=sen[i];
		for(m=0;m<lim1;m++){
			for(l=0;l<lim2;l++){
				lim3=m+l*2*lim1;
				b1=a[lim3].re;
				b2=a[lim3].im;
				c1=a[lim3+lim1].re;
				c2=a[lim3+lim1].im;
				a1=c1*cs+c2*si;
				a2=-c1*si+c2*cs;
				a[lim3].re=b1+a1;
				a[lim3].im=b2+a2;
				a[lim3+lim1].re=b1-a1;
				a[lim3+lim1].im=b2-a2;
			}
			cs1=cs*cstep-si*sstep;
			si1=si*cstep+cs*sstep;
			cs=cs1;
			si=si1;
		}
	}
}

/*********** Power spectrum computation ************/
void db(complex *x)
{
	int i;
	double a;
	for (i=0;i<NSAMPLES/2;i++) {
		a=(x[i].re*x[i].re+x[i].im*x[i].im)/NSAMPLES;
		if (a) x[i].re=4.3429448*(log(a)-4.655);
		else x[i].re=-MINDB;
	}
}

/********* The Hanning (raised-cosine) window for input data ******/
void r_cosine(complex *x)
{
	static float w[NSAMPLES];
	static int first=1;
	int i;
	
	if (first) {
		first=0;
		for (i=0;i<NSAMPLES;i++) w[i]=(1-cos(i*2*M_PI/NSAMPLES))*0.5;
	}
	for (i=0;i<NSAMPLES;i++) {
		x[i].re*=w[i];
		x[i].im*=w[i];
	}
}
