/*
 * Copyright (c) 2002, 2003 Red Hat, Inc. All rights reserved.
 *
 * This software may be freely redistributed under the terms of the
 * GNU General Public License.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: Liam Stewart
 * Component of: Visual Explain GUI tool for PostgreSQL - Red Hat Edition
 */

package com.redhat.rhdb.vise;

import java.util.ResourceBundle;
import java.util.Enumeration;
import java.util.Locale;
import java.text.MessageFormat;

// resources are actually "hidden" in the resources sub-package. This
// class is merely a convenient wrapper class that defines the keys
// and allows all classes to access the same resources without having
// to instantiate a resource object.

/**
 * Resources used by classes in the com.redhat.rhdb.vise package.
 *
 * @author <a href="mailto:liams@redhat.com">Liam Stewart</a>
 * @version 0.0
 */
public abstract class ExplainResources {

	// program properties
	public static final String CONFIGURATION_DIR       = "program.directory.configuration";
	public static final String FILE_LOCK               = "program.file.lock";
	public static final String FILE_CONFIGURATION      = "program.file.configuration";
	public static final String DEFAULT_FILE            = "program.default.file";
	public static final String DOCS_PATH               = "path.docs";
	public static final String IMAGE_PATH              = "path.image";
	public static final String SPLASH_IMAGE            = "image.splash.name";
	public static final String ICON_IMAGE              = "image.icon.name";

	// message text and other localizable stuff
	public static final String PROGRAM_TITLE                    = "program.title";
	public static final String ABOUT_TITLE                      = "about.title";
	public static final String ABOUT_NOTES                      = "about.notes";
	public static final String ERROR_GENERAL_TITLE              = "error.general.title";
	public static final String ERROR_LOCK_EXISTS                = "error.lock.exists.message";
	public static final String ERROR_LOCK_EXISTS_TITLE          = "error.lock.exists.title";
	public static final String ERROR_CREATE_LOCK                = "error.lock.create.message";
	public static final String ERROR_CREATE_LOCK_TITLE          = "error.lock.create.title";
	public static final String ERROR_OPEN_FILE                  = "error.file.open.message";
	public static final String ERROR_OPEN_FILE_BADVERSION       = "error.file.open.badversion";
	public static final String ERROR_OPEN_FILE_CORRUPTED        = "error.file.open.corrupted";
	public static final String ERROR_OPEN_FILE_TITLE            = "error.file.open.title";
	public static final String ERROR_SAVE_FILE                  = "error.file.save.message";
	public static final String ERROR_SAVE_FILE_NOPLAN           = "error.file.save.noplan";
	public static final String ERROR_SAVE_FILE_NOMATCH          = "error.file.save.nomatch";
	public static final String ERROR_SAVE_FILE_TITLE            = "error.file.save.title";
	public static final String ERROR_BAD_VALUE                  = "error.bad.value.message";
	public static final String ERROR_BAD_VALUE_TITLE            = "error.bad.value.title";
	public static final String MANUAL_FILE_NOT_FOUND            = "manual.file.not.found.message";
	public static final String MANUAL_NOT_FOUND                 = "manual.not.found.message";
	public static final String MANUAL_NOT_FOUND_TITLE           = "manual.not.found.title";
	public static final String WARNING_UNSUPPORTED_OPTION       = "warning.unsuported.option.message";
	public static final String WARNING_UNSUPPORTED_OPTION_TITLE = "warning.unsuported.option.title";
	public static final String FILE_OVERWRITE                   = "file.overwrite";
	public static final String FILE_OVERWRITE_TITLE             = "file.overwrite.title";
	public static final String MODIFIED_FILE                    = "modified.file.message";
	public static final String MODIFIED_TEXT                    = "modified.text.message";
	public static final String MODIFIED_FILE_TITLE              = "modified.file.title";
	public static final String LABEL_SQL_ENTRY_AREA             = "label.sqlentryarea";
	public static final String LABEL_SQL_ENTRY_AREA_MOD         = "label.sqlentryareamod";
    	public static final String MENU_FILE                        = "menu.file";
	public static final String MENU_EDIT                        = "menu.edit";
	public static final String MENU_STATEMENT                   = "menu.statement";
	public static final String MENU_VIEW                        = "menu.view";
	public static final String MENU_HELP                        = "menu.help";
	public static final String MENU_WINDOW                      = "menu.window";
	public static final String MENU_FILE_MNEMONIC               = "menu.file.mnemonic";
	public static final String MENU_EDIT_MNEMONIC               = "menu.edit.mnemonic";
	public static final String MENU_STATEMENT_MNEMONIC          = "menu.statement.mnemonic";
	public static final String MENU_VIEW_MNEMONIC               = "menu.view.mnemonic";
	public static final String MENU_HELP_MNEMONIC               = "menu.help.mnemonic";
	public static final String MENU_WINDOW_MNEMONIC             = "menu.window.mnemonic";
	public static final String MENU_ITEM_SHOWOVERVIEW           = "menu.item.showoverview";
	public static final String MENU_ITEM_SHOWOVERVIEW_MNEMONIC  = "menu.item.showoverview.mnemonic";
	public static final String MENU_ITEM_SHOWOVERVIEW_ACCEL     = "menu.item.showoverview.accelerator";
	public static final String MENU_ITEM_SHOWOVERVIEW_TOOLTIP   = "menu.item.showoverview.tooltip";
	public static final String MENU_ITEM_SHOWOPTIONS            = "menu.item.showoptions";
	public static final String MENU_ITEM_SHOWOPTIONS_MNEMONIC   = "menu.item.showoptions.mnemonic";
	public static final String MENU_ITEM_SHOWOPTIONS_MNEMONIC_INDEX   = "menu.item.showoptions.mnemonic.index";
	public static final String MENU_ITEM_SHOWOPTIONS_ACCEL      = "menu.item.showoptions.accelerator";
	public static final String MENU_ITEM_SHOWOPTIONS_TOOLTIP    = "menu.item.showoptions.tooltip";
	public static final String MENU_ITEM_SHOWEXPLAIN            = "menu.item.showexplain";
	public static final String MENU_ITEM_SHOWEXPLAIN_MNEMONIC   = "menu.item.showexplain.mnemonic"; 
	public static final String MENU_ITEM_SHOWEXPLAIN_MNEMONIC_INDEX   = "menu.item.showexplain.mnemonic.index"; 
	public static final String MENU_ITEM_SHOWEXPLAIN_TOOLTIP    = "menu.item.showexplain.tooltip";
	public static final String MENU_ITEM_SHOWEXPLAIN_ACCEL      = "menu.item.showexplain.accelerator";
	public static final String MENU_ITEM_SHOWEXPLAINVB          = "menu.item.showexplainvb";
 	public static final String MENU_ITEM_SHOWEXPLAINVB_MNEMONIC = "menu.item.showexplainvb.mnemonic";
	public static final String MENU_ITEM_SHOWEXPLAINVB_ACCEL    = "menu.item.showexplainvb.accelerator";
	public static final String MENU_ITEM_SHOWEXPLAINVB_TOOLTIP  = "menu.item.showexplainvb.tooltip";
	public static final String MENU_ITEM_ACTUALSIZE             = "menu.item.actualsize";
	public static final String MENU_ITEM_ACTUALSIZE_MNEMONIC    = "menu.item.actualsize.mnemonic";
	public static final String MENU_ITEM_ACTUALSIZE_ACCEL       = "menu.item.actualsize.accelerator";
	public static final String MENU_ITEM_ACTUALSIZE_TOOLTIP     = "menu.item.actualsize.tooltip";
	public static final String MENU_ITEM_FITINWINDOW            = "menu.item.fitinwindow";
	public static final String MENU_ITEM_FITINWINDOW_MNEMONIC   = "menu.item.fitinwindow.mnemonic";
	public static final String MENU_ITEM_FITINWINDOW_MNEMONIC_INDEX   = "menu.item.fitinwindow.mnemonic.index";
	public static final String MENU_ITEM_FITINWINDOW_ACCEL      = "menu.item.fitinwindow.accelerator";
	public static final String MENU_ITEM_FITINWINDOW_TOOLTIP    = "menu.item.fitinwindow.tooltip";
	public static final String MENU_ITEM_FITWIDTH               = "menu.item.fitwidth";
	public static final String MENU_ITEM_FITWIDTH_MNEMONIC      = "menu.item.fitwidth.mnemonic";
	public static final String MENU_ITEM_FITWIDTH_ACCEL         = "menu.item.fitwidth.accelerator";
	public static final String MENU_ITEM_FITWIDTH_TOOLTIP       = "menu.item.fitwidth.tooltip";
	public static final String MENU_ITEM_ORIENTATION            = "menu.item.orientation";
	public static final String MENU_ITEM_ORIENTATION_MNEMONIC   = "menu.item.orientation.mnemonic";
	public static final String MENU_ITEM_ORIENTATION_TOP        = "menu.item.orientation.top";
	public static final String MENU_ITEM_ORIENTATION_TOP_MNEMONIC        = "menu.item.orientation.top.mnemonic";
	public static final String MENU_ITEM_ORIENTATION_TOP_TOOLTIP        = "menu.item.orientation.top.tooltip";
	public static final String MENU_ITEM_ORIENTATION_BOTTOM     = "menu.item.orientation.bottom";
	public static final String MENU_ITEM_ORIENTATION_BOTTOM_MNEMONIC     = "menu.item.orientation.bottom.mnemonic";
	public static final String MENU_ITEM_ORIENTATION_BOTTOM_TOOLTIP        = "menu.item.orientation.bottom.tooltip";
	public static final String MENU_ITEM_ORIENTATION_LEFT       = "menu.item.orientation.left";
	public static final String MENU_ITEM_ORIENTATION_LEFT_MNEMONIC       = "menu.item.orientation.left.mnemonic";
	public static final String MENU_ITEM_ORIENTATION_LEFT_TOOLTIP        = "menu.item.orientation.left.tooltip";
	public static final String MENU_ITEM_ORIENTATION_RIGHT      = "menu.item.orientation.right";
	public static final String MENU_ITEM_ORIENTATION_RIGHT_MNEMONIC      = "menu.item.orientation.right.mnemonic";
	public static final String MENU_ITEM_ORIENTATION_RIGHT_TOOLTIP        = "menu.item.orientation.right.tooltip";
	public static final String CONNECTION_OPENING               = "con.opening";
	public static final String CONNECTION_OPEN                  = "con.open";
	public static final String CONNECTION_CLOSED                = "con.closed";
	public static final String CONNECTION_ERROR                 = "con.error";
	public static final String CONNECTION_ERROR_TITLE           = "con.error.title";
	public static final String OVERVIEW_TITLE 		            = "overview.title";
	public static final String OPTIONS_TITLE 		            = "options.title";
	public static final String PLAN_TITLE 		        	    = "plan.title";
	public static final String DUMP_TITLE 						= "dump.title";
	public static final String SQL_FILTER                       = "filter.sql.text";
	public static final String SQL_EXTENSION                    = "filter.sql.extension";
	public static final String PLAN_FILTER                      = "filter.plan.text";
	public static final String PLAN_EXTENSION                   = "filter.plan.extension";
	public static final String MULTI_FILTER                     = "filter.multi.text";
	public static final String PREFERENCES_TITLE                = "preferences.title";
	public static final String DATABASES_TITLE                  = "databases.title";
	public static final String PLANNEROPTIONS_TITLE             = "planneroptions.title";
	public static final String PREFS_NEWDB_TITLE                = "prefs.adddb.title";
	public static final String PREFS_EDITDB_TITLE               = "prefs.editdb.title";
	public static final String PREFS_COPYDB_NAME                = "prefs.copydb.name";
	public static final String PREFS_TAB_GENERAL                = "prefs.tab.general";
	public static final String PREFS_TAB_GENERAL_TOOLTIP        = "prefs.tab.general.tooltip";
	public static final String PREFS_TAB_DISPLAY                = "prefs.tab.display";
	public static final String PREFS_TAB_DISPLAY_TOOLTIP        = "prefs.tab.display.tooltip";
	public static final String PREFS_LABEL_SAVEPASSWORDS        = "prefs.label.savepasswords";
	public static final String PREFS_LABEL_SAVEPASSWORDS_MNEMONIC = "prefs.label.savepasswords.mnemonic";
	public static final String PREFS_LABEL_SAVEPASSWORDS_TOOLTIP = "prefs.label.savepasswords.tooltip";
	public static final String PREFS_LABEL_TOOLBAR_BUTTON       = "prefs.label.toolbar.button";
	public static final String PREFS_LABEL_EXPLAIN              = "prefs.label.explain";
	public static final String PREFS_LABEL_EXPLAIN_MNEMONIC     = "prefs.label.explain.mnemonic";
	public static final String PREFS_LABEL_EXPLAIN_TOOLTIP      = "prefs.label.explain.tooltip";
	public static final String PREFS_LABEL_ANALYZE              = "prefs.label.analyze";
	public static final String PREFS_LABEL_ANALYZE_MNEMONIC     = "prefs.label.analyze.mnemonic";
	public static final String PREFS_LABEL_ANALYZE_TOOLTIP      = "prefs.label.analyze.tooltip";
	public static final String PREFS_LABEL_TOOLTIPS             = "prefs.label.tooltips";
	public static final String PREFS_LABEL_TOOLTIPS_MNEMONIC    = "prefs.label.tooltips.mnemonic";
	public static final String PREFS_LABEL_TOOLTIPS_TOOLTIP     = "prefs.label.tooltips.tooltip";
	public static final String PREFS_LABEL_RELOAD               = "prefs.label.reload";
	public static final String PREFS_LABEL_RELOAD_MNEMONIC      = "prefs.label.reload.mnemonic";
	public static final String PREFS_LABEL_RELOAD_TOOLTIP       = "prefs.label.reload.tooltip";
	public static final String PREFS_LABEL_ANTIALIAS            = "prefs.label.antialias";
	public static final String PREFS_LABEL_ANTIALIAS_MNEMONIC   = "prefs.label.antialias.mnemonic";
	public static final String PREFS_LABEL_ANTIALIAS_TOOLTIP    = "prefs.label.antialias.tooltip";
	public static final String PREFS_LABEL_LARGEICONS           = "prefs.label.largeicons";
	public static final String PREFS_LABEL_LARGEICONS_MNEMONIC  = "prefs.label.largeicons.mnemonic";
	public static final String PREFS_LABEL_LARGEICONS_TOOLTIP   = "prefs.label.largeicons.tooltip";
	public static final String DBEDIT_LABEL_NICKNAME            = "dbedit.label.nickname";
	public static final String DBEDIT_LABEL_NICKNAME_MNEMONIC   = "dbedit.label.nickname.mnemonic";
	public static final String DBEDIT_LABEL_DATABASE            = "dbedit.label.database";
	public static final String DBEDIT_LABEL_DATABASE_MNEMONIC   = "dbedit.label.database.mnemonic";
	public static final String DBEDIT_LABEL_HOST                = "dbedit.label.host";
	public static final String DBEDIT_LABEL_HOST_MNEMONIC       = "dbedit.label.host.mnemonic";
	public static final String DBEDIT_LABEL_PORT                = "dbedit.label.port";
	public static final String DBEDIT_LABEL_PORT_MNEMONIC       = "dbedit.label.port.mnemonic";
	public static final String DBEDIT_LABEL_USER                = "dbedit.label.user";
	public static final String DBEDIT_LABEL_USER_MNEMONIC       = "dbedit.label.user.mnemonic";
	public static final String DBEDIT_LABEL_PASSWORD            = "dbedit.label.password";
	public static final String DBEDIT_LABEL_PASSWORD_MNEMONIC   = "dbedit.label.password.mnemonic";
	public static final String DBEDIT_ERROR_NICK_MISSING        = "dbedit.error.nickname.missing";
	public static final String DBEDIT_ERROR_NICK_MISSING_TITLE  = "dbedit.error.nickname.missing.title";
	public static final String DBEDIT_ERROR_NICK_USED           = "dbedit.error.nickname.used";
	public static final String DBEDIT_ERROR_NICK_USED_TITLE     = "dbedit.error.nickname.used.title";
	public static final String DBEDIT_ERROR_DB_MISSING          = "dbedit.error.db.missing";
	public static final String DBEDIT_ERROR_DB_MISSING_TITLE    = "dbedit.error.db.missing.title";
	public static final String DBEDIT_ERROR_PORT_INT            = "dbedit.error.port.int";
	public static final String DBEDIT_ERROR_PORT_INT_TITLE      = "dbedit.error.port.title";
	public static final String DBEDIT_ERROR_USER_MISSING        = "dbedit.error.user.missing";
	public static final String DBEDIT_ERROR_USER_MISSING_TITLE  = "dbedit.error.user.missing.title";
	public static final String DBEDIT_ERROR_HOST_MISSING        = "dbedit.error.host.missing";
	public static final String DBEDIT_ERROR_HOST_MISSING_TITLE  = "dbedit.error.host.missing.title";
	public static final String DBEDIT_ERROR_PORT_MISSING        = "dbedit.error.port.missing";
	public static final String DBEDIT_ERROR_PORT_MISSING_TITLE  = "dbedit.error.port.missing.title";
	public static final String POPTS_LABEL_SEQSCAN				= "popts.label.seqscan";
	public static final String POPTS_LABEL_INDEXSCAN			= "popts.label.indexscan";
	public static final String POPTS_LABEL_TIDSCAN				= "popts.label.tidscan";
	public static final String POPTS_LABEL_SORT					= "popts.label.sort";
	public static final String POPTS_LABEL_HASHAGG				= "popts.label.hashagg";
	public static final String POPTS_LABEL_NESTLOOP				= "popts.label.nestloop";
	public static final String POPTS_LABEL_MERGEJOIN			= "popts.label.mergejoin";
	public static final String POPTS_LABEL_HASHJOIN				= "popts.label.hashjoin";
	public static final String POPTS_LABEL_RPC					= "popts.label.rpc";
	public static final String POPTS_LABEL_TC					= "popts.label.tc";
	public static final String POPTS_LABEL_ITC					= "popts.label.itc";
	public static final String POPTS_LABEL_OC					= "popts.label.oc";
	public static final String POPTS_LABEL_GEQO					= "popts.label.geqo";
	public static final String POPTS_LABEL_THRESHOLD			= "popts.label.threshold";
	public static final String POPTS_LABEL_POOLSIZE				= "popts.label.poolsize";
	public static final String POPTS_LABEL_EFFORT				= "popts.label.effort";
	public static final String POPTS_LABEL_GENERATIONS			= "popts.label.generations";
	public static final String POPTS_LABEL_SELBIAS				= "popts.label.selbias";
	public static final String POPTS_TITLE_OPERATIONS			= "popts.title.operations";
	public static final String POPTS_TITLE_ESTIMATES			= "popts.title.estimates";
	public static final String POPTS_TITLE_GEQO					= "popts.title.geqo";
	public static final String PASSWORD_NEEDED_MSG              = "password.needed";
	public static final String PASSWORD_NEEDED_TITLE            = "password.title";
	public static final String PASSWORD_NEEDED_LABEL            = "password.label";
	public static final String PASSWORD_NEEDED_MNEMONIC         = "password.mnemonic";
	public static final String TOOLBAR_OVERVIEW_ICON            = "toolbar.overview.icon";

	public static final String HELP_TITLE                       = "help.title";

	public static final String ORIENTATION_TOP_ICON             = "orientation.top.icon";
	public static final String ORIENTATION_BOTTOM_ICON          = "orientation.bottom.icon";
	public static final String ORIENTATION_LEFT_ICON            = "orientation.left.icon";
	public static final String ORIENTATION_RIGHT_ICON           = "orientation.right.icon";
	public static final String DETAIL_COLUMN_NAMES              = "detail.column.names";
	
	private static ResourceBundle resources;

	static
	{
		resources = ResourceBundle.getBundle("com.redhat.rhdb.vise.resources.Resources");
	}

	/**
	 * Get an Enumeration of all keys.
	 *
	 * @return an <code>Enumeration</code> value
	 */
	public static Enumeration getKeys()
	{
		return resources.getKeys();
	}

	/**
	 * Get the current Locale.
	 *
	 * @return a <code>Locale</code> value
	 */
	public static Locale getLocale()
	{
		return resources.getLocale();
	}

	/**
	 * Get the object that is associated with the given key.
	 *
	 * @param key a <code>String</code> value
	 * @return an <code>Object</code> value
	 */
	public static Object getObject(String key)
	{
		return resources.getObject(key);
	}

	/**
	 * If a resource is a String, it can be accessed without casting
	 * through this method.
	 *
	 * @param key a <code>String</code> value
	 * @return a <code>String</code> value
	 */
	public static String getString(String key)
	{
		return resources.getString(key);
	}

	/**
	 * If a resource is an array of Strings, this method can be easily
	 * used to access it.
	 *
	 * @param key a <code>String</code> value
	 * @return a <code>String[]</code> value
	 */
	public static String[] getStringArray(String key)
	{
		return resources.getStringArray(key);
	}

	/**
	 * Retrieve a String resource, but pass it through a formatter
	 * that does parameter substitution. The assumption with this
	 * method is that the String resource only has one parameter that
	 * needs substitution.
	 *
	 * @param key a <code>String</code> value
	 * @param arg1 an <code>Object</code> value
	 * @return a <code>String</code> value
	 */
	public static String getString(String key, Object arg1)
	{
		return format(getString(key), new Object[] { arg1 });
	}

	/**
	 * Retrieve a String resource, but pass it through a formatter
	 * that does parameter substitution. The assumption with this
	 * method is that the String resource only has two parameters that
	 * need substitution.
	 *
	 * @param key a <code>String</code> value
	 * @param arg1 an <code>Object</code> value
	 * @param arg2 an <code>Object</code> value
	 * @return a <code>String</code> value
	 */
	public static String getString(String key, Object arg1, Object arg2)
	{
		return format(getString(key), new Object[] { arg1, arg2 });
	}

	/**
	 * Retrieve a String resource, but pass it through a formatter
	 * that does parameter substitution. Parameters are stored in the
	 * <i>args</i> parameter.
	 *
	 * @param key a <code>String</code> value
	 * @param args an <code>Object[]</code> value
	 * @return a <code>String</code> value
	 */
	public static String getString(String key, Object[] args)
	{
		return format(getString(key), args);
	}

	//
	// private methods
	//

	private static String format(String pattern, Object[] args)
	{
		return MessageFormat.format(pattern, args);
	}

}// ExplainResources
