/*
 * Copyright (c) 2002, 2003 Red Hat, Inc. All rights reserved.
 *
 * This software may be freely redistributed under the terms of the
 * GNU General Public License.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * Author: Liam Stewart
 * Component of: Visual Explain GUI tool for PostgreSQL - Red Hat Edition
 */

package com.redhat.rhdb.treedisplay;

import java.util.ArrayList;
import java.util.Arrays;

/**
 * Partial implementation of the TreeLayoutNode interface. Provides
 * implementations for all methods except {@link #getBoundingWidth},
 * {@link #getBoundingHeight}, and {@link #contains}.
 *
 * @author <a href="mailto:liams@redhat.com">Liam Stewart</a>
 * @version 0.0
 */
public abstract class AbstractTreeLayoutNode implements TreeLayoutNode {
	private Object data;
	private TreeLayoutNode parent;
	private ArrayList children;
	private int width, height, x, y;
	private TreeLayoutModel tlm;

	/**
	 * Creates a new <code>AbstractTreeLayoutNode</code> instance.
	 */
	protected AbstractTreeLayoutNode()
	{
		width = height = x = y = -1;
		parent = null;
		data = null;
		children = new ArrayList(10);
	}
	
	//
	// abstract methods
	//
	
	// inherits doc comment
	public abstract int getBoundingWidth();

	// inherits doc comment
	public abstract int getBoundingHeight();

	// inherits doc comment
	public abstract boolean contains(int x, int y);

	//
	// implmented methods
	//

	public TreeLayoutModel getTreeLayoutModel()
	{
		return tlm;
	}

	public void setTreeLayoutModel(TreeLayoutModel m)
	{
		tlm = m;
	}

	// inherits doc comment
	public int getX()
	{
		return x;
	}

	// inherits doc comment
	public void setX(int v)
	{
		this.x = v;
	}

	// inherits doc comment
	public int getY()
	{
		return y;
	}

	// inherits doc comment
	public void setY(int v)
	{
		this.y = v;
	}

	// inherits doc comment
	public int getWidth()
	{
		return width;
	}

	// inherits doc comment
	public void setWidth(int v)
	{
		this.width = v;
	}

	// inherits doc comment
	public int getHeight()
	{
		return height;
	}

	// inherits doc comment
	public void setHeight(int v)
	{
		this.height = v;
	}

	// inherits doc comment
	public Object getData()
	{
		return data;
	}

	// inherits doc comment
	public void setData(Object v)
	{
		this.data = v;
	}

	// inherits doc comment
	public TreeLayoutNode[] getChildren()
	{
		return (TreeLayoutNode[]) children.toArray();
	}

	// inherits doc comment
	public void setChildren(TreeLayoutNode[] v)
	{
		this.children = new ArrayList(Arrays.asList(v));
	}

	// inherits doc comment
	public void addChild(TreeLayoutNode v)
	{
		if (this == v)
			throw new IllegalArgumentException("A node can't be a child of itself.");

		children.add(v);
	}

	// inherits doc comment
	public void removeChild(int n)
	{
		if (n >= 0 && n < children.size())
			children.remove(n);
	}

	// inherits doc comment
	public void removeChild(TreeLayoutNode child)
	{
		if (children.contains(child))
			children.remove(child);
	}

	// inherits doc comment
	public int getChildCount()
	{
		return children.size();
	}

	// inherits doc comment
	public TreeLayoutNode getChild(int n)
	{
		if (n >= 0 && n < children.size())
			return (TreeLayoutNode) children.get(n);

		return null;
	}

	// inherits doc comment
	public int getIndexOfChild(TreeLayoutNode child)
	{
		if (children.contains(child))
			return children.indexOf(child);

		return -1;
	}

	// inherits doc comment
	public TreeLayoutNode getParent()
	{
		return parent;
	}

	// inherits doc comment
	public void setParent(TreeLayoutNode n) throws IllegalArgumentException
	{
		if (this == n)
			throw new IllegalArgumentException("A node can't be the parent of itself");

		parent = n;
	}

}// AbstractTreeLayoutNode
