// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/include/Intp_Arena.h,v 1.1.1.1 2001/07/23 07:25:39 xli18 Exp $
//



#ifndef _INTP_ARENA_H_
#define _INTP_ARENA_H_

#ifdef __cplusplus
extern "C" {
#endif

typedef struct Intp_Arena {
	struct Intp_Arena	*next_arena;// next arena
	char			*next_byte;	// next byte available in arena
	char			*last_byte;	// end of arena	space
	char			bytes[1];	// start of arena space
} Intp_Arena;

static const int default_intp_arena_size = 1024;
//
// given an empty space of memory, make it into an arena of given size.
//
Intp_Arena	*init_intp_arena(void *space,Intp_Arena *next_arena,unsigned size);
//
// malloc (free) an arena from the global (thread-safe) heap
//
Intp_Arena	*alloc_intp_arena(Intp_Arena *next,unsigned size);
void	free_intp_arena(Intp_Arena *a);

#ifdef __cplusplus
}
#endif

#endif	// _INTP_ARENA_H_
