// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/gc/gc_plan.cpp,v 1.2 2001/08/02 01:24:54 Rlhudson Exp $
//
 
 
// For quick reference
// 0x01000   is       4,096 // This is the size of a block and of a card, doing it this way means we can
//                          // get by without having a first object in card table since the object
//                          // will always be at the start of the card.
// 0x200000  is   2,097,152
// 0x800000  is   8,388,608
// 0x4000000 is  67,108,864
// 0x5000000 is  83,886,080
// 0xF000000 is 251,658,240

#include "gc_for_orp.h"
#include "gc_plan.h"
#include <math.h>
#include "gc_globals.h"
int get_page_size ()
{
    SYSTEM_INFO sSysInfo;         // useful information about the system
    GetSystemInfo(&sSysInfo);     // populate the system information structure
//    printf ("This computer has a page size of %d.\n", sSysInfo.dwPageSize);
    return (int)sSysInfo.dwPageSize;
}

#ifdef GC_GEN_V3
void 
Gc_Plan::_set_defaults()
{
#ifdef POINTER64
    _initial_heap_size_bytes = 0x5000000;
#else
    // Set some defaults.
    // Initial Heap size set to 16MB.
    _initial_heap_size_bytes = 0x1000000;
#endif
    _final_heap_size_bytes = _initial_heap_size_bytes * 3;
    // Heap increment set to 2MB
	_heap_extension_increment_bytes = 0x200000; 



#ifdef GC_TRAIN_V5
    _car_size_car_blocks           = 128;
#else
    _car_size_car_blocks           = 2048;      // 4K blocks means 8M cars.
#endif

#ifdef GC_SAPPHIRE
    _car_size_car_blocks           = 2048;    // Nursery might be absorbed so they must hold lots of blocks.
#endif

    _card_size_bytes               = (1<<GC_CARD_SHIFT_COUNT);     // Careful this must match up with GC_CARD_SHIFT_COUNT;

	_los_block_size_bytes          = 0x200000; //  Now set to 4MB block size.
    _los_threshold_bytes           = 16000;   // USE GLOBAL INSTEAD
    _number_of_nurseries           = 0; 
    _number_of_large_nurseries     = 32; // 16 works for spec
    _number_of_steps     = 1;
    _minimum_number_of_trains = 2;   // Only two trains for GC_GEN_V3
    _number_of_large_object_stores = 2;

#ifdef OBJECT_SPLITTING
    _sub_block_size_bytes          = 16384 * 16;
    _large_nursery_size_sub_blocks = 1;
    _car_block_size_sub_blocks     = 1;    
#else
    _sub_block_size_bytes          = (1<<GC_CARD_SHIFT_COUNT);
    _large_nursery_size_sub_blocks = 64;   // 64 * 4096 16 * 16K = 8 * 32K = 262K
    _car_block_size_sub_blocks     = 256;  // 16;
    _nursery_size_sub_blocks       = 4;    // 4;
    _los_threshold_bytes           = _sub_block_size_bytes;
#if 1 // GC_BLOCK_IS_CARD
    _sub_block_size_bytes = get_page_size ();  // Think 4K on NT4 (and probable w2k)
	_large_nursery_size_sub_blocks = 32;   // 4*64 = 262K
    _car_block_size_sub_blocks     = 1;
    _nursery_size_sub_blocks       = 4;    // 4*4=16K;
    _card_size_bytes               = _sub_block_size_bytes;  
    _los_threshold_bytes           = _sub_block_size_bytes/2;   // USE GLOBAL INSTEAD
    _car_size_car_blocks           = 2048 * 128;                // This should be 1 gigabyte 2048*128*4096
#endif
#endif // OBJECT_SPLITTING

    _step_block_size_sub_blocks    = _large_nursery_size_sub_blocks;
}
#endif // GC_GEN_V3

#ifdef GC_COPY_V2 // Simple Copy collector.
void 
Gc_Plan::_set_defaults()
{

    // THIS IS TUNED FOR AN 80Mbyte heap size...
    //
    // Set some defaults.
    //
    // a block size of 16384 gives us 4096 blocks in 67108864 bytes 
    //      Aka (64Mbytes) of memory.
    // A copy collector needs as much area as it can get since it has
    //  both a 'to' and a 'from' space.
    // 1/8 for nurseries     8 Mbytes  500 blocks
    // 1/4 for LOS           16 Mbytes  1000 blocks,

    // 5/8 for copy space.  40 Mbytes 2500 blocks
    //                          which allows a worse case maximum 
    //                          of 20 Mbytes of required memory.
    // There is an extra 96 blocks, some of which is used internal information
    // such as the block table.

    // The SPEC_Java_v17 benchmarks seem to need at least 
    // 2000 blocks in the copy space, both to and from space. 
    // The highest requirement I saw was
    // 712 blocks in from space. (*2)
    // Compress seems to want more than 8 Mbytes in LOS but it runs with 8 Mbytes.
    // CST on the other hand breaks at 8Mbytes so I increased it to 16 Mbytes.
    // It looks like everyone wins with a quick promotion to MOS. 
    // CST breaks with los set to 500 so increase to 1000 
    // 
    // A program that requires 32 Mbytes will not run in this configuration.
    //

   	_initial_heap_size_bytes = 83886080;
	_final_heap_size_bytes = 0xF000000;

	_heap_extension_increment_bytes = 0x100000; 
	_sub_block_size_bytes          = 16384;
	_nursery_size_sub_blocks       = 1;
	_large_nursery_size_sub_blocks = 24;
	_step_block_size_sub_blocks    = _large_nursery_size_sub_blocks;
    _car_size_car_blocks           = 2048;      // Not used. 1MB with 16K block size.
    _card_size_bytes               = 256;       // Not used
	_los_block_size_bytes          = 16777216;  // linpack needs more than 8 MBytes;
    _los_threshold_bytes =  262100;   
    _number_of_nurseries = 1000; 
    _number_of_large_nurseries = 96; // 12;
    _number_of_steps     = 1;
	verbose_gc           = false;
    stats_gc             = false;
    _number_of_large_object_stores = 4;
    // There is no limit on the total used. LOS threshhold should be 1 block.
}
#endif  // GC_COPY_V2

#ifdef GC_NONE_V0
// GC_NONE_V0 ignores these numbers.
void 
Gc_Plan::_set_defaults()
{
    //
    // Set some defaults.
    //
	_initial_heap_size_bytes = 0;
	_final_heap_size_bytes = 0;
	_heap_extension_increment_bytes = 0;

    _sub_block_size_bytes      = 0;
	_car_block_size_sub_blocks = 0;
    _car_size_car_blocks       = 0;
    _card_size_bytes           = 0; 
	_los_block_size_bytes      = 0; 
    _number_of_nurseries = 0; 
	_number_of_large_nurseries = 0;
    _number_of_steps     = 0;
    _nursery_size_blocks = 0;   
    _number_of_large_object_stores = 0;
	verbose_gc           = false;
    stats_gc             = false;    
}
#endif // GC_NONE_V0
#ifdef GC_FIXED_V1
void 
Gc_Plan::_set_defaults()
{
    //
    // Set some defaults.
    //
	_initial_heap_size_bytes = 83886080 * 2;
	_final_heap_size_bytes = 0xF000000 * 2;

	_heap_extension_increment_bytes = 0x100000 * 8;

    _sub_block_size_bytes      = 16384 * 2;
	_car_block_size_sub_blocks = 1;
    _car_size_car_blocks       = 1;
    _card_size_bytes           = 256;    // not used. 1024;
	_los_block_size_bytes      = 0x0400000; 
    _number_of_nurseries = 0;  // 600;  // 128;
	_number_of_large_nurseries = 0;
    _number_of_steps     = 1;
    _nursery_size_blocks = 1;    // 4;
    _number_of_large_object_stores = _initial_heap_size_bytes / _los_block_size_bytes; // time _los_block_size_bytes is initial size.
	verbose_gc           = false;
    stats_gc             = false;
    
}
#endif  // GC_FIXED_V1

// end file gc\gc_plan.cpp
