// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/base/ini.cpp,v 1.1.1.1 2001/07/23 07:25:38 xli18 Exp $
//


#include "platform.h"
#include <iostream.h>
#include <stdio.h>
#include <assert.h>

#include "orp_types.h"
#include "Class.h"
#include "exceptions.h"
#include "root_set_enum.h"
#include "orp_threads.h"
#include "compile.h"
#include "orp_utils.h"

#include "ini.h"





//////////////////////////////////////////////////////////////////////
// begin support functions for GC-protecting arguments to Java methods

void
orp_pop_gc_frames1(Method *meth,
                   uint32 *args,
                   GC_Frame *gc_frames
                   )
{
    int arg_idx = 0;

    gc_frames--;

    if(!meth->is_static()) {
        orp_pop_gc_frame(gc_frames);
        gc_frames--;
        arg_idx++;
    }

    Arg_List_Iterator iter = meth->get_argument_list();
    Java_Type typ;
    while((typ = curr_arg(iter)) != JAVA_TYPE_END) {
        switch(typ) {
        case JAVA_TYPE_CLASS:
        case JAVA_TYPE_ARRAY:
            orp_pop_gc_frame(gc_frames);
            gc_frames--;
            break;
        default:
            break;
        }
        iter = advance_arg_iterator(iter);
        arg_idx++;
    }
} //orp_pop_gc_frames1



void
orp_push_gc_frames1(Method *meth,
                    unsigned num_arg_words,
                    uint32 *args,
                    GC_Frame *gc_frames
                    )
{
    int arg_idx = 0;

    uint32 ref_arg;

    if(!meth->is_static()) {
        ref_arg = *args;
#ifdef _DEBUG
        //VTable **p_vtable = (VTable **)ref_arg;
#endif
        orp_push_gc_frame(gc_frames, args, sizeof(uint32));
        *args = ref_arg;
        args--;
        gc_frames++;
        arg_idx++;
    }

    Arg_List_Iterator iter = meth->get_argument_list();
    Java_Type typ;
    while((typ = curr_arg(iter)) != JAVA_TYPE_END) {
        switch(typ) {
        case JAVA_TYPE_LONG:
        case JAVA_TYPE_DOUBLE:
            args -= 2;
            break;
        case JAVA_TYPE_CLASS:
        case JAVA_TYPE_ARRAY:
            //{
            ref_arg = *args;
#ifdef _DEBUG
            //VTable **p_vtable = (VTable **)ref_arg;
#endif
            orp_push_gc_frame(gc_frames, args, sizeof(uint32));
            *args = ref_arg;
            args--;
            gc_frames++;
            //}
            break;
        default:
            args--;
            break;
        }
        iter = advance_arg_iterator(iter);
        arg_idx++;
    }
} //orp_push_gc_frames1



// end support functions for GC-protecting arguments to Java methods
//////////////////////////////////////////////////////////////////////



//////////////////////////////////////////////////////////////////////
///////////// begin Invoking Java methods from native code




#define MAX_STATIC_ARG_NUMBER 10
void orp_execute_java_method(Method *meth, void *return_value, ...)
{
    unsigned num_args = meth->get_num_args();
    J_Value   args_array_static[MAX_STATIC_ARG_NUMBER];
    J_Value   *args_array;
    if(num_args > MAX_STATIC_ARG_NUMBER) {
        // In this case we should malloc and later free some memory.
        assert(0);
        args_array = 0;
    } else {
        args_array = args_array_static;
    }

    Arg_List_Iterator iter = meth->get_argument_list();

    va_list args;
    va_start(args, return_value);
    Java_Type typ;

    unsigned arg_number = 0;
    if(!meth->is_static()) {
        // this pointer
        args_array[arg_number++].r = va_arg(args, J_Reference);
    }

    while((typ = curr_arg(iter)) != JAVA_TYPE_END) {
        switch(typ) {
        case JAVA_TYPE_INT:
            args_array[arg_number++].i = va_arg(args, int);
            break;
        case JAVA_TYPE_BYTE:
            args_array[arg_number++].b = va_arg(args, int);
            break;
        case JAVA_TYPE_BOOLEAN:
            args_array[arg_number++].z = va_arg(args, int);
            break;
        case JAVA_TYPE_CHAR:
            args_array[arg_number++].c = va_arg(args, int);
            break;
        case JAVA_TYPE_CLASS:
        case JAVA_TYPE_ARRAY:
            args_array[arg_number++].r = va_arg(args, J_Reference);
            break;
#if 0
        case JAVA_TYPE_FLOAT:
            args_array[arg_number++].f = va_arg(args, J_Float);
            break;
#endif
        default:
            assert(0);
            break;
        }
        iter = advance_arg_iterator(iter);
    }
    va_end(args);

    orp_execute_java_method_array_rethrow(meth, return_value, args_array);
} //orp_execute_java_method




void
orp_execute_java_method_array_rethrow(Method   *meth,
                                      void     *return_value,
                                      J_Value   args[])
{
    orp_execute_java_method_array(meth, return_value, args);
    if(get_current_thread_exception()) {
        rethrow_current_thread_exception();
    }
} //orp_execute_java_method_array_rethrow



///////////// end Invoking Java methods from native code
//////////////////////////////////////////////////////////////////////



Method *object_lookup_method(void *obj,
                             const char *name,
                             const char *descr)
{
    VTable *vtable = *((VTable **)obj);
    assert(vtable);

    Method *meth = class_lookup_method_recursive(vtable->clss, name, descr);
    if (meth == 0) {
        orp_cout <<"ERROR---> are you trying to run gnu classpath?";
        orp_cout << " make sure -classpath is correct" << endl;
    }
    assert(meth);
    return meth;
} //object_lookup_method




