// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/common/base/C_Interface.cpp,v 1.17 2002/01/15 00:34:07 ssubram5 Exp $
//


#include "platform.h"
#include "Class.h"
#include "environment.h"
#include "compile.h"
#include "jit_intf.h"
#include "jit_intf_cpp.h"
#include "internal_jit_intf.h"
#include "orp_utils.h"
#include "method_lookup.h"

#ifndef OBJECT_LOCK_V2
#include "find_natives.h"
#else
#include "find_natives_olv2.h"
#endif

#ifdef CLI_TESTING
String *cli_class_get_const_string(Class_Handle cl, unsigned index);
#ifdef CLI_OCL
#include "..\include\cli_misc.h"
#endif
#endif

//::Moved from common/cli/cli_c_interface.cpp. 
int array_length_offset()
{
    JavaArrayOfInt a;
    return (int)(((uint64)&(a.length)) - (uint64)&a);
} //array_length_offset




Java_Type get_java_type(const char *descriptor) 
{
    return (Java_Type)(descriptor[0]); 
}



Boolean field_is_static(Field_Handle f)
{
    return ((Field *)f)->is_static();
}



Boolean field_is_final(Field_Handle f)
{
    return ((Field *)f)->is_final();
}



Boolean field_is_private(Field_Handle f)
{
    return ((Field *)f)->is_private();
}



unsigned field_get_offset(Field_Handle f)
{
    assert(!((Field *)f)->is_static());
    return ((Field *)f)->get_offset();
} //field_get_offset

#if 0

void *get_addr_of_read_counter(Field_Handle f) 
{
    Class *c = ((Field *)f)->get_class();
    unsigned int field_offset = ((Field *)f)->get_offset();

#ifdef OBJECT_SPLITTING
    
    extern signed int first_cold_offset; 
    assert(first_cold_offset != -1);

    if (field_offset >= (unsigned int) first_cold_offset)  {
        assert(c->cold_read_counts);
        return (void *)((POINTER_SIZE_INT)(c->cold_read_counts) + 
            ((field_offset - first_cold_offset) * sizeof(int)));
    }
    else  {
        assert(c->hot_read_counts);
        return (void *)((POINTER_SIZE_INT)(c->hot_read_counts) + 
            (field_offset * sizeof(int)));
    }

#else
    // When objects are not split
    assert(c->read_counts);
    return (void *)((POINTER_SIZE_INT)(c->read_counts) + 
            (field_offset * sizeof(int)));

#endif // OBJECT_SPLITTING
}

void *get_addr_of_write_counter(Field_Handle f) 
{
    Class *c = ((Field *)f)->get_class();
    unsigned int field_offset = ((Field *)f)->get_offset();

#ifdef OBJECT_SPLITTING
    
    extern signed int first_cold_offset; 
    assert(first_cold_offset != -1);

    if (field_offset >= (unsigned int) first_cold_offset) {
        assert(c->cold_write_counts);
        return (void *)((POINTER_SIZE_INT)(c->cold_write_counts) + 
            ((field_offset - first_cold_offset) * sizeof(int)));
    } else  {
        assert(c->hot_write_counts);
        return (void *)((POINTER_SIZE_INT)(c->hot_write_counts) + 
            (field_offset * sizeof(int)));
    }
#else
    // When objects are not split
    assert(c->write_counts);
    return (void *)((POINTER_SIZE_INT)(c->write_counts) + 
        (field_offset * sizeof(int)));

#endif // OBJECT_SPLITTING
}

#endif

void *field_get_addr(Field_Handle f)
{
    assert(((Field *)f)->is_static());
    return ((Field *)f)->get_address();
} //field_get_addr



const char* field_get_name(Field_Handle f)
{
    return ((Field *)f)->get_name()->bytes;
}



const char* field_get_descriptor(Field_Handle f)
{
    return ((Field *)f)->get_signature()->descriptor->bytes;
}



Java_Type   field_get_type(Field_Handle f)
{
    return ((Field *)f)->get_java_type();
} //field_get_type



unsigned field_get_flags(Field_Handle f)
{
    return ((Field *)f)->get_access_flags();
}



Class_Handle field_get_class(Field_Handle f)
{
    return ((Field *)f)->get_class();
} //field_get_class



Boolean method_is_static(Method_Handle m)
{
    return ((Method *)m)->is_static();
}



Boolean method_is_final(Method_Handle m)
{
    return ((Method *)m)->is_final();
}



Boolean method_is_synchronized(Method_Handle m)
{
    return ((Method *)m)->is_synchronized();
}



Boolean method_is_private(Method_Handle m)
{
    return ((Method *)m)->is_private();
} //method_is_private



Boolean method_is_native(Method_Handle m)
{
    Method *meth = (Method *)m;
    return use_native_implementation(meth) || meth->is_native();
} //method_is_native



Byte *method_allocate_info_block(Method_Handle m, JIT_Handle j, size_t size)
{
    return (Byte *)((Method *)m)->allocate_jit_info_block(size, (JIT *)j);
} //method_allocate_info_block



Byte *method_allocate_jit_data_block(Method_Handle m, JIT_Handle j, size_t size)
{
    return (Byte *)((Method *)m)->allocate_JIT_data_block(size, (JIT *)j);
} //method_allocate_jit_data_block



Byte *method_get_info_block(Method_Handle m)
{
    return (Byte *)((Method *)m)->get_jit_info_block();
} //method_get_info_block



Byte *method_get_info_block(Method_Handle m, JIT_Handle j)
{
    JIT_Specific_Info *jit_info =
        ((Method *)m)->get_JIT_specific_info_no_create((JIT *)j);
    if (jit_info == NULL) return NULL;
    return (Byte *)jit_info->_jit_info_block;
} //method_get_info_block



unsigned method_get_info_block_size(Method_Handle m)
{
    return ((Method *)m)->get_jit_info_block_size();
} //method_get_info_block_size



unsigned method_get_info_block_size(Method_Handle m, JIT_Handle j)
{
    JIT_Specific_Info *jit_info =
        ((Method *)m)->get_JIT_specific_info_no_create((JIT *)j);
    assert(jit_info);
    return jit_info->_jit_info_block_size;
} //method_get_info_block_size



Byte *method_allocate_data_block(Method_Handle m, JIT_Handle j, size_t size)
{
    return (Byte *)((Method *)m)->allocate_rw_data_block(size, (JIT *)j);
} //method_allocate_data_block



Byte *method_allocate_code_block(Method_Handle m, JIT_Handle j, size_t size)
{
    return (Byte *)((Method *)m)->allocate_code_block(size, (JIT *)j);
} //method_allocate_code_block



Byte *method_get_code_block_addr(Method_Handle m)
{
    return (Byte *)((Method *)m)->get_code_block_addr();
} //method_get_code_block_addr



Byte *method_get_code_block_addr(Method_Handle m, JIT_Handle j)
{
    JIT_Specific_Info *jit_info =
        ((Method *)m)->get_JIT_specific_info_no_create((JIT *)j);
    assert(jit_info);
    return (Byte *)jit_info->get_code_block_addr();
} //method_get_code_block_addr



unsigned method_get_code_block_size(Method_Handle m)
{
    return ((Method *)m)->get_code_block_size();
} //method_get_code_block_size



unsigned method_get_code_block_size(Method_Handle m, JIT_Handle j)
{
    JIT_Specific_Info *jit_info =
        ((Method *)m)->get_JIT_specific_info_no_create((JIT *)j);
    assert(jit_info);
    return jit_info->get_code_block_size();
} //method_get_code_block_size



const Byte *method_get_byte_code_addr(Method_Handle m)
{
	return ((Method *)m)->get_byte_code_addr();
}



size_t method_get_byte_code_size(Method_Handle m)
{
    return ((Method *)m)->get_byte_code_size();
}



unsigned method_get_max_locals(Method_Handle m)
{
    return ((Method *)m)->get_max_locals();
}



unsigned method_get_max_stack(Method_Handle m)
{
    return ((Method *)m)->get_max_stack();
}



unsigned    method_get_flags(Method_Handle m)
{
    return ((Method *)m)->get_access_flags();
}



unsigned    method_get_offset(Method_Handle m)
{
    return ((Method *)m)->get_offset();
}



void *method_get_indirect_address(Method_Handle m)
{
    return ((Method *)m)->get_indirect_address();
} //method_get_indirect_address



const char *
method_get_name(Method_Handle m)
{
    return ((Method *)m)->get_name()->bytes;
}



const char* method_get_descriptor(Method_Handle m)
{
    return ((Method *)m)->get_signature()->descriptor->bytes;
}



Class_Handle method_get_class(Method_Handle m)
{
    return ((Method *)m)->get_class();
}



Java_Type method_get_return_type(Method_Handle m)
{
    return ((Method *)m)->get_return_java_type();
}



Boolean method_is_overridden(Method_Handle m)
{
    return ((Method *)m)->is_overridden();
} //method_is_overridden



Boolean method_uses_fastcall(Method_Handle m)
{
    return FALSE;
} //method_uses_fastcall



JIT_Handle method_get_JIT_id(Compile_Handle h)
{
    JIT *jit = ((Compilation_Handle *)h)->jit;
    return jit;
} //method_get_JIT_id



ORPExport void method_set_inline_assumption(Compile_Handle h,
                                            Method_Handle caller,
                                            Method_Handle callee)
{
    Compilation_Handle *ch = (Compilation_Handle *)h;
    JIT *jit = ch->jit;
    Method *caller_method = (Method *)caller;
    Method *callee_method = (Method *)callee;
    callee_method->set_inline_assumption(jit, caller_method);
} //method_set_inline_assumption



Method_Iterator method_get_first_method_jit(JIT_Handle j)
{
    return methods.get_first_method_jit((JIT *)j);
} //method_get_first_method_jit



Method_Iterator method_get_next_method_jit(Method_Iterator i)
{
    return methods.get_next_method_jit((JIT_Specific_Info *)i);
} //method_get_next_method_jit



Method_Handle method_get_method_jit(Method_Iterator i)
{
    return ((JIT_Specific_Info *)i)->get_method();
} //method_get_method_jit



unsigned method_get_line_number_table_size(Method_Handle m)
{
    Method *method = (Method *)m;

#ifdef USE_IA64_JIT
    orp_cout << "source code line numbers don't work" << endl;
    return 0;
#endif // USE_IA64_JIT

    if(method->_line_number_table) {
        return method->_line_number_table->length;
    } else {
        return 0;
    }
} //method_get_line_number_table_size



void method_get_line_number(Method_Handle m,
                            unsigned index,
                            unsigned *start_pc,
                            unsigned *line_number)
{
    Method *method = (Method *)m;
    Line_Number_Table   *table = method->_line_number_table;
    if(table && table->length > index) {
        *start_pc    = table->table[index].start_pc;
        *line_number = table->table[index].line_number;
    }
} //method_get_line_number_table_size

#ifdef STACK_TRACE_ADDITIONAL_INFO

void method_set_nativecode_offset_for_line(Method_Handle m,
                                          unsigned index,
										  unsigned npc_offset)
{
	Method *method = (Method *)m;
    Line_Number_Table   *table = method->_line_number_table;
	if(table && table->length > index) {
		table->table[index].npc_offset = npc_offset;
	}
}

#endif

unsigned method_get_local_vars_table_size(Method_Handle m)
{
    Method *method = (Method *)m;
    if(method->_local_vars_table) {
        unsigned n_entry = 0;
        unsigned n_locals = method->get_max_locals();
        for (unsigned i = 0; i < n_locals; i++) {
            Local_Var_Entry *lve = method->_local_vars_table[i]; 
            for (;lve != NULL; lve = lve->next) 
                n_entry++;
        }
        assert(n_entry != 0);
        return n_entry;
    } else
        return 0;
} //method_get_local_vars_table_size



const char* class_get_name(Class_Handle cl)
{
    return ((Class *)cl)->name->bytes;
} //class_get_name



unsigned class_get_flags(Class_Handle cl)
{
    return ((Class *)cl)->access_flags;
} //class_get_flags



int class_get_super_offset()
{
    return sizeof(VTable *);
} //class_get_super_offset


//#ifdef FAST_INSTOF
int vtable_get_super_array_offset()
{
	VTable *vtable = 0;
    return ((Byte *)&vtable->superclasses) - (Byte *)vtable;
}//vtable_get_super_array_offset

int class_get_depth(Class_Handle cl)
{
    return ((Class *)cl)->depth;
} //class_get_depth
//#endif


Boolean class_is_initialized(Class_Handle cl)
{
    return ((Class *)cl)->state == ST_Initialized;
} //class_is_initialized



Boolean class_has_non_default_finalizer(Class_Handle cl)
{
    return ((Class *)cl)->has_finalizer == 1;
} //class_has_non_default_finalizer



Class_Handle class_get_super_class(Class_Handle cl)
{
    return (Class_Handle)((Class *)cl)->super_class;
} //class_get_super_class



Boolean class_is_instanceof(Class_Handle s, Class_Handle t)
{
    return orp_instanceof_class((Class *)s, (Class *)t);
} //class_get_super_class



Class_Handle class_get_array_element_class(Class_Handle cl)
{
    return (Class_Handle)((Class *)cl)->array_element_class;
} //class_get_array_element_class



#ifdef CLI_TESTING
#ifdef CLI_OCL

// Need a different set of array classes for OCL since 
// in Java, arrays derive from Java/lang/Object; whereas, in 
// ECMA CLI, they derive from the abstract System.Array which 
// in turn derives from System.Object

Class_Handle class_get_array_of_class(Class_Handle cl)
{
    Class *clss = (Class *)cl;
    assert(clss);
    Global_Env *env = ORP_Global_State::loader_env;
	extern Global_CLI_Env *global_cli_env;
	assert(global_cli_env);

	if (clss == global_cli_env->System_Char) { 
		return global_cli_env->ArrayOfChar_Class;
	} else 	if (clss == global_cli_env->System_Boolean) { 
		return global_cli_env->ArrayOfBoolean_Class;
	} else if (clss == global_cli_env->System_Byte) { 
		return global_cli_env->ArrayOfByte_Class;
	} else if (clss == global_cli_env->System_Int16) { 
		return global_cli_env->ArrayOfShort_Class;
	} else if (clss == global_cli_env->System_UInt16) { 
		return global_cli_env->ArrayOfUShort_Class;
	} else if (clss == global_cli_env->System_Int32) { 
		return global_cli_env->ArrayOfInt_Class;
	} else if (clss == global_cli_env->System_UInt32) { 
		return global_cli_env->ArrayOfUInt_Class;
	} else if (clss == global_cli_env->System_Int64) { 
		return global_cli_env->ArrayOfLong_Class;
	} else if (clss == global_cli_env->System_UInt64) { 
		return global_cli_env->ArrayOfULong_Class;
	} else 	if (clss == global_cli_env->System_Single) { 
		return global_cli_env->ArrayOfFloat_Class;
	} else 	if (clss == global_cli_env->System_Double) { 
		return global_cli_env->ArrayOfDouble_Class;
	} else if (clss == global_cli_env->System_IntPtr) { 
		return global_cli_env->ArrayOfIntPtr_Class;
	} else if (clss == global_cli_env->System_UIntPtr) { 
		return global_cli_env->ArrayOfUIntPtr_Class;
	} else { 
        const unsigned max_name_length = 1000;
        char array_name[max_name_length + 2];   // extra chars: '[' and '\0'
        assert(clss->name->len < max_name_length);
        const char *class_name = clss->name->bytes;
        if(class_name[0] == '[') {
            sprintf(array_name, "[%s", class_name);
        } else {
            sprintf(array_name, "[L%s;", class_name);
        }
        String *arr_str = env->string_pool.lookup(array_name);
        Loader_Exception exc;
        Class *arr_clss = class_load_verify_prepare(env, arr_str, &exc);
        assert(arr_clss);
        return arr_clss;
	}
	return (Class_Handle) 0;
} //class_get_array_of_class


#else

// (mjc 20010719) Not sure yet if want to provide this functionality.
Class_Handle class_get_array_of_class(Class_Handle cl)
{
    Class *clss = (Class *)cl;
    assert(clss);
    Global_Env *env = ORP_Global_State::loader_env;
    if(clss == env->Boolean_Class) {
        return env->ArrayOfBoolean_Class;
    } else if(clss == env->Char_Class) {
        return env->ArrayOfChar_Class;
    } else if(clss == env->Byte_Class) {
        return env->ArrayOfByte_Class;
    } else if(clss == env->UByte_Class) {
        return env->ArrayOfUByte_Class;
    } else if(clss == env->Short_Class) {
        return env->ArrayOfShort_Class;
    } else if(clss == env->UShort_Class) {
        return env->ArrayOfUShort_Class;
    } else if(clss == env->Int_Class) {
        return env->ArrayOfInt_Class;
    } else if(clss == env->UInt_Class) {
        return env->ArrayOfUInt_Class;
    } else if(clss == env->IntPtr_Class) {
        return env->ArrayOfIntPtr_Class;
    } else if(clss == env->UIntPtr_Class) {
        return env->ArrayOfUIntPtr_Class;
    } else if(clss == env->Long_Class) {
        return env->ArrayOfLong_Class;
    } else if(clss == env->ULong_Class) {
        return env->ArrayOfULong_Class;
    } else {
#if 0
        // (mjc 20011025) What is this for?  Is it used by ww?
        if( !strcmp(clss->name->bytes, "System/Byte") ) {
            return env->ArrayOfUByte_Class;
        } else if( !strcmp(clss->name->bytes, "System/Char") ) {
            return env->ArrayOfChar_Class;
        }
#endif
        const unsigned max_name_length = 1000;
        char array_name[max_name_length + 2];   // extra chars: '[' and '\0'
        assert(clss->name->len < max_name_length);

        const char *class_name = clss->name->bytes;
        if(class_name[0] == '[') {
            sprintf(array_name, "[%s", class_name);
        } else {
            sprintf(array_name, "[L%s;", class_name);
        }
        String *arr_str = env->string_pool.lookup(array_name);
        Loader_Exception exc;
        Class *arr_clss = class_load_verify_prepare(env, arr_str, &exc);
        assert(arr_clss);
        return arr_clss;
    }
} //class_get_array_of_class

#endif // CLI_OCL
#endif // CLI_TESTING


void *class_get_vtable(Class_Handle cl)
{
    return ((Class *)cl)->vtable;
} //class_get_vtable



const char *class_get_source_file_name(Class_Handle cl)
{
    if (cl == 0) return 0;
    if (  ((Class *)cl)->src_file_name == 0  ) 
        return 0;
    return ((Class *)cl)->src_file_name->bytes;
} //class_get_source_file_name



const char *class_get_const_string(Class_Handle cl, unsigned index)
{
    Class *clss = (Class *)cl;
    String *str = 0;
#ifdef CLI_TESTING
    if(clss->cli_type_def) {
        str = cli_class_get_const_string(cl, index);
    } else {
#endif
    assert(index < clss->cp_size);
    Const_Pool *cp = clss->const_pool;
    str = cp[index].string;
#ifdef CLI_TESTING
    }
#endif
    return str->bytes;
} //class_get_const_string



void *class_get_const_string_intern_addr(Class_Handle cl, unsigned index)
{
    Class *clss = (Class *)cl;
    String *str = 0;
#ifdef CLI_TESTING
    if(clss->cli_type_def) {
        str = cli_class_get_const_string(cl, index);
    } else {
#endif
    assert(index < clss->cp_size);
    Const_Pool *cp = clss->const_pool;
    str = cp[index].string;
#ifdef CLI_TESTING
    }
#endif
    assert(str);

    if(!str->intern) {
        // orp_instantiate_cp_string_resolved assumes that GC is disabled
        assert(!orp_is_gc_enabled(p_TLS_orpthread));

#ifdef CLI_TESTING
#ifdef CLI_OCL
		if(clss->cli_type_def) {
			// call explicit cli new string creation
			extern Java_java_lang_String *orp_instantiate_cp_cli_string_resolved(String *str);
			orp_instantiate_cp_cli_string_resolved(str);
			return &(str->intern);
		}
#endif
#endif
        // Discard the result.  We are only interested in the side-effect
        // of setting str->intern.
        orp_instantiate_cp_string_resolved(str);
    }

    return &(str->intern);
} //class_get_const_string_intern_addr



Java_Type class_get_const_type(Class_Handle cl, unsigned index)
{
    return class_get_cp_const_type((Class *)cl, index);
} //class_get_const_type



const void *class_get_const_addr(Class_Handle cl, unsigned index)
{
    return class_get_addr_of_constant((Class *)cl, index);
} //class_get_const_addr



Arg_List_Iterator method_get_argument_list(Method_Handle m)
{
    return (Arg_List_Iterator)((Method *)m)->get_argument_list();
}




#ifdef CLI_TESTING


Class_Handle orp_resolve_class_new_cli(Compile_Handle h,
                                       Class_Handle c,
                                       unsigned index,
                                       Loader_Exception *exc);


Class_Handle orp_resolve_class_cli(Compile_Handle h,
                                   Class_Handle c,
                                   unsigned index,
                                   Loader_Exception *exc);
#endif





Class_Handle 
orp_resolve_class(Compile_Handle h,
                  Class_Handle c,
                  unsigned index,
                  Loader_Exception *exc)
{
    Class *clss = (Class *)c;
    Class *cc;
#ifdef CLI_TESTING
    if(clss->cli_type_def) {
        cc = (Class *)orp_resolve_class_cli(h, c, index, exc);
    } else {
#endif
        cc = (Class *)resolve_class(h, c, index, exc);
#ifdef CLI_TESTING
    }
#endif
    return cc;
} //orp_resolve_class



Class_Handle 
orp_resolve_class_new(Compile_Handle h,
                      Class_Handle c,
                      unsigned index,
                      Loader_Exception *exc)
{
    Class *clss = (Class *)c;
    Class *cc;
#ifdef CLI_TESTING
    if(clss->cli_type_def) {
        cc = (Class *)orp_resolve_class_new_cli(h, c, index, exc);
    } else {
#endif
        cc = (Class *)resolve_class_new(h, c, index, exc);
#ifdef CLI_TESTING
    }
#endif
    return cc;
} //orp_resolve_class_new



Class_Handle resolve_class_from_constant_pool(Class_Handle c_handle, unsigned index)
{
    Class *cc = ((Class *)c_handle)->const_pool[index].clss;
    return ((Class *)c_handle)->const_pool[index].clss;
    //return class_resolve_class(c_handle, index);
}



Class_Loader_Handle
class_get_class_loader(Class_Handle c)
{
    return (Class_Loader_Handle)((Class *)c)->class_loader;
} //class_get_class_loader



Class_Handle
class_load_class_by_name(const char *name,
                         Class_Handle c,
                         Loader_Exception *exc)
{
    Global_Env *env = ORP_Global_State::loader_env;
    String *n = env->string_pool.lookup(name);
    Class *clss = load_class_by_loader(env, n, ((Class *)c)->class_loader, exc);
    return (Class_Handle)clss;
} //class_load_class_by_name



Class_Handle
class_load_class_by_name_using_system_class_loader(const char *name,
                                                   Loader_Exception *exc)
{
    Global_Env *env = ORP_Global_State::loader_env;
    String *n = env->string_pool.lookup(name);
    Class *clss = load_class_by_loader(env, n, 0, exc);
    return (Class_Handle)clss;
} //class_load_class_by_name_using_system_class_loader



Class_Handle
class_load_class_by_descriptor(const char *descr,
                               Class_Handle c,
                               Loader_Exception *exc)
{
    Global_Env *env = ORP_Global_State::loader_env;
    String *n;
    switch(descr[0]) {
    case '[':
        n = env->string_pool.lookup(descr);
        break;
    case 'L':
        {
            int len = strlen(descr);
            char *name = new char[len];
            memcpy(name, descr + 1, len - 2);
            name[len - 2] = 0;
            n = env->string_pool.lookup(name);
            delete []name;
        }
        break;
    default:
        n = 0;
    }
    assert(n);
    Class *clss = load_class_by_loader(env, n, ((Class *)c)->class_loader, exc);
    return (Class_Handle)clss;
} //class_load_class_by_descriptor



//
// The following do not cause constant pools to be resolve, if they are not
// resolved already
//
const char *const_pool_get_field_name(Class_Handle cl, unsigned index)
{
    Const_Pool *const_pool = ((Class *)cl)->const_pool;
    if (!cp_is_fieldref(const_pool,index)) {
        assert(0);
        return "???";
    }
    if (cp_is_resolved(const_pool,index)) {
        return const_pool[index].field->get_name()->bytes;
    } else {
        index = const_pool[index].cp_tag.name_and_type_index;
        if(cp_is_resolved(const_pool, index)) {
            return const_pool[index].signature->name->bytes;
        } else {
            index = const_pool[index].ni_di.name_index;
            return const_pool[index].string->bytes;
        }
    }
} //const_pool_get_field_name



const char *const_pool_get_field_class_name(Class_Handle cl, unsigned index)
{
    Const_Pool *const_pool = ((Class *)cl)->const_pool;
    if (!cp_is_fieldref(const_pool,index)) {
        assert(0);
        return "???";
    }
    if (cp_is_resolved(const_pool,index)) {
        return const_pool[index].field->get_class()->name->bytes;
    } else {
        index = const_pool[index].cp_tag.class_index;
        return const_pool_get_class_name(cl,index);
    }
} //const_pool_get_field_class_name



const char *const_pool_get_field_descriptor(Class_Handle cl, unsigned index)
{
    Const_Pool *const_pool = ((Class *)cl)->const_pool;
    if (!cp_is_fieldref(const_pool,index)) {
        assert(0);
        return "???";
    }
    if (cp_is_resolved(const_pool,index)) {
        return const_pool[index].field->get_signature()->descriptor->bytes;
    } else {
        index = const_pool[index].cp_tag.name_and_type_index;
        if(cp_is_resolved(const_pool, index)) {
            return const_pool[index].signature->descriptor->bytes;
        } else {
            index = const_pool[index].ni_di.descriptor_index;
            return const_pool[index].string->bytes;
        }
    }
} //const_pool_get_field_descriptor



const char *const_pool_get_method_name(Class_Handle cl, unsigned index)
{
    Const_Pool *const_pool = ((Class *)cl)->const_pool;
    if (!cp_is_methodref(const_pool,index)) {
        assert(0);
        return "???";
    }
    if (cp_is_resolved(const_pool,index)) {
        return const_pool[index].method->get_name()->bytes;
    } else {
        index = const_pool[index].cp_tag.name_and_type_index;
        if(cp_is_resolved(const_pool, index)) {
            return const_pool[index].signature->name->bytes;
        } else {
            index = const_pool[index].ni_di.name_index;
            return const_pool[index].string->bytes;
        }
    }
} //const_pool_get_method_name



const char *const_pool_get_method_class_name(Class_Handle cl, unsigned index)
{
    Const_Pool *const_pool = ((Class *)cl)->const_pool;
    if (!cp_is_methodref(const_pool,index)) {
        assert(0);
        return "???";
    }
    if (cp_is_resolved(const_pool,index)) {
        return const_pool[index].method->get_class()->name->bytes;
    } else {
        index = const_pool[index].cp_tag.class_index;
        return const_pool_get_class_name(cl,index);
    }
} //const_pool_get_method_class_name



const char *const_pool_get_interface_method_name(Class_Handle cl, unsigned index)
{
    Const_Pool *const_pool = ((Class *)cl)->const_pool;
    if (!cp_is_interfacemethodref(const_pool,index)) {
        assert(0);
        return "???";
    }
    if (cp_is_resolved(const_pool,index)) {
        return const_pool[index].method->get_name()->bytes;
    } else {
        index = const_pool[index].cp_tag.name_and_type_index;
        if(cp_is_resolved(const_pool, index)) {
            return const_pool[index].signature->name->bytes;
        } else {
            index = const_pool[index].ni_di.name_index;
            return const_pool[index].string->bytes;
        }
    }
} //const_pool_get_interface_method_name



const char *const_pool_get_interface_method_class_name(Class_Handle cl, unsigned index)
{
    Const_Pool *const_pool = ((Class *)cl)->const_pool;
    if (!cp_is_interfacemethodref(const_pool,index)) {
        assert(0);
        return "???";
    }
    if (cp_is_resolved(const_pool,index)) {
        return const_pool[index].method->get_class()->name->bytes;
    } else {
        index = const_pool[index].cp_tag.class_index;
        return const_pool_get_class_name(cl,index);
    }
} //const_pool_get_interface_method_class_name



const char *const_pool_get_method_descriptor(Class_Handle cl, unsigned index)
{
    Const_Pool *const_pool = ((Class *)cl)->const_pool;
    if (!cp_is_methodref(const_pool,index)) {
        assert(0);
        return "???";
    }
    if (cp_is_resolved(const_pool,index)) {
        return const_pool[index].method->get_signature()->descriptor->bytes;
    } else {
        index = const_pool[index].cp_tag.name_and_type_index;
        if(cp_is_resolved(const_pool, index)) {
            return const_pool[index].signature->descriptor->bytes;
        } else {
            index = const_pool[index].ni_di.descriptor_index;
            return const_pool[index].string->bytes;
        }
    }
} //const_pool_get_method_descriptor



const char *const_pool_get_interface_method_descriptor(Class_Handle cl, unsigned index)
{
    Const_Pool *const_pool = ((Class *)cl)->const_pool;
    if (!cp_is_interfacemethodref(const_pool,index)) {
        assert(0);
        return "???";
    }
    if (cp_is_resolved(const_pool,index)) {
        return const_pool[index].method->get_signature()->descriptor->bytes;
    } else {
        index = const_pool[index].cp_tag.name_and_type_index;
        if(cp_is_resolved(const_pool, index)) {
            return const_pool[index].signature->descriptor->bytes;
        } else {
            index = const_pool[index].ni_di.descriptor_index;
            return const_pool[index].string->bytes;
        }
    }
} //const_pool_get_interface_method_descriptor



const char *const_pool_get_class_name(Class_Handle cl, unsigned index)
{
    Const_Pool *const_pool = ((Class *)cl)->const_pool;
    if (!cp_is_class(const_pool,index)) {
        assert(0);
        return "???";
    }
    if (cp_is_resolved(const_pool,index)) {
        return const_pool[index].clss->name->bytes;
    } else {
        index = const_pool[index].name_index;
        return const_pool[index].string->bytes;
    }
} //const_pool_get_class_name



unsigned method_get_num_handlers(Method_Handle m)
{
    return ((Method *)m)->num_bc_exception_handlers();
} //method_get_num_handlers



void method_get_handler_info(Method_Handle m,
                                    unsigned handler_id,
                                    unsigned *begin_offset,
                                    unsigned *end_offset,
                                    unsigned *handler_offset,
                                    unsigned *handler_cpindex)
{
    Handler *h = ((Method *)m)->get_bc_exception_handler_info(handler_id);
    *begin_offset    = h->get_start_pc();
    *end_offset      = h->get_end_pc();
    *handler_offset  = h->get_handler_pc();
    *handler_cpindex = h->get_catch_type_index();
} //method_get_handler_info



void method_set_num_target_handlers(Method_Handle m,
                                    JIT_Handle j,
                                    unsigned num_handlers)
{
    ((Method *)m)->set_num_target_exception_handlers((JIT *)j, num_handlers);
} //method_set_num_target_handlers



void method_set_target_handler_info(Method_Handle m,
                                    JIT_Handle    j,
                                    unsigned      eh_number,
                                    void         *start_ip,
                                    void         *end_ip,
                                    void         *handler_ip,
                                    Class_Handle  catch_cl,
                                    bool          exc_obj_is_dead)
{
    ((Method *)m)->set_target_exception_handler_info((JIT *)j,
                                                     eh_number,
                                                     start_ip,
                                                     end_ip,
                                                     handler_ip,
                                                     (Class *)catch_cl,
                                                     exc_obj_is_dead);
} //method_set_target_handler_info



Method_Side_Effects method_get_side_effects(Method_Handle m)
{
    return ((Method *)m)->get_side_effects();
} //method_get_side_effects



void method_set_side_effects(Method_Handle m, Method_Side_Effects mse)
{
    ((Method *)m)->set_side_effects(mse);
} //method_set_side_effects



JIT_Result method_recompile(Method_Handle m, JIT_Handle j)
{
#if defined(USE_IA64_JIT)
    assert(0);
    return JIT_FAILURE;
#else
    return jit_recompile_method((Method *)m, (JIT *)j);
#endif
} //method_recompile



Method_Handle class_lookup_method_recursively(Class_Handle clss,
                                              const char *name,
                                              const char *descr)
{
    return (Method_Handle) class_lookup_method_recursive((Class *)clss, name, descr);
} //class_lookup_method_recursively



Compile_Handle jit_get_comp_handle(JIT_Handle j)
{
    return ((JIT *)j)->global_compile_handle;
} //jit_get_comp_handle



int object_get_vtable_offset()
{
    return 0;
} //object_get_vtable_offset



int vtable_get_class_offset()
{
    return 0;
} //vtable_get_class_offset

Method_Handle frame_get_method(Frame_Context *frame)
{
    JIT_Specific_Info *jsi = methods.find((void *)*frame->p_eip);
    return (jsi == NULL) ? NULL : jsi->get_method();
}



