// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/base_natives/gnu_classpath/java_io_FileDescriptor.cpp,v 1.4 2001/08/23 06:11:16 gwu2 Exp $
//


#include "platform.h"
#include <fstream.h>
#include <assert.h>
#include <fcntl.h>

#ifdef ORP_POSIX
#include <unistd.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>

#ifdef ORP_NT
#include <io.h>
#endif

#include "native_utils.h"
#include "jni_direct.h"
#include "jni_utils.h"


#include "object_layout.h"


#include "java_io_FileDescriptor.h"


/*
 * Class:     FileDescriptor
 * Method:    syncInternal
 * Signature: (I)V
 */
JNIEXPORT void JNICALL Java_java_io_FileDescriptor_syncInternal
  (JNIEnv *jenv, jobject jobj, jint fd)
{
// do nothing on purpose
#ifdef ORP_NT
    _commit(fd); 
#else
#ifdef ORP_POSIX
    fsync(fd);
#endif
#endif
}

/*
 * Class:     FileDescriptor
 * Method:    validInternal
 * Signature: (I)Z
 */
JNIEXPORT jboolean JNICALL Java_java_io_FileDescriptor_validInternal
  (JNIEnv *jenv, jobject jobj, jint file_d)
{
#ifdef ORP_NT
	struct _stat statbuf;
	return (_fstat(file_d, &statbuf) == 0);
#elif defined (ORP_POSIX)
    struct stat statbuf;
    return (fstat(file_d, &statbuf) == 0);
#endif
}
