// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/ia32_o3_jit/overridden.cpp,v 1.3 2002/01/08 07:17:54 xhshi Exp $
//


#include "defines.h"
#include <iostream.h>
#include "jit_intf.h"
#include "bitstream.h"
#include "gc_eh_support.h"
#include "ir.h"
#include "x86_emitter.h"
#include "code_emitter.h"
#include "overridden.h"

#ifdef PLDI_OVERRIDDEN
extern JIT_Handle O3_Jit_Handle;

Overridden_Rec *create_overridden_rec(Code_Patch     *code_patch,
                                      char           *code_buffer,
                                      Method_Handle  mh,
                                      Compile_Handle cmpl)
{
    //
    // count how many entries are needed
    //
    unsigned n_entry = 0;
    Code_Patch *p;
    for (p = (Code_Patch*)code_patch;p != NULL; p = (Code_Patch*)p->next())
        if (p->is_overridden_patch()) n_entry++;

    if (n_entry == 0) return NULL;
    //
    // allocate space
    //
    unsigned sz = sizeof(Overridden_Rec) + (n_entry-1)*sizeof(or_entry);
    Overridden_Rec *rec = (Overridden_Rec*)method_allocate_jit_data_block(mh,cmpl,sz);
    //
    // fill in information
    //
    rec->n_entry = n_entry;
    or_entry *ent = rec->entries;
    for (p = (Code_Patch*)code_patch;p != NULL; p = (Code_Patch*)p->next())
    {
        if (!p->is_overridden_patch()) 
            continue;
        Overridden_Patch *op = (Overridden_Patch*)p;
        assert(op->length < MAX_OVERRIDDEN_CODE_SIZE);
        //::Don't override , if the offset is larger than 255. For atomic violation.
        if (op->target->code_offset() - op->offset - 2 >= (1u<<7))
            continue ;

        ent->m_handle    = op->m_handle;
        ent->code_offset = op->offset;
        ent->code_length = op->length;
        unsigned i;
        for (i = 0; i < op->length; i++)
            ent->orig_code[i] = code_buffer[op->offset+i];
        for (i = op->length; i < MAX_OVERRIDDEN_CODE_SIZE; i++)
            ent->orig_code[i] = 0;
        ent++; // next entry
    }
    return rec;
}

void recover_overridden(Method_Handle caller,
                        Method_Handle callee) //method that is overridden
{
    //
    // get code block and method info
    //
    Byte *code = method_get_code_block_addr(caller, O3_Jit_Handle);
    Byte *mi   = method_get_info_block(caller,O3_Jit_Handle);
    assert(code != NULL && mi != NULL);
    //
    // retrieve overridden rec
    //
    BitStream bits(mi, *(unsigned *)mi);
    GC_Map::fixed_width_info fwi;
    init_prof_and_overridden(bits,fwi); // retrieve prof_rec from bitstream
    assert(fwi.overridden_rec != NULL);
    //
    // find the places that need correction
    //
    Overridden_Rec *rec = (Overridden_Rec*)fwi.overridden_rec;
    unsigned i;
    for (i = 0; i < rec->n_entry; i++)
    {
        if (rec->entries[i].m_handle != callee) 
            continue;
        or_entry *oe = &rec->entries[i];
        //
        // first step: make the inst spinning (branch to itself)
        // To avoid other threads may execute the inst while
        // the original code is being recovered.
        // Writing the inst must be atomic (locking).
        // jmp opcode 0xEB  (0XEBFE : jump to itself)
        //
        Byte *first_byte = code + oe->code_offset;
        __asm {
            mov eax, first_byte
            mov cx, 0xFEEB
            lock xchg word ptr [eax], cx
        }
        //
        // write original code back
        //
        int j;
        for (j = 2; j < oe->code_length; j++)
            code[oe->code_offset + j] = oe->orig_code[j];
        //
        // Last step: write the 2 chars atomically.
        //
        Byte *first_orig = (Byte *)oe->orig_code;
        __asm {
            mov eax, first_byte
            mov edx, first_orig
            mov cx, word ptr [edx]
            lock xchg word ptr [eax], cx
        }
    }
}
#endif
