// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/ia32_o3_jit/level_3_jit_intf.cpp,v 1.4 2002/01/11 15:51:06 weldon Exp $
//



#include "defines.h"
#include <stdio.h>
#include <iostream.h>
#include <fstream.h>
#include <assert.h>
#include <string.h>

#include "jit_intf.h"
#include "orp_types.h"
#include "code_gen.h"
#include "level_3_jit_intf.h"
#include "gc_eh_support.h"
#include "o3_profiling.h"
#include "overridden.h"
#include "pldi.h"

JIT_Handle O3_Jit_Handle;
bool O3_no_cp = false;
bool O3_cp_hash = true;
bool O3_statistics = false;
FILE* fp_O3_dumpjit_profile = NULL;
bool In_O3_statistics = false;
bool Inner_O3_statistics = false;
//ofstream g_cout("dump_jit_O3.txt") ;
bool O3_no_dumpjit = false;
bool O3_do_code_scheduling = true;
//bool O3_priority_regalloc = false;
bool O3_priority_regalloc = true;
bool O3_bc_opt = true;
bool O3_lazy_exc = true;
bool O3_peephole = true;
bool O3_fast_wb = false;
bool O3_unsafe_fcmp = false;
unsigned O3_num_fp_globals = 3;
extern const char *O3_envvar_COMP;

Level_3_JIT::Level_3_JIT()
{
    O3_Jit_Handle = this;
    init();
}

Level_3_JIT::~Level_3_JIT()
{
#ifdef STAT_INDIRECT_CALL
	extern void __stdcall
		orp_stat_indirect_call(unsigned caller_addr, unsigned callee_addr) ;
	orp_stat_indirect_call(0,0) ;
#endif
    print_o3_profiling_info(this);
    print_pldi_stats();
}

void Level_3_JIT::next_command_line_argument(const char *name, const char *arg)
{
    if(strcmp(name, "-jitO3"))
        return;

    char *method_str = "METHODS=";
    char *inline_str = "INLINE=";
    char *pass_arg_str = "PASSARGS=";
    char *dottab_str = "DOTFILES=";
    char *comp_str = "COMP=";
    char *fpglobal_str = "fpglobals=";

    if (strncmp(arg, method_str, strlen(method_str)) == 0)
        O3_envvar_METHODS = arg + strlen(method_str);
    else if (strncmp(arg, inline_str, strlen(inline_str)) == 0)
        O3_envvar_INLINE = arg + strlen(inline_str);
    else if (strncmp(arg, pass_arg_str, strlen(pass_arg_str)) == 0)
        O3_envvar_ARGS = arg + strlen(pass_arg_str);
    else if (strncmp(arg, dottab_str, strlen(dottab_str)) == 0)
        O3_envvar_DOTFILES = arg + strlen(dottab_str);
    else if (strncmp(arg, comp_str, strlen(comp_str)) == 0)
        O3_envvar_COMP = arg + strlen(comp_str);
    else if (strncmp(arg, fpglobal_str, strlen(fpglobal_str)) == 0)
        O3_num_fp_globals = atoi(arg + strlen(fpglobal_str));
    else if (strcmp(arg, "onefile") == 0)
        one_dot_file = true;
    else if (strcmp(arg, "bigdumpjit") == 0)
        extended_dumpjit = true;
    else if (strcmp(arg, "nocp") == 0)
        O3_no_cp = true;
    else if (strcmp(arg, "nosched") == 0)
        O3_do_code_scheduling = false;
    else if (strcmp(arg, "nocphash") == 0)
        O3_cp_hash = false;
    else if (strcmp(arg, "statistics") == 0){
        O3_statistics = true;
		Inner_O3_statistics = true;
    }else if (strcmp(arg, "nodumpjit") == 0)
        O3_no_dumpjit = true;
    else if (strcmp(arg, "nopriority") == 0)
        O3_priority_regalloc = false;
    else if (strcmp(arg, "bcopt") == 0)
        O3_bc_opt = false;
    else if (strcmp(arg, "lazyexc") == 0)
        O3_lazy_exc = false;
    else if (strcmp(arg, "nopeephole") == 0)
        O3_peephole = false;
#if 0
    else if (strcmp(arg, "fastwb") == 0)
        O3_fast_wb = true;
#endif
    else if (strcmp(arg, "unsafe_fcmp") == 0)
        O3_unsafe_fcmp = true;
} //Level_3_JIT::next_command_line_argument



JIT_Result 
Level_3_JIT::compile_method(Compile_Handle     compilation,          // in
                            Method_Handle      meth,                 // in
                            JIT_Flags          flags                 // in
                            )
{
    Class_Handle c      = method_get_class(meth);
    const Byte  *bc     = method_get_byte_code_addr(meth);
    size_t       size   = method_get_byte_code_size(meth);
    unsigned max_stack  = method_get_max_stack(meth);
    unsigned max_locals = method_get_max_locals(meth);


    JIT_Result res = O3_compile_method(compilation,
                                       c,
                                       meth,
                                       bc,
                                       size,
                                       max_locals,
                                       max_stack,
                                       method_uses_fastcall(meth),
                                       (flags.insert_write_barriers == TRUE));

    return res;
} //Level_3_JIT::compile_method



//
// For exception handling.
// 
// This function is supposed to restore callee-saved registers.
// It is not implemented now, because currently we use this code for
// exception handling only and O1 doesn't need callee-saved regs in
// exception handlers.
// The particular version of O1 we use doesn't do global register allocation,
// so restoring callee-saved regs is not needed for GC either.
//
void
Level_3_JIT::unwind_stack_frame(Method_Handle      meth,                  // in
                                Frame_Context     *context,     // in out
                                Boolean       is_first           // in
                                )
{
    GC_Map::unwind_stack_frame(meth, context, is_first);
} //Level_3_JIT::unwind_stack_frame



/////////// begin GC support ///////////////

//
// Call from the ORP into the JIT.
// The JIT:
// 1. Enumerates all references for the current stack.
//    The enumeration is precise, i.e., non-references are not
//    enumerated.
//    Enumeration can be done with either ORP::orp_enumerate_reference or
//    ORP::orp_enumerate_references.  The enum_handle argument
//    must be used in those callbacks.
// 2. Unwinds the stack and modifies the context in-place.
//
void 
Level_3_JIT::get_root_set_from_stack_frame(Method_Handle         meth,          // in
                                           GC_Enumeration_Handle enum_handle,   // in
                                           Frame_Context        *context,       // in out
                                           Boolean               is_first       // in
                                           )
{
    GC_Map::get_root_set_from_stack_frame(meth, enum_handle, context, is_first);
} //Level_3_JIT::get_root_set_from_stack_frame



Boolean Level_3_JIT::can_enumerate(Method_Handle method,
                                   uint32        eip
                                   )
{
    //cout << "Level_3_JIT::can_enumerate at 0x" << hex << eip << dec << endl;
    //return FALSE;
    //return TRUE;
    return GC_Map::can_enumerate(method, eip);
} //Level_3_JIT::can_enumerate



unsigned Level_3_JIT::num_breakpoints(Method_Handle method,
                                      uint32        eip
                                      )
{
    assert(0);
    return 0;
}

// The JIT needs to write the breakpoint addresses into bp[],
// and to make context->p_eip point to the return eip for the method.
void Level_3_JIT::get_breakpoints(Method_Handle method,      // in
                                  uint32        *bp,         // out
                                  Frame_Context *context     // in out
                                  )
{
    assert(0);
    GC_Map::unwind_stack_frame(method, context, TRUE);
}


Boolean Level_3_JIT::call_returns_a_reference(Method_Handle         method,              // in
                                              const Frame_Context  *context              // in
                                              )
{
    return GC_Map::call_returns_a_reference(method, context);
}


/////////// end GC support ///////////////


void
Level_3_JIT::fix_handler_context(Method_Handle      meth,              // in
                                 Frame_Context     *context,           // in out
                                 Boolean            is_first           // in
                                 )
{
    GC_Map::fix_handler_context(meth, context, is_first);
#if 0
    static unsigned count = 0;
    count ++;
    if (count % 100 == 0)
        orp_cout << "fix_handler_context count: " << count << endl;
#endif // 0
} //Level_3_JIT::fix_handler_context



void *
Level_3_JIT::get_address_of_this(Method_Handle      meth,              // in
                                 const Frame_Context     *context,           // in
                                 Boolean            is_first           // in
                                 )
{
    return (void *)GC_Map::get_address_of_this(meth, context, is_first);
} //Level_3_JIT::get_address_of_this

#ifdef PLDI_OVERRIDDEN
void
Level_3_JIT::method_was_overridden(Method_Handle caller,
                                   Method_Handle callee)
{
    recover_overridden(caller,callee);
}
#endif
