// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/ia32_o3_jit/dotfiles.cpp,v 1.2 2001/08/13 09:54:55 xhshi Exp $
//


//
// Dumps a method to a single file in the "dotfiles" directory
// relative to the current directory.  If the "dotfiles" directory
// doesn't exist or can't be written for some other reason, it dumps
// to cout instead.
//
// The file name is constructed as <class>.<method>(<signature>).dot
//
// Illegal filename characters in NT:  / \ : * ? " < > |
//
// All '/' characters are replaced with '.'
// <> is replaced with {}
// Other illegal characters are replaced with '_'

// To do: grab a lock when printing to cout.

#include "defines.h"

#if defined(PRINTABLE_O3) && defined(ORP_NT)

#include <sys/types.h>
#include <sys/stat.h>
#include <iostream.h>
#include <strstrea.h>
#include <fstream.h>
#include <stdio.h>
#include <string.h>
#include "Flow_Graph.h"
#include "dumpjit.h"
#include "dotfiles.h"

#define DOT_DIR "dotfiles"

void dump_dot_file(ostream &cout, Flow_Graph *fg, const char *suffix)
{
  char filename[MAX_FILENAME];
  struct _stat stat_buf;

  // Check whether "dotfiles" directory exists.
  if (_stat(DOT_DIR, &stat_buf) != 0 ||
      !(stat_buf.st_mode & _S_IFDIR))
    {
      dumpjit(cout, fg);
      return;
    }

  // Create a filename based on the class name, method name, and
  // signature.
  create_filename(fg, filename, suffix);

  // Try to open the file for output.
  ofstream fout(filename);
  if (!fout)
    {
      dumpjit(cout, fg);
      return;
    }

  dumpjit_dot(fout, fg);
  fout.close();
}

void create_filename(Flow_Graph *fg, char *filename, const char *suffix)
{
  int i, len;
  Method_Handle mh = fg->m_handle();
  Class_Handle c = fg->c_handle();

  sprintf(filename, DOT_DIR"\\%s.%s%s%s.dot", class_get_name(c), method_get_name(mh),
          method_get_descriptor(mh), suffix);
  len = strlen(filename);
  for (i=strlen(DOT_DIR)+1; i<len; i++)
    {
      switch (filename[i])
        {
        case '/':
          filename[i] = '.';
          break;
        case '<':
          filename[i] = '{';
          break;
        case '>':
          filename[i] = '}';
          break;
        case '\\':
        case ':':
        case '*':
        case '?':
        case '"':
        case '|':
          filename[i] = '_';
          break;
        default:
          break;
        }
    }
}

#endif // PRINTABLE_O3
