// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/ia32_o1_jit/cg_method_invocation.cpp,v 1.2 2001/08/13 09:59:51 xhshi Exp $
//


#include "defines.h"
#include "jit_intf.h"
#include "jit_runtime_support.h"
#include <iostream.h>
#include <stdarg.h>
#include "code_emitter.h"
#include "cg_prepass.h"
#include "operand.h"
#include "lazy_code_selector.h"
#include "register_manager.h"
#include "stack.h"
#include "cg_method_invocation.h"
#include "fp_compatibility.h"
#include "jit_common.h"

enum Method_Kind {virtual_method, static_method, special_method};

unsigned gen_push_args(Mem_Manager& mem_manager,
							  Code_Emitter& emitter,
							  Stack& stack,
							  Frame& frame,
							  Method_Handle handle,
							  Method_Kind kind,
							  Jit_Method_Info *method_info) {
	unsigned n_arg_words = n_words_of_method_arg_type(handle);
	if (kind != static_method) {
		//
		// virtual methods have an implicit this argument
		//
		n_arg_words++;
		//
		// implicit this argument (which is an object ref) is not in arg list given by VM (below)
		//
	}
	method_info->cs_info[method_info->cnt].num_out_args = n_arg_words;
	stack.call_home(n_arg_words);
	//
	// for invokevirtual, we need to use this pointer to access to its method table.  
	// reg_manager has a scratch reg, then we keep this pointer in the reg for later
	// the access to method table.
	//
	if (kind == virtual_method) {
		Operand *this_opnd = stack.nth(n_arg_words -1);
		if (!this_opnd->is_reg() && stack.reg_manager.has_available_reg()) {
			Reg_Operand *reg = stack.reg_manager.get_reg();
			this_opnd->emit_mov_to_reg(emitter,&reg->opnd);
			stack.replace_nth(n_arg_words - 1, reg);
		}
	}
	for (unsigned i = 0; i < n_arg_words; i++) {
		if (i != 0)	// don't need record for first push
			make_esp_record(emitter.get_offset(),i,method_info,mem_manager);
		stack.nth(n_arg_words - i - 1)->emit_push(emitter,i);

	//	??????	stack.fp_inc_cnt();
	}
	stack.reg_manager.reset_after_call();
	return n_arg_words;
}

void gen_get_method_return(Mem_Manager& mem_manager,
						   Code_Emitter& emitter,
						   Stack& stack,
						   Pre_Alloc_Operand_Pool& op_pool,
						   Frame& frame,
						   Java_Type type) {
	switch (type) {
  	case JAVA_TYPE_BYTE: // signed
	case JAVA_TYPE_CHAR: // character
	case JAVA_TYPE_INT: // integer
	case JAVA_TYPE_SHORT: // 16-bit signed short
	case JAVA_TYPE_BOOLEAN: // boolean
	case JAVA_TYPE_CLASS: // object
	case JAVA_TYPE_ARRAY: // array
		// 32-bit result in eax

		stack.push(stack.reg_manager.get_reg(eax_reg));
		break;
	case JAVA_TYPE_LONG: // long
		// 64-bit result in edx:eax pair

		stack.push64(stack.reg_manager.get_reg(eax_reg),
			       stack.reg_manager.get_reg(edx_reg));
		break;
	case JAVA_TYPE_FLOAT: // single FP
		// 32-bit result on FP stack
        if (stack.fp_strict_mode)
        {
  	        Stack_Operand *dst = op_pool.nth_stack(stack.depth());
    	    stack.push(dst);
	        emitter.emit_fst(dst->mem_opnd(),0,1);
        }
        else
        {
            stack.fp_inc_cnt();
            result_on_fp_stack(mem_manager, stack, false);
        }
	    break;
	case JAVA_TYPE_DOUBLE: // double FP
		// 64-bit result on FP stack
        if (stack.fp_strict_mode)
        {
	        Stack_Operand *dst_hi = op_pool.nth_stack(stack.depth());
	        Stack_Operand *dst = op_pool.nth_stack(stack.depth()+1);
	        stack.push64(dst,dst_hi);
	        emitter.emit_fst(dst->mem_opnd(),1,1);
        }
        else
        {
	        stack.fp_inc_cnt();
            result_on_fp_stack(mem_manager, stack, true);
        }
        break;
	case JAVA_TYPE_VOID: // void return
		break;
	default:
		assert(0);
		break;
	}
}

int gen_invokevirtual(Mem_Manager& mem_manager,
					  Code_Emitter& emitter,
					  Stack& stack,
					  Pre_Alloc_Operand_Pool& op_pool,
					  Frame& frame,
					  Class_Handle class_handle,
                      Compile_Handle comp_handle,
					  unsigned index,
                      Jit_Method_Info *method_info) {
    Loader_Exception lexc;
	Method_Handle handle = resolve_virtual_method(comp_handle,class_handle,index,&lexc);
    if (!handle)
        return 1;

    if (method_is_static(handle))
        return 1;

	//
	// push arguments onto stack
	//
	unsigned n_arg_words = gen_push_args(mem_manager,emitter,stack,
										 frame,handle,virtual_method,method_info);
	//
	// generate call to method
	//
	unsigned offset = method_get_offset(handle);
	//
	//	mov		eax,[esp+(n_args-1)<<2]
	//	mov		eax,[eax]
	//	call	[eax + offset]
	//
	make_esp_record(emitter.get_offset(),n_arg_words,method_info,mem_manager);
	Operand *this_opnd = stack.nth(n_arg_words-1);
	X86_Reg_No this_reg = eax_reg; 
	if (this_opnd->is_reg()) {
		this_reg = ((Reg_Operand*)this_opnd)->opnd.reg_no();
	} else {
		emitter.emit_mov(&eax_opnd,&M_Base_Opnd(esp_reg,(n_arg_words-1)<<2));
		make_esp_record(emitter.get_offset(),n_arg_words,method_info,mem_manager);
	}
	emitter.emit_mov(&eax_opnd,&M_Base_Opnd(this_reg,0));
	make_esp_record(emitter.get_offset(),n_arg_words,method_info,mem_manager);
    method_info->cs_info[method_info->cnt].precall_IP = (unsigned)emitter.get_offset();
    method_info->cs_info[method_info->cnt].returns_ref = 0;  // use m_handle instead
	emitter.emit_call(&M_Base_Opnd(eax_reg,offset));
    method_info->cs_info[method_info->cnt].outarg_bv = 0;
    method_info->cs_info[method_info->cnt].m_handle = handle;
	method_info->cs_info[method_info->cnt++].ret_IP = (unsigned)emitter.get_offset();
	//
	// after a call, we need to pop the arguments from the stack
	//
	stack.pop(n_arg_words);
	//
	// push result onto stack
	//
	gen_get_method_return(mem_manager,emitter,stack,op_pool,
						  frame,method_get_return_type(handle));
    return 0;
}
int gen_invokestatic(Mem_Manager& mem_manager,
					  Code_Emitter& emitter,
					  Stack& stack,
					  Pre_Alloc_Operand_Pool& op_pool,
					  Frame& frame,
					  Class_Handle class_handle,
                      Compile_Handle comp_handle,
					  unsigned index,
					  Jit_Method_Info *method_info) {
    Loader_Exception lexc;
	Method_Handle handle = resolve_static_method(comp_handle,class_handle,index,&lexc);
    if (!handle)
        return 1;

    if (!method_is_static(handle))
        return 1;
	//
	// push arguments onto stack
	//
	unsigned n_arg_words = gen_push_args(mem_manager,emitter,stack,
										 frame,handle,static_method,method_info);
	//
	// generate call to method
	//
	void *addr = method_get_indirect_address(handle);
    if (!addr)
        return 1;

	//
	// static methods are implemented with a level of indirection
	//
	make_esp_record(emitter.get_offset(),n_arg_words,method_info,mem_manager);
    method_info->cs_info[method_info->cnt].precall_IP = (unsigned)emitter.get_offset();
    method_info->cs_info[method_info->cnt].returns_ref = 0;  // use m_handle instead
	emitter.emit_call(&M_Opnd((unsigned)addr));
    method_info->cs_info[method_info->cnt].outarg_bv = 0;
    method_info->cs_info[method_info->cnt].m_handle = handle;
	method_info->cs_info[method_info->cnt++].ret_IP = (unsigned)emitter.get_offset();
	//
	// after a call, we need to pop the arguments from the stack
	//
	stack.pop(n_arg_words);
	//
	// push result onto stack
	//
	gen_get_method_return(mem_manager,emitter,stack,op_pool,
						  frame,method_get_return_type(handle));
    return 0;
}

int gen_invokespecial(Mem_Manager& mem_manager,
							  Code_Emitter& emitter,
							  Stack& stack,
							  Pre_Alloc_Operand_Pool& op_pool,
							  Frame& frame,
							  Class_Handle class_handle,
                      Compile_Handle comp_handle,
							  unsigned index,
							  Jit_Method_Info *method_info) {
    Loader_Exception lexc;
	Method_Handle handle = resolve_special_method(comp_handle,class_handle,index,&lexc);
    if (!handle)
        return 1;

	//
	// push arguments onto stack
	//
	unsigned n_arg_words = gen_push_args(mem_manager,emitter,stack,
										 frame,handle,special_method,method_info);
	//
	// generate call to method
	//
	void *addr = method_get_indirect_address(handle);
    if (!addr)
        return 1;

	//
	// static methods are implemented with a level of indirection
	//
	make_esp_record(emitter.get_offset(),n_arg_words,method_info,mem_manager);
    method_info->cs_info[method_info->cnt].precall_IP = (unsigned)emitter.get_offset();
    method_info->cs_info[method_info->cnt].returns_ref = 0;  // use m_handle instead
	emitter.emit_call(&M_Opnd((unsigned)addr));
    method_info->cs_info[method_info->cnt].outarg_bv = 0;
    method_info->cs_info[method_info->cnt].m_handle = handle;
	method_info->cs_info[method_info->cnt++].ret_IP = (unsigned)emitter.get_offset();
	//
	// after a call, we need to pop the arguments from the stack
	//
	stack.pop(n_arg_words);
	//
	// push result onto stack
	//
	gen_get_method_return(mem_manager,emitter,stack,op_pool,
						  frame,method_get_return_type(handle));
    return 0;
}

int gen_invokeinterface(Mem_Manager& mem_manager,
					     Code_Emitter& emitter,
					     Stack& stack,
					     Pre_Alloc_Operand_Pool& op_pool,
					     Frame& frame,
					     Class_Handle class_handle,
                      Compile_Handle comp_handle,
					     unsigned index,
                         Jit_Method_Info *method_info,
                         unsigned n_args,
						 Data_Emitter& data_emitter,
                         Code_Patch *& code_patch_list) {

	//
	// for now we simply home all arguments;
	// we'll get fancy later by homing all potentially aliased
	// non-arguments, and then homing potentially trapping
	// arguments
	//
	stack.home_all();
    Loader_Exception lexc;
	Method_Handle handle = resolve_interface_method(comp_handle,class_handle,index,&lexc);
    if (!handle)
        return 1;

	// +1 for implicit this argument
	unsigned n_arg_words = n_words_of_method_arg_type(handle) + 1;

	//
	// generate call to helper
	//
	unsigned offset = method_get_offset(handle);

    // XXX- why not reuse lexc and handle from above?
    Loader_Exception exc;
	Method_Handle mhandle = resolve_interface_method(comp_handle,class_handle,index,&exc);
    assert(mhandle);
    Class_Handle IID = method_get_class(mhandle);
    void *addr = orp_get_rt_support_addr(ORP_RT_GET_INTERFACE_VTABLE_VER0);
	//
    //  push    IID
    //  push    [esp+((n_args-1)<<2) + 12]   // +12 for 2 previous pushes  ?????
    //  call    ORP_RT_GET_INTERFACE_VTABLE_VER0
    //  call    [eax + offset]
	//
	emitter.emit_push(&Imm_Opnd((int)IID));
	make_esp_record(emitter.get_offset(),1,method_info,mem_manager);
	unsigned this_offset = (stack.size - stack.depth() + frame.n_callee + n_arg_words) << 2;
	emitter.emit_push(&M_Base_Opnd(esp_reg,this_offset));
	make_esp_record(emitter.get_offset(),2,method_info,mem_manager);
    unsigned patch_offset = emitter.get_offset()+1;
    method_info->cs_info[method_info->cnt].precall_IP = (unsigned)emitter.get_offset();
    method_info->cs_info[method_info->cnt].returns_ref = 0;
    emitter.emit_call((char*)addr);
	method_info->cs_info[method_info->cnt+1].ret_IP = (unsigned)emitter.get_offset();
    method_info->cs_info[method_info->cnt+1].num_out_args = 2;
    method_info->cs_info[method_info->cnt+1].outarg_bv = 0x2; // outarg 2 is a ref
    method_info->cs_info[method_info->cnt+1].m_handle = NULL;
	code_patch_list =
		new(mem_manager) Call_Patch(code_patch_list,patch_offset,(char*)addr);

	//
	// generate call to method
	//
	// for now we simply push the home locations onto the stack
	// we'll get fancy later by consider arguments that are in
	// registers, immediates, and so on.
	//
	unsigned displacement = (stack.size - stack.depth() + frame.n_callee + n_arg_words - 1) << 2;
	for (unsigned i = 1; i <= n_arg_words; i++) {
		// keep records for stack unwinding while pushing args
		emitter.emit_push(&M_Base_Opnd(esp_reg,displacement));
		make_esp_record(emitter.get_offset(),i,method_info,mem_manager);
	}
    method_info->cs_info[method_info->cnt].precall_IP = (unsigned)emitter.get_offset();
    method_info->cs_info[method_info->cnt].returns_ref = 0;  // use m_handle instead
	emitter.emit_call(&M_Base_Opnd(eax_reg,offset));
	method_info->cs_info[method_info->cnt].num_out_args = n_arg_words;
	method_info->cs_info[method_info->cnt].ret_IP = (unsigned)emitter.get_offset();
    method_info->cs_info[method_info->cnt].outarg_bv = 0;
    method_info->cs_info[method_info->cnt].m_handle = handle;
	method_info->cnt += 2;	// for both call sites
	//
	// after a call, we need to pop the arguments from the stack
	//
	stack.pop(n_arg_words);
	//
	// push result onto stack
	//
	gen_get_method_return(mem_manager,emitter,stack,op_pool,
						  frame,method_get_return_type(handle));

    return 0;
}

