// Copyright (C)  2000 Intel Corporation.  All rights reserved.
//
// $Header: /usr/development/orp/orp/arch/ia32/base/root_set_enum_ia32.cpp,v 1.14 2002/01/11 11:31:48 xli18 Exp $
//


#include "platform.h"
#include <assert.h>
#include <iostream.h>

#include "object_layout.h"
#include "environment.h"
#include "orp_types.h"
#include "jit_runtime_support.h"
#include "method_lookup.h"
#include "stack_manipulation.h"
#include "orp_threads.h"
#include "orp_utils.h"
#include "jit_intf.h"
#include "jit_intf_cpp.h"
#include "nogc.h"
#include "compile.h"
#include "orp_stats.h"

#include "orp_synch.h"

#include "finalize.h"
#include "Class_Loader.h"

#include "root_set_enum.h"
#include "enum_trampoline.h"
#include "exceptions.h"
#include "jvmdi_clean.h"

#include "../x86/x86.h"

#ifdef ORP_POSIX
#ifdef __linux__
#include <asm/spinlock.h>
#endif
#include "platform2.h"
#endif

#ifdef ORP_VTUNE_SUPPORT
//M: 
#include "orp_vtune.h"
#endif


#ifdef ORP_POSIX
#define  CHECK_HIJACK_SUPPORT_MACRO() printf("CHECK_HIJACK_SUPPORT_MACRO is not imeplemented on Linux\n");
#endif

#define NBP 256
uint8 *gc_breakpoint_address[NBP];
uint8  gc_breakpoint_opcode[NBP];

#ifdef GC_SAPPHIRE
#include "gc_for_orp.h"
#endif // GC_SAPPHIRE

//
// forward references
//
void orp_enum(ORP_thread *thread);
void orp_enumerate_references_in_gc_frames(ORP_thread *thread);
void orp_enumerate_object_handles(ORP_thread *thread);
void orp_thread_enumerate_from_native(ORP_thread *thread);
void orp_thread_enumerate_from_java(Boolean is_first, ORP_thread *thread);

void orp_enumerate_root_set_global_refs();
void orp_enumerate_root_set_single_thread_not_on_stack(ORP_thread *thread);
void orp_enumerate_root_set_global_refs();
void orp_enumerate_root_set_from_stack(Boolean is_first, ORP_thread *thread);
void enum_when_a_debugger();
void enum_when_no_debugger();
void all_threads_to_safepoint();

bool jvmdi_debugger;

ORP_Code_Type get_orpct(ORP_thread *thread);


#if 1 // RICKS_COMPARE_EXCHANGE_HACK.
#ifdef ORP_POSIX

PVOID 
InterlockedCompareExchange(
						   IN OUT PVOID *Destination,
						   IN PVOID Exchange,
						   IN PVOID Comperand
						   ) 
{
#ifdef OBSOLETE
    static spinlock_t s_l;
    spin_lock(&s_l);
	
    PVOID old_value = *Destination;
    if(old_value == Comperand) {
		*Destination = Exchange;
    }
	
    spin_unlock(&s_l);
	
    return old_value;
    // This needs to be implemented for GNUC for both IA32 and IA64.
    // NT provides it for IA32 and IA64. For pointer values IA64 also provides
    // InterlockedCompareExchangePointer.
#else
    if(!orp_atomic_compare_exchange) {
        orp_atomic_compare_exchange = (void *(*)(void ** ,void *,void *))getaddress__orp_atomic_compare_exchange();
}
    return orp_atomic_compare_exchange(Destination, Exchange, Comperand);
#endif
}

#endif

// Check to see if enumeration is possible at this point.
bool stack_enumeration_is_possible ()
{
	assert(0);
    // To Be Done for IA32
    return true;
}

// Implement these with a simple interlocked compare exchange. On IA64 we will need
// to use acquire when we move to disabled or enable will block and rel when we enable.
// On Linux Weldon will (someday) write InterlockedCompareExchange for me.
gc_enable_disable_state gc_if_disabled_then_enable(gc_enable_disable_state *p_en_dis)
{
    assert (*p_en_dis < bogus);
    // We cast the PVOID to an int then to the correct type. On IA64 I am assuming enums are longs,
    // if not we might need to fix this.
    return (gc_enable_disable_state)(long)
        InterlockedCompareExchange ((PVOID *)p_en_dis, (PVOID)enabled, (PVOID)disabled);
}

gc_enable_disable_state gc_if_enabled_then_EWB(gc_enable_disable_state *p_en_dis)
{
    assert (*p_en_dis < bogus);
    return (gc_enable_disable_state)(long)
        InterlockedCompareExchange ((PVOID *)p_en_dis, (PVOID)enabled_will_block, (PVOID)enabled);
}

gc_enable_disable_state gc_if_EWB_then_enable(gc_enable_disable_state *p_en_dis)
{
    assert (*p_en_dis < bogus);
    return (gc_enable_disable_state)(long)
        InterlockedCompareExchange ((PVOID *)p_en_dis, (PVOID)enabled, (PVOID)enabled_will_block);
}

gc_enable_disable_state gc_if_enabled_then_disable(gc_enable_disable_state *p_en_dis)
{
    assert (*p_en_dis < bogus);
    return (gc_enable_disable_state)(long)
        InterlockedCompareExchange ((PVOID *)p_en_dis, (PVOID)disabled, (PVOID)enabled);
}

gc_enable_disable_state gc_if_enabled_hijack_then_disable(gc_enable_disable_state *p_en_dis)
{
    assert (*p_en_dis < bogus);
    return (gc_enable_disable_state)(long)
        InterlockedCompareExchange ((PVOID *)p_en_dis, (PVOID)disabled, (PVOID)enabled_hijack);
}

gc_enable_disable_state gc_if_disabled_then_enabled_hijack(gc_enable_disable_state *p_en_dis)
{
    assert (*p_en_dis < bogus);
    return (gc_enable_disable_state)(long)
        InterlockedCompareExchange ((PVOID *)p_en_dis, (PVOID)enabled_hijack, (PVOID)disabled);
}
#else // RICKS_COMPARE_EXCHANGE_HACK

void * getaddress__gc_if_disabled_then_enable()
{
    static void *addr = 0;
    if (addr) {
        return addr;
    }
	
    const int stub_size = 1024;
    char *stub = (char *)gc_malloc_fixed_code_for_class_loading(stub_size);
#ifdef _DEBUG
    memset(stub, 0xcc /*int 3*/, stub_size);
#endif
    char *ss = stub;
	
    ss = push(ss, &ebp_opnd);
    ss = mov(ss, &ebp_opnd, &esp_opnd );
    ss = push(ss, &ecx_opnd);
    ss = push(ss, &ebx_opnd);
	
    ss = mov(ss, &M_Base_Opnd(ebp_reg, -4), &Imm_Opnd(bogus) );
	
    ss = alu(ss, xor_opc, &eax_opnd, &eax_opnd);
	
    ss = mov(ss, &ebx_opnd, &M_Base_Opnd(ebp_reg, +8)  );
    ss = mov(ss, &ecx_opnd, &Imm_Opnd(enabled)  );
	
    ss = prefix(ss, lock_prefix);
    ss = cmpxchg(ss, &M_Base_Opnd(ebx_reg, +0), &ecx_opnd);
	
    ss = pop(ss, &ebx_opnd);
    ss = mov(ss, &esp_opnd, &ebp_opnd  );
    ss = pop(ss, &ebp_opnd);
    ss = ret(ss);    
	
    addr = stub;
#ifdef ORP_VTUNE_SUPPORT
    //M:
    vtune_notify_stub_load_finished("getaddress__gc_if_disabled_then_enable",(Byte*) stub,ss-stub);
#endif
    return addr;
} //getaddress__gc_if_disabled_then_enable


gc_enable_disable_state gc_if_disabled_then_enable(gc_enable_disable_state *p_en_dis)
{
    gc_enable_disable_state ret_val = bogus;
	
	gc_enable_disable_state (* gidte)(gc_enable_disable_state *)  = 
		(gc_enable_disable_state (*      )(gc_enable_disable_state *) )
        getaddress__gc_if_disabled_then_enable();
	
    ret_val = gidte(p_en_dis);
	
    return ret_val;
}


void * getaddress__gc_if_enabled_then_EWB()
{
    static void *addr = 0;
    if (addr) {
        return addr;
    }
	
    const int stub_size = 1024;
    char *stub = (char *)gc_malloc_fixed_code_for_class_loading(stub_size);
#ifdef _DEBUG
    memset(stub, 0xcc /*int 3*/, stub_size);
#endif
    char *ss = stub;
	
    ss = push(ss, &ebp_opnd);
    ss = mov(ss, &ebp_opnd, &esp_opnd );
    ss = push(ss, &ecx_opnd);
    ss = push(ss, &ebx_opnd);
	
    ss = mov(ss, &M_Base_Opnd(ebp_reg, -4), &Imm_Opnd(bogus) );
	
    ss = mov(ss, &eax_opnd, &Imm_Opnd(enabled)  );
    ss = mov(ss, &ebx_opnd, &M_Base_Opnd(ebp_reg, +8)  );
	
    ss = mov(ss, &ecx_opnd, &Imm_Opnd(enabled_will_block)  );
	
    ss = prefix(ss, lock_prefix);
    ss = cmpxchg(ss, &M_Base_Opnd(ebx_reg, +0), &ecx_opnd);
	
    ss = pop(ss, &ebx_opnd);
    ss = mov(ss, &esp_opnd, &ebp_opnd  );
    ss = pop(ss, &ebp_opnd);
    ss = ret(ss);    
	
    addr = stub;
#ifdef ORP_VTUNE_SUPPORT
    //M:
    vtune_notify_stub_load_finished("getaddress__gc_if_enabled_then_EWB",(Byte*) stub,ss-stub);
#endif
    return addr;
} //getaddress__gc_if_enabled_then_EWB


gc_enable_disable_state gc_if_enabled_then_EWB(gc_enable_disable_state *p_en_dis)
{
	
    gc_enable_disable_state ret_val = bogus;
	
	gc_enable_disable_state (* giete)(gc_enable_disable_state *)  = 
		(gc_enable_disable_state (*      )(gc_enable_disable_state *) )
        getaddress__gc_if_enabled_then_EWB();
	
    ret_val = giete(p_en_dis);
	
    return ret_val;
}


void * getaddress__gc_if_EWB_then_enable()
{
    static void *addr = 0;
    if (addr) {
        return addr;
    }
	
    const int stub_size = 1024;
    char *stub = (char *)gc_malloc_fixed_code_for_class_loading(stub_size);
#ifdef _DEBUG
    memset(stub, 0xcc /*int 3*/, stub_size);
#endif
    char *ss = stub;
	
    ss = push(ss, &ebp_opnd);
    ss = mov(ss, &ebp_opnd, &esp_opnd );
    ss = push(ss, &ecx_opnd);
    ss = push(ss, &ebx_opnd);
	
    ss = mov(ss, &M_Base_Opnd(ebp_reg, -4), &Imm_Opnd(bogus) );
	
    ss = mov(ss, &eax_opnd, &Imm_Opnd(enabled_will_block)  );
    ss = mov(ss, &ebx_opnd, &M_Base_Opnd(ebp_reg, +8)  );
	
    ss = mov(ss, &ecx_opnd, &Imm_Opnd(enabled)  );
	
    ss = prefix(ss, lock_prefix);
    ss = cmpxchg(ss, &M_Base_Opnd(ebx_reg, +0), &ecx_opnd);
	
    ss = pop(ss, &ebx_opnd);
    ss = mov(ss, &esp_opnd, &ebp_opnd  );
    ss = pop(ss, &ebp_opnd);
    ss = ret(ss);    
	
    addr = stub;
#ifdef ORP_VTUNE_SUPPORT
    //M: 
    vtune_notify_stub_load_finished("getaddress__gc_if_EWB_then_enable",(Byte*) stub,ss-stub);
#endif
    return addr;
} //getaddress__gc_if_EWB_then_enable


gc_enable_disable_state gc_if_EWB_then_enable(gc_enable_disable_state *p_en_dis)
{
    gc_enable_disable_state ret_val = bogus;
	
	gc_enable_disable_state (* giEte)(gc_enable_disable_state *)  = 
		(gc_enable_disable_state (*      )(gc_enable_disable_state *) )
        getaddress__gc_if_EWB_then_enable();
	
    ret_val = giEte(p_en_dis);
	
    return ret_val;
}


void * getaddress__gc_if_enabled_then_disable()
{
    static void *addr = 0;
    if (addr) {
        return addr;
    }
	
    const int stub_size = 1024;
    char *stub = (char *)gc_malloc_fixed_code_for_class_loading(stub_size);
#ifdef _DEBUG
    memset(stub, 0xcc /*int 3*/, stub_size);
#endif
    char *ss = stub;
	
    ss = push(ss, &ebp_opnd);
    ss = mov(ss, &ebp_opnd, &esp_opnd );
    ss = push(ss, &ecx_opnd);
    ss = push(ss, &ebx_opnd);
	
    ss = mov(ss, &M_Base_Opnd(ebp_reg, -4), &Imm_Opnd(bogus) );
	
    ss = mov(ss, &eax_opnd, &Imm_Opnd(enabled)  );
    ss = mov(ss, &ebx_opnd, &M_Base_Opnd(ebp_reg, +8)  );
	
    ss = mov(ss, &ecx_opnd, &Imm_Opnd(disabled)  );
	
    ss = prefix(ss, lock_prefix);
    ss = cmpxchg(ss, &M_Base_Opnd(ebx_reg, +0), &ecx_opnd);
	
    ss = pop(ss, &ebx_opnd);
    ss = mov(ss, &esp_opnd, &ebp_opnd  );
    ss = pop(ss, &ebp_opnd);
    ss = ret(ss);    
	
    addr = stub;
#ifdef ORP_VTUNE_SUPPORT
    //M: 
    vtune_notify_stub_load_finished("getaddress__gc_if_enabled_then_disable",(Byte*) stub,ss-stub);
#endif
    return addr;
} //getaddress__gc_if_enabled_then_disable


gc_enable_disable_state gc_if_enabled_then_disable(gc_enable_disable_state *p_en_dis)
{
    gc_enable_disable_state ret_val = bogus;
	
	gc_enable_disable_state (* gietd)(gc_enable_disable_state *)  = 
		(gc_enable_disable_state (*      )(gc_enable_disable_state *) )
        getaddress__gc_if_enabled_then_disable();
	
    ret_val = gietd(p_en_dis);
	
    return ret_val;
}

#endif // #else RICKS_COMPARE_EXCHANGE_HACK

gc_enable_disable_state gc_get_enabled_status (gc_enable_disable_state *p_en_dis)
{
    return *p_en_dis;    
}


void restore_thread_state(ORP_thread *thread)
{
    assert( (thread->gc_status == gc_at_safepoint) ||
		(thread->gc_status == gc_moving_to_safepoint) );
    assert(p_the_safepoint_control_thread);
    assert(thread->thread_is_java_suspended == false);
	
	if (thread == p_TLS_orpthread) {
		// a thread should have never had set its own hijack
		assert(thread->hijack_p_eip == 0);
		assert(gc_breakpoint_address[0] == 0);
		assert(gc_breakpoint_opcode[0] == 0);
		return;
	}
	
    if(thread->hijack_p_eip) {
        assert(0); // remove when hit
        // Undo the eip hijacking.
        assert(thread->hijack_old_eip);
		
        assert( *(thread->hijack_p_eip) == (uint32)getaddress__orp_stop_thread_for_gc_ret_trampoline() );
		
        *(thread->hijack_p_eip) = thread->hijack_old_eip;
        thread->hijack_p_eip = 0;
        thread->hijack_old_eip = 0;
        assert(thread->hijack_returning_from != 0);
        thread->hijack_returning_from = 0;
    }
	
    assert(thread->hijack_p_eip == 0);
	
    // the following two fields are still set if hijack actually happened
    // clear them now
    thread->hijack_old_eip = 0;
    thread->hijack_returning_from = 0;
	
    for (int xx = 0; xx < NBP; xx++) {
        if (gc_breakpoint_address[xx] == 0)
            break;
        if (*gc_breakpoint_address[xx] == 0x6f) {
            // do not mess with a debugger breakpoint!
            assert(gc_breakpoint_opcode[xx] == 0);
            continue;
        }
        assert(*gc_breakpoint_address[xx] == 0x6e);
        assert(gc_breakpoint_opcode[xx] != 0);
        *gc_breakpoint_address[xx] = gc_breakpoint_opcode[xx]; 
        gc_breakpoint_opcode[xx] = 0;
        gc_breakpoint_address[xx] = 0;
    }
} //restore_thread_state


void hijack_return_eip(ORP_thread *thread)
{
    CHECK_HIJACK_SUPPORT_MACRO();
	
    // a thread should never set its own hijack
    assert(thread->hijack_p_eip == 0);
    assert(p_the_safepoint_control_thread);
    assert(p_the_safepoint_control_thread != thread);
    assert(thread->which_trap == x_nothing);
    assert(thread->thread_is_java_suspended == false);
	
    Registers *reg = thread_gc_get_context(thread);
    JIT_Specific_Info *jit_info = methods.find_deadlock_free((void *)reg->eip);
    ORP_Code_Type orpct = orp_identify_eip_deadlock_free((void *)reg->eip);
	assert(orpct == ORP_TYPE_JAVA); 
	
    Frame_Context context;
    memset(&context, 0, sizeof(context) );
    context.p_eip = &(reg->eip);
    if(orpct == ORP_TYPE_JAVA) { // hijack ONLY if in a java frame
        context.p_ebp = &(reg->ebp);
        context.p_ebx = &(reg->ebx);
        context.p_esi = &(reg->esi);
        context.p_edi = &(reg->edi);
        context.esp = reg->esp;
    }
	
    Boolean res = unwind_to_next_java_frame(&context, thread, TRUE);
    if(!res) {
        assert(thread->hijack_p_eip == 0);
        // simply do nothing because there is only one 
        // java frame on the stack (nothing to hijack).
        return;
    }
    orpct = orp_identify_eip_deadlock_free((void *)(*(context.p_eip)));
	
    assert(thread->hijack_p_eip == 0);
    thread->hijack_p_eip = context.p_eip;
    assert(thread->hijack_p_eip);
    thread->hijack_old_eip = *(context.p_eip);
	jit_info = methods.find_deadlock_free((void *)(*(context.p_eip)));
    thread->hijack_returning_from = jit_info->get_method();
	
    *(context.p_eip) = (uint32)getaddress__orp_stop_thread_for_gc_ret_trampoline();
	
} //Thread_To_GC_Safe_Point::hijack_return_eip

// Forward reference.
void orp_resume_a_thread_after (ORP_thread *p_thr, bool debug_breakpoint);

void orp_resume_threads_after(bool debug_breakpoint)
{
#ifdef GC_SAPPHIRE
	assert (0); // threads come up and go done individually.
#endif // GC_SAPPHIRE
	
    if (debug_breakpoint == true) {
        assert(global_safepoint_status == java_debugger);
	} else {
        assert(global_safepoint_status == enumerate_the_universe);
	}
	
    global_safepoint_status = nill;
	
    // add ctl-c debugger poll here
	
	assert(p_the_safepoint_control_thread == p_TLS_orpthread);
    p_the_safepoint_control_thread = 0;
	
#ifdef _DEBUG
    for(JIT **jit = jit_compilers; *jit; jit++) {
        (*jit)->gc_end();
    }
#endif
	
    ORP_thread *p_thr = p_active_threads_list;
    assert(p_thr);
	
    // resume _all_ threads (except those that have been java_lang_Thread_suspend0()'ed
    while(p_thr) {
		orp_resume_a_thread_after (p_thr, debug_breakpoint);

#ifdef CONCURRENCY_ANALYSIS
        if(p_thr != p_TLS_orpthread)
        {
            uint64 end_time = readTimeStampCounter();
#ifdef ORP_POSIX
            fprintf(f_concur, 
                "GC_END( tid = %d, gc_thread_id = %d, time = %llu )\n",
                p_thr->thread_index, p_TLS_orpthread->thread_index, end_time );
#else
            fprintf(f_concur, 
                "GC_END( tid = %d, gc_thread_id = %d, time = %I64u )\n",
                p_thr->thread_index, p_TLS_orpthread->thread_index, end_time );
#endif //#ifdef ORP_POSIX
        }
#endif //#ifdef CONCURRENCY_ANALYSIS

        p_thr = p_thr->p_active;
    }
		
	//ssssssssssssssssssssssssssssssssss    p_thread_lock->_unlock();

    // Several Reference Queues may need to be notified because the GC
    // added References to them. Do that now.
    orp_notify_pending_reference_queues();
	
    // For now we run the finalizers immediately in the context of the
    // thread which requested GC.
    // Eventually we may have a different scheme, e.g., a dedicated
    // finalize thread.

    if (orp_get_nursery()==NULL) {
        extern int running_finalizers_deferred;
        running_finalizers_deferred = 1;
    } else {
        orp_run_pending_finalizers();
    }
}  //orp_resume_threads_after

//
// orp_resume_a_thread_after - resumes threads if they have not been 
//								java_lang_Thread_suspend0(ed)
// input -	thread - the tread to resume
//			debug_breakpoint - ???
void orp_resume_a_thread_after (ORP_thread *p_thr, bool debug_breakpoint)
{
	// assert(p_thr->p_nursery);
    if (debug_breakpoint) {
		assert(p_thr->gc_status == gc_at_safepoint);
    } else {
#ifdef GC_SAPPHIRE
        assert ((p_thr->gc_sapphire_status == sapphire_nursery_released) ||
			(p_thr->gc_sapphire_status == sapphire_enumeration_done) ||
			(p_thr->gc_sapphire_status == sapphire_between_enumerations) ||
			(p_thr->gc_sapphire_status == sapphire_flipped));
#else
        assert(p_thr->gc_status == gc_enumeration_done);
#endif
    }
    if(p_TLS_orpthread == p_thr)  {
        // this is the current thread, don't resume
        assert(p_thr->which_trap == x_the_safepoint_control_thread);
        p_thr->which_trap = x_nothing;
        assert(p_thr->restore_context_after_gc == false);
        p_thr->gc_status = zero;
        return; //ssssssssssssssssssssssssssssss22222222222222222
    } 
	else {
        assert(p_thr->which_trap != x_nothing);
        assert(p_thr->which_trap != x_the_safepoint_control_thread);
		
        if(p_thr->restore_context_after_gc) {
			
			assert(p_thr->which_trap == x_suspend_in_java_frame);
            thread_gc_set_context(p_thr);
        }
		
        if (p_thr->which_trap == x_suspend_in_java_frame)  
        {
            p_thr->which_trap = x_nothing;
            p_thr->gc_status = zero;
#ifdef LINUX_THREAD_SUSPEND
            bool resume_thread(ORP_thread *);
            DWORD stat = resume_thread(p_thr);
            return;
#else
            DWORD stat = RESUME_THREAD(p_thr);
#endif
			assert(stat == 1);
        } 
		else {
			if ((p_thr->which_trap == x_java_sleep) ||
				(p_thr->which_trap == x_java_wait)) {
				// Sleep or wait will be in an enabled_will_block state 
				// AND waiting for
				// the event gc_resume_event_handle.
				// Move it into the enabled state and send the signal below
				// Beforp the sleeping thread will go into a disabled state
				// it will grab the thread/gc lock.
				bool good_ljf = false;
				if (p_TLS_orpthread->gc_frame_context.ljf != 0) {
					good_ljf = true;
				}
				
				memset(&(p_thr->gc_frame_context), 0, sizeof(p_thr->gc_frame_context) );
				p_thr->gc_frame_context.ljf = (uint32)p_thr->get_last_java_frame();
				
				if (good_ljf) {
					assert (p_thr->gc_frame_context.ljf != 0);
				}
				p_thr->gc_frame_context.p_eip = &(p_thr->gc_frame_context_eip_var);
				p_thr->gc_status = gc_at_safepoint;
                assert (p_thr->gc_enabled_status == enabled_will_block);
				gc_enable_disable_state endis = gc_if_EWB_then_enable(&p_thr->gc_enabled_status);
				assert (endis == enabled_will_block); // Bug if it didn't block
			} else {
				if (p_thr->thread_is_java_suspended) {
					memset(&(p_thr->gc_frame_context), 0, sizeof(p_thr->gc_frame_context) );
					p_thr->gc_frame_context.ljf = (uint32)p_thr->get_last_java_frame();
					p_thr->gc_frame_context.p_eip = &(p_thr->gc_frame_context_eip_var);
					
					assert(p_thr->which_trap != x_nothing);
					p_thr->gc_status = gc_at_safepoint;
				} else {
					p_thr->gc_status = zero;
					p_thr->which_trap = x_nothing;
					// The hijack eip logic ends up here...
				}  //   if (p_thr->thread_is_java_suspended)
			} // if (p_thr->which_trap == x_java_wait)(p_thr->which_trap == x_java_sleep)
        }  //   if (p_thr->which_trap == x_suspend_in_java_frame)  
    }  //  if(p_TLS_orpthread == p_thr)
	
    boolean sstat = SetEvent(p_thr->gc_resume_event_handle);
    assert(sstat);
	
	assert( (p_thr->gc_status == zero) || (p_thr->gc_status == gc_at_safepoint) );
    p_thr->restore_context_after_gc = false;
	
    if (p_thr->which_trap == x_java_sleep) {
		assert(p_thr->gc_frame_context.ljf != 0);
    }
    assert (p_thr->gc_status != gc_enumeration_done);
}

//////////////////////////////////////////////////////////////////////////
// begin breakpoint-related stuff


#define BP_MAGIC  0xff77ff77

#pragma optimize( "g", off )
void __cdecl at_breakpoint(uint32 edi_arg,
                           uint32 esi_arg,
                           uint32 ebp_arg,
                           uint32 esp_arg,
                           uint32 ebx_arg,
                           uint32 edx_arg,
                           uint32 ecx_arg,
                           uint32 eax_arg,
                           uint32 flags_arg,
                           uint32 eip_arg
                           )
{
    assert( (p_TLS_orpthread->gc_status == zero) ||
		(p_TLS_orpthread->gc_status == gc_moving_to_safepoint) );
    
    assert(p_the_safepoint_control_thread != p_TLS_orpthread);
    assert(p_TLS_orpthread->thread_is_java_suspended == false);
	
    // can only call this procedure from enum breakpoint or debugger breakpoint
    assert( ( *(uint8 *)(p_TLS_orpthread->regs.eip) == 0x6e)     || 
		( *(uint8 *)(p_TLS_orpthread->regs.eip) == 0x6f)         );
	
#if 0 //def _DEBUG
    if (p_TLS_orpthread->gc_status == zero) {
        orp_cout << "a thread other than the intended thread hit a gc breakpoint" << endl;
    }
#endif
	
    assert(eip_arg == BP_MAGIC);    
    eip_arg = p_TLS_orpthread->regs.eip;
	
    switch ( *(uint8 *)(p_TLS_orpthread->regs.eip) ) {
		
    case 0x6e: // an enumeration breakpoint
        {
            memset(&(p_TLS_orpthread->gc_frame_context), 0, sizeof(p_TLS_orpthread->gc_frame_context) );
			
            p_TLS_orpthread->gc_frame_context.p_eip = &eip_arg;
            p_TLS_orpthread->gc_frame_context.p_ebp = &ebp_arg;
            p_TLS_orpthread->gc_frame_context.p_ebx = &ebx_arg;
            p_TLS_orpthread->gc_frame_context.p_esi = &esi_arg;
            p_TLS_orpthread->gc_frame_context.p_edi = &edi_arg;
            p_TLS_orpthread->gc_frame_context.esp   = esp_arg + 8;
            p_TLS_orpthread->gc_frame_context.ljf   = (uint32)get_orp_last_java_frame();
			
            assert(jvmdi_debugger == false);
			
            assert(p_the_safepoint_control_thread);
            assert(global_safepoint_status == enumerate_the_universe);
            assert(p_TLS_orpthread->gc_status != gc_at_safepoint);
			
            p_TLS_orpthread->gc_status = gc_at_safepoint;
			
            assert(p_TLS_orpthread->which_trap == x_nothing);
            p_TLS_orpthread->which_trap = x_at_breakpoint;
			
            if (p_TLS_orpthread->gc_status == zero)
            {
                // this can only happen if a 3rd party thread executes the
                // same method that gc breakpoints were set in for the targeted thread.
                // the below line will prevent the 3rd party thread from wasting the cpu.
                Sleep(1);
            }
            orp_enable_gc();
            DWORD wstat = WaitForSingleObject(p_TLS_orpthread->gc_resume_event_handle, INFINITE);
            assert(wstat != WAIT_FAILED);
            orp_disable_gc();
			
            return;
            break;
        }
		
    case 0x6f:  // a debugger breakpoint
        {
            assert(jvmdi_debugger == true);
			
            while (true) {
				
                bool stat = p_thread_lock->_lock_or_null(); 
				
                if (stat == true) {
					
                    memset(&(p_TLS_orpthread->gc_frame_context), 0, sizeof(p_TLS_orpthread->gc_frame_context) );
					
                    p_TLS_orpthread->gc_frame_context.p_eip = &eip_arg;
                    p_TLS_orpthread->gc_frame_context.p_ebp = &ebp_arg;
                    p_TLS_orpthread->gc_frame_context.p_ebx = &ebx_arg;
                    p_TLS_orpthread->gc_frame_context.p_esi = &esi_arg;
                    p_TLS_orpthread->gc_frame_context.p_edi = &edi_arg;
                    p_TLS_orpthread->gc_frame_context.esp   = esp_arg + 8;
                    p_TLS_orpthread->gc_frame_context.ljf   = (uint32)get_orp_last_java_frame();
					
                    assert(p_the_safepoint_control_thread == 0);
                    p_the_safepoint_control_thread = p_TLS_orpthread;
					
                    assert(global_safepoint_status == nill);
                    global_safepoint_status = java_debugger;
					
                    all_threads_to_safepoint();
                    jvmdi_breakpoint(&eip_arg);
                    orp_resume_threads_after(true);
					
                    return;
                }
				
                else {
					switch (global_safepoint_status) {
						
					case nill:
						{
							// try again, another thread held the 
							// lock (but is not doing any safepoint stuff)
							Sleep(1);
							break;
						}
						
					case enumerate_the_universe:
						assert(0);  // remove when hit
						// fall through to java_debugger on purpose
						
					case java_debugger:
						{
							// another thread actually hit a debugger bkpt first
							assert(p_the_safepoint_control_thread);
							assert(p_the_safepoint_control_thread != p_TLS_orpthread);
							
							
							assert(eip_arg != BP_MAGIC);    
							
							memset(&(p_TLS_orpthread->gc_frame_context), 0, sizeof(p_TLS_orpthread->gc_frame_context) );
							
							p_TLS_orpthread->gc_frame_context.p_eip = &eip_arg;
							p_TLS_orpthread->gc_frame_context.p_ebp = &ebp_arg;
							p_TLS_orpthread->gc_frame_context.p_ebx = &ebx_arg;
							p_TLS_orpthread->gc_frame_context.p_esi = &esi_arg;
							p_TLS_orpthread->gc_frame_context.p_edi = &edi_arg;
							p_TLS_orpthread->gc_frame_context.esp   = esp_arg + 8;
							p_TLS_orpthread->gc_frame_context.ljf   = (uint32)get_orp_last_java_frame();
							
							assert(p_TLS_orpthread->gc_status != gc_at_safepoint);
							p_TLS_orpthread->gc_status = gc_at_safepoint;
							
							assert(p_TLS_orpthread->which_trap == x_nothing);
							p_TLS_orpthread->which_trap = x_at_breakpoint;
							
							orp_enable_gc();
							DWORD wstat = WaitForSingleObject(p_TLS_orpthread->gc_resume_event_handle, INFINITE);
							assert(wstat != WAIT_FAILED);
							orp_disable_gc();
							
							// break and try to grab the lock again
							
							break;
						}
						
					case java_suspend_one_thread:
						{
							assert(0); // remove after debugging
							
							if (p_TLS_orpthread->thread_is_java_suspended == true) {
								
								memset(&(p_TLS_orpthread->gc_frame_context), 0, sizeof(p_TLS_orpthread->gc_frame_context) );
								p_TLS_orpthread->gc_frame_context.ljf = (uint32)p_TLS_orpthread->get_last_java_frame();
								p_TLS_orpthread->gc_frame_context.p_eip = &(p_TLS_orpthread->gc_frame_context_eip_var);
								
								boolean rstat = ResetEvent(p_TLS_orpthread->event_handle_suspend0);
								assert(rstat);
								
								assert(p_TLS_orpthread->gc_enabled_status == disabled);
								assert(p_the_safepoint_control_thread == 0);
								
								assert(p_TLS_orpthread->gc_status != gc_at_safepoint);
								p_TLS_orpthread->gc_status = gc_at_safepoint;
								
								assert(p_TLS_orpthread->which_trap == x_nothing);
								p_TLS_orpthread->which_trap = x_at_breakpoint; // gets rewritten in ...suspend0()
								
								orp_enable_gc();
								
								DWORD wstat = WaitForSingleObject(p_TLS_orpthread->event_handle_suspend0, INFINITE);
								assert(wstat != WAIT_FAILED);
								
								orp_disable_gc();
								
								if (p_TLS_orpthread->p_stop_object) {
									
									assert(0);  // remove after debugging
									throw_java_exception_from_native(p_TLS_orpthread->p_stop_object);
								}
								
								// can't do the below, another suspend0 could
								// hit before the assert()'s are executed
								// assert(p_the_safepoint_control_thread == 0);
								// assert(p_TLS_orpthread->which_trap == x_nothing);
								// assert(p_TLS_orpthread->thread_is_java_suspended == false);
							}
							
							break;
						}
						
					default:
						{
							assert(0);
						}
						
					} // end of switch(global_safepoint_status)
					
                } // end of else 
				
                Sleep(0);
				
            } // end of while(true)
			
        }  // end of case 0x6f
		
    default:
        {
            assert(0);
            break;
        }
    } // end of switch(...regs.eip)
	
} //at_breakpoint
#pragma optimize( "", on )


void *getaddress__orp_at_a_jit_breakpoint()
{
    //orp_cout << "getaddress__orp_at_a_jit_breakpoint() needs debugging, contact Weldon" << endl;
    //assert(0);  orp_exit(30558);
	
    static void *addr = 0;
    if (addr) {
        return addr;
    }
	
    const int stub_size = 1024;
    char *stub = (char *)gc_malloc_fixed_code_for_class_loading(stub_size);
#ifdef _DEBUG
    memset(stub, 0xcc /*int 3*/, stub_size);
#endif
    char *ss = stub;
	
    ss = push(ss, &Imm_Opnd(BP_MAGIC) );
    ss = pushfd(ss);
    ss = pushad(ss);
	
    ss = call(ss, (char *)at_breakpoint);
	
    ss = popad(ss);
    ss = popfd(ss);
	
    ss = ret(ss);
	
    addr = stub;
#ifdef ORP_VTUNE_SUPPORT
    //M: 
    vtune_notify_stub_load_finished("getaddress__orp_at_a_jit_breakpoint",(Byte*) stub,ss-stub);
#endif
    return addr;
} //getaddress__orp_at_a_jit_breakpoint


// end breakpoint-related stuff
//////////////////////////////////////////////////////////////////////////



//
// Enumerate references on the stack.  Assume that the current context
// indicates that we are in jitted code.
//

void orp_suspended_java_frame_or_set_traps(ORP_thread *thread)
{
    assert(thread->thread_is_java_suspended == false);
    assert(thread->gc_enabled_status == disabled);
    assert(thread->gc_status == gc_moving_to_safepoint);
	
    JIT_Specific_Info *jit_info =
        methods.find_deadlock_free((void *)(thread->regs.eip));
    assert(jit_info);
    JIT *jit = jit_info->get_jit();
	
    memset(&(thread->gc_frame_context), 0, sizeof(thread->gc_frame_context) );
	
    thread->gc_frame_context.p_eip = &(thread->regs.eip);
    thread->gc_frame_context.p_ebp = &(thread->regs.ebp);
    thread->gc_frame_context.p_ebx = &(thread->regs.ebx);
    thread->gc_frame_context.p_esi = &(thread->regs.esi);
    thread->gc_frame_context.p_edi = &(thread->regs.edi);
    thread->gc_frame_context.p_eax = &(thread->regs.eax);
    thread->gc_frame_context.p_ecx = &(thread->regs.ecx);
    thread->gc_frame_context.p_edx = &(thread->regs.edx);
    thread->gc_frame_context.esp = thread->regs.esp;
    thread->gc_frame_context.ljf   = (uint32)thread->get_last_java_frame();
	
#if 1 // TESTING BREAKPOINTS 1 = normal, 0 = testing
    // Are we at a GC-safe point?
    if(jit->can_enumerate(jit_info->get_method(), thread->regs.eip)) {
		
        thread->gc_status = gc_at_safepoint;
        assert(thread->which_trap == x_nothing);
        thread->which_trap = x_suspend_in_java_frame;
		
        return;   
    }
#endif // END OF TESTING BREAKPOINTS
	
    // Not at a GC-safe point.  We will let the thread run, but before we do it,
    // we will:
    //  1. gc_status = moving_to_gc_safepoint
    //  2. Hijack the return eip.
    //  3. Set the breakpoints
    // There are only three ways to escape from a Java frame:
    //  A. Return.  This is handled by (1) above.
    //  B. Call to another method.  Handled by (2).
    //  C. Exception which is not handled in the current method.  This is handled
    //     by the exception throwing code which checks the state of the thread
	
    // toss assert(thread->gc_status == zero);
	
    // toss thread->gc_status = gc_moving_to_safepoint;
//    orp_cout << " internal bug no hijack - x0x0x" << endl; 
#if 0 // rlh for sapphire
    if (jvmdi_debugger == false)
    {
        // jit breakpoints and hijack ret eip are basically for better performance
        // to reduce confusion, turn them off when the jvmdi debugger is active
		
        hijack_return_eip(thread);
		
#ifdef _DEBUG
        for (int xx = 0; xx < NBP; xx++) {
            assert(gc_breakpoint_address[xx] == 0);
            assert(gc_breakpoint_opcode[xx] == 0);
        }
#endif
		
        unsigned num_bkpts = jit->num_breakpoints(jit_info->get_method(), thread->regs.eip);
        assert(num_bkpts <= NBP);  // BUGBUG need to handle a variable number of breakpoints
		
#if 0  // turn back on later
        orp_cout << "%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%" << endl;
        orp_cout << "orp_suspended_java_frame_or_set_traps() -- hijacking ret eip and setting gc breakpoints";
        orp_cout << "  num_bkpts = " << num_bkpts << "  in " << jit_info->get_method()->get_name()->bytes << endl;
		
        if (num_bkpts) {
			
            jit->get_breakpoints(jit_info->get_method(), 
				(uint32 *)gc_breakpoint_address, 
				&thread->gc_frame_context);
        }
		
        for(unsigned int zz = 0; zz < num_bkpts; zz++) {
            if ( (*gc_breakpoint_address[zz]) == 0x6f) {
                // do not mess with debugger breakpoint!
                continue;
            }
            gc_breakpoint_opcode[zz] = *gc_breakpoint_address[zz];
            *gc_breakpoint_address[zz] = 0x6e;     // an illegal, ring 0 instruction
        }
#endif
		
    }
#endif // rlh for sapphire
} //orp_suspended_java_frame_or_set_traps


void orp_enum(ORP_thread *thread)
{
    assert(thread->gc_status == gc_at_safepoint);
	
    // restore_thread_state() should have already been called by now
    assert(gc_breakpoint_address[0] == 0);
    assert(gc_breakpoint_opcode[0] == 0);
    assert(thread->hijack_p_eip == 0);
	
    //orp_cout << "orp_enum() -- thread " << hex << thread;
    //orp_cout << "  which_trap =  " << thread->which_trap << endl;
	
    switch (thread->which_trap) {
		
    case x_the_safepoint_control_thread:
        {
            assert(thread == p_TLS_orpthread);
			
            orp_thread_enumerate_from_native(thread);
            break;
        }
		
    case x_lock_enum:
    case x_lock_enum_or_null:
    case x_orp_enable_gc:
        {
            orp_thread_enumerate_from_native(thread);
            break;
        }
    case x_suspend_in_java_frame:
        {
            orp_thread_enumerate_from_java(true, thread);
#ifndef LINUX_THREAD_SUSPEND
            thread->restore_context_after_gc = true;
#endif
            break;
        }
    case x_java_suspended:
        {
            assert(thread->thread_is_java_suspended == true);
			
            orp_thread_enumerate_from_native(thread);
            break;
        }
    case x_at_breakpoint:
        {
            orp_thread_enumerate_from_java(true, thread);
			
            break;
        }
    case x_orp_stop_thread_for_gc_ret:
        {
            
            //
            // The thread being hijacked atomically moves from 
            // disabled -> enabled_hijack and then
            // waits for a signal from this the gc thread.
            // The gc thread (atomically with respect to thread 
            // being enumed) moves the enum 
            // thread from enabled_hijack -> disabled and signal 
            // this thread to resume.
            //
            // thread to enum                          gc_thread
            // assert state==disabled
            // sets state = enabled_for_hijack
            //                                         notices (state==enable_for_hijack)
            //  *we are here for both threads*
            //                                         enumerate etc ...
            //                                         state = disable
            //                                         signals to continue
            // (gc_thread actions appear atomic)
            // continues 
            // assert state==disable
            //
            // Notice that later GCs will force this routine to continue since it will have
            // a disabled state. If "this thread" did the disable after it continued then 
            // the next gc would see this thread in an enabled_for_hijack state but 
            // gated by the current gc to continue whenever it felt like.
            //
			
            orp_thread_enumerate_from_java(false, thread);
			
            // enumerate eax if it holds a reference (see orp_stop_thread_for_gc_ret() )
            if (thread->gc_frame_context.p_eax)
                orp_enumerate_root_reference(0, (void **)(thread->gc_frame_context.p_eax) );
            gc_enable_disable_state endis = gc_if_enabled_hijack_then_disable(&(thread->gc_enabled_status));
            assert (endis == enabled_hijack);
            // The thread will be signaled to resumed by the caller.
            break;
        }
    case x_orp_throw:
        {
            orp_enumerate_root_set_from_stack(TRUE, thread);
            orp_enumerate_root_set_single_thread_not_on_stack(thread);
            orp_enumerate_object_handles(thread);
            thread->gc_status = gc_enumeration_done;
            break;
        }
    case x_orp_execute_java_method_array:
        {
            assert(0);
            break;
        }
    case x_native_wrapper:
        {
            assert(0);
            break;
        }
    case x_java_wait:
        {
            orp_thread_enumerate_from_native(thread);
            break;
        }
    case x_java_sleep:
        {
            orp_thread_enumerate_from_native(thread);
            break;
        }
    default:
        {
            assert(0);
            orp_exit(45567);
        }
    }
    assert(thread->gc_status == gc_enumeration_done);
#ifdef GC_SAPPHIRE
    // we have enumerated the thread now transfer the ssb that was being used
    // by the write barrier so the gc thread can process it.
void sapphire_move_ssb(ORP_thread *p_orpthread);
    sapphire_move_ssb(thread);
    thread->gc_sapphire_status = sapphire_enumeration_done;
#endif // GC_SAPPHIRE
}

//
// This is the entry point from GC.
//


void get_control_of_threads_for_gc()
{
		
    //assert(p_thread_lock->_critical_section.OwningThread 
    //           == p_TLS_orpthread->thread_id);
	//ssssssssssssssssssssssssssssssssssssssssss    p_thread_lock->_lock(); 
    assert (p_TLS_orpthread->gc_status == zero);
	
#ifdef _DEBUG
    for(JIT **jit = jit_compilers; *jit; jit++) {
        (*jit)->gc_start();
    }
#endif
	
	memset(&(p_TLS_orpthread->gc_frame_context), 0, sizeof(p_TLS_orpthread->gc_frame_context) );
	p_TLS_orpthread->gc_frame_context.ljf = (uint32)p_TLS_orpthread->get_last_java_frame();
    if (p_TLS_orpthread->gc_frame_context.ljf == 0) {  // GC can only happen from Java.
        // Thread is either being born or is dying if ljf is zero..
        assert((p_TLS_orpthread->app_status == thread_is_birthing) || 
                (p_TLS_orpthread->app_status == thread_is_dying));
    }
	p_TLS_orpthread->gc_frame_context.p_eip = &(p_TLS_orpthread->gc_frame_context_eip_var);
	// set the gc frame throw context
	Frame_Context *thr_cxt = p_TLS_orpthread->throw_context;
	if(thr_cxt){
		orp_copy_frame_context(&p_TLS_orpthread->gc_frame_throw_context, p_TLS_orpthread->throw_context);
	}
}

#ifdef GC_SAPPHIRE
// Forward reference.
void orp_sapphire_enumerate_root_set_all_threads();
#endif // GC_SAPPHIRE

void orp_enumerate_root_set_all_threads()
{
#ifdef GC_SAPPHIRE
	orp_sapphire_enumerate_root_set_all_threads();
	return;
#endif // GC_SAPPHIRE
	
    bool prev_state = orp_disable_gc();      //----------------v

	get_control_of_threads_for_gc();
	
    assert(p_the_safepoint_control_thread == 0);
	p_the_safepoint_control_thread = p_TLS_orpthread;
	
    assert(global_safepoint_status == nill);
    global_safepoint_status = enumerate_the_universe;
	
    if (jvmdi_debugger) {
        enum_when_a_debugger();
    }
    else {
        enum_when_no_debugger();
    }
    
    int n_threads = thread_gc_number_of_threads(); // reset iterator.
    for(int n = 0; n < n_threads; n++) {
        ORP_thread *thread = (ORP_thread *)thread_gc_enumerate_one();
        assert (thread->gc_status == gc_enumeration_done);
        // It can be enabled or enabled_will_block if it isn't in a java frame.
        assert ((thread->gc_enabled_status == enabled) || 
            (thread->gc_enabled_status == enabled_will_block) || 
            (thread->which_trap == x_suspend_in_java_frame) ||
            (thread->which_trap == x_orp_stop_thread_for_gc_ret) );
    }

    if(prev_state) {
        orp_enable_gc();        //-----------------------------^
    }
} //orp_enumerate_root_set_all_threads



// Forward reference
void move_a_thread_to_safepoint(ORP_thread *thread);


void all_threads_to_safepoint()
{
	
#ifdef _DEBUG
    ORP_thread *p_cursor = p_active_threads_list;
    while(p_cursor) {
        assert( (p_cursor->gc_status == zero) || (p_cursor->gc_status == gc_at_safepoint) );
        p_cursor = p_cursor->p_active;
    }
#endif
	
	uint32 n_threads = thread_gc_number_of_threads();
	
	unsigned n;
	for(n = 0; n < n_threads; n++) {
		
		ORP_thread *thread = (ORP_thread *)thread_gc_enumerate_one();
		// Suspend this thread.
		move_a_thread_to_safepoint(thread);
	} // end of for loop
	assert (n == n_threads);
	
	// process the current thread
	assert(p_TLS_orpthread->gc_status == zero);
	p_TLS_orpthread->gc_status = gc_at_safepoint;
	assert(p_TLS_orpthread->which_trap == x_nothing);
	p_TLS_orpthread->which_trap = x_the_safepoint_control_thread;
	assert(p_TLS_orpthread->restore_context_after_gc == false);
}

// move_a_thread_to_safepoint - 
// Input thread - the thread that is to be moved to a gc safe point
// Comment - The thread doing the gc is never passed to this routine
//
void move_a_thread_to_safepoint(ORP_thread *thread)
{
#ifndef GC_SAPPHIRE
    // Sapphire and the debugger are the only folks using this at the present.
    // and the debugger is broken.
    assert(0);  // reuse the code from enum_when_no_debugger()???
#endif 
    
	assert(thread != p_TLS_orpthread);
	thread->restore_context_after_gc = false;
	
	if (thread->thread_is_java_suspended) {
		assert(thread->gc_status == gc_at_safepoint);
        assert(thread->which_trap != x_nothing);
        return; 
	}
	
    if (thread->app_status == thread_is_sleeping) {
        assert (thread->app_status == thread_is_sleeping);
        gc_enable_disable_state	endis = gc_if_enabled_then_EWB(&thread->gc_enabled_status);
        if ((endis == enabled) && (thread->app_status == thread_is_sleeping)) {
            // Check to avoid ABA problems
            // If it goes to disabled we just fall through.
            //                thread_gc_suspend_one(thread);
                
            assert (thread->app_status == thread_is_sleeping); // Make sure no race happened.
            assert(thread->gc_status == gc_at_safepoint);
            assert(thread->which_trap == x_java_sleep);
            assert(thread->gc_frame_context.ljf != 0);
            return;
        }
        // Thread was sleeping but stop sleeping before we could do the EWB so look for 
        // another state.
    }
        
    if (thread->app_status == thread_is_waiting) {
        assert(thread->app_status == thread_is_waiting);
            
        gc_enable_disable_state	endis = gc_if_enabled_then_EWB(&thread->gc_enabled_status);
        //                thread_gc_suspend_one(thread);
        if ((endis == enabled) && (thread->app_status == thread_is_waiting)) { 
            // We are enabled check app_status to avoid ABA problem.
            assert(thread->app_status == thread_is_waiting);
            assert(thread->gc_status == gc_at_safepoint);
            assert(thread->which_trap == x_java_wait);
            assert(thread->gc_frame_context.ljf != 0);    
            return;
        } // if ((endis == enabled) && (thread->app_status == thread_is_waiting))
    } // if (thread->app_status == thread_is_waiting) {
        
    boolean rstat = ResetEvent(thread->gc_resume_event_handle);
    assert(rstat);
	
    assert(thread->gc_status == zero);
    thread->gc_status = gc_moving_to_safepoint;
	
    gc_enable_disable_state endis = bogus;

    // What if the thread goes into sleep or wait shouldn't this while loop
    // be around the above code also.
    while (1) {
        endis = gc_if_enabled_then_EWB(&thread->gc_enabled_status);    
		
        if ((endis == enabled) || // then it MUST have atomically moved to EWB
            (endis == enabled_will_block) ) {
            if(thread->gc_status != gc_at_safepoint) {
                thread->gc_status = gc_at_safepoint;        
				
                assert(thread->which_trap == x_nothing);
                thread->which_trap = x_orp_enable_gc;
                restore_thread_state(thread);
                memset(&(thread->gc_frame_context), 0, sizeof(thread->gc_frame_context) );
                thread->gc_frame_context.ljf = (uint32)thread->get_last_java_frame();    
                // The thread is being born or is dying if ljf is null.
                thread->gc_frame_context.p_eip = &(thread->gc_frame_context_eip_var);
            } else {
                assert(thread->which_trap != x_nothing);
            }
            break;
        } // if ((endis == enabled) || ...
		
        thread_gc_suspend_one(thread);
		
		ORP_Code_Type orpct = get_orpct(thread);
        if(orpct == ORP_TYPE_JAVA) {
            restore_thread_state(thread);
			orp_suspended_java_frame_or_set_traps(thread);
            if (thread->gc_status == gc_at_safepoint) {
                assert(thread->which_trap == x_suspend_in_java_frame);
                restore_thread_state(thread);
                break;
            }
        }  // if(orpct == ORP_TYPE_JAVA)
		
        DWORD stat = RESUME_THREAD(thread);
        
        assert(stat == 1);  // thread was suspended
        Sleep(2);
    }
}

void enum_when_a_debugger() 
{
    while (1) {
		
        if (0 /*replace with debugger bkpt was hit */ ) 
        {
            assert(0);  // fix this
        }
        else {
            all_threads_to_safepoint();
			
            // check for a debugger breakpoint
			
			
            // enumerate every thread
            ORP_thread *p_cursor = p_active_threads_list;
            while (p_cursor) {
                orp_enum(p_cursor);
                assert(p_cursor->gc_status == gc_enumeration_done);
                p_cursor = p_cursor->p_active;
            }
			// finally, process all the global refs
            orp_enumerate_root_set_global_refs();
            break;  // breaks out of while(1) loop
        }
    } // end of while(1) loop
}

void process_the_current_thread ();

#ifdef GC_SAPPHIRE
bool check_all_threads_sapphire_status (gc_sapphire_state state);
void change_all_threads_sapphire_status (gc_sapphire_state state);
#endif // GC_SAPPHIRE

void enum_when_no_debugger() 
{
    uint32 n_threads;
    unsigned n;
    
    // #ifdef _DEBUG
    n_threads = thread_gc_number_of_threads(); // reset iterator.
    for(n = 0; n < n_threads; n++) {
        ORP_thread *thread = (ORP_thread *)thread_gc_enumerate_one();
        assert (thread->gc_status != gc_enumeration_done);
        assert (p_TLS_orpthread->gc_status != gc_enumeration_done);
    }
    // #endif
    
    bool done = false;
    
    n_threads = thread_gc_number_of_threads(); // reset iterator.
    for(n = 0; n < n_threads; n++) {
        ORP_thread *thread = (ORP_thread *)thread_gc_enumerate_one();
        assert(thread != p_TLS_orpthread);

#ifdef CONCURRENCY_ANALYSIS
        uint64 start_time = readTimeStampCounter();
#ifdef ORP_POSIX
        fprintf(f_concur, 
            "GC_START( tid = %d, gc_thread_id = %d, time = %llu )\n",
            thread->thread_index, p_TLS_orpthread->thread_index, start_time );
#else
        fprintf(f_concur, 
            "GC_START( tid = %d, gc_thread_id = %d, time = %I64u )\n",
            thread->thread_index, p_TLS_orpthread->thread_index, start_time );
#endif //#ifdef ORP_POSIX
#endif //#ifdef CONCURRENCY_ANALYSIS
        
        thread->restore_context_after_gc = false;
        
        if (thread->thread_is_java_suspended) {
            assert(thread->thread_is_java_suspended);
            assert(thread->gc_status == gc_at_safepoint);
            assert(thread->which_trap != x_nothing);
            assert(thread->gc_frame_context.ljf != 0);  // diagnostic only, remove if hit
            assert(thread->thread_is_java_suspended);
#ifdef GC_SAPPHIRE
                thread_enum_start_hook();
#endif // GC_SAPPHIRE            
            orp_enum(thread);
#ifdef GC_SAPPHIRE
                thread_enum_end_hook(SUSPENDED_BY_ENABLED_WILL_BLOCK);
#endif // GC_SAPPHIRE            

            assert(thread->thread_is_java_suspended);
            assert(thread->gc_status == gc_enumeration_done);
            
#ifdef GC_SAPPHIRE
            thread->gc_sapphire_status = sapphire_enumeration_done;                // Thread does not need to be resumed.
            thread->gc_status = gc_at_safepoint;
#endif         
            assert (thread->gc_status == gc_enumeration_done);
            continue;
        } // if (thread->thread_is_java_suspended) {
        
        if (thread->app_status == thread_is_sleeping) {
            assert (thread->app_status == thread_is_sleeping);
            gc_enable_disable_state	endis = gc_if_enabled_then_EWB(&thread->gc_enabled_status);
            if ((endis == enabled) && (thread->app_status == thread_is_sleeping)) {
                // Check to avoid ABA problems
                // If it goes to disabled we just fall through.
                //                thread_gc_suspend_one(thread);
                
                assert (thread->app_status == thread_is_sleeping); // Make sure no race happened.
                assert(thread->gc_status == gc_at_safepoint);
                assert(thread->which_trap == x_java_sleep);
                assert(thread->gc_frame_context.ljf != 0);
//                orp_cout << "Enum while sleeping" << endl;
#ifdef GC_SAPPHIRE
                thread_enum_start_hook();
#endif // GC_SAPPHIRE
                orp_enum(thread);
                
                assert(thread->gc_status == gc_enumeration_done);
                
#ifdef GC_SAPPHIRE
                thread->gc_sapphire_status = sapphire_enumeration_done;
                assert(thread->app_status == thread_is_sleeping);
                // resume the thread
                orp_resume_a_thread_after (thread, false); // false since not in debugger.
                thread_enum_end_hook(SUSPENDED_BY_ENABLED_WILL_BLOCK);
                assert(thread->gc_sapphire_status == sapphire_enumeration_done);
#endif               
                continue;
            }
            // else fall through and loop.
        } //if (thread->app_status == thread_is_sleeping) {
        
        if (thread->app_status == thread_is_waiting) {
            assert(thread->app_status == thread_is_waiting);
            
            gc_enable_disable_state	endis = gc_if_enabled_then_EWB(&thread->gc_enabled_status);
            //                thread_gc_suspend_one(thread);
            if ((endis == enabled) && (thread->app_status == thread_is_waiting)) { 
                // We are enabled check app_status to avoid ABA problem.
                assert(thread->app_status == thread_is_waiting);
                assert(thread->gc_status == gc_at_safepoint);
                assert(thread->which_trap == x_java_wait);
                assert(thread->gc_frame_context.ljf != 0);
                
#ifdef GC_SAPPHIRE
                thread_enum_start_hook();
#endif // GC_SAPPHIRE
                orp_enum(thread);
                
                assert(thread->gc_status == gc_enumeration_done);
#ifdef GC_SAPPHIRE		
                thread->gc_sapphire_status = sapphire_enumeration_done;
                assert(thread->app_status == thread_is_waiting);	
                // resume the thread
                orp_resume_a_thread_after (thread, false); // false since not in debugger.
                thread_enum_end_hook(SUSPENDED_BY_ENABLED_WILL_BLOCK);
                assert(thread->gc_sapphire_status == sapphire_enumeration_done);
#endif	
                assert (thread->gc_status == gc_enumeration_done);      
                continue;
            } // if ((endis == enabled) && (thread->app_status == thread_is_waiting))
        } // if (thread->app_status == thread_is_waiting) {
        
        boolean rstat = ResetEvent(thread->gc_resume_event_handle);
        assert(rstat);
        
#ifdef GC_SAPPHIRE
        
#else
        // This is hit a lot and needs to be investigated more but I'm leaving the assert in until
        // we can fully understand what is going on.
        // From one aspect if a thread is sleeping then it can be at a safepoint which is OK.
        // But given that we are just now entering this routine how did the thread get to a safepoint
        // I suspect that the gc_status is not changed properly due to some race condition.
        // RLH 10/6/01
        assert(thread->gc_status == zero); 
#endif 
        
        thread->gc_status = gc_moving_to_safepoint;
        
        gc_enable_disable_state endis = bogus;

        // Don't we have a race condition if the thread goes into a sleep or wait
        // state that after we have passed the above logic.
        while (1)
        {
            endis = gc_if_enabled_then_EWB(&thread->gc_enabled_status);    
            
            if ((endis == enabled) || // then it MUST have atomically moved to EWB
                (endis == enabled_will_block) || 
                (endis == enabled_hijack)  
                ){
                if(thread->gc_status != gc_at_safepoint) {
                    thread->gc_status = gc_at_safepoint;        
                    assert(thread->which_trap == x_nothing);
                    thread->which_trap = x_orp_enable_gc;
                    restore_thread_state(thread);
                    memset(&(thread->gc_frame_context), 0, sizeof(thread->gc_frame_context) );
                    thread->gc_frame_context.ljf = (uint32)thread->get_last_java_frame();
                    // The thread is being born or is dying if ljf is null.
                    thread->gc_frame_context.p_eip = &(thread->gc_frame_context_eip_var);
                } else {
                    assert (thread->gc_frame_context.ljf == (uint32)(thread->get_last_java_frame()));
                    assert(thread->which_trap != x_nothing);
                }
#ifdef GC_SAPPHIRE
                thread_enum_start_hook();
#endif // GC_SAPPHIRE
                orp_enum(thread);
#ifdef GC_SAPPHIRE	
                assert(thread->gc_sapphire_status == sapphire_enumeration_done);                    
                assert(thread->gc_status == gc_enumeration_done);			// resume the thread
                orp_resume_a_thread_after (thread, false); // false since not in debugger.
                thread_enum_end_hook(SUSPENDED_BY_ENABLED_WILL_BLOCK);
                // This could cause a change of gc_status to gc_at_safepoint...
#endif
                break; //while (1)
            }  // if ((endis == enabled) ||

#ifdef LINUX_THREAD_SUSPEND
            // using signals instead of suspend/resume semantics.
            bool suspend_thread(ORP_thread *);
            bool resume_thread(ORP_thread *);

            bool suspended = suspend_thread( thread ) ;
            if( ! suspended ) continue;

            ORP_Code_Type orpct = orp_identify_eip_deadlock_free( (void *)(thread->regs.eip) );
            if(orpct == ORP_TYPE_JAVA) {
                orp_suspended_java_frame_or_set_traps(thread);
                if (thread->gc_status == gc_at_safepoint) {
                   assert(thread->which_trap == x_suspend_in_java_frame);
                   orp_enum(thread);
                   break; //  while (1)
               }
            } //orpct == ORP_TYPE_JAVA

            resume_thread(thread);
 
#endif //LINUX_THREAD_SUSPEND
#ifndef ORP_POSIX // Skip if using ORP_POSIX this will be added later using 
                  // signals instead of suspend/resume semantics.
#ifdef GC_SAPPHIRE
            thread_enum_start_hook();            
#endif // GC_SAPPHIRE
            thread_gc_suspend_one(thread);
            
            ORP_Code_Type orpct = get_orpct(thread);
            
            if(orpct == ORP_TYPE_JAVA) {
                restore_thread_state(thread);
                orp_suspended_java_frame_or_set_traps(thread);
                
                if (thread->gc_status == gc_at_safepoint) {
                    assert(thread->which_trap == x_suspend_in_java_frame);
                    restore_thread_state(thread);
                    orp_enum(thread);
                    
#ifdef GC_SAPPHIRE	
                    assert(thread->gc_status == gc_enumeration_done);
                    assert(thread->gc_sapphire_status == sapphire_enumeration_done);	
                    // resume the thread
                    orp_resume_a_thread_after (thread, false); // false since not in debugger.
                    thread_enum_end_hook(SUSPENDED_AT_SAFE_POINT);
#endif
                    break; //while (1)
                }
            }
            
            DWORD stat = RESUME_THREAD(thread);
#ifdef GC_SAPPHIRE
            thread_enum_end_hook(SUSPENDED_AT_UNSAFE_POINT);
#endif // GC_SAPPHIRE
            assert(stat == 1);  // thread was suspended but not at a safepoint, try again.
            
#endif //POSIX
            Sleep(2);
        } // while (1) thread is resumed before break

    } // end for(unsigned n = 0; n < n_threads; n++)
    
    // Make sure we got all the threads...
    assert (n == n_threads);
    
    process_the_current_thread ();
    // finally, process all the global refs
    orp_enumerate_root_set_global_refs();
#ifdef GC_SAPPHIRE
    assert (check_all_threads_sapphire_status (sapphire_enumeration_done));
    change_all_threads_sapphire_status (sapphire_between_enumerations);
#endif // GC_SAPPHIRE
}

void process_the_current_thread ()
{
    // process the current thread
    
    if (!(p_TLS_orpthread->gc_frame_context.ljf)) {
        if(! ( p_TLS_orpthread->app_status == thread_is_birthing || 
               p_TLS_orpthread->app_status == thread_is_dying ) ){
            orp_cout << "BUG BUG " << "Why is ljf 0 here." << endl;
        }
        p_TLS_orpthread->gc_frame_context.ljf = (uint32)(p_TLS_orpthread->get_last_java_frame());
    }

    assert(p_TLS_orpthread->gc_status == zero);
    p_TLS_orpthread->gc_status = gc_at_safepoint;
    p_TLS_orpthread->which_trap = x_the_safepoint_control_thread;
    assert(p_TLS_orpthread->restore_context_after_gc == false);
#ifdef GC_SAPPHIRE
    p_TLS_orpthread->gc_sapphire_status = sapphire_enumerate;
#endif // GC_SAPPHIRE
    orp_enum(p_TLS_orpthread);
}

#ifdef GC_SAPPHIRE
extern void sapphire_release_nursery (ORP_thread *thead);

void orp_sapphire_release_nursery(ORP_thread *thread)
{
    assert(thread->gc_status == gc_at_safepoint);
	
    // restore_thread_state() should have already been called by now
    assert(gc_breakpoint_address[0] == 0);
    assert(gc_breakpoint_opcode[0] == 0);
    assert(thread->hijack_p_eip == 0);

//	void *debug_nursery = thread->p_nursery;
//      orp_cout << "orp_enum() -- thread " << hex << thread;
//      orp_cout << "  thread->p_nursery is "  << thread->p_nursery << endl;
//	orp_cout << "Releasing a nursery in a thread" << endl;

	sapphire_release_nursery(thread);

//      if ((debug_nursery != NULL) && (thread->p_nursery == NULL)) {
//          orp_cout << "  thread->p_nursery is now "  << thread->p_nursery << endl;
//      }
	thread->gc_sapphire_status = sapphire_nursery_released;
}

// Forward reference needed.

void sapphire_release_nurseries_when_no_debugger() ;

void orp_sapphire_release_nurseries_all_threads()
{
	//	orp_cout << "Grabbing control of threads one by one to release nurseries" << endl;
	get_control_of_threads_for_gc(); //vvvvvvvvvvvvvvvvvvvvvvvvvv
	
    assert (global_safepoint_status == enumerate_the_universe);
	
    assert(p_the_safepoint_control_thread == p_TLS_orpthread); // Set in the sapphire driver
	//	p_the_safepoint_control_thread = p_TLS_orpthread;
	
    if (jvmdi_debugger) {
		// Deal with later and when Weldon is around to help.
		assert (0);//        release_nurseries_when_a_debugger();
    }
	else {
        sapphire_release_nurseries_when_no_debugger();
    }
	assert (global_safepoint_status == enumerate_the_universe);
	//	orp_resume_threads_after(false); //^^^^^^^^^^^^^^^^^^^^^^^^^^
	//	orp_cout << "Resuming threads with fresh nurseries." << endl;
}

void sapphire_release_nursery_when_no_debugger (ORP_thread *thread)
{
	orp_sapphire_release_nursery(thread);
}

void sapphire_release_nurseries_when_no_debugger() 
{
    change_all_threads_sapphire_status(sapphire_releasing_nursery);
    assert (global_safepoint_status == enumerate_the_universe); 
    uint32 n_threads = thread_gc_number_of_threads();
    for(unsigned n = 0; n < n_threads; n++) {
        ORP_thread *thread = (ORP_thread *)thread_gc_enumerate_one();
        assert (thread != p_TLS_orpthread); // should never see this thread.
        // Stop the thread
        move_a_thread_to_safepoint(thread);
        
//-        assert (thread->gc_status == gc_at_safepoint);
        // Release the nursery
//-        sapphire_release_nursery_when_no_debugger (thread);
        // resume the thread
//-        orp_resume_a_thread_after (thread, false); // false since not in debugger. 
    } // end of for loop
#if 1
    
    n_threads = thread_gc_number_of_threads();
    for(unsigned nnn = 0; nnn < n_threads; nnn++) {
        ORP_thread *thread = (ORP_thread *)thread_gc_enumerate_one();
        assert (thread != p_TLS_orpthread); // should never see this thread.
        // Stop the thread
//+        move_a_thread_to_safepoint(thread);
        
        assert (thread->gc_status == gc_at_safepoint);
        // Release the nursery
        sapphire_release_nursery_when_no_debugger (thread);
        // resume the thread
        orp_resume_a_thread_after (thread, false); // false since not in debugger. 
    } // end of for loop
#endif

    assert (n == n_threads);
    
    // process the current thread
    //    assert (p_TLS_orpthread->p_nursery); // This might have been released already (debug)
    // NO we might be asking for an initial nursery.
    
    assert(p_TLS_orpthread->gc_status == zero);
    p_TLS_orpthread->gc_status = gc_at_safepoint;
    p_TLS_orpthread->which_trap = x_the_safepoint_control_thread;
    assert(p_TLS_orpthread->restore_context_after_gc == false);
    p_TLS_orpthread->gc_sapphire_status = sapphire_releasing_nursery;
    sapphire_release_nursery_when_no_debugger(p_TLS_orpthread);
    assert (global_safepoint_status == enumerate_the_universe);
    uint32 nn_threads = thread_gc_number_of_threads();
    for(unsigned nn = 0; nn < nn_threads; nn++) {
        ORP_thread *thread = (ORP_thread *)thread_gc_enumerate_one();
        assert (thread != p_TLS_orpthread); // should never see this thread.
        assert (thread->gc_sapphire_status == sapphire_nursery_released);
    } // end of for loop
    assert (p_TLS_orpthread->gc_sapphire_status == sapphire_nursery_released);
    p_TLS_orpthread->gc_status = zero; // Return status to zero.
}

#if 0
void sapphire_enum_when_no_debugger();
#endif 

void orp_sapphire_enumerate_root_set_all_threads()
{
    
#ifdef ORP_NT
    SetThreadPriority(p_TLS_orpthread->thread_handle, THREAD_PRIORITY_HIGHEST);
#endif
    get_control_of_threads_for_gc();
    
    assert (global_safepoint_status == enumerate_the_universe);
    assert (p_the_safepoint_control_thread = p_TLS_orpthread); // Set when we released nurseries.
    assert (global_safepoint_status == enumerate_the_universe);

    if (jvmdi_debugger) {
        enum_when_a_debugger();
    }
    else {
        enum_when_no_debugger();
    }
    p_TLS_orpthread->gc_status = zero;
    
#ifdef ORP_NT
    SetThreadPriority(p_TLS_orpthread->thread_handle ,THREAD_PRIORITY_NORMAL);
#endif
} //orp_enumerate_root_set_all_threads

#endif // 0 GC_SAPPHIRE


// a forward reference nneded by orp_thread_enumerate_from_context(), 
// and orp_thread_enumerate()

void orp_enumerate_root_set_from_stack(Boolean is_first,
                                       ORP_thread *thread
                                       );

// is_first is used to determine if we need to enumerate output args.
// For this reason it is false if we hijacked the ip (the output arg is
// enumerated by the caller. is_first is also false we are
// enumerating from a native.
void orp_thread_enumerate_from_java(Boolean is_first, ORP_thread *thread)
{
    assert(thread->gc_status == gc_at_safepoint);
    
    // restore_thread_state() should have already been called by now
    assert(gc_breakpoint_address[0] == 0);
    assert(gc_breakpoint_opcode[0] == 0);
    assert(thread->hijack_p_eip == 0);
    
    orp_enumerate_root_set_from_stack(is_first, thread);
    
    orp_enumerate_root_set_single_thread_not_on_stack(thread);
    orp_enumerate_object_handles(thread);
    
    thread->gc_status = gc_enumeration_done;
}


void orp_thread_enumerate_from_native(ORP_thread *thread)
{
    assert(thread->gc_status == gc_at_safepoint);
    
    // restore_thread_state() should have already been called by now
    assert(gc_breakpoint_address[0] == 0);
    assert(gc_breakpoint_opcode[0] == 0);
    assert(thread->hijack_p_eip == 0);
    
    if (!thread->gc_frame_context.ljf) {
        // If ljf is zero either the thread is being born, or is dying -- only two possible cases.
        assert ((thread->app_status == thread_is_dying) || (thread->app_status == thread_is_birthing));
    } else {
        orp_enumerate_root_set_from_stack(FALSE, thread);
    }
    
    orp_enumerate_root_set_single_thread_not_on_stack(thread);
    orp_enumerate_object_handles(thread);
    
    thread->gc_status = gc_enumeration_done;
    
} //orp_thread_enumerate_from_native


//
// This is the only stack walking function that used for root set enumeration.
//


void orp_enumerate_root_set_from_stack(Boolean is_first, ORP_thread *thread)
{
#ifdef _DEBUG
    Method *prev_meth;
    int loop_count = 0;
#endif
    JIT_Specific_Info *jit_info = 0;
    while(1) {
#ifdef _DEBUG
        prev_meth = jit_info ? jit_info->get_method() : 0;
        loop_count++;
#endif
        jit_info = methods.find_deadlock_free((void *)*(thread->gc_frame_context.p_eip));
        
        ORP_Code_Type orpct = orp_identify_eip_deadlock_free((void *)*(thread->gc_frame_context.p_eip));
        if(orpct == ORP_TYPE_JAVA) {
            assert(jit_info->get_jit());
#ifdef ORP_STATS
            orp_stats_total.num_unwind_java_frames_gc++;
            jit_info->num_unwind_java_frames_gc++;
#endif
            jit_info->get_jit()->get_root_set_from_stack_frame(jit_info->get_method(),
                0,
                &(thread->gc_frame_context),
                is_first);
            is_first = FALSE;  
        } else {
#ifdef ORP_STATS
            orp_stats_total.num_unwind_native_frames_gc++;
#endif
            
            Boolean ok = ro_unwind_native_stack_frame( &(thread->gc_frame_context));
            if(!ok) {
#ifdef _DEBUG
                if(prev_meth) {
                    // The bottom-most frame must belong to main or run.
                    const char *name = prev_meth->get_name()->bytes;
                    
#ifdef CLI_TESTING
                    // In CLI there's no restriction on the name of the
                    // method on the bottom of the stack, but for now
                    // we are handling C# code only, so we can check
                    // that we have a "Main".
                    assert(!(strcmp("exit", name) &&
                             strcmp("main", name) &&
                             strcmp("Main", name) &&
                             strcmp("run", name) &&
                             name[0] != '<'
						     //runShutdownHooks is temporary method name in java.lang.Runtime
						     && strcmp("runShutdownHooks", name))); 
#else
                    assert(!( strcmp ("exit", name) && strcmp("main", name) 
                        && strcmp("run", name) && name[0] != '<'
						//runShutdownHooks is temporary method name in java.lang.Runtime
						&& strcmp("runShutdownHooks", name) )); 
#endif                    
                    
                }
#endif
                break;
            }
            is_first = FALSE;
        }
    }
    
	if(thread->throw_context == NULL)return;

#ifdef USE_DLL_JIT
	__declspec(dllimport)
#else
    extern
#endif
		void adjustContextEIP(Frame_Context *context);
	adjustContextEIP(&thread->gc_frame_throw_context);

	jit_info = 0;
    while(1) {
#ifdef _DEBUG
        prev_meth = jit_info ? jit_info->get_method() : 0;
        loop_count++;
#endif
        jit_info = methods.find_deadlock_free((void *)*(thread->gc_frame_throw_context.p_eip));
        
        ORP_Code_Type orpct = orp_identify_eip_deadlock_free((void *)*(thread->gc_frame_throw_context.p_eip));
        if(orpct == ORP_TYPE_JAVA) {
            assert(jit_info->get_jit());
#ifdef ORP_STATS
            orp_stats_total.num_unwind_java_frames_gc++;
            jit_info->num_unwind_java_frames_gc++;
#endif
            jit_info->get_jit()->get_root_set_from_stack_frame(jit_info->get_method(),
                0,
                &(thread->gc_frame_throw_context),
                is_first);
            is_first = FALSE;  
        } else {
#ifdef ORP_STATS
            orp_stats_total.num_unwind_native_frames_gc++;
#endif
            
            Boolean ok = ro_unwind_native_stack_frame( &(thread->gc_frame_throw_context));
            if(!ok) {
#ifdef _DEBUG
                if(prev_meth) {
                    // The bottom-most frame must belong to main or run.
                    const char *name = prev_meth->get_name()->bytes;
                    
#ifdef CLI_TESTING
                    // In CLI there's no restriction on the name of the
                    // method on the bottom of the stack, but for now
                    // we are handling C# code only, so we can check
                    // that we have a "Main".
                    assert(!(strcmp("Main", name)));
#else
                    assert(!( strcmp ("exit", name) && strcmp("main", name) 
                        && strcmp("run", name) && name[0] != '<' 
						//runShutdownHooks is temporary method name in java.lang.Runtime
						&& strcmp("runShutdownHooks", name) )); 
#endif
                }
#endif
                return; 
            }
            is_first = FALSE;
        }
    }
} //orp_enumerate_root_set_from_stack


#ifdef GC_SAPPHIRE
bool check_all_threads_sapphire_status (gc_sapphire_state state)
{
    uint32 n_threads;
    unsigned n;
    n_threads = thread_gc_number_of_threads(); // init iterator
    for(n = 0; n < n_threads; n++) {
        ORP_thread *thread = (ORP_thread *)thread_gc_enumerate_one();
        if (thread->gc_sapphire_status != state) {
            return false;
        }
    }
    if (p_TLS_orpthread->gc_sapphire_status != state) {
        return false;
    }
    return true;
}

#endif // GC_SAPPHIRE

