/*
 *  OpenDuke
 *  Copyright (C) 1999  Rusty Wagner
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 */


#pragma hdrstop
#include "Vertex.h"

int CVertexList::AddVertex(CVertex& v)
{
	SetVertex(count,v);
	count++;
	if (count>=arraySize)
	{
		D3DVERTEX *newList=new D3DVERTEX[arraySize+VERT_BLOCK_SIZE];
		memcpy(newList,list,arraySize*sizeof(D3DVERTEX));
		delete[] list;
		list=newList;
		arraySize+=VERT_BLOCK_SIZE;		
	}
	return count-1;
}

int CTLVertexList::AddVertex(CTLVertex& v)
{
	SetVertex(count,v);
	count++;
	if (count>=arraySize)
	{
		D3DTLVERTEX *newList=new D3DTLVERTEX[arraySize+VERT_BLOCK_SIZE];
		memcpy(newList,list,arraySize*sizeof(D3DTLVERTEX));
		delete[] list;
		list=newList;
		arraySize+=VERT_BLOCK_SIZE;		
	}
	return count-1;
}

int CIndexList::AddIndex(WORD n)
{
	SetIndex(count,n);
	count++;
	if (count>=arraySize)
	{
		WORD *newList=new WORD[arraySize+VERT_BLOCK_SIZE];
		memcpy(newList,list,arraySize*sizeof(WORD));
		delete[] list;
		list=newList;
		arraySize+=VERT_BLOCK_SIZE;
	}
	return count-1;
}

void CVertexList::Reflect(float waterLevel)
{
	for (int i=0;i<count;i++)
		list[i].y=waterLevel*2.0-list[i].y;
}

void CLVertexList::Reflect(float waterLevel)
{
	for (int i=0;i<count;i++)
		list[i].y=waterLevel*2.0-list[i].y;
}
