/*
 *  OpenDuke
 *  Copyright (C) 1999  Rusty Wagner
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 */


#ifndef PLATFORM_UNIX
#include <vcl.h>
#pragma hdrstop
#else
#include "linux_inc.h"
#endif
#include "Sound.h"

SoundEngine::SoundEngine()
{
}

SoundEngine::~SoundEngine()
{
}

int SoundEngine::Initialized()
{
    return 0;
}


Sound** soundCache=NULL;
int soundCacheCount=0;
int soundCacheMax=0;

Sound* LoadSound(GroupFile *group,char *name)
{
    for (int i=0;i<soundCacheCount;i++)
    {
        if (!strcmp(soundCache[i]->name,name))
            return soundCache[i];
    }
    int len=group->FileSize(name)-0x40;
    if (soundCacheCount>=soundCacheMax)
    {
        soundCacheMax+=SOUNDCACHE_STEP;
        Sound** newCache=new Sound*[soundCacheMax];
        if (soundCache)
        {
            memcpy(newCache,soundCache,sizeof(Sound*)*soundCacheCount);
            delete[] soundCache;
        }
        soundCache=newCache;
    }
    soundCache[soundCacheCount]=new Sound;
    soundCache[soundCacheCount]->name=new char[strlen(name)+1];
    strcpy(soundCache[soundCacheCount]->name,name);
    soundCache[soundCacheCount]->format.wFormatTag=WAVE_FORMAT_PCM;
    soundCache[soundCacheCount]->format.nChannels=1;
    soundCache[soundCacheCount]->format.nSamplesPerSec=8000;
    soundCache[soundCacheCount]->format.nAvgBytesPerSec=8000;
    soundCache[soundCacheCount]->format.nBlockAlign=1;
    soundCache[soundCacheCount]->format.wBitsPerSample=8;
    soundCache[soundCacheCount]->format.cbSize=0;
    soundCache[soundCacheCount]->len=len;
    soundCache[soundCacheCount]->data=new char[soundCache[soundCacheCount]->len];
    group->LoadFileB(name,(char*)soundCache[soundCacheCount]->data,0x30,len);
    return soundCache[soundCacheCount++];
}

Sound* LoadRTSSound(RTSFile *rts, int i)
{
    char name[16];
    sprintf(name,"RTS file #%d",i);
    for (int j=0;j<soundCacheCount;j++)
    {
        if (!strcmp(soundCache[j]->name,name))
            return soundCache[j];
    }
    int len=rts->FileSize(i)-0x40;
    if (soundCacheCount>=soundCacheMax)
    {
        soundCacheMax+=SOUNDCACHE_STEP;
        Sound** newCache=new Sound*[soundCacheMax];
        if (soundCache)
        {
            memcpy(newCache,soundCache,sizeof(Sound*)*soundCacheCount);
            delete[] soundCache;
        }
        soundCache=newCache;
    }
    soundCache[soundCacheCount]=new Sound;
    soundCache[soundCacheCount]->name=new char[strlen(name)+1];
    strcpy(soundCache[soundCacheCount]->name,name);
    soundCache[soundCacheCount]->format.wFormatTag=WAVE_FORMAT_PCM;
    soundCache[soundCacheCount]->format.nChannels=1;
    soundCache[soundCacheCount]->format.nSamplesPerSec=8000;
    soundCache[soundCacheCount]->format.nAvgBytesPerSec=8000;
    soundCache[soundCacheCount]->format.nBlockAlign=1;
    soundCache[soundCacheCount]->format.wBitsPerSample=8;
    soundCache[soundCacheCount]->format.cbSize=0;
    soundCache[soundCacheCount]->len=len;
    soundCache[soundCacheCount]->data=new char[soundCache[soundCacheCount]->len];
    rts->LoadFileB(i,(char*)soundCache[soundCacheCount]->data,0x30,len);
    return soundCache[soundCacheCount++];
}

