/* 
 *   Creation Date: <2001/05/09 23:26:42 samuel>
 *   Time-stamp: <2001/05/21 22:20:56 samuel>
 *   
 *	<disk.h>
 *	
 *	Block-device related
 *   
 *   Copyright (C) 2001 Samuel Rydh (samuel@ibrium.se)
 *   
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation
 *   
 */

#ifndef _H_DISK
#define _H_DISK

enum { 
	BF_ENABLE_WRITE		= 1, 
	BF_FORCE		= 2,
	BF_CD_ROM		= 4,
	BF_BOOT			= 8,

	BF_NOT_BOOTABLE		= 16,
	BF_SUBDEVICE		= 32,
	BF_HFS			= 64,
	BF_HFS_PLUS		= 128
};

enum {
	BDEV_TYPE_BOOT		= 1,
	BDEV_TYPE_NOT_BOOT	= 2, 
	BDEV_TYPE_REMOVABLE	= 4,
	BDEV_TYPE_HFS		= 8
};

/* from disk_open.c */
extern int disk_open( char *name, int flags, int *ro_fallback, int silent );

/* from blkdev.c */
typedef struct bdev_desc {
	int			fd;
	int			flags;			/* BF_XXX */
	
	/* both soffs and size are multiples of 512 */
	ullong 			soffs;			/* offset to partition */
	ullong 			size;			/* size of partition */

	char			*dev_name;
	char			*vol_name;

	ulong			mdb_checksum;
	ulong			name_checksum;

	/* fields private to blkdev.c */
	int			priv_claimed;
	int			priv_id;
	struct bdev_desc	*priv_next;
} bdev_desc_t;

extern void 		bdev_setup_drives( void );

extern bdev_desc_t	*bdev_get_volume( int bdev_type );
extern void		bdev_close_volume( bdev_desc_t *dev );

#endif   /* _H_DISK */


