/* 
 *   Creation Date: <2000/12/28 21:23:03 samuel>
 *   Time-stamp: <2001/06/21 14:56:35 samuel>
 *   
 *	<booter.c>
 *	
 *	Booter glue
 *   
 *   Copyright (C) 2000, 2001 Samuel Rydh (samuel@ibrium.se)
 *   
 *   This program is free software; you can redistribute it and/or
 *   modify it under the terms of the GNU General Public License
 *   as published by the Free Software Foundation
 *   
 */

#include "mol_config.h"
#include "booter.h"
#include "res_manager.h"
#include "debugger.h"

// GLOBAL (special platform configuration)
platform_expert_ops_t gPE;

extern void 
booter_init( void )
{
	char *nvram_str;
	char *oftree_str;
	memset( &gPE, 0, sizeof(gPE) );

	/* Resources with boot-method dependent names */
	if( is_newworld_boot() ) {
		nvram_str = "nvram_image_nw";
		oftree_str = "oftree_nw";
		newworld_booter_init();
	} else if( is_bootx_boot() ) {
		nvram_str = "nvram_image_x";
		oftree_str = "oftree_x";
		bootx_init();
	} else if( is_oldworld_boot() ) {
		nvram_str = "nvram_image";
		oftree_str = "oftree";
		oldworld_booter_init();
	} else if( is_elf_boot() ) {
		nvram_str = "nvram_image_nw";	/* XXX: TEMP */
		oftree_str = "oftree_nw";	/* XXX: TEMP */
		elf_booter_init();
	} else {
		printm("Unexpected error\n");
		exit(1);
	}

	if( !(gPE.nvram_image_name=get_str_res( nvram_str ))
	    || !(gPE.oftree_filename=get_str_res( oftree_str )) ) {
		printm("booter.c: Could not find an expected resource - exiting\n");
		exit(1);
	}
}

extern void 
booter_cleanup( void )
{
	if( gPE.booter_cleanup )
		gPE.booter_cleanup();
}

extern void
booter_startup( void )
{
	if( gPE.booter_startup )
		gPE.booter_startup();
}


/************************************************************************/
/*	Boot method							*/
/************************************************************************/

int _boot_method_globals_inited=0;
int _boot_is_newworld=0, _boot_is_bootx=0, _boot_is_oldworld=0, _boot_is_elf=0;

static struct {
	char	*key;
	int	*flagptr;
} boot_methods[] = {
	{ "oldworld",	&_boot_is_oldworld },
	{ "newworld",	&_boot_is_newworld },
	{ "macosx",	&_boot_is_bootx },
	{ "bootx",	&_boot_is_bootx },
	{ "osx",	&_boot_is_bootx },
	{ "elf",	&_boot_is_elf },
	{ NULL,	NULL }
};

void 
_init_boot_method_globals( void )
{
	char *s;
	int i=0;
	
	if( (s=get_str_res("boot_method")) != NULL ){
		while( boot_methods[i].key && strcasecmp(s, boot_methods[i].key) )
			i++;
		if( !boot_methods[i].key ) {
			printm("--->Bad 'boot_method' value\n");
			exit(1);
		}
		*boot_methods[i].flagptr = 1;
	} else {
		printm("WARNING: No 'boot_method' resource found, using old scheme\n");
		if( get_bool_res("newworld_boot") == 1 )
			_boot_is_newworld = 1;
		else
			_boot_is_oldworld = 1;
	}
	_boot_method_globals_inited = 1;
}
