/* Output from p2c 1.21alpha-07.Dec.93, the Pascal-to-C translator */
/* From input file "mtxline.pas" */


#include "cfuncs.h"


#define MTXLINE_G
#include "mtxline.h"


boolean bind_left[19] = {
  false, false, true, false, false, true, true, false, true, true, false,
  true, false, true, false, false, false, false, false
};

#ifndef STRINGS_H

#endif

#ifndef NOTES_H
#include "notes.h"
#endif


typedef music_word word_scan[max_words];

typedef struct line_info {
  word_index0 here, nword;
  bar_index0 nbar;
  paragraph_index0 voice_pos, voice_stave, mus, chord;
  short extra;
  boolean vocal;
  word_index0 bar_bound[max_bars + 1];
  short word_bound[max_words + 1];
  word_scan scan;
} line_info;


static char name[19][10] = {
  "?", "note", "znote", "lyricsTag", "(", ")", ")(", "[", "]", "PMX<",
  "meter", "ornament", "rest", "//", "BAR", "TeX", "@", "firstonly", "ERROR"
};

static line_info info[maxvoices];


/* ------------------------------------------------------------- */

short beatsPerLine(void)
{
  short Result;
  voice_index voice, FORLIM;
  line_info *WITH;

  FORLIM = nvoices;
  for (voice = 1; voice <= FORLIM; voice++) {
    WITH = &info[voice-1];
    if (WITH->nbar > 0 || WITH->extra > 0) {
      if (WITH->extra % one_beat > 0) {
/* p2c: mtxline.pas, line 97:
 * Note: Using % for possibly-negative arguments [317] */
	error3(voice, "Line length not an integer number of beats");
      }
      Result = WITH->nbar * meternum + WITH->extra / one_beat;
    }
  }
  return Result;
}


void skipChordBar(voice_index voice)
{
  line_info *WITH;
  char STR1[256];

  WITH = &info[voice-1];
  if (WITH->chord > 0) {
    sprintf(STR1, "%c", barsym);
    if (!strcmp(P[WITH->chord - 1], STR1))
      predelete(P[WITH->chord - 1], 1);
  }
}


char *getBar(char *Result, voice_index voice, short bar)
{
  line_info *WITH;

  WITH = &info[voice-1];
  return (substr_(Result, P[WITH->mus - 1],
		  WITH->word_bound[WITH->bar_bound[bar-1]] + 1,
		  WITH->word_bound[WITH->bar_bound[bar]] -
		  WITH->word_bound[WITH->bar_bound[bar-1]]));
}


char *musicLine(char *Result, voice_index voice)
{
  return strcpy(Result, P[musicLineNo(voice) - 1]);
}


paragraph_index0 musicLineNo(voice_index voice)
{
  return (info[voice-1].mus);
}


void setMusicLineNo(voice_index voice, paragraph_index lno)
{
  info[voice-1].mus = lno;
}


paragraph_index0 chordLineNo(voice_index voice)
{
  return (info[voice-1].chord);
}


void setChordLineNo(voice_index voice, paragraph_index lno)
{
  info[voice-1].chord = lno;
}


void setVocal(voice_index voice, boolean voc)
{
  info[voice-1].vocal = voc;
}


boolean isVocal(voice_index voice)
{
  return (info[voice-1].vocal);
}


void setStavePos(voice_index voice, stave_index stave, stave_index pos)
{
  line_info *WITH;

  WITH = &info[voice-1];
  WITH->voice_pos = pos;
  WITH->voice_stave = stave;
}


stave_index voiceStave(voice_index voice)
{
  return (info[voice-1].voice_stave);
}


stave_index voicePos(voice_index voice)
{
  return (info[voice-1].voice_pos);
}


voice_index companion(voice_index voice)
{
  short s;

  s = info[voice-1].voice_stave;
  if (number_on_stave[s-1] == 1)
    return voice;
  else if (info[voice-1].voice_pos == 1)
    return (voice + 1);
  else
    return (voice - 1);
}


void regroup(voice_index voice)
{
  word_index0 i, j;
  word_index0 j2 = 0;
  line_info *WITH;
  word_index0 FORLIM;

  WITH = &info[voice-1];
  FORLIM = WITH->nbar;
  for (i = 1; i <= FORLIM; i++) {
    j2 = WITH->bar_bound[i];
    j = j2 + 1;
    while (j <= WITH->here &&
	   (bind_left[(long)WITH->scan[j-1]] || WITH->scan[j-1] == barword)) {
      WITH->bar_bound[i]++;
      j++;
    }
  }
  if (WITH->extra > 0)
    WITH->bar_bound[WITH->nbar + 1] = WITH->here;
  WITH->nword = WITH->here;
}


void resetInfo(voice_index voice, char *buf)
{
  line_info *WITH;

  WITH = &info[voice-1];
  strcpy(buf, P[WITH->mus - 1]);
  *P[WITH->mus - 1] = '\0';
  WITH->bar_bound[0] = 0;
  WITH->word_bound[0] = 0;
  WITH->nbar = 0;
  WITH->here = 0;
}


void clearLabels(void)
{
  voice_index voice, FORLIM;
  line_info *WITH;

  FORLIM = nvoices;
  for (voice = 0; voice <= FORLIM - 1; voice++) {
    WITH = &info[voice];
    WITH->chord = 0;
    WITH->mus = 0;
  }
}


void appendNote(voice_index voice, music_word nscan)
{
  line_info *WITH;

  WITH = &info[voice-1];
  WITH->here++;
  if (WITH->here > max_words)
    error3(voice, "Words per line limit exceeded");
  WITH->scan[WITH->here - 1] = nscan;
}


void appendToLine(voice_index voice, char *note)
{
  line_info *WITH;

  if (*note == '\0')
    return;
  WITH = &info[voice-1];
  sprintf(P[WITH->mus - 1] + strlen(P[WITH->mus - 1]), "%s%c", note, blank);
  WITH->word_bound[WITH->here] = strlen(P[WITH->mus - 1]);
}


void markBar(voice_index voice)
{
  line_info *WITH;

  WITH = &info[voice-1];
  if (WITH->nbar == 0)
    error3(voice, "Empty bar");
  else
    WITH->bar_bound[WITH->nbar] = WITH->here;
}


short numberOfBars(voice_index voice)
{
  return (info[voice-1].nbar);
}


void barForward(voice_index voice, short nbars)
{
  line_info *WITH;

  WITH = &info[voice-1];
  if (WITH->nbar + nbars < 0)
    error3(voice, "Next voice before bar is full");
  WITH->nbar += nbars;
  if (WITH->nbar > max_bars)
    error3(voice, "Bars per line limit exceeded");
  if (nbars > 0)
    WITH->bar_bound[WITH->nbar] = WITH->here;
}


void setExtraLength(voice_index voice, short ext)
{
  line_info *WITH;

  WITH = &info[voice-1];
  WITH->extra = ext;
  WITH->scan[WITH->here] = other;
}


short ExtraLength(voice_index voice)
{
  return (info[voice-1].extra);
}


voice_index0 findVoice(char *w_)
{
  voice_index0 Result = 0;
  char w[256];
  short i, FORLIM;

  strcpy(w, w_);
  curtail(w, ':');
  FORLIM = nvoices;
  for (i = 1; i <= FORLIM; i++) {
    if (!strcmp(w, voice_label[i-1]))
      return i;
  }
  getNum(w, &i);
  if (i == 0)
    return Result;
  if (i > 0 && i <= nvoices)
    return i;
  error("Numeric label outside range 1..nvoices", print);
  return Result;
}


static void info3(voice_index voice)
{
  line_info *WITH;

  WITH = &info[voice-1];
  printf("In voice \"%s\" near word %d:\n", voice_label[voice-1], WITH->here);
  printf("%*cV\n", WITH->word_bound[WITH->here], ' ');
}


void error3(voice_index voice, char *message)
{
  char STR1[256];

  info3(voice);
  sprintf(STR1, "   %s", message);
  error(STR1, print);
}


void warning3(voice_index voice, char *message)
{
  char STR1[256];

  info3(voice);
  sprintf(STR1, "   %s", message);
  warning(STR1, print);
}


char *nextMusicWord(char *Result, voice_index voice)
{
  return (MusicWord(Result, voice, info[voice-1].here));
}


char *MusicWord(char *Result, short voice, short n)
{
  line_info *WITH;

  WITH = &info[voice-1];
  if (n > 0 && n <= WITH->nword)
    return (substr_(Result, P[WITH->mus - 1], WITH->word_bound[n-1] + 1,
		    WITH->word_bound[n] - WITH->word_bound[n-1] - 1));
  else
    return strcpy(Result, "");
}


music_word thisNote(voice_index voice)
{
  line_info *WITH;

  WITH = &info[voice-1];
  return (WITH->scan[WITH->here - 2]);
}


music_word nextNote(voice_index voice)
{
  line_info *WITH;

  WITH = &info[voice-1];
  return (WITH->scan[WITH->here - 1]);
}


boolean endOfBar(voice_index voice, short bar_no)
{
  line_info *WITH;

  WITH = &info[voice-1];
  return (WITH->here > WITH->bar_bound[bar_no]);
}


void gotoBar(voice_index voice, short bar_no)
{
  line_info *WITH;

  WITH = &info[voice-1];
  WITH->here = WITH->bar_bound[bar_no-1] + 1;
}


char *getMusicWord(char *Result, voice_index voice)
{
  line_info *WITH;

  WITH = &info[voice-1];
  line_no = orig_line_no[WITH->mus - 1];
  MusicWord(Result, voice, WITH->here);
  WITH->here++;
  return Result;
}


boolean maybeMusicLine(char *l_)
{
  boolean Result;
  char l[256];
  char w[256];
  music_word nscan;

  strcpy(l, l_);
  GetNextWord(w, l, blank, dummy);
/* p2c: mtxline.pas: Note: Eliminated unused assignment statement [338] */
  if (pos1(w[0], "abcdefg") == 0)
    return false;
  getNextMusWord(w, l, &nscan);
  return (nscan == abcdefg);
}


void getNextMusWord(char *buf, char *note, music_word *nscan)
{
  char maybe_error[256];
  char STR2[256];

  GetNextWord(note, buf, blank, dummy);
  if (*note == '\0')
    return;
  if (note[0] == '\\') {
    *maybe_error = '\0';
    if (note[strlen(note) - 1] != '\\')
      strcpy(maybe_error, note);
    while (*buf != '\0' && note[strlen(note) - 1] != '\\')
      sprintf(note + strlen(note), " %s",
	      GetNextWord(STR2, buf, blank, dummy));
    if (note[strlen(note) - 1] != '\\')
      error("Unterminated TeX literal", print);
    *nscan = texword;
    if (*maybe_error != '\0') {
      sprintf(STR2, "Possible unterminated TeX literal: %s", maybe_error);
      warning(STR2, print);
    }
    return;
  }
  if (tonic_solfa) {
    translateSolfa(note);
    if (note[0] == '"')
      predelete(note, 1);
  }
  switch (note[0]) {

  case 'a':
  case 'b':
  case 'c':
  case 'd':
  case 'e':
  case 'f':
  case 'g':
    *nscan = abcdefg;
    break;

  case 'z':
    *nscan = zword;
    break;

  case '(':
    *nscan = lparen;
    break;

  case '{':
    if (note[strlen(note) - 1] == '}')
      *nscan = lyrtag;
    else
      *nscan = lparen;
    break;

  case ')':
  case '}':
    if (pos1('(', note) == 0)
      *nscan = rparen;
    else
      *nscan = rlparen;
    break;

  case '[':
    *nscan = lbrac;
    break;

  case ']':
    *nscan = rbrac;
    break;

  case '@':
    *nscan = atword;
    break;

  case 'm':
    *nscan = mword;
    break;

  case 'r':
    *nscan = rword;
    break;

  case '#':
  case '-':
  case 'n':
  case 'x':
  case '?':
  case 's':
    *nscan = pmxl;
    break;

  case 'G':
    if (pos1('A', note) > 0)
      *nscan = pmxl;
    else
      *nscan = other;
    break;

  case '1':
  case '2':
  case '3':
  case '4':
  case '5':
  case '6':
  case '7':
  case '8':
  case '9':
    if (pos1('/', note) > 0)
      *nscan = mword;
    else
      *nscan = pmxl;
    break;

  case 'o':
    *nscan = oword;
    break;

  case 'A':
  case 'V':
    *nscan = FirstOnly;
    break;

  case '/':
    if (!strcmp(note, "//"))
      *nscan = nextvoice;
    else if (!strcmp(note, "/")) {
      strcpy(note, "//");
      warning("/ changed to //", print);
      *nscan = nextvoice;
    } else {
      error("Word starts with /: do you mean \\?", print);
      *nscan = err;
    }
    break;

  default:
    if (pos1('|', note) > 0)
      *nscan = barword;
    else
      *nscan = other;
    break;
  }
}


char initOctave(stave_index voice_stave)
{
  char Result;

  if (pos1(clef[voice_stave-1], "Gt08") > 0)
    Result = '4';
  else
    Result = '3';
  if (verbose > 1)
    printf("  Stave %d  Clef %c  Position %d\n",
	   voice_stave, clef[voice_stave-1],
	   pos1(clef[voice_stave-1], "Gt0"));
  return Result;
}


boolean upper(voice_index voice)
{
  line_info *WITH;

  WITH = &info[voice-1];
  if (WITH->voice_pos == 1 && voice < nvoices)
    return (WITH->voice_stave == info[voice].voice_stave);
  else
    return false;
}


void describeVoice(voice_index voice, char *describe_lyr)
{
  short bar, w;
  line_info *WITH;
  char STR1[256];
  line_info *WITH1;
  short FORLIM;

  WITH = &info[voice-1];
  printf("Voice `%s' is on line %d", voice_label[voice-1], WITH->mus);
  if (WITH->vocal) {
    printf(", is vocal");
    puts(describe_lyr);
  } else {
    if (WITH->chord > 0)
      printf(" and has chords on line %d", WITH->chord);
    putchar('\n');
  }
  if (verbose <= 1)
    return;
  WITH1 = &info[voice-1];
  printf("Line has %d bars", WITH1->nbar);
  if (WITH1->extra > 0)
    printf(" + %d/64 notes\n", WITH1->extra);
  else
    putchar('\n');
  printf("Bars:");
  FORLIM = WITH1->nbar;
  for (bar = 1; bar <= FORLIM; bar++)
    printf(" %s ", getBar(STR1, voice, bar));
  printf("\nWord types:");
  FORLIM = WITH1->nword;
  for (w = 0; w <= FORLIM - 1; w++)
    printf(" %s", name[(long)WITH1->scan[w]]);
  putchar('\n');
}




/* End. */
